/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class SetTimingScale
extends TimingScale {
    @Nullable
    private static MessageDigest md5 = null;
    private static boolean triedToGetMD5 = false;
    @NonNull
    @NonNull BigRational @NonNull [] validVals;
    private byte[] md5hash = null;
    private int hash;

    private void mkMD5hash() {
        MessageDigest xxMD5;
        if (!triedToGetMD5) {
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {}
            triedToGetMD5 = true;
        }
        if ((xxMD5 = md5) != null) {
            xxMD5.reset();
            int i = 0;
            while (i < this.validVals.length) {
                xxMD5.update(this.validVals[i].getNumerator().toByteArray());
                xxMD5.update(this.validVals[i].getDenominator().toByteArray());
                ++i;
            }
            this.md5hash = xxMD5.digest();
        }
    }

    private void mkHash() {
        byte[] xxMD5hash = this.md5hash;
        if (xxMD5hash == null) {
            this.hash = this.type.hashCode() ^ this.from.getNumerator().intValue() ^ this.from.getDenominator().intValue() ^ this.to.getNumerator().intValue() ^ this.to.getDenominator().intValue() ^ this.numOfScales.intValue();
        } else {
            this.hash = this.type.hashCode();
            int i = 0;
            int sh = 0;
            while (i < xxMD5hash.length) {
                this.hash ^= xxMD5hash[i] << sh;
                ++i;
                sh = (sh + 8) % 32;
            }
        }
    }

    public SetTimingScale(@NonNull List<@NonNull BigRational> scales) {
        @NonNull BigInteger locNumOfVals = ZERO;
        this.nxt = null;
        this.type = EScaleType.SetSmall;
        assert (scales.size() > 0) : "Empty input set of scales";
        scales.sort(null);
        this.validVals = new BigRational[scales.size()];
        int i = 0;
        for (BigRational scale : scales) {
            locNumOfVals = SetTimingScale.addNN(locNumOfVals, ONE);
            this.validVals[i++] = scale;
        }
        this.numOfScales = locNumOfVals;
        this.from = this.validVals[0];
        this.to = this.validVals[this.validVals.length - 1];
        this.mkMD5hash();
        this.mkHash();
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (arg.getClass() != this.getClass()) {
            return false;
        }
        SetTimingScale as = (SetTimingScale)arg;
        if (this.type != as.type) {
            return false;
        }
        byte[] locMD5h = this.md5hash;
        byte[] argMD5h = as.md5hash;
        if (locMD5h == null || argMD5h == null) {
            return false;
        }
        if (!this.from.equals((Object)as.from)) {
            return false;
        }
        if (!this.to.equals((Object)as.to)) {
            return false;
        }
        if (!this.numOfScales.equals(as.numOfScales)) {
            return false;
        }
        int i = 0;
        while (i < locMD5h.length) {
            if (locMD5h[i] != argMD5h[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public void printVals() {
        BigRational[] bigRationalArray = this.validVals;
        int n = this.validVals.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull BigRational i = bigRationalArray[n2];
            System.out.println(i);
            ++n2;
        }
    }

    @Override
    public boolean inRange(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(this.from) >= 0 && value.compareTo(this.to) <= 0;
    }

    @Override
    public boolean elem(@Nullable BigRational value) {
        if (!this.inRange(value)) {
            return false;
        }
        int low = 0;
        int high = this.validVals.length - 1;
        int middle = high / 2;
        do {
            int cmp;
            if ((cmp = this.validVals[middle].compareTo(value)) == 0) {
                return true;
            }
            if (cmp < 0) {
                low = middle + 1;
            } else {
                high = middle - 1;
            }
            middle = (low + high) / 2;
        } while (low <= high);
        return false;
    }

    @Override
    public @NonNull BigRational closest(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        int low = 0;
        int high = this.validVals.length - 1;
        int middle = high / 2;
        int cmp;
        while ((cmp = this.validVals[middle].compareTo(value)) != 0) {
            if (cmp < 0) {
                low = middle + 1;
            } else {
                high = middle - 1;
            }
            if (high < low) {
                if (value.subtract(this.validVals[high]).compareTo(value.subtract(this.validVals[low]).negate()) < 0) {
                    return this.validVals[high];
                }
                return this.validVals[low];
            }
            middle = (low + high) / 2;
        }
        return value;
    }

    @Override
    public @Nullable BigRational closestUp(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return null;
        }
        int low = 0;
        int high = this.validVals.length - 1;
        int middle = high / 2;
        int cmp;
        while ((cmp = this.validVals[middle].compareTo(value)) != 0) {
            if (cmp < 0) {
                low = middle + 1;
            } else {
                high = middle - 1;
            }
            if (high < low) {
                return this.validVals[low];
            }
            middle = (low + high) / 2;
        }
        return value;
    }

    @Override
    public @Nullable BigRational closestDown(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return null;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        int low = 0;
        int high = this.validVals.length - 1;
        int middle = high / 2;
        int cmp;
        while ((cmp = this.validVals[middle].compareTo(value)) != 0) {
            if (cmp < 0) {
                low = middle + 1;
            } else {
                high = middle - 1;
            }
            if (high < low) {
                return this.validVals[high];
            }
            middle = (low + high) / 2;
        }
        return value;
    }

    @Override
    public Iterator<BigRational> iterator() {
        Iterator<BigRational> it = new Iterator<BigRational>(){
            @NonNull
            private @NonNull BigRational @NonNull [] p;
            private int i;
            {
                this.p = SetTimingScale.this.validVals;
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.p.length;
            }

            @Override
            public BigRational next() {
                if (this.i >= this.p.length) {
                    throw new NoSuchElementException();
                }
                @NonNull BigRational ret = this.p[this.i++];
                return ret;
            }
        };
        return it;
    }

    @Override
    public @NonNull TimingScale.IntervalNarrowingContext getInitialMiddle() {
        return new TimingScale.SetIntervalNarrowingContext(this.from, this.to, this.validVals.length, (this.validVals.length + 1) / 2, this.validVals);
    }

    @Override
    public @NonNull TimingScale shrinkScale(@Nullable BigInteger maxNumberOfScales) {
        if (maxNumberOfScales == null || maxNumberOfScales.compareTo(this.numOfScales) >= 0) {
            return this;
        }
        BigInteger numOfValuesToRemove = this.numOfScales.subtract(maxNumberOfScales);
        BigInteger removeEach = this.numOfScales.divide(numOfValuesToRemove);
        LinkedList<@NonNull BigRational> newSet = new LinkedList<BigRational>();
        if (removeEach.compareTo(BigInteger.ONE) == 0) {
            BigInteger takeEach = this.numOfScales.divide(maxNumberOfScales);
            int counter = 0;
            do {
                newSet.add(this.validVals[counter]);
            } while ((counter += takeEach.intValue()) < this.validVals.length);
            return new SetTimingScale(newSet);
        }
        BigInteger counter = BigInteger.ONE;
        BigRational[] bigRationalArray = this.validVals;
        int n = this.validVals.length;
        int n2 = 0;
        while (n2 < n) {
            BigRational value = bigRationalArray[n2];
            if (counter.compareTo(removeEach) >= 0) {
                counter = BigInteger.ONE;
            } else {
                newSet.add(value);
                counter = counter.add(BigInteger.ONE);
            }
            ++n2;
        }
        return new SetTimingScale(newSet);
    }

    @Override
    @NonNull TimingScale.IntervalNarrowingContext getValInMiddleR(@NonNull TimingScale.IntervalNarrowingContext interval) {
        interval.halfMidVal();
        interval.newMidVal();
        return interval;
    }
}

