/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeHidden;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Root
extends NodeHidden {
    private ArrayList<@NonNull NodeHidden> children = null;
    @Nullable
    private HashMap<@NonNull Node, @NonNull EErrorType> lastError = null;

    public Root(@NonNull String id) {
        super(id, ENodeType.Root);
    }

    @Override
    public void addChild(@NonNull Node child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if (!(child instanceof NodeHidden)) {
            throw new UnsupportedOperationException("Method addChild can be used only for ancestors of NodeHidden class.");
        }
        this.children.add((NodeHidden)child);
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        System.out.println("root(" + this.id + ")");
        NodeHidden last = null;
        for (NodeHidden node : this.children) {
            if (last == null) {
                last = node;
                continue;
            }
            last.printT(this, "  ", "");
            last = node;
        }
        if (last != null) {
            last.printT(this, "  ", "  ");
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer res = new StringBuffer("root(" + this.id + ")\n");
        NodeHidden last = null;
        for (NodeHidden node : this.children) {
            if (last == null) {
                last = node;
                continue;
            }
            res.append(last.stringT(this, "  ", ""));
            last = node;
        }
        if (last != null) {
            res.append(last.stringT(this, "  ", "  "));
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public boolean compute(@Nullable Node callee, @Nullable BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Root node " + this.id + " called 2nd times!";
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        for (NodeHidden node : this.children) {
            if (node.compute(this, BigRational.ONE)) continue;
            res = false;
        }
        return res;
    }

    @Override
    public BigRational[] prepareAuto(@Nullable Node callee, boolean sendFreq) {
        assert (!this.called) : "Root node " + this.id + " called 2nd times!";
        this.called = true;
        assert (this.children != null) : "Root not initialized yet";
        for (NodeHidden node : this.children) {
            node.prepareAuto(this, false);
        }
        return null;
    }

    @Nullable Map<@NonNull Node, @NonNull EErrorType> getLastError() {
        return Collections.unmodifiableMap(this.lastError);
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@Nullable Node callee, @Nullable BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.children != null) : "Null children in root node " + this.id;
        assert (this.children.size() > 0) : "Empty children in root node " + this.id;
        HashMap<@NonNull Node, @NonNull EErrorType> xxlastError = this.lastError;
        if (xxlastError == null) {
            xxlastError = new HashMap(this.children.size());
            this.lastError = xxlastError;
        } else {
            xxlastError.clear();
        }
        this.lastComp = ECompState.OnceSatisfied;
        EErrorType res = EErrorType.None;
        for (NodeHidden node : this.children) {
            EErrorType tmpr = node.computeAutoWR(this, BigRational.ONE);
            xxlastError.put(node, tmpr);
            if (tmpr == EErrorType.None || tmpr == EErrorType.NotEnabled) continue;
            res = tmpr;
        }
        if (res == EErrorType.None) {
            this.lastComp = ECompState.OnceSubtreeOK;
        }
        return res;
    }

    @Override
    public void trackAutoWR(@Nullable Node callee) {
        if (!this.enabled) {
            return;
        }
        assert (this.children != null) : "Null children in root node " + this.id;
        assert (this.children.size() > 0) : "Empty children in root node " + this.id;
        for (Node node : this.children) {
            node.trackAutoWR(this);
        }
    }

    @Override
    public boolean getReversePath(@NonNull Node callee, @NonNull List<@NonNull Node> path) {
        return true;
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@Nullable Node callee, @NonNull Node node) {
        assert (this.children != null) : "Null children in root node " + this.id;
        assert (this.children.size() > 0) : "Empty children in root node " + this.id;
        @NonNull ArrayList<@NonNull Node> res = new ArrayList<Node>();
        for (NodeHidden nd : this.children) {
            res.addAll(nd.getDirectlyConnectedTo(this, node));
        }
        return res;
    }
}

