/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.PLL;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;

public class PLLrev
extends PLL {
    @NonNull
    protected BigRational postDivider = BigRational.ONE;

    public PLLrev(@NonNull String id, @NonNull TimingScale multiplier, @NonNull TimingScale divider) {
        super(id, multiplier, divider);
        this.type = ENodeType.PLLrev;
    }

    @Override
    public void setPostDivider(@NonNull BigRational postDividerValue) {
        assert (postDividerValue.compareTo(BigRational.ZERO) > 0) : "Incorrect value of postdivider, must be positive";
        this.postDivider = postDividerValue;
    }

    @Override
    public BigRational getPostDivider() {
        return this.postDivider;
    }

    @Override
    public void setJustMultiplier(@Nullable BigRational multiply) {
        FreqLimitErrorI xxLogFLE = this.logFLE;
        if (this.multiplier == null || multiply == null) {
            this.setMultiplier = null;
            this.setDivider = null;
            if (this.multiplier == null && xxLogFLE != null && this.enabled) {
                xxLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
        } else {
            this.setDivider = null;
            if (this.multiplier.elem(multiply)) {
                this.setMultiplier = multiply;
            } else {
                this.setMultiplier = null;
                this.setDivider = null;
                if (xxLogFLE != null && this.enabled) {
                    this.isInternalDivError = false;
                    xxLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
                }
            }
        }
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational xxOutputClock;
        BigRational xxSetMultiplier;
        if (!this.enabled) {
            return true;
        }
        assert (this.multiplier != null) : "PLL multiplier not defined - " + this.id;
        assert (this.divider != null) : "PLL multiplier not defined - " + this.id;
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if ((xxSetMultiplier = this.setMultiplier) != null) {
            BigRational xxSetDivider = this.setDivider;
            assert (xxSetDivider != null) : "Divider unset for PLL even if defined";
            xxOutputClock = clock.multiply(xxSetMultiplier);
            BigRational xxFCCOClock = xxOutputClock.multiply(this.postDivider).multiply(xxSetDivider);
            if (!this.checkInternalDividerFreq(xxFCCOClock)) {
                res = false;
            }
        } else {
            assert (this.useDefaults) : "Default vaule used even if forbidden in " + this.id;
            BigRational xxDefaultMul = this.defaultMul;
            assert (xxDefaultMul != null) : "Default vaule used even if forbidden in " + this.id;
            BigRational xxDefaultDiv = this.defaultDiv;
            assert (xxDefaultDiv != null) : "Divider without default value and used for division";
            xxOutputClock = clock.multiply(xxDefaultMul);
            BigRational xxFCCOClock = xxOutputClock.multiply(this.postDivider).multiply(xxDefaultDiv);
            if (!this.checkInternalDividerFreq(xxFCCOClock)) {
                res = false;
            }
        }
        if (!this.checkOutputFreq(xxOutputClock)) {
            res = false;
        }
        this.outputClock = xxOutputClock;
        if (this.child.compute(this, xxOutputClock)) {
            return res;
        }
        return false;
    }

    private @NonNull EErrorType computeSetOutputFreq(@NonNull BigRational clock, @NonNull BigRational setOutFreq, boolean @NonNull [] internalDivError) {
        internalDivError[0] = false;
        BigRational ratioOI = setOutFreq.divide(clock);
        TimingScale xxdivider = this.divider;
        TimingScale xxmultiplier = this.multiplier;
        assert (xxdivider != null);
        assert (xxmultiplier != null);
        BigRational xxcompMultiplier = xxmultiplier.closest(ratioOI);
        BigRational xxOutputClock = clock.multiply(xxcompMultiplier);
        BigRational xxcompDivider = null;
        EErrorType total = EErrorType.None;
        for (BigRational dividerFCC : xxdivider) {
            assert (dividerFCC != null);
            BigRational xxFCCOClock = xxOutputClock.multiply(this.postDivider).multiply(dividerFCC);
            EErrorType actual = this.testDividerFreq(xxFCCOClock);
            if (actual == EErrorType.None) {
                xxcompDivider = dividerFCC;
                total = EErrorType.None;
                break;
            }
            if (total == EErrorType.None) {
                total = actual;
                continue;
            }
            if (actual == total) continue;
            total = EErrorType.CannotSetup;
        }
        if (xxcompDivider == null) {
            internalDivError[0] = true;
            return total;
        }
        this.compDivider = xxcompDivider;
        this.compMultiplier = xxcompMultiplier;
        BigRational ac = setOutFreq.compareTo(xxOutputClock) < 0 ? xxOutputClock.divide(setOutFreq).subtract(BigRational.ONE) : setOutFreq.divide(xxOutputClock).subtract(BigRational.ONE);
        if (ac.compareTo(this.accuracy) > 0) {
            return EErrorType.CannotSetup;
        }
        EErrorType sbr = this.testOutputFreq(xxOutputClock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.outputClock = xxOutputClock;
        return EErrorType.None;
    }

    private @NonNull EErrorType computePLLrevAllPos(@NonNull BigRational clock) {
        TimingScale xxDivider = this.divider;
        TimingScale xxMultiplier = this.multiplier;
        assert (xxDivider != null && xxMultiplier != null);
        EErrorType outErr = EErrorType.None;
        block0: for (BigRational mul : xxMultiplier) {
            assert (mul != null);
            BigRational trueOutputClock = clock.multiply(mul);
            outErr = this.testOutputFreq(trueOutputClock);
            if (outErr == EErrorType.TooSlow) continue;
            if (outErr == EErrorType.TooFast) break;
            for (BigRational dividerFCC : xxDivider) {
                assert (dividerFCC != null);
                BigRational xxFCCOClock = trueOutputClock.multiply(this.postDivider).multiply(dividerFCC);
                EErrorType fccErr = this.testDividerFreq(xxFCCOClock);
                if (fccErr == EErrorType.TooSlow) continue;
                if (fccErr == EErrorType.TooFast) continue block0;
                this.lastComp = ECompState.OnceSatisfied;
                EErrorType childErr = this.child.computeAutoWR(this, trueOutputClock);
                if (childErr == EErrorType.None || childErr == EErrorType.NotEnabled) {
                    this.compMultiplier = mul;
                    this.compDivider = dividerFCC;
                    this.outputClock = trueOutputClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                if (childErr == EErrorType.TooSlow || childErr == EErrorType.CannotSetup) continue block0;
                return childErr;
            }
        }
        if (outErr == EErrorType.TooSlow) {
            return outErr;
        }
        return EErrorType.CannotSetup;
    }

    private @NonNull EErrorType computePLLrevAutoWR(@NonNull BigRational clock) {
        BigRational actDiv;
        BigRational actMul;
        if (this.setMultiplier != null) {
            actMul = this.setMultiplier;
            actDiv = this.setDivider;
        } else if (this.useDefaults && this.defaultMul != null) {
            actMul = this.defaultMul;
            assert (this.defaultDiv != null) : "If default multiplier is set then divider must be set too in " + this.id;
            actDiv = this.defaultDiv;
        } else {
            actMul = null;
            actDiv = null;
        }
        @NonNull EErrorType sbr = EErrorType.None;
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (actMul != null && actDiv == null) {
            TimingScale xxDivider = this.divider;
            assert (xxDivider != null);
            BigRational xxOutputClock = clock.multiply(actMul);
            EErrorType fccErr = EErrorType.None;
            for (BigRational dividerFCC : xxDivider) {
                assert (dividerFCC != null);
                BigRational xxFCCOClock = xxOutputClock.multiply(this.postDivider).multiply(dividerFCC);
                fccErr = this.testDividerFreq(xxFCCOClock);
                if (fccErr == EErrorType.TooSlow) continue;
                if (fccErr == EErrorType.TooFast) break;
                this.lastComp = ECompState.OnceSatisfied;
                EErrorType childErr = this.child.computeAutoWR(this, xxOutputClock);
                if (childErr == EErrorType.None || childErr == EErrorType.NotEnabled) {
                    this.compMultiplier = actMul;
                    this.compDivider = dividerFCC;
                    this.outputClock = xxOutputClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                return childErr;
            }
            if (fccErr == EErrorType.TooSlow) {
                return fccErr;
            }
            return EErrorType.CannotSetup;
        }
        if (actMul != null && actDiv != null) {
            BigRational xxOutputClock = clock.multiply(actMul);
            BigRational xxFCCOClock = xxOutputClock.multiply(this.postDivider).multiply(actDiv);
            sbr = this.testDividerFreq(xxFCCOClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            sbr = this.testOutputFreq(xxOutputClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = xxOutputClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, xxOutputClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return nres;
        }
        if (xxSetOutputFreq != null) {
            sbr = this.computeSetOutputFreq(clock, xxSetOutputFreq, new boolean[1]);
            BigRational xxoutputClock = this.outputClock;
            assert (xxoutputClock != null);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, xxoutputClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return nres;
        }
        return this.computePLLrevAllPos(clock);
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational xxOutputClock;
        BigRational xxFCCOClock;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.multiplier != null) : "PLLrev not fully defined - " + this.id;
        EErrorType sbr = this.testInputFreq(clock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        BigRational xxDefaultDiv = this.defaultDiv;
        BigRational xxDefaultMul = this.defaultMul;
        if (xxDefaultDiv != null && xxDefaultMul != null && (sbr = this.testDividerFreq(xxFCCOClock = (xxOutputClock = clock.multiply(xxDefaultMul)).multiply(this.postDivider).multiply(xxDefaultDiv))) == EErrorType.None && (sbr = this.testOutputFreq(xxOutputClock)) == EErrorType.None) {
            this.outputClock = xxOutputClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, xxOutputClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.compDivider = xxDefaultDiv;
                this.compMultiplier = xxDefaultMul;
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
        }
        return this.computePLLrevAutoWR(clock);
    }
}

