/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FLLPLL;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.GeometricTimingScale;
import com.nxp.swtools.clocks.model.LinearTimingScale;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.SetTimingScale;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PLL
extends FLLPLL {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(PLL.class);
    private static final int MAX_NUM_OF_CONFIGS_POW = 24;
    @NonNull
    protected TimingScale divider = new TimingScale();
    @Nullable
    protected BigRational defaultDiv;
    @Nullable
    protected BigRational setDivider;
    @Nullable
    protected BigRational compDivider;
    @Nullable
    protected BigRational minDividerOutput;
    @Nullable
    protected BigRational maxDividerOutput;
    protected int @Nullable [][] combinedArray = null;
    protected static final int[] TRAVERSAL_ORDER;
    protected static final int TRAVERSAL_STEP = 127;
    protected static final int MAX_CACHE = 5;
    protected Object[][] cache = new Object[5][6];
    private int constrainedMinDiv = 0;
    @NonNull
    private static final BigRational DEFAULT_DECIMAL_STEP;
    private static final int NUMBER_OF_DIGITS = 4;

    static {
        int[] nArray = new int[127];
        nArray[0] = 63;
        nArray[1] = 31;
        nArray[2] = 95;
        nArray[3] = 15;
        nArray[4] = 47;
        nArray[5] = 79;
        nArray[6] = 111;
        nArray[7] = 7;
        nArray[8] = 23;
        nArray[9] = 39;
        nArray[10] = 55;
        nArray[11] = 71;
        nArray[12] = 87;
        nArray[13] = 103;
        nArray[14] = 119;
        nArray[15] = 3;
        nArray[16] = 11;
        nArray[17] = 19;
        nArray[18] = 27;
        nArray[19] = 35;
        nArray[20] = 43;
        nArray[21] = 51;
        nArray[22] = 59;
        nArray[23] = 67;
        nArray[24] = 75;
        nArray[25] = 83;
        nArray[26] = 91;
        nArray[27] = 99;
        nArray[28] = 107;
        nArray[29] = 115;
        nArray[30] = 123;
        nArray[31] = 1;
        nArray[32] = 5;
        nArray[33] = 9;
        nArray[34] = 13;
        nArray[35] = 17;
        nArray[36] = 21;
        nArray[37] = 25;
        nArray[38] = 29;
        nArray[39] = 33;
        nArray[40] = 37;
        nArray[41] = 41;
        nArray[42] = 45;
        nArray[43] = 49;
        nArray[44] = 53;
        nArray[45] = 57;
        nArray[46] = 61;
        nArray[47] = 65;
        nArray[48] = 69;
        nArray[49] = 73;
        nArray[50] = 77;
        nArray[51] = 81;
        nArray[52] = 85;
        nArray[53] = 89;
        nArray[54] = 93;
        nArray[55] = 97;
        nArray[56] = 101;
        nArray[57] = 105;
        nArray[58] = 109;
        nArray[59] = 113;
        nArray[60] = 117;
        nArray[61] = 121;
        nArray[62] = 125;
        nArray[64] = 2;
        nArray[65] = 4;
        nArray[66] = 6;
        nArray[67] = 8;
        nArray[68] = 10;
        nArray[69] = 12;
        nArray[70] = 14;
        nArray[71] = 16;
        nArray[72] = 18;
        nArray[73] = 20;
        nArray[74] = 22;
        nArray[75] = 24;
        nArray[76] = 26;
        nArray[77] = 28;
        nArray[78] = 30;
        nArray[79] = 32;
        nArray[80] = 34;
        nArray[81] = 36;
        nArray[82] = 38;
        nArray[83] = 40;
        nArray[84] = 42;
        nArray[85] = 44;
        nArray[86] = 46;
        nArray[87] = 48;
        nArray[88] = 50;
        nArray[89] = 52;
        nArray[90] = 54;
        nArray[91] = 56;
        nArray[92] = 58;
        nArray[93] = 60;
        nArray[94] = 62;
        nArray[95] = 64;
        nArray[96] = 66;
        nArray[97] = 68;
        nArray[98] = 70;
        nArray[99] = 72;
        nArray[100] = 74;
        nArray[101] = 76;
        nArray[102] = 78;
        nArray[103] = 80;
        nArray[104] = 82;
        nArray[105] = 84;
        nArray[106] = 86;
        nArray[107] = 88;
        nArray[108] = 90;
        nArray[109] = 92;
        nArray[110] = 94;
        nArray[111] = 96;
        nArray[112] = 98;
        nArray[113] = 100;
        nArray[114] = 102;
        nArray[115] = 104;
        nArray[116] = 106;
        nArray[117] = 108;
        nArray[118] = 110;
        nArray[119] = 112;
        nArray[120] = 114;
        nArray[121] = 116;
        nArray[122] = 118;
        nArray[123] = 120;
        nArray[124] = 122;
        nArray[125] = 124;
        nArray[126] = 126;
        TRAVERSAL_ORDER = nArray;
        DEFAULT_DECIMAL_STEP = new BigRational(1, 10);
    }

    private static int gcd(int a, int b) {
        BigInteger aBig = BigInteger.valueOf(a);
        BigInteger bBig = BigInteger.valueOf(b);
        return aBig.gcd(bBig).intValue();
    }

    /*
     * Unable to fully structure code
     */
    private static void qrsort(int @NonNull [][] vals, int low, int high) {
        if (high <= low) {
            return;
        }
        tmp = high - low;
        if (tmp == 1) {
            if (vals[high][0] * vals[low][1] < vals[low][0] * vals[high][1]) {
                tmp0 = vals[low][0];
                tmp1 = vals[low][1];
                vals[low][0] = vals[high][0];
                vals[low][1] = vals[high][1];
                vals[high][0] = tmp0;
                vals[high][1] = tmp1;
            }
            return;
        }
        tmp = low + tmp / 2;
        swap0 = vals[tmp][0];
        swap1 = vals[tmp][1];
        actLow = low;
        actHigh = high;
        ** GOTO lbl34
        {
            ++actLow;
            do {
                if (actLow < actHigh && (long)vals[actLow][0] * swap1 < swap0 * (long)vals[actLow][1]) continue block0;
                while (actLow < actHigh && swap0 * (long)vals[actHigh][1] < (long)vals[actHigh][0] * swap1) {
                    --actHigh;
                }
                if (actLow >= actHigh) continue;
                tmp0 = vals[actLow][0];
                tmp1 = vals[actLow][1];
                vals[actLow][0] = vals[actHigh][0];
                vals[actLow][1] = vals[actHigh][1];
                vals[actHigh][0] = tmp0;
                vals[actHigh][1] = tmp1;
                ++actLow;
                --actHigh;
lbl34:
                // 3 sources

            } while (actLow < actHigh);
        }
        if (actLow == actHigh) {
            if ((long)vals[actLow][0] * swap1 < swap0 * (long)vals[actLow][1]) {
                ++actLow;
            } else {
                --actHigh;
            }
        }
        if (actHigh > low) {
            PLL.qrsort(vals, low, actHigh);
        }
        if (high > actLow) {
            PLL.qrsort(vals, actLow, high);
        }
    }

    private static int @NonNull [][] mkCombinedArray(int divMin, int divMax, int mulMin, int mulMax) {
        if (divMin < 1 || divMax < divMin || mulMin < 1 || mulMax < mulMin) {
            throw new UnsupportedOperationException("Divider/multiplier limits out of bounds.");
        }
        int divSize = divMax - divMin + 1;
        int mulSize = mulMax - mulMin + 1;
        long totalSize = (long)divSize * (long)mulSize;
        if (totalSize > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Unsupported array size: Array size longer then MAX INT.");
        }
        int[][] vals = new int[1 + (int)totalSize][2];
        vals[(int)totalSize][1] = 0;
        vals[(int)totalSize][0] = 0;
        int i = mulMin;
        int j = divMin;
        int k = 0;
        while (k < (int)totalSize) {
            int gcdVal = PLL.gcd(i, j);
            vals[k][0] = i / gcdVal;
            vals[k][1] = j / gcdVal;
            if (++j > divMax) {
                j = divMin;
                ++i;
            }
            ++k;
        }
        PLL.qrsort(vals, 0, (int)totalSize - 1);
        int shrinkedTotal = 0;
        int k2 = 0;
        while (k2 < (int)totalSize) {
            if (vals[k2][0] != vals[k2 + 1][0] || vals[k2][1] != vals[k2 + 1][1]) {
                ++shrinkedTotal;
            }
            ++k2;
        }
        int @NonNull [][] result = new int[shrinkedTotal][2];
        i = 0;
        int k3 = 0;
        while (k3 < (int)totalSize) {
            if (vals[k3][0] != vals[k3 + 1][0] || vals[k3][1] != vals[k3 + 1][1]) {
                result[i][0] = vals[k3][0];
                result[i++][1] = vals[k3][1];
            }
            ++k3;
        }
        return result;
    }

    public PLL(@NonNull String id) {
        super(id, ENodeType.PLL);
        this.defaultDiv = null;
        this.setDivider = null;
        this.minDividerOutput = null;
        this.maxDividerOutput = null;
    }

    public PLL(@NonNull String id, @NonNull TimingScale multiplier, @NonNull TimingScale divider) {
        super(id, ENodeType.PLL, multiplier, null);
        this.divider = divider;
        this.defaultDiv = null;
        this.setDivider = null;
        this.minDividerOutput = null;
        this.maxDividerOutput = null;
    }

    private int @Nullable [][] readCache(@NonNull BigRational clock) {
        Object[][] locCache = this.cache;
        int i = 0;
        while (i < 5) {
            if (locCache[i][2] == null) {
                return null;
            }
            if (clock.equals(locCache[i][2])) {
                boolean limitsOK = true;
                BigRational xxMinDividerOutput = this.minDividerOutput;
                limitsOK = xxMinDividerOutput == null ? locCache[i][0] == null : xxMinDividerOutput.equals(locCache[i][0]);
                BigRational xxMaxDividerOutput = this.maxDividerOutput;
                if (limitsOK) {
                    limitsOK = xxMaxDividerOutput == null ? locCache[i][1] == null : xxMaxDividerOutput.equals(locCache[i][1]);
                }
                if (limitsOK && this.divider == this.cache[i][3] && this.multiplier == this.cache[i][4]) {
                    return (int[][])this.cache[i][5];
                }
            }
            ++i;
        }
        return null;
    }

    void insertToCache(@NonNull BigRational clock, int @NonNull [][] combArr) {
        int i = 0;
        while (i < 5) {
            if (this.cache[i][2] == null) {
                this.cache[i][0] = this.minDividerOutput;
                this.cache[i][1] = this.maxDividerOutput;
                this.cache[i][2] = clock;
                this.cache[i][3] = this.divider;
                this.cache[i][4] = this.multiplier;
                this.cache[i][5] = combArr;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.cache[i][0] = this.cache[i + 1][0];
            this.cache[i][1] = this.cache[i + 1][1];
            this.cache[i][2] = this.cache[i + 1][2];
            this.cache[i][3] = this.cache[i + 1][3];
            this.cache[i][4] = this.cache[i + 1][4];
            this.cache[i][5] = this.cache[i + 1][5];
            ++i;
        }
        this.cache[4][0] = this.minDividerOutput;
        this.cache[4][1] = this.maxDividerOutput;
        this.cache[4][2] = clock;
        this.cache[4][3] = this.divider;
        this.cache[4][4] = this.multiplier;
        this.cache[4][5] = combArr;
    }

    @Override
    public void setMulDivTimingScale(@NonNull TimingScale multiplier, @Nullable TimingScale divider) {
        this.multiplier = multiplier;
        assert (divider != null) : "Trying to insert empty divider into PLL " + this.id;
        this.divider = divider;
        this.setMultiplier = null;
        this.setDivider = null;
        this.defaultMul = null;
        this.defaultDiv = null;
    }

    @Override
    public void setMultiplierDivider(@Nullable BigRational multiply, @Nullable BigRational divide) {
        FreqLimitErrorI xxLogFLE = this.logFLE;
        if (this.multiplier == null || multiply == null || divide == null) {
            this.setMultiplier = null;
            this.setDivider = null;
            if (this.multiplier == null && xxLogFLE != null && this.enabled) {
                xxLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
        } else {
            TimingScale tmpDiv = this.divider;
            assert (tmpDiv != null) : "Method setMultiplierDivider wrongly used for FLL";
            if (this.multiplier.elem(multiply) && tmpDiv.elem(divide)) {
                this.setMultiplier = multiply;
                this.setDivider = divide;
            } else {
                this.setMultiplier = null;
                this.setDivider = null;
                if (xxLogFLE != null && this.enabled) {
                    if (!tmpDiv.elem(divide)) {
                        this.isInternalDivError = true;
                        xxLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
                    }
                    if (!this.multiplier.elem(multiply)) {
                        this.isInternalDivError = false;
                        xxLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
                    }
                }
            }
        }
    }

    @Override
    public @Nullable BigRational getDivider() {
        return this.setDivider;
    }

    @Override
    public void setDefaultMultiplierDivider(@Nullable BigRational multiply, @Nullable BigRational divide) {
        if (this.multiplier == null || multiply == null || divide == null) {
            this.defaultMul = null;
            this.defaultDiv = null;
        } else {
            TimingScale tmpDiv = this.divider;
            assert (tmpDiv != null) : "Method setDefaultMultiplierDivider wrongly used for FLL";
            if (this.multiplier.elem(multiply) && tmpDiv.elem(divide)) {
                this.defaultMul = multiply;
                this.defaultDiv = divide;
            } else {
                this.defaultMul = null;
                this.defaultDiv = null;
            }
        }
    }

    @Override
    public @Nullable BigRational getDefaultDivider() {
        return this.defaultDiv;
    }

    @Override
    public @Nullable BigRational getPLLMinDividerOutput() {
        return this.minDividerOutput;
    }

    @Override
    public @Nullable BigRational getPLLMaxDividerOutput() {
        return this.maxDividerOutput;
    }

    @Override
    public void setMinDividerFreq(@Nullable BigRational freq) {
        this.minDividerOutput = freq;
    }

    @Override
    public void setMaxDividerFreq(@Nullable BigRational freq) {
        this.maxDividerOutput = freq;
    }

    @Override
    public boolean getInternalDivError() {
        return this.isInternalDivError;
    }

    protected boolean checkDividerFreq(@Nullable BigRational clock) {
        if (clock == null) {
            return true;
        }
        BigRational xxMinDividerOutput = this.minDividerOutput;
        if (xxMinDividerOutput != null && xxMinDividerOutput.compareTo(clock) > 0) {
            return false;
        }
        BigRational xxMaxDividerOutput = this.maxDividerOutput;
        return xxMaxDividerOutput == null || xxMaxDividerOutput.compareTo(clock) >= 0;
    }

    @Override
    public boolean checkInternalDividerFreq(@Nullable BigRational clock) {
        this.isInternalDivError = true;
        if (clock == null) {
            return true;
        }
        FreqLimitErrorI xxLogFLE = this.logFLE;
        BigRational xxMinDividerOutput = this.minDividerOutput;
        if (xxMinDividerOutput != null && xxMinDividerOutput.compareTo(clock) > 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        BigRational xxMaxDividerOutput = this.maxDividerOutput;
        if (xxMaxDividerOutput != null && xxMaxDividerOutput.compareTo(clock) < 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        return true;
    }

    protected @NonNull EErrorType testDividerFreq(@Nullable BigRational clock) {
        if (!this.testFreqLimits) {
            return EErrorType.None;
        }
        if (clock == null) {
            return EErrorType.ArgNull;
        }
        BigRational xxMinDividerOutput = this.minDividerOutput;
        if (xxMinDividerOutput != null && xxMinDividerOutput.compareTo(clock) > 0) {
            return EErrorType.TooSlow;
        }
        BigRational xxMaxDividerOutput = this.maxDividerOutput;
        if (xxMaxDividerOutput != null && xxMaxDividerOutput.compareTo(clock) < 0) {
            return EErrorType.TooFast;
        }
        return EErrorType.None;
    }

    @Override
    public boolean checkInputFreq(@Nullable BigRational clock) {
        this.isInternalDivError = false;
        if (clock == null || !this.testFreqLimits) {
            return true;
        }
        BigRational xxMinInputFreq = this.minInputFreq;
        FreqLimitErrorI xxLogFLE = this.logFLE;
        if (xxMinInputFreq != null && xxMinInputFreq.compareTo(clock) > 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(true, this);
            }
            return false;
        }
        BigRational xxMaxInputFreq = this.maxInputFreq;
        if (xxMaxInputFreq != null && xxMaxInputFreq.compareTo(clock) < 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(true, this);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOutputFreq(@Nullable BigRational clock) {
        this.isInternalDivError = false;
        if (clock == null || !this.testFreqLimits) {
            return true;
        }
        BigRational xxMinOutputFreq = this.minOutputFreq;
        FreqLimitErrorI xxLogFLE = this.logFLE;
        if (xxMinOutputFreq != null && xxMinOutputFreq.compareTo(clock) > 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        BigRational xxMaxOutputFreq = this.maxOutputFreq;
        if (xxMaxOutputFreq != null && xxMaxOutputFreq.compareTo(clock) < 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        return true;
    }

    @Override
    public @Nullable BigRational getPLLdivClock() {
        BigRational tmpInputClock = this.inputClock;
        if (tmpInputClock == null) {
            return null;
        }
        if (this.outputClock == null) {
            return null;
        }
        BigRational tmpSetDivider = this.setDivider;
        BigRational tmpDefaultDiv = this.defaultDiv;
        if (!(tmpSetDivider != null || this.useDefaults && tmpDefaultDiv != null)) {
            return null;
        }
        if (!(this.setMultiplier != null || this.useDefaults && this.defaultMul != null)) {
            return null;
        }
        BigRational result = null;
        if (tmpSetDivider != null) {
            result = tmpInputClock.divide(tmpSetDivider);
        } else if (tmpDefaultDiv != null) {
            result = tmpInputClock.divide(tmpDefaultDiv);
        }
        return result;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        if (this.setDivider == null || this.setMultiplier == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        if (!(this.setDivider != null && this.setMultiplier != null || this.defaultDiv != null && this.defaultMul != null)) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public void clean() {
        super.clean();
        this.setDivider = null;
        this.compDivider = null;
    }

    @Override
    public void resetAndCleanScale() {
        this.divider = new TimingScale();
        this.defaultDiv = null;
        this.setDivider = null;
        this.compDivider = null;
        this.minDividerOutput = null;
        this.maxDividerOutput = null;
        this.multiplier = null;
        this.defaultMul = null;
        this.setMultiplier = null;
        this.compMultiplier = null;
        this.outputClock = null;
        this.inputClock = null;
        this.setOutputFreq = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
        this.combinedArray = null;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational xxOutputClock;
        BigRational xxSetMultiplier;
        if (!this.enabled) {
            return true;
        }
        assert (this.multiplier != null) : "PLL multiplier not defined - " + this.id;
        assert (this.divider != null) : "PLL multiplier not defined - " + this.id;
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if ((xxSetMultiplier = this.setMultiplier) != null) {
            BigRational xxSetDivider = this.setDivider;
            assert (xxSetDivider != null) : "Divider unset for PLL even if defined";
            BigRational divClock = clock.divide(xxSetDivider);
            if (!this.checkInternalDividerFreq(divClock)) {
                res = false;
            }
            this.workingMultiplier = xxSetMultiplier;
            xxOutputClock = this.operation.clockModify(divClock);
        } else {
            assert (this.useDefaults) : "Default vaule used even if forbidden in " + this.id;
            BigRational xxDefaultMul = this.defaultMul;
            assert (xxDefaultMul != null) : "Default vaule used even if forbidden in " + this.id;
            BigRational xxDefaultDiv = this.defaultDiv;
            assert (xxDefaultDiv != null) : "Divider without default value and used for division";
            BigRational divClock = clock.divide(xxDefaultDiv);
            if (!this.checkInternalDividerFreq(divClock)) {
                res = false;
            }
            this.workingMultiplier = xxDefaultMul;
            xxOutputClock = this.operation.clockModify(divClock);
        }
        if (!this.checkOutputFreq(xxOutputClock)) {
            res = false;
        }
        this.outputClock = xxOutputClock;
        if (this.child.compute(this, xxOutputClock)) {
            return res;
        }
        return false;
    }

    private @NonNull BigRational @Nullable [] getRatioConstrComb(@NonNull BigRational reqRatio, @NonNull BigRational clock) {
        int minDiv;
        boolean isConstrained = true;
        int[][] vals = this.manipulateConstraintCombArray(clock);
        if (vals == null) {
            vals = this.combinedArray;
            isConstrained = false;
        }
        assert (vals != null);
        int low = 0;
        int high = vals.length - 1;
        int middle = high / 2;
        boolean found = false;
        while (true) {
            BigRational midValue = new BigRational(vals[middle][0], vals[middle][1]);
            switch (midValue.compareTo(reqRatio)) {
                case 0: {
                    found = true;
                    break;
                }
                case -1: {
                    low = middle + 1;
                    break;
                }
                default: {
                    high = middle - 1;
                }
            }
            if (found || high < low) break;
            middle = high + low >>> 1;
        }
        if (!found) {
            BigRational midValue1;
            BigRational midValue2 = midValue1 = new BigRational(vals[middle][0], vals[middle][1]);
            int middle2 = middle;
            boolean middleClosest = false;
            if (midValue1.compareTo(reqRatio) < 0) {
                middle2 = middle + 1;
                if (middle2 >= vals.length) {
                    middleClosest = true;
                } else {
                    midValue2 = new BigRational(vals[middle2][0], vals[middle2][1]);
                }
            } else if (middle == 0) {
                middleClosest = true;
            } else {
                middle2 = middle - 1;
                midValue2 = new BigRational(vals[middle2][0], vals[middle2][1]);
            }
            if (!middleClosest) {
                BigRational diff2;
                BigRational diff1 = reqRatio.subtract(midValue1);
                if (diff1.compareTo(TimingScale.ZERO) < 0) {
                    diff1 = diff1.negate();
                }
                if ((diff2 = reqRatio.subtract(midValue2)).compareTo(TimingScale.ZERO) < 0) {
                    diff2 = diff2.negate();
                }
                if (diff1.compareTo(diff2) > 0) {
                    middle = middle2;
                }
            }
        }
        if (isConstrained) {
            minDiv = this.constrainedMinDiv;
        } else {
            assert (this.divider.from.getDenominator().equals(TimingScale.ONE));
            minDiv = this.divider.from.getNumerator().intValue();
        }
        int tmpMul = vals[middle][0];
        int tmpDiv = vals[middle][1];
        assert (this.multiplier.from.getDenominator().equals(TimingScale.ONE));
        int tmpMulFromValue = this.multiplier.from.getNumerator().intValue();
        int mulFactor = 1;
        if (tmpDiv < minDiv) {
            mulFactor = minDiv / tmpDiv;
            if (minDiv % tmpDiv != 0) {
                ++mulFactor;
            }
        }
        if (tmpMul < tmpMulFromValue) {
            int tmpMulFactor = tmpMulFromValue / tmpMul;
            if (tmpMulFromValue % tmpMul != 0) {
                ++tmpMulFactor;
            }
            if (tmpMulFactor > mulFactor) {
                mulFactor = tmpMulFactor;
            }
        }
        if (mulFactor > 1) {
            tmpMul *= mulFactor;
            tmpDiv *= mulFactor;
        }
        @NonNull BigRational imul = new BigRational(tmpMul);
        @NonNull BigRational idiv = new BigRational(tmpDiv);
        @NonNull BigRational[] res = new BigRational[]{imul, idiv};
        return res;
    }

    protected @NonNull BigRational @Nullable [] getRatio(@NonNull BigRational reqRatio, @NonNull BigRational clock) {
        if (this.combinedArray != null) {
            return this.getRatioConstrComb(reqRatio, clock);
        }
        BigRational searchedRatio = reqRatio;
        BigInteger fraction = this.multiplierFraction;
        if (fraction != null) {
            searchedRatio = searchedRatio.multiply(fraction);
        }
        assert (this.divider != null) : "Wrongly initialized divider in " + this.id;
        assert (this.multiplier != null) : "Wrongly initialized divider in " + this.id;
        BigRational proposedDivider = new BigRational(searchedRatio.getDenominator());
        BigRational proposedMultiplier = new BigRational(searchedRatio.getNumerator());
        @Nullable BigRational[] dividerBoundries = this.getDividerBounds(clock);
        this.multiplier.setRequiredRatio(reqRatio.multiply(proposedDivider));
        if (this.divider.elem(proposedDivider) && this.multiplier.elem(proposedMultiplier) && PLL.isInRange(dividerBoundries, proposedDivider)) {
            return new BigRational[]{proposedMultiplier, proposedDivider};
        }
        BigRational[] closestPair = null;
        for (BigRational currentDivider : this.divider) {
            assert (currentDivider != null);
            if (!PLL.isInRange(dividerBoundries, currentDivider)) continue;
            this.multiplier.setRequiredRatio(reqRatio.multiply(currentDivider));
            proposedMultiplier = searchedRatio.multiply(currentDivider);
            if (this.divider.elem(currentDivider) && this.multiplier.elem(proposedMultiplier)) {
                this.workingMultiplier = proposedMultiplier;
                return new BigRational[]{proposedMultiplier, currentDivider};
            }
            proposedMultiplier = this.multiplier.closest(proposedMultiplier);
            closestPair = PLL.getCloserRatio(closestPair, new BigRational[]{proposedMultiplier, currentDivider}, searchedRatio);
        }
        if (closestPair == null) {
            @NonNull BigRational[] oldResult = this.oldGetRatio(searchedRatio, clock);
            if (oldResult != null) {
                LOGGER.log(Level.SEVERE, "PLL algorythm results do not match!! Please contact Filip Cekovsky!");
            }
            return oldResult;
        }
        return closestPair;
    }

    private static @NonNull BigRational @Nullable [] getCloserRatio(@NonNull BigRational @Nullable [] current, @NonNull BigRational @NonNull [] proposed, @NonNull BigRational reqRatio) {
        @NonNull BigRational[] original = current;
        if (original == null) {
            if (proposed.length == 2) {
                return proposed;
            }
            LOGGER.log(Level.SEVERE, "PLL updateClosestRatio() contract violated - argument with unexpected number of values");
            return null;
        }
        if (proposed.length != 2 || original.length != 2) {
            LOGGER.log(Level.SEVERE, "PLL updateClosestRatio() contract violated - argument with unexpected number of values");
            return original;
        }
        BigRational currentRatio = new BigRational(original[0].toBigInteger(), original[1].toBigInteger());
        BigRational proposedRatio = new BigRational(proposed[0].toBigInteger(), proposed[1].toBigInteger());
        if (currentRatio.subtract(reqRatio).abs().compareTo(proposedRatio.subtract(reqRatio).abs()) > 0) {
            return proposed;
        }
        return original;
    }

    private @Nullable BigRational @NonNull [] getDividerBounds(@NonNull BigRational input) {
        BigRational locMaxDividerOutput = this.maxDividerOutput;
        BigRational locMinDividerOutput = this.minDividerOutput;
        BigRational minDivider = null;
        BigRational maxDivider = null;
        if (locMaxDividerOutput != null && input.compareTo(locMaxDividerOutput) > 0) {
            BigRational minDivision = input.divide(locMaxDividerOutput);
            minDivider = this.divider.closestUp(minDivision);
        }
        if (locMinDividerOutput != null && input.compareTo(locMinDividerOutput) < 0) {
            BigRational maxDivision = input.divide(locMinDividerOutput);
            maxDivider = this.divider.closestUp(maxDivision);
        }
        return new BigRational[]{minDivider == null ? this.divider.from : minDivider, maxDivider == null ? this.divider.to : maxDivider};
    }

    private static boolean isInRange(@Nullable BigRational @NonNull [] range, @NonNull BigRational value) {
        if (range.length != 2) {
            LOGGER.log(Level.SEVERE, "PLL isInRange contract viiolated - range with unexpected number of values");
            return true;
        }
        BigRational[] locRange = range;
        if (locRange[1] == null) {
            if (locRange[0] == null) {
                return true;
            }
            return locRange[0].compareTo(value) <= 0;
        }
        if (locRange[0] == null) {
            return locRange[1].compareTo(value) >= 0;
        }
        return locRange[0].compareTo(value) <= 0 && locRange[1].compareTo(value) >= 0;
    }

    protected @NonNull BigRational @Nullable [] oldGetRatio(@NonNull BigRational reqRatio, @NonNull BigRational clock) {
        BigRational minDiv;
        if (this.combinedArray != null) {
            return this.getRatioConstrComb(reqRatio, clock);
        }
        TimingScale xxdivider = this.divider;
        BigRational startingDivider = xxdivider.from;
        BigRational xxMaxDividerOutput = this.maxDividerOutput;
        BigRational xxMinDividerOutput = this.minDividerOutput;
        if (xxMaxDividerOutput != null && clock.compareTo(xxMaxDividerOutput) > 0 ? (startingDivider = xxdivider.closestUp(minDiv = clock.divide(xxMaxDividerOutput))) == null : xxMinDividerOutput != null && clock.compareTo(xxMinDividerOutput) < 0) {
            return null;
        }
        TimingScale xxmultiplier = this.multiplier;
        assert (xxmultiplier != null) : "Wrongly initialized divider in " + this.id;
        this.workingMultiplier = xxmultiplier.from;
        BigRational curRatio = this.operation.clockModify(BigRational.ONE).divide(startingDivider);
        BigRational curMultiplier = xxmultiplier.from;
        BigRational curDivider = startingDivider;
        BigRational[] res = null;
        BigRational dif = null;
        block0 : switch (curRatio.compareTo(reqRatio)) {
            case 0: {
                res = new BigRational[]{curMultiplier, curDivider};
                return res;
            }
            case 1: {
                dif = curRatio.subtract(reqRatio);
                for (BigRational imul : xxmultiplier) {
                    assert (imul != null) : "Wrongly initialized multiplier/iterator in " + this.id;
                    boolean wasBreak = false;
                    boolean wasIn = false;
                    this.workingMultiplier = imul;
                    BigRational tmpMult = this.operation.clockModify(BigRational.ONE);
                    for (BigRational idiv : xxdivider) {
                        assert (idiv != null) : "Wrongly initialized divider/iterator in " + this.id;
                        imul = xxmultiplier.setRequiredRatio(reqRatio.multiply(idiv));
                        if (!this.checkDividerFreq(clock.divide(idiv))) {
                            if (!wasIn) continue;
                            break;
                        }
                        wasIn = true;
                        BigRational tmpRatio = tmpMult.divide(idiv);
                        switch (tmpRatio.compareTo(reqRatio)) {
                            case 0: {
                                res = new BigRational[]{imul, idiv};
                                return res;
                            }
                            case 1: {
                                BigRational actdif = tmpRatio.subtract(reqRatio);
                                if (actdif.compareTo(dif) >= 0) break;
                                curRatio = tmpRatio;
                                curMultiplier = imul;
                                curDivider = idiv;
                                dif = actdif;
                                break;
                            }
                            default: {
                                wasBreak = true;
                                BigRational actdif = reqRatio.subtract(tmpRatio);
                                if (actdif.compareTo(dif) >= 0) break;
                                curRatio = tmpRatio;
                                curMultiplier = imul;
                                curDivider = idiv;
                                dif = actdif;
                            }
                        }
                        if (wasBreak) break;
                    }
                    if (wasBreak) continue;
                    res = new BigRational[]{curMultiplier, curDivider};
                    return res;
                }
                break;
            }
            default: {
                dif = reqRatio.subtract(curRatio);
                boolean wasIn = false;
                for (BigRational idiv : xxdivider) {
                    assert (idiv != null) : "Wrongly initialized divider/iterator in " + this.id;
                    if (!this.checkDividerFreq(clock.divide(idiv))) {
                        if (!wasIn) continue;
                        break block0;
                    }
                    wasIn = true;
                    boolean wasBreak = false;
                    xxmultiplier.setRequiredRatio(reqRatio.multiply(idiv));
                    for (BigRational imul : xxmultiplier) {
                        assert (imul != null) : "Wrongly initialized multiplier/iterator in " + this.id;
                        this.workingMultiplier = imul;
                        BigRational tmpRatio = this.operation.clockModify(BigRational.ONE).divide(idiv);
                        switch (tmpRatio.compareTo(reqRatio)) {
                            case 0: {
                                res = new BigRational[]{imul, idiv};
                                return res;
                            }
                            case -1: {
                                BigRational actdif = reqRatio.subtract(tmpRatio);
                                if (actdif.compareTo(dif) >= 0) break;
                                curRatio = tmpRatio;
                                curMultiplier = imul;
                                curDivider = idiv;
                                dif = actdif;
                                break;
                            }
                            default: {
                                wasBreak = true;
                                BigRational actdif = tmpRatio.subtract(reqRatio);
                                if (actdif.compareTo(dif) >= 0) break;
                                curRatio = tmpRatio;
                                curMultiplier = imul;
                                curDivider = idiv;
                                dif = actdif;
                            }
                        }
                        if (wasBreak) break;
                    }
                    if (wasBreak) continue;
                    res = new BigRational[]{curMultiplier, curDivider};
                    return res;
                }
            }
        }
        res = new BigRational[]{curMultiplier, curDivider};
        return res;
    }

    private int[][] manipulateConstraintCombArray(@NonNull BigRational clock) {
        int maxDiv;
        int minDiv;
        BigRational xxMinDivOutput = this.minDividerOutput;
        BigRational xxMaxDivOutput = this.maxDividerOutput;
        boolean shorter = false;
        if (xxMaxDivOutput == null) {
            assert (this.divider.from.getDenominator().equals(TimingScale.ONE));
            minDiv = this.divider.from.getNumerator().intValue();
        } else {
            BigRational closeMin = this.divider.closestUp(clock.divide(xxMaxDivOutput));
            if (closeMin == null) {
                assert (this.divider.from.getDenominator().equals(TimingScale.ONE));
                minDiv = this.divider.from.getNumerator().intValue();
            } else {
                assert (closeMin.getDenominator().equals(TimingScale.ONE));
                minDiv = closeMin.getNumerator().intValue();
                shorter = closeMin.compareTo(this.divider.from) > 0;
            }
        }
        this.constrainedMinDiv = minDiv;
        if (xxMinDivOutput == null) {
            assert (this.divider.to.getDenominator().equals(TimingScale.ONE));
            maxDiv = this.divider.to.getNumerator().intValue();
        } else {
            BigRational closeMax = this.divider.closestDown(clock.divide(xxMinDivOutput));
            if (closeMax == null) {
                assert (this.divider.to.getDenominator().equals(TimingScale.ONE));
                maxDiv = this.divider.to.getNumerator().intValue();
            } else {
                assert (closeMax.getDenominator().equals(TimingScale.ONE));
                maxDiv = closeMax.getNumerator().intValue();
                boolean bl = shorter = shorter || closeMax.compareTo(this.divider.to) < 0;
            }
        }
        if (!shorter) {
            return null;
        }
        int[][] vals = this.readCache(clock);
        if (vals == null) {
            assert (this.multiplier.from.getDenominator().equals(TimingScale.ONE));
            assert (this.multiplier.to.getDenominator().equals(TimingScale.ONE));
            vals = PLL.mkCombinedArray(minDiv, maxDiv, this.multiplier.from.getNumerator().intValue(), this.multiplier.to.getNumerator().intValue());
            TimingScale locDivider = this.divider;
            this.divider = new LinearTimingScale(minDiv, maxDiv, 1);
            this.insertToCache(clock, vals);
            this.divider = locDivider;
        }
        return vals;
    }

    private @NonNull EErrorType computePLLAutoConstrComb(@NonNull BigRational clock) {
        boolean isConstrained = true;
        int[][] vals = this.manipulateConstraintCombArray(clock);
        if (vals == null) {
            vals = this.combinedArray;
            isConstrained = false;
        }
        assert (vals != null);
        int low = 0;
        int high = vals.length - 1;
        int middle = high / 2;
        this.workingMultiplier = BigRational.ONE;
        @NonNull BigRational xxOutputClock = new BigRational(vals[middle][0], vals[middle][1]).multiply(this.operation.clockModify(clock));
        EErrorType tmpResult = this.testOutputFreq(xxOutputClock);
        while (true) {
            if (tmpResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                tmpResult = this.child.computeAutoWR(this, xxOutputClock);
                if (tmpResult == EErrorType.None || tmpResult == EErrorType.NotEnabled) {
                    this.outputClock = xxOutputClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    tmpResult = EErrorType.None;
                    break;
                }
                if (tmpResult != EErrorType.TooFast && tmpResult != EErrorType.TooSlow) break;
            }
            if (tmpResult == EErrorType.TooFast) {
                high = middle - 1;
            } else if (tmpResult == EErrorType.TooSlow) {
                low = middle + 1;
            }
            if (high < low) {
                return tmpResult;
            }
            middle = high + low >>> 1;
            xxOutputClock = new BigRational(vals[middle][0], vals[middle][1]).multiply(this.operation.clockModify(clock));
            tmpResult = this.testOutputFreq(xxOutputClock);
        }
        if (this.stopComputation) {
            return EErrorType.None;
        }
        if (tmpResult != EErrorType.None) {
            if (high - low + 1 <= 127) {
                int i = low;
                while (i <= high) {
                    xxOutputClock = new BigRational(vals[i][0], vals[i][1]).multiply(this.operation.clockModify(clock));
                    tmpResult = this.testOutputFreq(xxOutputClock);
                    if (tmpResult == EErrorType.TooSlow) {
                        ++i;
                        continue;
                    }
                    if (tmpResult == EErrorType.TooFast) {
                        return EErrorType.CannotSetup;
                    }
                    this.lastComp = ECompState.OnceSatisfied;
                    tmpResult = this.child.computeAutoWR(this, xxOutputClock);
                    if (tmpResult == EErrorType.None || tmpResult == EErrorType.NotEnabled) {
                        this.outputClock = xxOutputClock;
                        this.lastComp = ECompState.OnceSubtreeOK;
                        tmpResult = EErrorType.None;
                        middle = i;
                        break;
                    }
                    if (tmpResult == EErrorType.TooFast) {
                        return EErrorType.CannotSetup;
                    }
                    ++i;
                }
            } else {
                int[] nArray = TRAVERSAL_ORDER;
                int n = TRAVERSAL_ORDER.length;
                int n2 = 0;
                while (n2 < n) {
                    int k = nArray[n2];
                    int i = k + low / 127 * 127;
                    while (i < low) {
                        i += 127;
                    }
                    boolean resultFound = false;
                    while (i <= high) {
                        xxOutputClock = new BigRational(vals[i][0], vals[i][1]).multiply(this.operation.clockModify(clock));
                        tmpResult = this.testOutputFreq(xxOutputClock);
                        if (tmpResult == EErrorType.TooSlow) {
                            i += 127;
                            continue;
                        }
                        if (tmpResult == EErrorType.TooFast) break;
                        this.lastComp = ECompState.OnceSatisfied;
                        tmpResult = this.child.computeAutoWR(this, xxOutputClock);
                        if (tmpResult == EErrorType.None || tmpResult == EErrorType.NotEnabled) {
                            this.outputClock = xxOutputClock;
                            this.lastComp = ECompState.OnceSubtreeOK;
                            tmpResult = EErrorType.None;
                            middle = i;
                            resultFound = true;
                            break;
                        }
                        if (tmpResult == EErrorType.TooFast) break;
                        i += 127;
                    }
                    if (!resultFound) {
                        if (this.stopComputation) {
                            return EErrorType.None;
                        }
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        }
        if (tmpResult == EErrorType.None) {
            int minDiv;
            if (isConstrained) {
                minDiv = this.constrainedMinDiv;
            } else {
                assert (this.divider.from.getDenominator().equals(TimingScale.ONE));
                minDiv = this.divider.from.getNumerator().intValue();
            }
            int tmpMul = vals[middle][0];
            int tmpDiv = vals[middle][1];
            assert (this.multiplier.from.getDenominator().equals(TimingScale.ONE));
            int tmpMulFromValue = this.multiplier.from.getNumerator().intValue();
            int mulFactor = 1;
            if (tmpDiv < minDiv) {
                mulFactor = minDiv / tmpDiv;
                if (minDiv % tmpDiv != 0) {
                    ++mulFactor;
                }
            }
            if (tmpMul < tmpMulFromValue) {
                int tmpMulFactor = tmpMulFromValue / tmpMul;
                if (tmpMulFromValue % tmpMul != 0) {
                    ++tmpMulFactor;
                }
                if (tmpMulFactor > mulFactor) {
                    mulFactor = tmpMulFactor;
                }
            }
            if (mulFactor > 1) {
                tmpMul *= mulFactor;
                tmpDiv *= mulFactor;
            }
            this.compMultiplier = new BigRational(tmpMul);
            this.compDivider = new BigRational(tmpDiv);
            return tmpResult;
        }
        return EErrorType.CannotSetup;
    }

    private @NonNull EErrorType testMultiplier(@NonNull BigRational mul, @NonNull BigRational divOutputClock) {
        this.workingMultiplier = mul;
        @NonNull BigRational newClock = this.operation.clockModify(divOutputClock);
        @NonNull EErrorType subResult = this.testOutputFreq(newClock);
        if (subResult != EErrorType.None) {
            return subResult;
        }
        return this.child.computeAutoWR(this, newClock);
    }

    private void prepareIntervalHalving() {
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger maxScaleSize = two.pow(24);
        BigInteger halveMaxScale = two.pow(12);
        BigInteger scaleSize = this.divider.numOfScales.multiply(this.multiplier.numOfScales);
        if (scaleSize.compareTo(maxScaleSize) <= 0) {
            return;
        }
        BigInteger divMaxSize = null;
        BigInteger multMaxSize = null;
        if (this.divider.numOfScales.compareTo(halveMaxScale) <= 0) {
            multMaxSize = maxScaleSize.divide(this.divider.numOfScales);
        } else {
            divMaxSize = maxScaleSize.divide(this.multiplier.numOfScales);
        }
        this.divider = this.divider.shrinkScale(divMaxSize);
        this.multiplier = this.multiplier.shrinkScale(multMaxSize);
    }

    private void cleanupIntervalHalving(@Nullable TimingScale dividerScale, @Nullable TimingScale multiplierScale) {
        if (dividerScale != null) {
            this.divider = dividerScale;
        }
        if (multiplierScale != null) {
            this.multiplier = multiplierScale;
        }
    }

    private @NonNull EErrorType findRatioByIntervalHalving(@NonNull BigRational clock) {
        TimingScale xxMultiplier = this.multiplier;
        assert (xxMultiplier != null) : "Multiplier not assigned in " + this.id;
        TimingScale xxDivider = this.divider;
        assert (xxDivider != null) : "Divider not assigned in " + this.id;
        boolean wasTooFast = false;
        boolean wasIn = false;
        BigRational tooFastFreqOut = null;
        BigRational tooSlowFreqOut = null;
        for (BigRational idiv : xxDivider) {
            assert (idiv != null) : "Iterator of divider with null values in " + this.id;
            BigRational divOutputClock = clock.divide(idiv);
            EErrorType sbr = this.testDividerFreq(divOutputClock);
            if (sbr != EErrorType.None) {
                if (!wasIn) continue;
                break;
            }
            wasIn = true;
            TimingScale.IntervalNarrowingContext interval = this.multiplier.getInitialMiddle();
            this.workingMultiplier = interval.midVal;
            @NonNull BigRational newClock = this.operation.clockModify(divOutputClock);
            @NonNull EErrorType subResult = this.testOutputFreq(newClock);
            BigRational intervalStartingFromValue = interval.fromVal;
            EErrorType rangeError = EErrorType.None;
            boolean firsttime = true;
            while (true) {
                if (subResult == EErrorType.None) {
                    this.lastComp = ECompState.OnceSatisfied;
                    subResult = this.child.computeAutoWR(this, newClock);
                    if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                        this.compMultiplier = this.workingMultiplier;
                        this.compDivider = idiv;
                        this.outputClock = newClock;
                        this.lastComp = ECompState.OnceSubtreeOK;
                        return EErrorType.None;
                    }
                }
                if (subResult == EErrorType.TooSlow) {
                    if (tooSlowFreqOut == null) {
                        tooSlowFreqOut = newClock;
                    } else if (newClock.compareTo(tooSlowFreqOut) > 0) {
                        tooSlowFreqOut = newClock;
                    }
                    if (rangeError == EErrorType.None) {
                        rangeError = EErrorType.TooSlow;
                    } else if (rangeError == EErrorType.TooFast) {
                        rangeError = EErrorType.CannotSetup;
                    }
                    if (firsttime) {
                        firsttime = false;
                        subResult = this.testMultiplier(interval.toVal, divOutputClock);
                        if (subResult == EErrorType.TooSlow) break;
                        if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                            this.compMultiplier = this.workingMultiplier;
                            this.compDivider = idiv;
                            this.outputClock = this.operation.clockModify(divOutputClock);
                            this.lastComp = ECompState.OnceSubtreeOK;
                            return EErrorType.None;
                        }
                    }
                    if (!interval.halfTotalValHigh()) {
                        subResult = EErrorType.BothFastSlow;
                        break;
                    }
                    interval.fromVal = interval.getOneUpFromMiddle();
                } else {
                    if (subResult != EErrorType.TooFast) break;
                    if (tooFastFreqOut == null) {
                        tooFastFreqOut = newClock;
                    } else if (newClock.compareTo(tooFastFreqOut) < 0) {
                        tooFastFreqOut = newClock;
                    }
                    if (rangeError == EErrorType.None) {
                        rangeError = EErrorType.TooFast;
                    } else if (rangeError == EErrorType.TooSlow) {
                        rangeError = EErrorType.CannotSetup;
                    }
                    if (firsttime) {
                        firsttime = false;
                        subResult = this.testMultiplier(interval.fromVal, divOutputClock);
                        if (subResult == EErrorType.TooFast) break;
                        if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                            this.compMultiplier = this.workingMultiplier;
                            this.compDivider = idiv;
                            this.outputClock = this.operation.clockModify(divOutputClock);
                            this.lastComp = ECompState.OnceSubtreeOK;
                            return EErrorType.None;
                        }
                    }
                    if (!interval.halfTotalValLow()) {
                        subResult = EErrorType.BothFastSlow;
                        break;
                    }
                    interval.toVal = interval.getOneDownFromMiddle();
                }
                interval = this.multiplier.getValInMiddleR(interval);
                this.workingMultiplier = interval.midVal;
                newClock = this.operation.clockModify(divOutputClock);
                subResult = this.testOutputFreq(newClock);
                if (subResult != EErrorType.None) continue;
                if (tooFastFreqOut != null && newClock.compareTo(tooFastFreqOut) >= 0) {
                    subResult = EErrorType.TooFast;
                    continue;
                }
                if (tooSlowFreqOut == null || newClock.compareTo(tooSlowFreqOut) > 0) continue;
                subResult = EErrorType.TooSlow;
            }
            if (this.stopComputation) {
                return EErrorType.None;
            }
            if (intervalStartingFromValue.compareTo(interval.fromVal) != 0) {
                Iterator<BigRational> downIterator = interval.reverseIterator();
                boolean tryAnotherOne = false;
                block8: while (downIterator.hasNext()) {
                    BigRational xxIntervalScale = downIterator.next();
                    assert (xxIntervalScale != null);
                    this.workingMultiplier = xxIntervalScale;
                    newClock = this.operation.clockModify(divOutputClock);
                    subResult = this.testOutputFreq(newClock);
                    if (subResult == EErrorType.TooFast) continue;
                    if (subResult == EErrorType.TooSlow) break;
                    this.lastComp = ECompState.OnceSatisfied;
                    subResult = this.child.computeAutoWR(this, newClock);
                    switch (subResult) {
                        case TooFast: {
                            break;
                        }
                        case TooSlow: {
                            break block8;
                        }
                        case None: 
                        case NotEnabled: {
                            this.compMultiplier = xxIntervalScale;
                            this.compDivider = idiv;
                            this.outputClock = newClock;
                            this.lastComp = ECompState.OnceSubtreeOK;
                            return EErrorType.None;
                        }
                        case BothFastSlow: {
                            return EErrorType.BothFastSlow;
                        }
                        default: {
                            tryAnotherOne = true;
                        }
                    }
                }
                if (tryAnotherOne) continue;
                if (subResult == EErrorType.TooFast) {
                    wasTooFast = true;
                    continue;
                }
                if (subResult == EErrorType.TooSlow) {
                    if (wasTooFast) {
                        return EErrorType.BothFastSlow;
                    }
                    return subResult;
                }
            } else {
                for (BigRational xxIntervalScale : interval) {
                    assert (xxIntervalScale != null);
                    this.workingMultiplier = xxIntervalScale;
                    newClock = this.operation.clockModify(divOutputClock);
                    subResult = this.testOutputFreq(newClock);
                    if (subResult == EErrorType.TooSlow) continue;
                    if (subResult == EErrorType.TooFast) break;
                    this.lastComp = ECompState.OnceSatisfied;
                    subResult = this.child.computeAutoWR(this, newClock);
                    if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                        this.compMultiplier = xxIntervalScale;
                        this.compDivider = idiv;
                        this.outputClock = newClock;
                        this.lastComp = ECompState.OnceSubtreeOK;
                        return EErrorType.None;
                    }
                    if (subResult != EErrorType.BothFastSlow && subResult == EErrorType.TooFast) break;
                }
                if (subResult == EErrorType.TooFast) {
                    wasTooFast = true;
                    continue;
                }
                if (subResult == EErrorType.TooSlow) {
                    if (wasTooFast) {
                        return EErrorType.BothFastSlow;
                    }
                    return subResult;
                }
            }
            if (!this.stopComputation) continue;
            return EErrorType.None;
        }
        return EErrorType.CannotSetup;
    }

    private @NonNull EErrorType computePLLAutoWR(@NonNull BigRational clock) {
        BigRational actDiv;
        BigRational actMul;
        if (this.setMultiplier != null) {
            actMul = this.setMultiplier;
            assert (this.setDivider != null) : "If multiplier is set then divider must be set too in " + this.id;
            actDiv = this.setDivider;
        } else if (this.useDefaults && this.defaultMul != null) {
            actMul = this.defaultMul;
            assert (this.defaultDiv != null) : "If default multiplier is set then divider must be set too in " + this.id;
            actDiv = this.defaultDiv;
        } else {
            actMul = null;
            actDiv = null;
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (actMul != null && actDiv != null) {
            BigRational actClock = clock.divide(actDiv);
            EErrorType sbr = this.testDividerFreq(actClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.workingMultiplier = actMul;
            sbr = this.testOutputFreq(actClock = this.operation.clockModify(actClock));
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = actClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, actClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return nres;
        }
        if (xxSetOutputFreq != null) {
            BigRational rel = xxSetOutputFreq.divide(clock);
            BigRational xxCompMultiplier = null;
            BigRational xxCompDivider = null;
            BigRational[] r = this.getRatio(rel, clock);
            if (r != null) {
                xxCompMultiplier = r[0];
                xxCompDivider = r[1];
            }
            if (xxCompDivider == null || xxCompMultiplier == null) {
                return EErrorType.CannotSetup;
            }
            this.workingMultiplier = xxCompMultiplier;
            BigRational xxoutputClock = this.operation.clockModify(clock).divide(xxCompDivider);
            BigRational xxsetOutputFreq = this.setOutputFreq;
            assert (xxsetOutputFreq != null) : "Explicit requirement on ouput frequency expected but not set in " + this.id;
            BigRational ac = xxsetOutputFreq.compareTo(xxoutputClock) < 0 ? xxoutputClock.divide(xxsetOutputFreq).subtract(BigRational.ONE) : xxsetOutputFreq.divide(xxoutputClock).subtract(BigRational.ONE);
            EErrorType sbr = ac.compareTo(this.accuracy) > 0 ? EErrorType.CannotSetup : this.testOutputFreq(xxoutputClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, xxoutputClock);
            this.outputClock = xxoutputClock;
            this.compMultiplier = xxCompMultiplier;
            this.compDivider = xxCompDivider;
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return nres;
        }
        if (this.combinedArray != null) {
            return this.computePLLAutoConstrComb(clock);
        }
        if (this.multiplier instanceof LinearTimingScale || this.multiplier instanceof GeometricTimingScale || this.multiplier instanceof SetTimingScale) {
            TimingScale formerMult = this.multiplier;
            TimingScale formerDiv = this.divider;
            this.prepareIntervalHalving();
            EErrorType result = this.findRatioByIntervalHalving(clock);
            this.cleanupIntervalHalving(formerDiv, formerMult);
            return result;
        }
        BigRational xxOutputClock = null;
        TimingScale xxMultiplier = this.multiplier;
        assert (xxMultiplier != null) : "Multiplier not assigned in " + this.id;
        TimingScale xxDivider = this.divider;
        assert (xxDivider != null) : "Divider not assigned in " + this.id;
        boolean wasTooFast = false;
        boolean wasIn = false;
        for (BigRational idiv : xxDivider) {
            assert (idiv != null) : "Iterator of divider with null values in " + this.id;
            BigRational divOutputClock = clock.divide(idiv);
            EErrorType sbr = this.testDividerFreq(divOutputClock);
            if (sbr != EErrorType.None) {
                if (!wasIn) continue;
                break;
            }
            wasIn = true;
            sbr = EErrorType.None;
            boolean firstCompute = true;
            xxMultiplier.setRequiredRatio(clock.divide(divOutputClock));
            for (BigRational imul : xxMultiplier) {
                assert (imul != null) : "Iterator of multiplier with null values in " + this.id;
                this.workingMultiplier = imul;
                xxOutputClock = this.operation.clockModify(divOutputClock);
                sbr = this.testOutputFreq(xxOutputClock);
                if (sbr == EErrorType.TooSlow) {
                    PLL.updateRequiredRatio(xxMultiplier, imul);
                    continue;
                }
                if (sbr == EErrorType.TooFast) break;
                this.lastComp = ECompState.OnceSatisfied;
                sbr = this.child.computeAutoWR(this, xxOutputClock);
                if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                    this.compMultiplier = imul;
                    this.compDivider = idiv;
                    this.outputClock = xxOutputClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                if (sbr == EErrorType.TooFast) break;
                if (sbr == EErrorType.BothFastSlow) {
                    PLL.updateRequiredRatio(xxMultiplier, imul);
                    continue;
                }
                if (!firstCompute || sbr != EErrorType.TooSlow) continue;
                firstCompute = false;
                this.workingMultiplier = this.multiplier.to;
                xxOutputClock = this.operation.clockModify(divOutputClock);
                sbr = this.testOutputFreq(xxOutputClock);
                if (sbr != EErrorType.None) continue;
                sbr = this.child.computeAutoWR(this, xxOutputClock);
                if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                    this.compMultiplier = this.multiplier.to;
                    this.compDivider = idiv;
                    this.outputClock = xxOutputClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
                if (sbr != EErrorType.TooSlow) continue;
                return sbr;
            }
            if (this.stopComputation) {
                return EErrorType.None;
            }
            if (sbr == EErrorType.TooFast) {
                wasTooFast = true;
                continue;
            }
            if (sbr == EErrorType.TooSlow) {
                if (wasTooFast) {
                    return EErrorType.BothFastSlow;
                }
                return sbr;
            }
            if (sbr != EErrorType.None) continue;
            return sbr;
        }
        this.outputClock = xxOutputClock;
        return EErrorType.CannotSetup;
    }

    private static void updateRequiredRatio(@NonNull TimingScale xxMultiplier, @NonNull BigRational imul) {
        String nextImulInteger;
        BigRational nextImul = xxMultiplier.setRequiredRatio(imul.add(DEFAULT_DECIMAL_STEP));
        assert (nextImul != null) : "No suitable value found!";
        String imulInteger = imul.toString(4).split(Pattern.quote("."))[0];
        if (imulInteger.compareTo(nextImulInteger = nextImul.toString(4).split(Pattern.quote("."))[0]) != 0) {
            String acceptedFormat = nextImul.toString(4).split(Pattern.quote("."))[0];
            assert (acceptedFormat != null);
            nextImul = BigRational.tryParse((String)acceptedFormat);
            assert (nextImul != null);
            xxMultiplier.setRequiredRatio(nextImul);
        }
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational actClock;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.multiplier != null) : "FLL/PLL not fully defined - " + this.id;
        EErrorType sbr = this.testInputFreq(clock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        BigRational xxDefaultDiv = this.defaultDiv;
        BigRational xxDefaultMul = this.defaultMul;
        if (xxDefaultDiv != null && xxDefaultMul != null && (sbr = this.testDividerFreq(actClock = clock.divide(xxDefaultDiv))) == EErrorType.None) {
            this.workingMultiplier = xxDefaultMul;
            sbr = this.testOutputFreq(actClock = this.operation.clockModify(actClock));
            if (sbr == EErrorType.None) {
                this.outputClock = actClock;
                this.lastComp = ECompState.OnceSatisfied;
                EErrorType nres = this.child.computeAutoWR(this, actClock);
                if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                    this.compDivider = xxDefaultDiv;
                    this.compMultiplier = xxDefaultMul;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
            }
        }
        return this.computePLLAutoWR(clock);
    }

    @Override
    public void setScaleComputed() {
        assert (this.multiplier != null) : "PLL multiplier not defined - " + this.id;
        assert (this.divider != null) : "PLL divider not defined - " + this.id;
        if (this.compMultiplier == null || this.compDivider == null) {
            return;
        }
        if (!(this.setMultiplier != null || this.useDefaults && this.defaultMul != null)) {
            this.setMultiplier = this.compMultiplier;
        }
        if (!(this.setDivider != null || this.useDefaults && this.defaultDiv != null)) {
            this.setDivider = this.compDivider;
        }
    }

    @Override
    public @Nullable TimingScale getDivisionScale() {
        return this.divider;
    }
}

