/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public interface ModelCreationI {
    public @NonNull String getID();

    public @NonNull ENodeType getType();

    public @Nullable BigRational getMinInput();

    public @Nullable BigRational getMinOutput();

    public @Nullable BigRational getMaxInput();

    public @Nullable BigRational getMaxOutput();

    public @Nullable String getPredecessor();

    public @Nullable String getSuccessor();

    public @Nullable List<@NonNull String> getPredList();

    public @Nullable List<@NonNull String> getSuccList();

    public @NonNull BigRational getClockFrequency();

    public @NonNull List<@NonNull BigRational> getListClockFreq();

    public @Nullable BigRational getDefaultClockFreq();

    public @NonNull ScaleData getXLLDivider();

    public @NonNull ScaleData getXLLMultiplier();

    public @Nullable BigRational getDefaultDiv();

    public @Nullable BigRational getDefaultMul();

    public @Nullable BigRational getDivMinOutput();

    public @Nullable BigRational getDivMaxOutput();

    public @NonNull BigRational getPostDivider();

    public @NonNull List<@NonNull FLLextSingleData> getFLLextData();

    public @Nullable BigRational getFLLextDefault();

    public @NonNull ScaleData getScaleData();

    public @Nullable BigRational getDefaultScale();

    public @NonNull String getMasterDiv();

    public @Nullable BigInteger getMasterSlaveRatio();

    public @Nullable List<@NonNull BigRational> getMasterSlaveAllowedRatios();

    public @NonNull List<@NonNull String> getListOfMasters();

    public @Nullable String getDefaultBranch();

    public @NonNull List<String @NonNull []> getClockSignalPairs();

    public void setPredecessorID(@NonNull String var1);

    public void setSuccessorID(@NonNull String var1);

    public void setPredecessors(@NonNull List<@NonNull String> var1);

    public void setSuccessors(@NonNull List<@NonNull String> var1);

    public static class FLLextSingleData {
        @Nullable
        public BigRational iLo;
        @Nullable
        public BigRational iHi;
        @NonNull
        public BigRational mulBy;
        @Nullable
        public BigRational oLo;
        @Nullable
        public BigRational oHi;

        public FLLextSingleData(@NonNull BigRational mul) {
            this.mulBy = mul;
            this.oHi = null;
            this.oLo = null;
            this.iHi = null;
            this.iLo = null;
        }
    }

    public static class ScaleData {
        @NonNull
        public EScaleType type;
        @Nullable
        public BigRational low;
        @Nullable
        public BigRational high;
        @Nullable
        public BigRational step;
        public long n;
        @Nullable
        public ArrayList<@NonNull BigRational> scalelist;
        @Nullable
        public ICalculus calculus;

        public ScaleData(@NonNull EScaleType scaleType) {
            this.type = scaleType;
        }
    }
}

