/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.rational.BigRational;

public class FrequencyRange {
    @NonNull
    private BigRational lowerBound;
    @NonNull
    private BigRational upperBound;

    public FrequencyRange(@NonNull BigRational min, @NonNull BigRational max) {
        this.lowerBound = min;
        this.upperBound = max;
        assert (min.compareTo(max) <= 0);
    }

    public boolean isInRange(@NonNull BigRational value) {
        return this.lowerBound.compareTo(value) <= 0 && this.upperBound.compareTo(value) >= 0;
    }

    public @NonNull BigRational getMinimalFrequency() {
        return this.lowerBound;
    }

    public @NonNull BigRational getMaximalFrequency() {
        return this.upperBound;
    }
}

