/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.GeometricTimingScale;
import com.nxp.swtools.clocks.model.LinearTimingScale;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeSimpleCon;
import com.nxp.swtools.clocks.model.SetTimingScale;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.List;

public class FLLPLL
extends NodeSimpleCon {
    protected TimingScale multiplier;
    @Nullable
    protected BigRational outputClock;
    @Nullable
    protected BigRational inputClock;
    @Nullable
    protected BigRational setOutputFreq;
    @Nullable
    protected BigRational defaultMul;
    @Nullable
    protected BigRational setMultiplier;
    @Nullable
    protected BigRational compMultiplier;
    @NonNull
    protected BigRational workingMultiplier = BigRational.ONE;
    protected boolean importedFreq;
    @NonNull
    protected BigRational savedAcc;
    protected boolean useDefaults;
    protected boolean isInternalDivError = false;
    @NonNull
    protected Node.IClockModify operation = p -> p.multiply(this.workingMultiplier);
    @Nullable
    protected BigInteger multiplierFraction = null;

    protected FLLPLL(@NonNull String id, @NonNull ENodeType type) {
        super(id, type);
        this.multiplier = null;
        this.outputClock = null;
        this.inputClock = null;
        this.setOutputFreq = null;
        this.defaultMul = null;
        this.setMultiplier = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
        this.useDefaults = true;
    }

    protected FLLPLL(@NonNull String id, @NonNull ENodeType type, @NonNull TimingScale multiplier, @Nullable TimingScale divider) {
        super(id, type);
        this.multiplier = multiplier;
        this.outputClock = null;
        this.inputClock = null;
        this.setOutputFreq = null;
        this.defaultMul = null;
        this.setMultiplier = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
        this.useDefaults = true;
    }

    @Override
    public void includeDefaults() {
        this.useDefaults = true;
    }

    @Override
    public void excludeDefaults() {
        this.useDefaults = false;
    }

    @Override
    public void setMulDivTimingScale(@NonNull TimingScale multiplier, @Nullable TimingScale divider) {
        this.multiplier = multiplier;
        assert (divider == null) : "FLL is being set to use divider";
        this.setMultiplier = null;
        this.defaultMul = null;
    }

    @Override
    public @Nullable BigRational getMultiplier() {
        return this.setMultiplier;
    }

    @Override
    public @Nullable BigRational getDefaultMultiplier() {
        return this.defaultMul;
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational clock = new BigRational(freq);
        return this.setOutputFrequency(clock);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        this.setOutputFreq = freq;
        return this.checkOutputFreq(freq);
    }

    @Override
    public void setAccuracy(@NonNull BigRational acc) {
        this.accuracy = acc;
        assert (this.accuracy.compareTo(BigRational.ZERO) >= 0);
    }

    @Override
    public void setFraction(@Nullable BigInteger fraction) {
        this.multiplierFraction = fraction;
        this.operation = fraction == null ? p -> p.multiply(this.workingMultiplier) : p -> p.multiply(this.workingMultiplier).divide(fraction);
    }

    @Override
    public @Nullable BigInteger getFraction() {
        return this.multiplierFraction;
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred != null ? this.pred.id : "";
        String cs = null;
        cs = this.inputClock == null ? "" : "@" + this.inputClock;
        if (this.outputClock != null) {
            cs = String.valueOf(cs) + "#" + this.outputClock;
        }
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + cs);
        if (this.child != null) {
            if ("".equals(prefLast)) {
                this.child.printT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    ");
            } else {
                this.child.printT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     ");
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer cs = new StringBuffer();
        if (this.inputClock != null) {
            cs.append('@');
            cs.append(this.inputClock);
        }
        if (this.outputClock != null) {
            cs.append('#');
            cs.append(this.outputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(cs);
        res.append('\n');
        if (this.child != null) {
            if ("".equals(prefLast)) {
                res.append(this.child.stringT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    "));
            } else {
                res.append(this.child.stringT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     "));
            }
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        if (this.setMultiplier == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        if (this.setMultiplier == null && this.defaultMul == null) {
            unset.add(this);
            return false;
        }
        return true;
    }

    @Override
    public void clean() {
        this.setOutputFreq = null;
        this.setMultiplier = null;
        this.compMultiplier = null;
    }

    @Override
    public void resetAndCleanScale() {
        this.inputClock = null;
        this.setOutputFreq = null;
        this.multiplier = null;
        this.defaultMul = null;
        this.setMultiplier = null;
        this.compMultiplier = null;
        this.accuracy = TimingScale.defaultAccuracy;
        this.importedFreq = false;
        this.savedAcc = this.accuracy;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational xxOutputClock;
        BigRational xxSetMultiplier;
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        this.isInternalDivError = false;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if ((xxSetMultiplier = this.setMultiplier) != null) {
            this.workingMultiplier = xxSetMultiplier;
            xxOutputClock = this.operation.clockModify(clock);
        } else {
            assert (this.useDefaults) : "Default vaule used even if forbidden in " + this.id;
            BigRational xxDefaultMul = this.defaultMul;
            assert (xxDefaultMul != null) : "Default vaule used even if forbidden in " + this.id;
            this.workingMultiplier = xxDefaultMul;
            xxOutputClock = this.operation.clockModify(clock);
        }
        this.isInternalDivError = false;
        if (!this.checkOutputFreq(xxOutputClock)) {
            res = false;
        }
        this.outputClock = xxOutputClock;
        if (this.child.compute(this, xxOutputClock)) {
            return res;
        }
        return false;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        if (!this.enabled) {
            this.child.prepareAuto(this, false);
        } else if (this.setMultiplier != null || this.useDefaults && this.defaultMul != null) {
            this.child.prepareAuto(this, false);
        } else if (this.setOutputFreq != null) {
            this.child.prepareAuto(this, false);
        } else {
            BigRational[] vals = this.child.prepareAuto(this, true);
            if (vals != null) {
                this.importedFreq = true;
                this.savedAcc = this.accuracy;
                this.setOutputFreq = vals[0];
                BigRational tmpAcc = vals[1];
                assert (tmpAcc != null);
                this.accuracy = tmpAcc;
            }
        }
        return null;
    }

    @Override
    public void closeAuto() {
        if (this.importedFreq) {
            this.importedFreq = false;
            this.savedAcc = this.accuracy = this.savedAcc;
            this.setOutputFreq = null;
        }
    }

    private @NonNull EErrorType computeAutoWithMiddleSearch(@NonNull BigRational clock) {
        TimingScale.IntervalNarrowingContext interval = this.multiplier.getInitialMiddle();
        this.workingMultiplier = interval.midVal;
        @NonNull BigRational newClock = BigRational.ZERO;
        @NonNull EErrorType subResult = EErrorType.None;
        BigRational xxDefaultScale = this.defaultMul;
        if (xxDefaultScale != null && xxDefaultScale.compareTo(this.workingMultiplier) != 0) {
            this.workingMultiplier = xxDefaultScale;
            newClock = this.operation.clockModify(clock);
            subResult = this.testOutputFreq(newClock);
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (this.stopComputation) {
                    return EErrorType.Aborted;
                }
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compMultiplier = xxDefaultScale;
                    return EErrorType.None;
                }
            }
            this.workingMultiplier = interval.midVal;
        }
        newClock = this.operation.clockModify(clock);
        subResult = this.testOutputFreq(newClock);
        EErrorType rangeError = EErrorType.None;
        while (true) {
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (this.stopComputation) {
                    return EErrorType.Aborted;
                }
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compMultiplier = this.workingMultiplier;
                    return EErrorType.None;
                }
            }
            if (subResult == EErrorType.TooSlow) {
                if (rangeError == EErrorType.None) {
                    rangeError = EErrorType.TooSlow;
                } else if (rangeError == EErrorType.TooFast) {
                    rangeError = EErrorType.CannotSetup;
                }
                if (!interval.halfTotalValHigh()) {
                    return rangeError;
                }
                interval.fromVal = interval.getOneUpFromMiddle();
            } else {
                if (subResult != EErrorType.TooFast) break;
                if (rangeError == EErrorType.None) {
                    rangeError = EErrorType.TooFast;
                } else if (rangeError == EErrorType.TooSlow) {
                    rangeError = EErrorType.CannotSetup;
                }
                if (!interval.halfTotalValLow()) {
                    return rangeError;
                }
                interval.toVal = interval.getOneDownFromMiddle();
            }
            interval = this.multiplier.getValInMiddleR(interval);
            this.workingMultiplier = interval.midVal;
            newClock = this.operation.clockModify(clock);
            subResult = this.testOutputFreq(newClock);
        }
        if (subResult == EErrorType.BothFastSlow) {
            return subResult;
        }
        for (BigRational xxIntervalScale : interval) {
            assert (xxIntervalScale != null);
            this.workingMultiplier = xxIntervalScale;
            newClock = this.operation.clockModify(clock);
            subResult = this.testOutputFreq(newClock);
            if (subResult == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                subResult = this.child.computeAutoWR(this, newClock);
                if (this.stopComputation) {
                    return EErrorType.Aborted;
                }
                if (subResult == EErrorType.None || subResult == EErrorType.NotEnabled) {
                    this.outputClock = newClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    this.compMultiplier = this.workingMultiplier;
                    return EErrorType.None;
                }
            }
            if (subResult != EErrorType.TooFast) continue;
            return EErrorType.CannotSetup;
        }
        return EErrorType.CannotSetup;
    }

    private @NonNull EErrorType computeFLLAutoWR(@NonNull BigRational clock) {
        TimingScale xxMultiplier = this.multiplier;
        assert (xxMultiplier != null) : "Multiplier not assigned in " + this.id;
        Object actMul = this.setMultiplier != null ? this.setMultiplier : (this.useDefaults && this.defaultMul != null ? this.defaultMul : null);
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (actMul != null) {
            this.workingMultiplier = actMul;
            BigRational actClock = this.operation.clockModify(clock);
            EErrorType sbr = this.testOutputFreq(actClock);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = actClock;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, actClock);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            return nres;
        }
        if (xxSetOutputFreq != null) {
            BigRational ac;
            BigRational rel = xxSetOutputFreq.divide(clock);
            EErrorType sbr = EErrorType.None;
            BigRational xxfrm = xxMultiplier.from;
            assert (xxfrm != null) : "Multiplier not initialized properly, 'from' value (minimal) is missing in " + this.id;
            BigRational xxto = xxMultiplier.to;
            assert (xxto != null) : "Multiplier not initialized properly, 'to' value (maximal) is missing in " + this.id;
            BigRational xxOutputClock = null;
            if (rel.compareTo(xxfrm) <= 0) {
                this.workingMultiplier = xxfrm;
                xxOutputClock = this.operation.clockModify(clock);
                ac = xxOutputClock.divide(xxSetOutputFreq).subtract(BigRational.ONE);
                sbr = ac.compareTo(this.accuracy) > 0 ? EErrorType.TooFast : this.testOutputFreq(xxOutputClock);
            } else if (rel.compareTo(xxto) >= 0) {
                this.workingMultiplier = xxto;
                xxOutputClock = this.operation.clockModify(clock);
                ac = xxSetOutputFreq.divide(xxOutputClock).subtract(BigRational.ONE);
                sbr = ac.compareTo(this.accuracy) > 0 ? EErrorType.TooSlow : this.testOutputFreq(xxOutputClock);
            } else {
                this.workingMultiplier = xxMultiplier.closest(rel);
                xxOutputClock = this.operation.clockModify(clock);
                ac = xxSetOutputFreq.compareTo(xxOutputClock) < 0 ? xxOutputClock.divide(xxSetOutputFreq).subtract(BigRational.ONE) : BigRational.ONE.subtract(xxOutputClock.divide(xxSetOutputFreq));
                sbr = ac.compareTo(this.accuracy) > 0 ? EErrorType.CannotSetup : this.testOutputFreq(xxOutputClock);
            }
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, xxOutputClock);
            this.outputClock = xxOutputClock;
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compMultiplier = this.workingMultiplier;
                return EErrorType.None;
            }
            return nres;
        }
        if (this.multiplier instanceof LinearTimingScale || this.multiplier instanceof GeometricTimingScale || this.multiplier instanceof SetTimingScale) {
            return this.computeAutoWithMiddleSearch(clock);
        }
        @NonNull BigRational xxoutputClock = BigRational.ZERO;
        EErrorType sbr = EErrorType.None;
        boolean wasTooSlow = false;
        boolean fst = true;
        @NonNull BigRational minValue = xxMultiplier.from;
        @NonNull BigRational maxValue = xxMultiplier.to;
        BigRational xxDefaultMul = this.defaultMul;
        if (xxDefaultMul != null) {
            this.workingMultiplier = xxDefaultMul;
            xxoutputClock = this.operation.clockModify(clock);
            sbr = this.testOutputFreq(xxoutputClock);
            if (sbr == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                sbr = this.child.computeAutoWR(this, xxoutputClock);
                if (this.stopComputation) {
                    return EErrorType.Aborted;
                }
                if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                    this.compMultiplier = this.workingMultiplier;
                    this.outputClock = xxoutputClock;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
            }
            if (sbr == EErrorType.TooFast) {
                maxValue = this.workingMultiplier;
            } else if (sbr == EErrorType.TooSlow) {
                minValue = this.workingMultiplier;
                fst = false;
                wasTooSlow = true;
            }
        }
        for (BigRational m : xxMultiplier) {
            assert (m != null) : "Multiplier not initilized/iterator failed to create in " + this.id;
            if (m.compareTo(minValue) < 0) continue;
            if (m.compareTo(maxValue) > 0) {
                sbr = EErrorType.TooFast;
                break;
            }
            this.workingMultiplier = m;
            xxoutputClock = this.operation.clockModify(clock);
            sbr = this.testOutputFreq(xxoutputClock);
            if (sbr == EErrorType.TooSlow) {
                fst = false;
                wasTooSlow = true;
                continue;
            }
            if (sbr == EErrorType.TooFast) break;
            this.lastComp = ECompState.OnceSatisfied;
            sbr = this.child.computeAutoWR(this, xxoutputClock);
            if (this.stopComputation) {
                return EErrorType.Aborted;
            }
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.compMultiplier = m;
                this.outputClock = xxoutputClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                return EErrorType.None;
            }
            if (sbr == EErrorType.TooFast) {
                if (fst) {
                    return sbr;
                }
                return EErrorType.CannotSetup;
            }
            if (sbr == EErrorType.BothFastSlow) {
                return sbr;
            }
            fst = false;
            if (sbr != EErrorType.TooSlow) continue;
            wasTooSlow = true;
        }
        this.outputClock = xxoutputClock;
        if (wasTooSlow && sbr == EErrorType.TooFast) {
            return EErrorType.CannotSetup;
        }
        return sbr;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.multiplier != null) : "FLL/PLL not fully defined - " + this.id;
        EErrorType sbr = this.testInputFreq(clock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        BigRational xxDefaultMul = this.defaultMul;
        if (xxDefaultMul != null) {
            this.workingMultiplier = xxDefaultMul;
            BigRational actClock = this.operation.clockModify(clock);
            sbr = this.testOutputFreq(actClock);
            if (sbr == EErrorType.None) {
                this.outputClock = actClock;
                this.lastComp = ECompState.OnceSatisfied;
                EErrorType nres = this.child.computeAutoWR(this, actClock);
                if (this.stopComputation) {
                    return EErrorType.None;
                }
                if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                    this.compMultiplier = xxDefaultMul;
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return EErrorType.None;
                }
            }
        }
        return this.computeFLLAutoWR(clock);
    }

    @Override
    public void setScaleComputed() {
        assert (this.multiplier != null) : "FLL/PLL not fully defined - " + this.id;
        if (this.compMultiplier == null) {
            return;
        }
        if (!(this.setMultiplier != null || this.useDefaults && this.defaultMul != null)) {
            this.setMultiplier = this.compMultiplier;
        }
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.outputClock;
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.child != null) : "Null child in FLL/PLL " + this.id;
        @NonNull List<@NonNull Node> res = this.child.getDirectlyConnectedTo(this, node);
        if (res.size() > 0) {
            if (this == node) {
                res.add(this);
            } else if (!res.contains(node)) {
                res.clear();
            }
        }
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
        this.outputClock = null;
    }

    @Override
    public @Nullable TimingScale getMultiplicativeScale() {
        return this.multiplier;
    }
}

