/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.DivCommonSlave;
import com.nxp.swtools.clocks.model.DivMasterSlave;
import com.nxp.swtools.clocks.model.DivMultiSlave;
import com.nxp.swtools.clocks.model.DivSlave;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class DivMaster
extends Divider {
    @NonNull
    private @NonNull List<@NonNull DivCommonSlave> slaves;

    public DivMaster(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, scaler);
        this.type = ENodeType.DivMaster;
        this.slaves = new ArrayList<DivCommonSlave>();
    }

    public DivMaster(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, scaler, defaultScale);
        this.type = ENodeType.DivMaster;
        this.slaves = new ArrayList<DivCommonSlave>();
    }

    @Override
    public void addSlave(@NonNull Divider divider) {
        if (divider instanceof DivSlave) {
            this.slaves.add((DivCommonSlave)divider);
        } else if (divider instanceof DivMasterSlave) {
            this.slaves.add(0, (DivCommonSlave)divider);
        } else if (divider instanceof DivMultiSlave) {
            if (this.slaves.size() == 0) {
                this.slaves.add((DivCommonSlave)divider);
            } else {
                int i = 0;
                while (i < this.slaves.size()) {
                    if (this.slaves.get(i) instanceof DivSlave) break;
                    ++i;
                }
                this.slaves.add(i, (DivCommonSlave)divider);
            }
        }
    }

    @Override
    public boolean setOutputFrequency(byte freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(short freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(int freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(long freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigInteger freq) {
        BigRational tmpFreq = new BigRational(freq);
        return this.setOutputFrequency(tmpFreq);
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        boolean res = super.setOutputFrequency(freq);
        for (DivCommonSlave slave : this.slaves) {
            if (!slave.isLocked()) continue;
            slave.setScale = null;
            boolean bl = res = res && slave.setOutputFrequency(freq);
        }
        return res;
    }

    @Override
    public boolean setScale(@Nullable BigRational newScale) {
        BigRational curScale = null;
        FreqLimitErrorI locLogFLE = this.logFLE;
        if (newScale == null || this.scaler == null) {
            this.setScale = null;
            if (this.useDefaults) {
                curScale = this.defaultScale;
            }
        } else if (this.scaler.elem(newScale)) {
            curScale = this.setScale = newScale;
        } else {
            this.setScale = null;
        }
        if (curScale == null && newScale != null) {
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.ScaleOutOfRange, this);
            }
            return false;
        }
        boolean res = true;
        for (DivCommonSlave slave : this.slaves) {
            if (slave.isLocked()) {
                slave.setScale = curScale;
            }
            if (curScale == null) continue;
            BigRational xxSlaveSetScale = slave.setScale;
            if (xxSlaveSetScale != null && !slave.isLocked()) {
                res = res && slave.checkScaleRatio(xxSlaveSetScale.divide(curScale), this);
                continue;
            }
            BigRational xxSlaveDefaultScale = slave.defaultScale;
            if (!slave.useDefaults || xxSlaveDefaultScale == null) continue;
            boolean bl = res = res && slave.checkScaleRatio(xxSlaveDefaultScale.divide(curScale), this);
        }
        return res;
    }

    private @NonNull EErrorType checkAllSlaves(@NonNull BigRational clock) {
        EErrorType res = EErrorType.None;
        for (DivCommonSlave slave : this.slaves) {
            EErrorType sbr = slave.computeAutoWR(this, clock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled || res == EErrorType.BothFastSlow) continue;
            if (sbr == EErrorType.BothFastSlow) {
                res = EErrorType.BothFastSlow;
                continue;
            }
            if (res == EErrorType.CannotSetup) continue;
            if (sbr == EErrorType.CannotSetup) {
                res = EErrorType.CannotSetup;
                continue;
            }
            if (sbr == EErrorType.TooFast) {
                if (res == EErrorType.TooFast) continue;
                if (res == EErrorType.None) {
                    res = EErrorType.TooFast;
                    continue;
                }
                res = EErrorType.BothFastSlow;
                continue;
            }
            if (res == EErrorType.TooSlow) continue;
            res = res == EErrorType.None ? sbr : EErrorType.BothFastSlow;
        }
        return res;
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        BigRational newClock;
        EErrorType sbr;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        if ((sbr = this.testInputFreq(clock)) != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        assert (this.scaler != null) : "Null scaler in divider " + this.id;
        assert (this.child != null) : "Null child in divider " + this.id;
        Object xxCompScale = this.setScale != null ? this.setScale : (this.useDefaults && this.defaultScale != null ? this.defaultScale : null);
        if (xxCompScale != null) {
            BigRational newClock2 = clock.divide(xxCompScale);
            sbr = this.testOutputFreq(newClock2);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = newClock2;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock2);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.compScale = xxCompScale;
                this.lastComp = ECompState.OnceSubtreeOK;
                return this.checkAllSlaves(clock);
            }
            return nres;
        }
        BigRational xxSetOutputFreq = this.setOutputFreq;
        if (xxSetOutputFreq != null) {
            if (clock.divide(this.scaler.from).compareTo(xxSetOutputFreq.divide(BigRational.ONE.add(this.accuracy))) < 0) {
                return EErrorType.TooSlow;
            }
            if (clock.divide(this.scaler.to).compareTo(xxSetOutputFreq.multiply(BigRational.ONE.add(this.accuracy))) > 0) {
                return EErrorType.TooFast;
            }
            xxCompScale = this.getCScale(clock, xxSetOutputFreq);
            BigRational newClock3 = clock.divide(xxCompScale);
            BigRational ac = xxSetOutputFreq.compareTo(newClock3) < 0 ? newClock3.divide(xxSetOutputFreq).subtract(BigRational.ONE) : xxSetOutputFreq.divide(newClock3).subtract(BigRational.ONE);
            if (ac.compareTo(this.accuracy) > 0) {
                return EErrorType.CannotSetup;
            }
            sbr = this.testOutputFreq(newClock3);
            if (sbr != EErrorType.None) {
                return sbr;
            }
            this.outputClock = newClock3;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock3);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                return this.checkAllSlaves(clock);
            }
            return nres;
        }
        xxCompScale = this.defaultScale;
        if (xxCompScale != null && (sbr = this.testOutputFreq(newClock = clock.divide(xxCompScale))) == EErrorType.None) {
            this.lastComp = ECompState.OnceSatisfied;
            sbr = this.child.computeAutoWR(this, newClock);
            if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                this.outputClock = newClock;
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                sbr = this.checkAllSlaves(clock);
                if (sbr == EErrorType.None || sbr == EErrorType.NotEnabled) {
                    return EErrorType.None;
                }
            }
        }
        EErrorType res = EErrorType.TooFast;
        boolean fst = true;
        EErrorType outres = EErrorType.None;
        for (BigRational scale : this.scaler) {
            assert (scale != null);
            xxCompScale = scale;
            BigRational newClock4 = clock.divide(xxCompScale);
            sbr = this.testOutputFreq(newClock4);
            if (sbr != EErrorType.None) {
                if (outres != EErrorType.CannotSetup || sbr == EErrorType.TooFast) {
                    outres = sbr == EErrorType.TooFast ? sbr : (outres == EErrorType.TooFast ? EErrorType.CannotSetup : sbr);
                }
                if (sbr != EErrorType.TooSlow) continue;
                return outres;
            }
            this.outputClock = newClock4;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType nres = this.child.computeAutoWR(this, newClock4);
            if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                this.compScale = xxCompScale;
                nres = this.checkAllSlaves(clock);
                if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
                    return EErrorType.None;
                }
            }
            if (nres == EErrorType.BothFastSlow) {
                return nres;
            }
            if (nres == EErrorType.TooSlow) {
                if (fst) {
                    return EErrorType.TooSlow;
                }
                return EErrorType.CannotSetup;
            }
            fst = false;
            if (nres == EErrorType.TooFast && res == nres) continue;
            res = EErrorType.CannotSetup;
        }
        if (outres == EErrorType.CannotSetup) {
            res = outres;
        }
        return res;
    }

    @Override
    public @NonNull List<@NonNull DivCommonSlave> getSlaveDividers() {
        @NonNull ArrayList<@NonNull DivCommonSlave> result = new ArrayList<DivCommonSlave>(this.slaves.size());
        for (DivCommonSlave slave : this.slaves) {
            result.add(slave);
        }
        return result;
    }
}

