/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;

public class DivCommonSlave
extends Divider {
    @NonNull
    protected static final Divider DUMMY_DIVIDER = new Divider("--<DUMMY_DIVIDER>--");
    @NonNull
    protected static final DivCommonSlave DUMMY_SLAVE = new DivCommonSlave("--<DUMMY_SLAVE>--");
    @Nullable
    protected BigInteger maximalRatio = null;

    protected DivCommonSlave(@NonNull String id) {
        super(id);
    }

    protected DivCommonSlave(@NonNull String id, @NonNull TimingScale scaler) {
        super(id, scaler);
    }

    protected DivCommonSlave(@NonNull String id, @NonNull TimingScale scaler, @NonNull BigRational defaultScale) {
        super(id, scaler, defaultScale);
    }

    public boolean isLocked() {
        return false;
    }

    boolean checkScaleRatio(@NonNull BigRational ratioToMaster, @NonNull Divider masterArg) {
        FreqLimitErrorI locLogFLE = this.logFLE;
        if (ratioToMaster.getDenominator().equals(TimingScale.ONE)) {
            BigInteger maximalRatioLoc = this.maximalRatio;
            if (maximalRatioLoc == null) {
                return true;
            }
            BigInteger ratio = ratioToMaster.getNumerator();
            if (ratio.compareTo(maximalRatioLoc) <= 0) {
                return true;
            }
            if (locLogFLE != null && this.enabled) {
                locLogFLE.logDividerError(EDividerError.MasterSlaveRatioInSlave, this);
                locLogFLE.logDividerError(EDividerError.MasterSlaveRatioInMaster, masterArg);
            }
            return false;
        }
        if (locLogFLE != null && this.enabled) {
            locLogFLE.logDividerError(EDividerError.RatioNotIntegralInSlave, this);
            locLogFLE.logDividerError(EDividerError.RatioNotIntegralInMaster, masterArg);
        }
        return false;
    }

    @NonNull EErrorType testScaleRatio(@NonNull BigRational ratioToMaster) {
        BigInteger ratio;
        if (!ratioToMaster.getDenominator().equals(TimingScale.ONE)) {
            if (ratioToMaster.getNumerator().equals(TimingScale.ONE)) {
                return EErrorType.TooFast;
            }
            return EErrorType.CannotSetup;
        }
        BigInteger maximalRatioLoc = this.maximalRatio;
        if (maximalRatioLoc != null && (ratio = ratioToMaster.getNumerator()).compareTo(maximalRatioLoc) > 0) {
            return EErrorType.TooFast;
        }
        return EErrorType.None;
    }

    @Override
    public void setMaximalRatio(@Nullable BigInteger maxRatio) {
        this.maximalRatio = maxRatio;
    }

    @Override
    public @Nullable BigInteger getMaximalRatio() {
        return this.maximalRatio;
    }

    protected @NonNull EErrorType computeWith2Scales(@NonNull BigRational clock, @NonNull BigRational myScale, @NonNull BigRational masterScale) {
        @NonNull EErrorType scaleErr = this.testScaleRatio(myScale.divide(masterScale));
        if (scaleErr != EErrorType.None) {
            return scaleErr;
        }
        BigRational newClock = clock.divide(myScale);
        EErrorType sbr = this.testOutputFreq(newClock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.outputClock = newClock;
        this.lastComp = ECompState.OnceSatisfied;
        EErrorType nres = this.child.computeAutoWR(this, newClock);
        if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
            this.lastComp = ECompState.OnceSubtreeOK;
            this.compScale = myScale;
            return EErrorType.None;
        }
        return nres;
    }

    protected @NonNull EErrorType computeWithFreqScale(@NonNull BigRational clock, @NonNull BigRational freq, @NonNull BigRational masterScale) {
        @NonNull BigRational xxCompScale = this.getCScale(clock, freq);
        @NonNull EErrorType scaleErr = this.testScaleRatio(xxCompScale.divide(masterScale));
        if (scaleErr != EErrorType.None) {
            return scaleErr;
        }
        @NonNull BigRational newClock = clock.divide(xxCompScale);
        BigRational ac = freq.compareTo(newClock) < 0 ? newClock.divide(freq).subtract(BigRational.ONE) : freq.divide(newClock).subtract(BigRational.ONE);
        if (ac.compareTo(this.accuracy) > 0) {
            return EErrorType.CannotSetup;
        }
        @NonNull EErrorType sbr = this.testOutputFreq(newClock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.outputClock = newClock;
        this.lastComp = ECompState.OnceSatisfied;
        EErrorType nres = this.child.computeAutoWR(this, newClock);
        if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
            this.lastComp = ECompState.OnceSubtreeOK;
            this.compScale = xxCompScale;
            return EErrorType.None;
        }
        return nres;
    }
}

