/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.CalculatedTimingScale;
import com.nxp.swtools.clocks.model.Clock;
import com.nxp.swtools.clocks.model.ClockFixed;
import com.nxp.swtools.clocks.model.ClockGeneratorRational;
import com.nxp.swtools.clocks.model.ClockListFixed;
import com.nxp.swtools.clocks.model.Consumer;
import com.nxp.swtools.clocks.model.DivMaster;
import com.nxp.swtools.clocks.model.DivMasterSlave;
import com.nxp.swtools.clocks.model.DivMultiSlave;
import com.nxp.swtools.clocks.model.DivSlave;
import com.nxp.swtools.clocks.model.Divider;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.FLL;
import com.nxp.swtools.clocks.model.FLLext;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Gate;
import com.nxp.swtools.clocks.model.GeometricTimingScale;
import com.nxp.swtools.clocks.model.LargeGeometricScale;
import com.nxp.swtools.clocks.model.LargeLinearScale;
import com.nxp.swtools.clocks.model.LargeSetScale;
import com.nxp.swtools.clocks.model.LinearTimingScale;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.ModelDataComI;
import com.nxp.swtools.clocks.model.Multiplexer;
import com.nxp.swtools.clocks.model.Multiplier;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeHidden;
import com.nxp.swtools.clocks.model.NodeSplitter;
import com.nxp.swtools.clocks.model.PLL;
import com.nxp.swtools.clocks.model.PLLrev;
import com.nxp.swtools.clocks.model.Root;
import com.nxp.swtools.clocks.model.SetTimingScale;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ClockModel {
    private static final int smallSetThreshold = 0xFFFFFFF;
    private static final int smallLinearThreshold = 128;
    private static final int smallGeometricThreshold = 256;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClockModel.class);
    private Root clockRoot = null;
    private List<@NonNull Node> allNodes = null;
    private HashMap<@NonNull String, @NonNull Node> nodeByName = null;
    private boolean useDefault = true;
    private boolean stopAutoComputation = false;

    public static @NonNull ClockModel makeDemoModel() {
        ClockModel model = new ClockModel();
        Root root = new Root("#root#");
        Clock osc = new Clock("OSC");
        Divider div = new Divider("DIV");
        Consumer clockOut = new Consumer("CLOCK_OUT");
        model.setRoot(root);
        model.addNode(osc);
        model.addNode(div);
        model.addNode(clockOut);
        root.addChild(osc);
        osc.setPred(root);
        osc.setChild(div);
        div.setPred(osc);
        div.setChild(clockOut);
        clockOut.setPred(div);
        assert (BigInteger.ONE != null);
        LinearTimingScale ts = new LinearTimingScale(BigRational.NewBigInteger((int)1), new BigInteger("255"), BigRational.NewBigInteger((int)1));
        div.setTimingScaleValues(ts);
        osc.setMinOutputFreq(new BigRational("8000000"));
        osc.setMaxOutputFreq(new BigRational("16000000"));
        return model;
    }

    public static @NonNull TimingScale makeTimingScale(@NonNull ModelCreationI.ScaleData scaleData) {
        if (scaleData.type == EScaleType.Calculated) {
            assert (scaleData.calculus != null);
            return new CalculatedTimingScale(scaleData.calculus);
        }
        if (scaleData.type == EScaleType.SetSmall) {
            ArrayList<@NonNull BigRational> xxscalelist = scaleData.scalelist;
            assert (xxscalelist != null) : "Scale list expected for set scale, but null provided";
            if (xxscalelist.size() > 0xFFFFFFF) {
                return new LargeSetScale(xxscalelist);
            }
            return new SetTimingScale(xxscalelist);
        }
        BigRational xxlow = scaleData.low;
        assert (xxlow != null) : "Scale data improperly initilized - low";
        BigRational xxhigh = scaleData.high;
        assert (xxhigh != null) : "Scale data improperly initilized - high";
        BigRational xxstep = scaleData.step;
        assert (xxstep != null) : "Scale data improperly initilized - step";
        if (scaleData.type == EScaleType.LinearSmall) {
            if (scaleData.n > 128L) {
                return new LargeLinearScale(xxlow, xxhigh, xxstep);
            }
            return new LinearTimingScale(xxlow, xxhigh, xxstep);
        }
        assert (scaleData.type == EScaleType.GeometricSmall);
        if (scaleData.n > 256L) {
            return new LargeGeometricScale(xxlow, xxhigh, xxstep);
        }
        return new GeometricTimingScale(xxlow, xxhigh, xxstep);
    }

    public static @NonNull ClockModel createModel(@NonNull Collection<@NonNull ModelDataComI> devices) {
        ClockModel model = new ClockModel();
        for (ModelDataComI gd : devices) {
            ModelCreationI deviceToCreate = gd.getDevice();
            NodeHidden nd = null;
            TimingScale ts = null;
            BigRational xxdefaultScale = null;
            switch (deviceToCreate.getType()) {
                case Root: {
                    nd = new Root(deviceToCreate.getID());
                    break;
                }
                case Splitter: {
                    nd = new NodeSplitter(deviceToCreate.getID());
                    break;
                }
                case Multiplexer: {
                    nd = new Multiplexer(deviceToCreate.getID());
                    break;
                }
                case Divider: {
                    ts = ClockModel.makeTimingScale(deviceToCreate.getScaleData());
                    xxdefaultScale = deviceToCreate.getDefaultScale();
                    if (xxdefaultScale != null) {
                        nd = new Divider(deviceToCreate.getID(), ts, xxdefaultScale);
                        break;
                    }
                    nd = new Divider(deviceToCreate.getID(), ts);
                    break;
                }
                case DivMaster: {
                    ts = ClockModel.makeTimingScale(deviceToCreate.getScaleData());
                    xxdefaultScale = deviceToCreate.getDefaultScale();
                    if (xxdefaultScale != null) {
                        nd = new DivMaster(deviceToCreate.getID(), ts, xxdefaultScale);
                        break;
                    }
                    nd = new DivMaster(deviceToCreate.getID(), ts);
                    break;
                }
                case DivSlave: {
                    ts = ClockModel.makeTimingScale(deviceToCreate.getScaleData());
                    xxdefaultScale = deviceToCreate.getDefaultScale();
                    DivSlave slaveDivider = xxdefaultScale != null ? new DivSlave(deviceToCreate.getID(), ts, xxdefaultScale) : new DivSlave(deviceToCreate.getID(), ts);
                    BigInteger maxRatio = deviceToCreate.getMasterSlaveRatio();
                    if (maxRatio != null) {
                        slaveDivider.setMaximalRatio(maxRatio);
                    } else {
                        List<@NonNull BigRational> allowedRatios = deviceToCreate.getMasterSlaveAllowedRatios();
                        if (allowedRatios != null) {
                            slaveDivider.setAllowedRatios(allowedRatios);
                        }
                    }
                    nd = slaveDivider;
                    break;
                }
                case DivMultiSlave: {
                    ts = ClockModel.makeTimingScale(deviceToCreate.getScaleData());
                    xxdefaultScale = deviceToCreate.getDefaultScale();
                    DivMultiSlave multiSlaveDivider = xxdefaultScale != null ? new DivMultiSlave(deviceToCreate.getID(), ts, xxdefaultScale) : new DivMultiSlave(deviceToCreate.getID(), ts);
                    multiSlaveDivider.setMaximalRatio(deviceToCreate.getMasterSlaveRatio());
                    nd = multiSlaveDivider;
                    break;
                }
                case DivMasterSlave: {
                    ts = ClockModel.makeTimingScale(deviceToCreate.getScaleData());
                    xxdefaultScale = deviceToCreate.getDefaultScale();
                    DivMasterSlave masterSlaveDivider = xxdefaultScale != null ? new DivMasterSlave(deviceToCreate.getID(), ts, xxdefaultScale) : new DivMasterSlave(deviceToCreate.getID(), ts);
                    BigInteger ratio = deviceToCreate.getMasterSlaveRatio();
                    if (ratio != null) {
                        masterSlaveDivider.setMaximalRatio(ratio);
                    } else {
                        List<@NonNull BigRational> allowedRatios = deviceToCreate.getMasterSlaveAllowedRatios();
                        if (allowedRatios != null) {
                            masterSlaveDivider.setAllowedRatios(allowedRatios);
                        }
                    }
                    nd = masterSlaveDivider;
                    break;
                }
                case Multiplier: {
                    TimingScale mts = ClockModel.makeTimingScale(deviceToCreate.getScaleData());
                    xxdefaultScale = deviceToCreate.getDefaultScale();
                    if (xxdefaultScale != null) {
                        nd = new Multiplier(deviceToCreate.getID(), mts, xxdefaultScale);
                        break;
                    }
                    nd = new Multiplier(deviceToCreate.getID(), mts);
                    break;
                }
                case Clock: {
                    nd = new Clock(deviceToCreate.getID());
                    break;
                }
                case ClockFixed: {
                    nd = new ClockFixed(deviceToCreate.getID(), deviceToCreate.getClockFrequency());
                    break;
                }
                case ClockListFixed: {
                    nd = new ClockListFixed(deviceToCreate.getID(), deviceToCreate.getListClockFreq(), deviceToCreate.getDefaultClockFreq());
                    break;
                }
                case ClockGeneratorRat: {
                    nd = new ClockGeneratorRational(deviceToCreate.getID());
                    break;
                }
                case PLL: {
                    TimingScale mts = ClockModel.makeTimingScale(deviceToCreate.getXLLMultiplier());
                    ts = ClockModel.makeTimingScale(deviceToCreate.getXLLDivider());
                    PLL pll = new PLL(deviceToCreate.getID(), mts, ts);
                    pll.setDefaultMultiplierDivider(deviceToCreate.getDefaultMul(), deviceToCreate.getDefaultDiv());
                    pll.setMinDividerFreq(deviceToCreate.getDivMinOutput());
                    pll.setMaxDividerFreq(deviceToCreate.getDivMaxOutput());
                    nd = pll;
                    break;
                }
                case PLLrev: {
                    TimingScale mts = ClockModel.makeTimingScale(deviceToCreate.getXLLMultiplier());
                    ts = ClockModel.makeTimingScale(deviceToCreate.getXLLDivider());
                    PLLrev pllrev = new PLLrev(deviceToCreate.getID(), mts, ts);
                    pllrev.setDefaultMultiplierDivider(deviceToCreate.getDefaultMul(), deviceToCreate.getDefaultDiv());
                    pllrev.setMinDividerFreq(deviceToCreate.getDivMinOutput());
                    pllrev.setMaxDividerFreq(deviceToCreate.getDivMaxOutput());
                    ((Node)pllrev).setPostDivider(deviceToCreate.getPostDivider());
                    nd = pllrev;
                    break;
                }
                case FLL: {
                    TimingScale mts = ClockModel.makeTimingScale(deviceToCreate.getXLLMultiplier());
                    FLL fll = new FLL(deviceToCreate.getID(), mts);
                    fll.setDefaultMultiplier(deviceToCreate.getDefaultMul());
                    nd = fll;
                    break;
                }
                case FLLext: {
                    FLLext flle = new FLLext(deviceToCreate.getID());
                    for (ModelCreationI.FLLextSingleData fd : deviceToCreate.getFLLextData()) {
                        flle.addMulConstWConstr(fd.mulBy, fd.iLo, fd.iHi, fd.oLo, fd.oHi);
                    }
                    BigRational defaultFLLextMul = deviceToCreate.getFLLextDefault();
                    if (defaultFLLextMul != null) {
                        flle.setDefaultMulConst(defaultFLLextMul);
                    }
                    nd = flle;
                    break;
                }
                case Gate: {
                    nd = new Gate(deviceToCreate.getID());
                    break;
                }
                case Consumer: {
                    nd = new Consumer(deviceToCreate.getID());
                    break;
                }
                default: {
                    assert (false) : "Some device type not supported in model creation";
                    break;
                }
            }
            assert (nd != null) : "No ini-type selected";
            nd.setMinInputFreq(deviceToCreate.getMinInput());
            nd.setMaxInputFreq(deviceToCreate.getMaxInput());
            nd.setMinOutputFreq(deviceToCreate.getMinOutput());
            nd.setMaxOutputFreq(deviceToCreate.getMaxOutput());
            if (nd.getType() == ENodeType.Root) {
                model.setRoot((Root)nd);
            } else {
                model.addNode(nd);
            }
            gd.setDevice(nd);
        }
        block32: for (ModelDataComI gd : devices) {
            ModelCreationI device = gd.getDevice();
            String did = device.getID();
            Node nd = null;
            block21 : switch (device.getType()) {
                case Multiplexer: {
                    String tmpID = device.getSuccessor();
                    assert (tmpID != null) : "ERROR: No successor for multiplexer";
                    Node tmpNode = model.getNode(tmpID);
                    assert (tmpNode != null) : "ERROR: Node " + tmpID + " not existing";
                    nd = model.getNode(did);
                    assert (nd != null) : "ERROR: Node " + did + " not existing";
                    nd.addChild(tmpNode);
                    List<@NonNull @NonNull @NonNull String> strLst = device.getPredList();
                    assert (strLst != null) : "List of predecessors missing for multiplexer " + did;
                    for (String id : strLst) {
                        Node mpred = model.getNode(id);
                        assert (mpred != null) : "ERROR: Node " + id + " not found";
                        nd.addPred(mpred);
                    }
                    String tmpBranch = device.getDefaultBranch();
                    if (tmpBranch == null) continue block32;
                    Node branch = model.getNode(tmpBranch);
                    assert (branch != null) : "Default branch " + tmpBranch + " not found for multiplexer " + did;
                    nd.setDefaultSelected(branch);
                    break;
                }
                case Splitter: {
                    Node msucc;
                    String tmpID = device.getPredecessor();
                    assert (tmpID != null) : "ERROR: No predecessor for node splitter";
                    Node tmpNode = model.getNode(tmpID);
                    assert (tmpNode != null) : "ERROR: Node " + tmpID + " not existing";
                    nd = model.getNode(did);
                    assert (nd != null) : "ERROR: Node " + did + " not existing";
                    nd.addPred(tmpNode);
                    List<@NonNull @NonNull @NonNull String> strLst = device.getSuccList();
                    assert (strLst != null) : "List of successors missing for node splitter " + did;
                    for (String id : strLst) {
                        msucc = model.getNode(id);
                        assert (msucc != null) : "ERROR: Node " + id + " not found";
                        nd.addChild(msucc);
                    }
                    continue block32;
                }
                case Root: {
                    Node msucc;
                    nd = model.getNode(did);
                    assert (nd != null) : "ERROR: Node " + did + " not existing";
                    List<@NonNull @NonNull @NonNull String> strLst = device.getSuccList();
                    assert (strLst != null) : "List of successors missing for node splitter " + did;
                    for (String id : strLst) {
                        msucc = model.getNode(id);
                        assert (msucc != null) : "ERROR: Node " + id + " not found";
                        nd.addChild(msucc);
                    }
                    continue block32;
                }
                default: {
                    nd = model.getNode(did);
                    assert (nd != null) : "ERROR: Node " + did + " not existing";
                    String tmpID = device.getPredecessor();
                    assert (tmpID != null) : "ERROR: No predecessor for device " + did;
                    Node tmpNode = model.getNode(tmpID);
                    assert (tmpNode != null) : "ERROR: Node " + tmpID + " not existing";
                    nd.setPred(tmpNode);
                    if (nd.getType() != ENodeType.Consumer) {
                        tmpID = device.getSuccessor();
                        assert (tmpID != null) : "ERROR: No successor for device " + did;
                        tmpNode = model.getNode(tmpID);
                        assert (tmpNode != null) : "ERROR: Node " + tmpID + " not existing";
                        nd.setChild(tmpNode);
                    }
                    switch (device.getType()) {
                        case DivSlave: 
                        case DivMasterSlave: {
                            Node master = model.getNode(device.getMasterDiv());
                            assert (master != null) : "ERROR: Node " + device.getMasterDiv() + " not existing, expected master divider";
                            nd.setMaster((Divider)master);
                            master.addSlave((Divider)nd);
                            break block21;
                        }
                        case DivMultiSlave: {
                            Node master;
                            @NonNull List<@NonNull String> masterNames = device.getListOfMasters();
                            for (String oneMaster : masterNames) {
                                master = model.getNode(oneMaster);
                                assert (master != null) : "ERROR: Node " + oneMaster + " not existing, expected master divider";
                                nd.addMaster((Divider)master);
                                if (master.getType() == ENodeType.DivMasterSlave) {
                                    master.setSlave((Divider)nd);
                                    continue;
                                }
                                master.addSlave((Divider)nd);
                            }
                            continue block32;
                        }
                    }
                }
            }
        }
        return model;
    }

    public void addNode(@NonNull Node nd) {
        Node inl;
        boolean isNodeIn;
        if (this.allNodes == null) {
            this.allNodes = new ArrayList<Node>();
            this.nodeByName = new HashMap();
        }
        boolean bl = isNodeIn = (inl = this.nodeByName.get(nd.id)) != null;
        if (isNodeIn && inl != nd) {
            this.nodeByName.remove(inl.id);
            this.allNodes.remove(inl);
        }
        if (inl != nd) {
            this.nodeByName.put(nd.id, nd);
            this.allNodes.add(nd);
        }
    }

    public void setRoot(@NonNull Root nd) {
        Node inl;
        boolean isNodeIn;
        if (this.allNodes == null) {
            this.allNodes = new ArrayList<Node>();
            this.nodeByName = new HashMap();
        }
        boolean bl = isNodeIn = (inl = this.nodeByName.get(nd.id)) != null;
        if (isNodeIn && inl != nd) {
            this.nodeByName.remove(inl.id);
            this.allNodes.remove(inl);
        }
        if (inl != nd) {
            this.nodeByName.put(nd.id, nd);
            this.allNodes.add(nd);
            this.clockRoot = nd;
        }
    }

    public @Nullable Node getNode(@NonNull String name) {
        assert (this.nodeByName != null) : "Model not setup properly, missing nodes";
        return this.nodeByName.get(name);
    }

    public void printTree() {
        Root root = this.clockRoot;
        assert (root != null) : "No root device exists, cannot print";
        this.clockRoot.printT(root, "", "");
    }

    public @NonNull String stringTree() {
        Root root = this.clockRoot;
        assert (root != null) : "No root device exists, cannot print";
        String res = root.stringT(root, "", "").toString();
        return res == null ? "ERROR" : res;
    }

    public void setFreqLimitErrorLogger(@Nullable FreqLimitErrorI logger) {
        if (this.allNodes == null) {
            return;
        }
        for (Node nd : this.allNodes) {
            nd.setFreqLimitErrorLog(logger);
        }
    }

    public boolean isEverySet(@NonNull List<@NonNull Node> unset) {
        if (this.allNodes == null) {
            return false;
        }
        boolean res = true;
        for (Node nd : this.allNodes) {
            boolean bl = res = res && nd.isSet(unset);
        }
        return res;
    }

    public boolean isEverySetOrDefault(@NonNull List<@NonNull Node> unset) {
        if (this.allNodes == null) {
            return false;
        }
        boolean res = true;
        for (Node nd : this.allNodes) {
            boolean bl = res = res && nd.isSetOrDefault(unset);
        }
        return res;
    }

    public boolean isEverySetOrDisabled(@NonNull List<@NonNull Node> unset) {
        if (this.allNodes == null) {
            return false;
        }
        boolean res = true;
        for (Node nd : this.allNodes) {
            if (!nd.enabled) continue;
            boolean bl = res = res && nd.isSet(unset);
        }
        return res;
    }

    public boolean isEverySetOrDefaultOrDisabled(@NonNull List<@NonNull Node> unset) {
        if (this.allNodes == null) {
            return false;
        }
        boolean res = true;
        for (Node nd : this.allNodes) {
            if (!nd.enabled) continue;
            boolean bl = res = res && nd.isSetOrDefault(unset);
        }
        return res;
    }

    public void includeDefaults() {
        this.useDefault = true;
        if (this.allNodes == null) {
            return;
        }
        for (Node nd : this.allNodes) {
            nd.includeDefaults();
        }
    }

    public void excludeDefaults() {
        this.useDefault = false;
        if (this.allNodes == null) {
            return;
        }
        for (Node nd : this.allNodes) {
            nd.excludeDefaults();
        }
    }

    private void resetCall() {
        if (this.allNodes == null) {
            return;
        }
        for (Node nd : this.allNodes) {
            nd.resetCall();
        }
    }

    public boolean compute(@NonNull List<@NonNull Node> unset) {
        long recomputeStart = System.nanoTime();
        if (this.useDefault ? !this.isEverySetOrDefault(unset) : !this.isEverySet(unset)) {
            return false;
        }
        this.resetCall();
        for (Node nd : this.allNodes) {
            nd.resetNodeComputed();
        }
        assert (BigRational.ONE != null);
        assert (this.clockRoot != null);
        boolean result = this.clockRoot.compute(null, null);
        for (Node nd : this.allNodes) {
            NodeHidden node = (NodeHidden)nd;
            if (!node.enabled || node.wasComputed) continue;
            node.checkInputFreq(BigRational.ZERO);
            node.checkInternalDividerFreq(BigRational.ZERO);
            node.checkOutputFreq(BigRational.ZERO);
        }
        LOGGER.info("compute finished in[ms]: " + (double)(System.nanoTime() - recomputeStart) / 1000000.0);
        return result;
    }

    public boolean computeDisabled(@NonNull List<@NonNull Node> unset) {
        long recomputeStart = System.nanoTime();
        if (this.useDefault ? !this.isEverySetOrDefaultOrDisabled(unset) : !this.isEverySetOrDisabled(unset)) {
            return false;
        }
        this.resetCall();
        for (Node nd : this.allNodes) {
            nd.resetNodeComputed();
            ((NodeHidden)nd).resetInputOutputClock();
        }
        assert (BigRational.ONE != null);
        assert (this.clockRoot != null);
        boolean result = this.clockRoot.compute(null, null);
        for (Node nd : this.allNodes) {
            NodeHidden node = (NodeHidden)nd;
            if (!node.enabled || node.wasComputed) continue;
            node.checkInputFreq(BigRational.ZERO);
            node.checkInternalDividerFreq(BigRational.ZERO);
            node.checkOutputFreq(BigRational.ZERO);
        }
        LOGGER.info("computeDisabled finished in[ms]: " + (double)(System.nanoTime() - recomputeStart) / 1000000.0);
        return result;
    }

    private void closeAuto() {
        if (this.allNodes == null) {
            return;
        }
        for (Node nd : this.allNodes) {
            NodeHidden node = (NodeHidden)nd;
            node.closeAuto();
            if (!node.enabled || node.wasComputed) continue;
            node.checkInputFreq(BigRational.ZERO);
            node.checkInternalDividerFreq(BigRational.ZERO);
            node.checkOutputFreq(BigRational.ZERO);
        }
    }

    public EErrorType computeAutoWR() {
        long recomputeStart = System.nanoTime();
        Root xxClockRoot = this.clockRoot;
        assert (xxClockRoot != null);
        this.resetCall();
        xxClockRoot.prepareAuto(null, false);
        this.resetFlagsAndTrackBeforeAutoWR();
        EErrorType res = xxClockRoot.computeAutoWR(null, null);
        if (this.stopAutoComputation) {
            res = EErrorType.Aborted;
        }
        if (res == EErrorType.None || res == EErrorType.NotEnabled) {
            for (Node nd : this.allNodes) {
                ((NodeHidden)nd).setScaleComputed();
            }
        }
        this.checkFreqLimitsOnDeadBranches();
        this.closeAuto();
        LOGGER.info("computeAutoWR finished in[ms]: " + (double)(System.nanoTime() - recomputeStart) / 1000000.0);
        return res;
    }

    public @NonNull Map<@NonNull Node, @NonNull EErrorType> computeAutoWRPerClock() {
        long recomputeStart = System.nanoTime();
        Root locClockRoot = this.clockRoot;
        assert (locClockRoot != null);
        this.resetCall();
        locClockRoot.prepareAuto(null, false);
        this.resetFlagsAndTrackBeforeAutoWR();
        locClockRoot.computeAutoWR(null, null);
        Map<@NonNull Node, @NonNull EErrorType> res = locClockRoot.getLastError();
        assert (res != null) : "Error result null even if computed??";
        for (Map.Entry<Node, EErrorType> entry : res.entrySet()) {
            if (this.stopAutoComputation) {
                entry.setValue(EErrorType.Aborted);
                continue;
            }
            if (!entry.getValue().equals((Object)EErrorType.None)) continue;
            NodeHidden setTreeComputed = (NodeHidden)entry.getKey();
            setTreeComputed.setTreeScaleComputed(locClockRoot);
        }
        if (!this.stopAutoComputation) {
            this.checkFreqLimitsOnDeadBranches();
        }
        this.closeAuto();
        LOGGER.info("computeAutoWRPerClock finished in[ms]: " + (double)(System.nanoTime() - recomputeStart) / 1000000.0);
        return res;
    }

    public EErrorType computeAutoWRNoFreqLimits() {
        long recomputeStart = System.nanoTime();
        assert (this.clockRoot != null);
        this.resetFlagsAndTrackBeforeAutoWR();
        EErrorType res = this.clockRoot.computeAutoWR(null, null);
        if (this.stopAutoComputation) {
            res = EErrorType.Aborted;
        }
        if (res == EErrorType.None || res == EErrorType.NotEnabled) {
            for (Node nd : this.allNodes) {
                ((NodeHidden)nd).setScaleComputed();
            }
        }
        for (Node nd : this.allNodes) {
            nd.testFreqLimits = true;
        }
        LOGGER.info("computeAutoWRNoFreqLimits finished in[ms]: " + (double)(System.nanoTime() - recomputeStart) / 1000000.0);
        return res;
    }

    public void clean() {
        for (Node nd : this.allNodes) {
            nd.clean();
        }
    }

    public boolean getReversePathFrom(@NonNull String name, @NonNull List<@NonNull Node> path) {
        boolean isNodeNull;
        assert (this.nodeByName != null) : "Model is empty";
        Node nd = this.nodeByName.get(name);
        boolean bl = isNodeNull = nd == null;
        if (isNodeNull) {
            return false;
        }
        return nd.getReversePath(nd, path);
    }

    public boolean getReversePathFrom(@Nullable Node node, @NonNull List<@NonNull Node> path) {
        if (node != null) {
            return node.getReversePath(node, path);
        }
        return false;
    }

    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node node) {
        assert (this.clockRoot != null);
        return this.clockRoot.getDirectlyConnectedTo(null, node);
    }

    private void resetFlagsBeforeAutoWR() {
        for (Node nd : this.allNodes) {
            nd.allowComputation();
            nd.lastComp = ECompState.NoComp;
            nd.resetNodeComputed();
            ((NodeHidden)nd).resetInputOutputClock();
        }
    }

    private void resetFlagsAndTrackBeforeAutoWR() {
        for (Node nd : this.allNodes) {
            nd.allowComputation();
            nd.lastComp = ECompState.NoComp;
            nd.resetNodeComputed();
            nd.resetFirstTrackFlag();
            ((NodeHidden)nd).resetInputOutputClock();
        }
        this.clockRoot.trackAutoWR(null);
    }

    private void checkFreqLimitsOnDeadBranches() {
        for (Node nd : this.allNodes) {
            NodeHidden node = (NodeHidden)nd;
            if (!node.enabled || node.wasComputed) continue;
            node.checkInputFreq(BigRational.ZERO);
            node.checkInternalDividerFreq(BigRational.ZERO);
            node.checkOutputFreq(BigRational.ZERO);
        }
    }

    public @Nullable BigRational runSearchInterval(@NonNull Node node) {
        BigRational workingAcc;
        long recomputeStart = System.nanoTime();
        this.stopAutoComputation = false;
        assert (this.clockRoot != null);
        this.resetFlagsAndTrackBeforeAutoWR();
        @NonNull BigRational savedAcc = node.initSearchWithinInterval();
        EErrorType res = this.clockRoot.computeAutoWR(null, null);
        if (res != EErrorType.None && res != EErrorType.NotEnabled) {
            node.setAccuracy(savedAcc);
            return null;
        }
        BigRational resultAcc = Node.STARTING_DEVIATION;
        while ((workingAcc = node.narrowSearchInterval()) != null) {
            if (this.stopAutoComputation) {
                return null;
            }
            this.resetFlagsBeforeAutoWR();
            res = this.clockRoot.computeAutoWR(null, null);
            if (res != EErrorType.None && res != EErrorType.NotEnabled) {
                if (this.stopAutoComputation) {
                    return null;
                }
                this.resetFlagsBeforeAutoWR();
                workingAcc = node.halfStepBackInterval();
                res = this.clockRoot.computeAutoWR(null, null);
                if (res == EErrorType.None || res == EErrorType.NotEnabled) {
                    resultAcc = workingAcc;
                    break;
                }
                this.resetFlagsBeforeAutoWR();
                node.setAccuracy(resultAcc);
                this.clockRoot.computeAutoWR(null, null);
                break;
            }
            resultAcc = workingAcc;
        }
        for (Node nd : this.allNodes) {
            ((NodeHidden)nd).setScaleComputed();
        }
        this.checkFreqLimitsOnDeadBranches();
        node.setAccuracy(savedAcc);
        LOGGER.info("runSearchInterval finished in[ms]: " + (double)(System.nanoTime() - recomputeStart) / 1000000.0);
        return resultAcc;
    }

    public void stopAutoCompute() {
        this.stopAutoComputation = true;
        for (Node nd : this.allNodes) {
            nd.stopComputation();
        }
    }
}

