/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.design;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.rcp.jface.WarningDialog;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apugraph.ApuKernelsReconcileUtil;
import com.nxp.s32ds.gte.apugraph.design.DesignMessages;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelSource;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelRegistryManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ReconcileKernelAction
implements IExternalJavaAction {
    public boolean canExecute(Collection<? extends EObject> collection) {
        ApuKernel kernel = (ApuKernel)EObjects.firstOrNull(collection, ApuKernel.class);
        return kernel != null;
    }

    private static void performReconcile(ApuKernel apuKernel, IWorkbenchWindow activeWorkbenchWindow) {
        Shell shell = activeWorkbenchWindow.getShell();
        IWorkbenchPart activePart = activeWorkbenchWindow.getActivePage().getActivePart();
        if (!(activePart instanceof DiagramEditor)) {
            return;
        }
        DiagramEditor diagramEditor = (DiagramEditor)activePart;
        if (diagramEditor.isDirty()) {
            diagramEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        TransactionalEditingDomain editingDomain = diagramEditor.getEditingDomain();
        ApuKernelInfo suspectKernelInfo = apuKernel.getKernelInfo();
        ApuKernelSource source = suspectKernelInfo.getSource();
        if (source == null) {
            ReconcileKernelAction.replaceKernelInfo(apuKernel, editingDomain);
            return;
        }
        if ("apex_kernel_workspace_root".equals(Apex2KernelRegistryManager.INSTANCE.getArchetypeByComparingURIs(suspectKernelInfo))) {
            ReconcileKernelAction.reconcileWithReload(apuKernel, editingDomain, shell);
            return;
        }
    }

    public void execute(Collection<? extends EObject> collection, Map<String, Object> map) {
        ApuKernel apuKernel = (ApuKernel)EObjects.firstOrNull(collection, ApuKernel.class);
        this.doUpdate(apuKernel);
    }

    public void doUpdate(final ApuKernel apuKernel) {
        final IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = activeWorkbenchWindow.getShell();
        if (apuKernel == null) {
            Status theStatus = new Status(4, "com.nxp.s32ds.gte.apugraph.design", DesignMessages.ReconcileKernelAction_kernel_is_null);
            ErrorDialog.openError((Shell)shell, (String)DesignMessages.ReconcileKernelAction_error, (String)DesignMessages.ReconcileKernelAction_kernel_is_null, (IStatus)theStatus);
            return;
        }
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    ReconcileKernelAction.performReconcile(apuKernel, activeWorkbenchWindow);
                }
            };
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            Status theStatus = new Status(4, "com.nxp.s32ds.gte.apugraph.design", target.getMessage(), target);
            ErrorDialog.openError((Shell)shell, (String)DesignMessages.ReconcileKernelAction_error, (String)target.getMessage(), (IStatus)theStatus);
        }
        catch (InterruptedException e) {
            Status theStatus = new Status(4, "com.nxp.s32ds.gte.apugraph.design", e.getMessage());
            WarningDialog.openError((Shell)shell, (String)DesignMessages.ReconcileKernelAction_error, (String)e.getMessage(), (IStatus)theStatus);
        }
    }

    private static void replaceKernelInfo(final ApuKernel apuKernel, final TransactionalEditingDomain editingDomain) {
        CommandStack commandStack = editingDomain.getCommandStack();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                ApuKernelInfo suspectKernelInfo = apuKernel.getKernelInfo();
                URI uri = ReconcileKernelAction.resolveUri(suspectKernelInfo);
                String fragment = uri.fragment();
                ResourceSet resourceSet = editingDomain.getResourceSet();
                Resource resource = resourceSet.getResource(uri, true);
                EObject aKernekInfo = resource.getEObject(fragment);
                if (aKernekInfo instanceof ApuKernelInfo) {
                    ApuKernelInfo reloadedKernelInfo = (ApuKernelInfo)aKernekInfo;
                    apuKernel.setKernelInfo(reloadedKernelInfo);
                    EList kernelInputs = apuKernel.getKernelInputs();
                    for (ApuKernelInput port : kernelInputs) {
                        ReconcileKernelAction.resolveKernelPortInfo(resource, (ApuKernelPort)port);
                    }
                    EList kernelOutputs = apuKernel.getKernelOutputs();
                    for (ApuKernelOutput port : kernelOutputs) {
                        ReconcileKernelAction.resolveKernelPortInfo(resource, (ApuKernelPort)port);
                    }
                }
                EcoreUtil.delete((EObject)suspectKernelInfo);
            }
        };
        commandStack.execute((Command)command);
    }

    private static void reconcileWithReload(final ApuKernel apuKernel, TransactionalEditingDomain editingDomain, final Shell shell) {
        CommandStack commandStack = editingDomain.getCommandStack();
        RecordingCommand command = new RecordingCommand(editingDomain){

            protected void doExecute() {
                ReconcileKernelAction.handleReconcile(apuKernel, shell);
            }
        };
        commandStack.execute((Command)command);
    }

    private static IStatus handleReconcile(ApuKernel apuKernel, Shell shell) {
        MultiStatus ms = new MultiStatus("com.nxp.s32ds.gte.apugraph.design", 0, new String(), null);
        ApuGraph graph = apuKernel.getGraph();
        ms.add(ApuKernelsReconcileUtil.handleReconcile((ApuKernel)apuKernel));
        ms.add(ApuKernelsReconcileUtil.cleanupApuGraph((ApuGraph)graph));
        if (ms.getSeverity() == 2) {
            WarningDialog.openError((Shell)shell, (String)DesignMessages.ReconcileKernelAction_warning, (String)DesignMessages.ReconcileKernelAction_warning_kernels_have_been_removed, (IStatus)ms);
        } else if (ms.getSeverity() == 4) {
            ErrorDialog.openError((Shell)shell, (String)DesignMessages.ReconcileKernelAction_error, (String)DesignMessages.ReconcileKernelAction_kernel_not_found, (IStatus)ms);
        }
        return ms;
    }

    private static void resolveKernelPortInfo(Resource resource, ApuKernelPort port) {
        ApuKernelPortInfo portInfo = port.getPortInfo();
        String portInfoFragment = ReconcileKernelAction.extractFragment((EObject)portInfo);
        EObject aPortInfo = resource.getEObject(portInfoFragment);
        if (aPortInfo instanceof ApuKernelPortInfo) {
            ApuKernelPortInfo reloadedPortInfo = (ApuKernelPortInfo)aPortInfo;
            port.setPortInfo(reloadedPortInfo);
        }
    }

    private static String extractFragment(EObject object) {
        Resource eResource;
        String fragment;
        URI uri = null;
        uri = object.eIsProxy() ? ((InternalEObject)object).eProxyURI() : ((fragment = (eResource = object.eResource()).getURIFragment(object)) == null ? eResource.getURI().appendFragment(fragment) : eResource.getURI());
        return uri.fragment();
    }

    private static URI resolveUri(ApuKernelInfo info) {
        Resource eResource;
        String fragment;
        URI original = null;
        original = info.eIsProxy() ? ((InternalEObject)info).eProxyURI() : ((fragment = (eResource = info.eResource()).getURIFragment((EObject)info)) == null ? eResource.getURI().appendFragment(fragment) : eResource.getURI());
        return original;
    }
}

