/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.design;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.rcp.jface.ListDialogWithToggle;
import com.nxp.s32ds.ext.rcp.jface.WarningDialog;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphs;
import com.nxp.s32ds.gte.apugraph.design.DesignMessages;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.core.filter.KernelDuplicateFilter;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelRegistryManager;
import com.nxp.s32ds.vgt.ide.ui.VgtIdeUi;
import com.nxp.s32ds.vgt.vpt.kernel.ui.dialogs.KernelListFilteredSelectionDialog;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateKernelAction
implements IExternalJavaAction {
    private static boolean show = true;

    public boolean canExecute(Collection<? extends EObject> arg0) {
        return true;
    }

    public void execute(Collection<? extends EObject> collection, Map<String, Object> map) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = activeWorkbenchWindow.getShell();
        ApuGraph graph = (ApuGraph)EObjects.firstOrNull(collection, ApuGraph.class);
        List<ApuKernelInfo> selected = CreateKernelAction.openSelectionWindow(graph, shell);
        if (selected != null) {
            MultiStatus multiStatus = new MultiStatus("com.nxp.s32ds.gte.apugraph.design", 4, new String(), null);
            selected.forEach(k -> {
                try {
                    ApuGraphs.addKernel((ApuGraph)graph, (ApuKernelInfo)k);
                    VgtIdeUi.saveDiagram((IWorkbenchWindow)activeWorkbenchWindow);
                }
                catch (IllegalArgumentException e) {
                    Status status = new Status(4, "com.nxp.s32ds.gte.apugraph.design", e.getMessage());
                    multiStatus.add((IStatus)status);
                }
            });
            if (multiStatus.getChildren().length > 0) {
                String title = DesignMessages.CreateKernelAction;
                String message = DesignMessages.KernelCreationError;
                new ErrorDialog(shell, title, message, (IStatus)multiStatus, 4).open();
            }
        }
    }

    private static List<ApuKernelInfo> openSelectionWindow(ApuGraph graph, Shell shell) {
        KernelListFilteredSelectionDialog dialog;
        Set hiddenDuplicatesOnDiagram;
        MultiStatus multiStatus = new MultiStatus("com.nxp.s32ds.gte.apugraph.design", 4, new String(), null);
        List kernels = Apex2KernelRegistryManager.INSTANCE.getAllArchetypesKernelInfos();
        if (!multiStatus.isOK()) {
            new WarningDialog(shell, DesignMessages.CreateKernelAction_kernel_loading_errors, (IStatus)multiStatus, 4).open();
        }
        if (kernels.isEmpty()) {
            return kernels;
        }
        Set filterSet = graph.getKernels().stream().map(k -> k.getKernelInfo()).collect(Collectors.toSet());
        KernelDuplicateFilter duplicateFilter = new KernelDuplicateFilter(kernels, filterSet);
        duplicateFilter.prepareDuplicates();
        if (!duplicateFilter.getDuplicates().isEmpty()) {
            Set duplicates = duplicateFilter.getDuplicates().stream().map(k -> NLS.bind((String)"{0} ({1})", (Object)k.getName(), (Object)k.getSource().getCategory())).collect(Collectors.toSet());
            if (show) {
                ListDialogWithToggle dialogWithToggle = ListDialogWithToggle.openWarning((Shell)shell, (String)DesignMessages.CreateKernelAction_duplicates_found, (String)DesignMessages.CreateKernelAction_duplicates_warning_message, (String)DesignMessages.CreateKernelAction_do_not_show_message, (boolean)false, duplicates);
                boolean bl = show = !dialogWithToggle.getToggleState();
            }
        }
        if ((hiddenDuplicatesOnDiagram = duplicateFilter.findHiddenDuplicatesInFilter()) != null && !hiddenDuplicatesOnDiagram.isEmpty()) {
            Set hiddenKernelInfoNamesAndCategory = hiddenDuplicatesOnDiagram.stream().map(k -> NLS.bind((String)"{0} ({1})", (Object)k.getName(), (Object)k.getSource().getCategory())).collect(Collectors.toSet());
            ListDialogWithToggle dialogWithToggle = ListDialogWithToggle.openWithoutToggle((int)1, (Shell)shell, (String)DesignMessages.CreateKernelAction_kernel_loading_errors, (String)DesignMessages.CreateKernelAction_hidden_duplictes_found_on_diagram, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, hiddenKernelInfoNamesAndCategory);
            if (dialogWithToggle.getReturnCode() != 2) {
                return null;
            }
            List kernelsToRemove = graph.getKernels().stream().filter(k -> hiddenDuplicatesOnDiagram.stream().anyMatch(hk -> EmfResources.compareByAbsolutePath((EObject)k.getKernelInfo(), (EObject)hk))).collect(Collectors.toList());
            graph.getKernels().removeAll(kernelsToRemove);
        }
        if ((dialog = new KernelListFilteredSelectionDialog(shell, duplicateFilter.getFilteredList(), true)).open() != 0) {
            return null;
        }
        List<ApuKernelInfo> selected = Arrays.asList((ApuKernelInfo[])Arrays.copyOf(dialog.getResult(), dialog.getResult().length, ApuKernelInfo[].class));
        if (selected.size() > 100) {
            MessageDialog.openError((Shell)shell, (String)DesignMessages.CreateKernelAction_error, (String)NLS.bind((String)DesignMessages.CreateKernelAction_kernel_number_exceeded, (Object)100));
            return null;
        }
        return selected;
    }
}

