/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.design;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphPort;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apukernel.provider.ApuKernelEditPlugin;
import org.eclipse.emf.common.util.EList;

public class ApuGraphPropertiesService {
    private static String EMPTY_STRING = "";

    public String getKernelInformation(ApuKernel kernel) {
        return ApuGraphPropertiesService.formatKernelInformation(kernel.getKernelInfo());
    }

    public String getKernelInformation(ApuKernelPort port) {
        return this.getKernelInformation(port.getKernel());
    }

    private static String formatKernelInformation(ApuKernelInfo info) {
        return String.format("%s (%s)", info.getIdentifier(), info.getSource().getCategory());
    }

    public String getEKSizeXPortInformation(ApuKernelPort port) {
        return port == null ? EMPTY_STRING : port.getPortInfo().getPortElementsInfo().getEKSizeX();
    }

    public String getEKSizeYPortInformation(ApuKernelPort port) {
        return port == null ? EMPTY_STRING : port.getPortInfo().getPortElementsInfo().getEKSizeY();
    }

    public String getE0SizeXPortInformation(ApuKernelPort port) {
        return port == null ? EMPTY_STRING : port.getPortInfo().getPortElementsInfo().getE0SizeX();
    }

    public String getE0SizeYPortInformation(ApuKernelPort port) {
        return port == null ? EMPTY_STRING : port.getPortInfo().getPortElementsInfo().getE0SizeY();
    }

    public String getSourceElementType(ApuGraphSource source) {
        EList inputs = source.getKernelInputs();
        if (!inputs.isEmpty()) {
            return this.getKernelElementDataType((ApuKernelPort)inputs.get(0));
        }
        return EMPTY_STRING;
    }

    public String getSinkElementType(ApuGraphSink sink) {
        return this.getKernelElementDataType((ApuKernelPort)sink.getKernelOutput());
    }

    public String getGraphName(ApuGraphPort source) {
        ApuGraph graph = source.getGraph();
        if (graph != null) {
            return graph.getName();
        }
        return EMPTY_STRING;
    }

    public String getGraphSourceName(ApuKernelInput input) {
        ApuGraphSource source = input.getGraphSource();
        return source != null ? source.getName() : EMPTY_STRING;
    }

    public String getInputsOutputName(ApuKernelInput input) {
        ApuKernelOutput output = input.getKernelOutput();
        return output != null ? output.getName() : EMPTY_STRING;
    }

    public String getKernelOutput(ApuGraphSink sink) {
        return sink.getKernelOutput() == null ? EMPTY_STRING : String.format("%s.%s", sink.getKernelOutput().getKernel().getName(), sink.getKernelOutput().getName());
    }

    public String getKernelElementDataType(ApuKernelPort port) {
        ApuKernelPortInfo portInfo;
        if (port != null && (portInfo = port.getPortInfo()) != null) {
            return portInfo.getPortElementsInfo().getE0DataType().getName();
        }
        return EMPTY_STRING;
    }

    public String getKernelElementMemoryPart(ApuKernelPort port) {
        ApuKernelPortInfo portInfo = port.getPortInfo();
        if (portInfo != null) {
            return ApuGraphPropertiesService.getMemoryPartLabel(portInfo.getPortAttrbutesInfo().getMemoryPart());
        }
        return EMPTY_STRING;
    }

    private static String getMemoryPartLabel(ApuMemoryPart candidate) {
        if (candidate == ApuMemoryPart.ATTR_CMEM) {
            return ApuKernelEditPlugin.INSTANCE.getString("_UI_ApuMemoryPart_ATTR_CMEM_literal");
        }
        if (candidate == ApuMemoryPart.ATTR_DMEM) {
            return ApuKernelEditPlugin.INSTANCE.getString("_UI_ApuMemoryPart_ATTR_DMEM_literal");
        }
        return String.valueOf(candidate);
    }
}

