/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.design;

import com.nxp.s32ds.ext.emf.common.util.DiagnosticAttachment;
import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphPort;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuGraphs;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.vgt.ide.core.VgtDesignService;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.sirius.diagram.DNode;

public class ApuGraphDesignService
extends VgtDesignService {
    private static final int DEFAULT_KERNEL_HEIGHT = 10;
    private static final int DEFAULT_KERNEL_WIDTH = 15;
    private static final double MAX_PORTS_DEFAULT_SIZE_KERNEL = 4.0;

    public Boolean checkError(EObject object) {
        if (object instanceof ApuGraphSink || object instanceof ApuGraphSource || object instanceof ApuKernel || object instanceof ApuKernelInput || object instanceof ApuKernelInfo || object instanceof ApuKernelOutput || object instanceof ApuKernelPort) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(object);
            DiagnosticAttachment.attach((EObject)object, (Diagnostic)diagnostic);
            if (diagnostic.getSeverity() == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    public String createInputName(ApuGraphSource port) {
        EList sources = port.getGraph().getGraphSources();
        String pattern = "Input{0}";
        List list = sources.stream().map(ApuGraphPort::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public String createOutputName(ApuGraphSink port) {
        EList sinks = port.getGraph().getGraphSinks();
        String pattern = "Output{0}";
        List list = sinks.stream().map(ApuGraphPort::getName).collect(Collectors.toList());
        return ApuUsages.composeNextName(list, (String)pattern);
    }

    public void doNothing(ApuKernelPort kernelPort) {
    }

    public boolean isReconcileKernelEnabled(EObject obj) {
        return obj instanceof ApuKernel;
    }

    public boolean isConnectAllowed(EObject context, EObject presource, EObject pretarget) {
        if (presource instanceof ApuKernelOutput && pretarget instanceof ApuKernelInput) {
            return !((ApuKernelOutput)presource).getKernel().equals(((ApuKernelInput)pretarget).getKernel());
        }
        return true;
    }

    public boolean graphSourcesLimitIsNotExceeded(EObject container) {
        if (container instanceof ApuGraph) {
            return ((ApuGraph)container).getGraphSources().size() < 100;
        }
        return false;
    }

    public boolean graphSinksLimitIsNotExceeded(EObject container) {
        if (container instanceof ApuGraph) {
            return ((ApuGraph)container).getGraphSinks().size() < 100;
        }
        return false;
    }

    public boolean kernelsLimitIsNotExceeded(EObject container) {
        if (container instanceof ApuGraph) {
            return ((ApuGraph)container).getKernels().size() < 100;
        }
        return false;
    }

    public Integer increaseSizeIfNeeded(EObject eObject, DNode view) {
        ApuKernel kernel;
        int portsCount;
        int multiplier;
        if (!(eObject instanceof ApuKernel)) {
            return -1;
        }
        if (view.getHeight() == null) {
            view.setHeight(Integer.valueOf(10));
        }
        if (view.getWidth() == null) {
            view.setWidth(Integer.valueOf(15));
        }
        if ((multiplier = (int)Math.round((double)(portsCount = (kernel = (ApuKernel)eObject).getKernelInfo().getPortInfos().size()) / 4.0)) > 1) {
            view.setHeight(Integer.valueOf(10 * multiplier));
            view.setWidth(Integer.valueOf(15 * multiplier));
        }
        return -1;
    }

    public void update(EObject eObject) {
        ApuGraph graph = (ApuGraph)EObjects.eContainer((EObject)eObject, ApuGraph.class);
        if (graph != null) {
            ApuGraphs.update((ApuGraph)graph);
        }
    }
}

