/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apugraph.design;

import com.nxp.s32ds.ext.sirius.SiriusViewpoints;
import com.nxp.s32ds.gte.apugraph.ApuGraphPackage;
import com.nxp.s32ds.mdt.ide.core.adapters.UsagesNotificationAdapter;
import com.nxp.s32ds.mdt.ide.core.adapters.UsagesNotificationSessionManagerListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ApuGraphDesignActivator
implements BundleActivator {
    public static final String PLUGIN_ID = "com.nxp.s32ds.gte.apugraph.design";
    private static ApuGraphDesignActivator plugin;
    private static Set<Viewpoint> viewpoints;
    private static UsagesNotificationAdapter graphNotifyAdapter;
    private UsagesNotificationSessionManagerListener listener = new UsagesNotificationSessionManagerListener(ApuGraphDesignActivator.getGraphNotifyAdapter(), ApuGraphDesignActivator.createNotificationFilter(), filterOperations);
    private static List<String> filterOperations;

    static {
        filterOperations = Collections.unmodifiableList(Arrays.asList("ReconcileGraphAction"));
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        viewpoints = new HashSet<Viewpoint>();
        String designPath = "/$nl$/description/apugraph.odesign";
        Set registeredViewpoints = SiriusViewpoints.registerViewpoints((Bundle)context.getBundle(), (String)designPath);
        viewpoints.addAll(registeredViewpoints);
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this.listener);
    }

    public void stop(BundleContext context) throws Exception {
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this.listener);
        plugin = null;
        if (viewpoints != null) {
            for (Viewpoint viewpoint : viewpoints) {
                ViewpointRegistry.getInstance().disposeFromPlugin(viewpoint);
            }
            viewpoints.clear();
            viewpoints = null;
        }
    }

    public static ApuGraphDesignActivator getDefault() {
        return plugin;
    }

    private static UsagesNotificationAdapter getGraphNotifyAdapter() {
        if (graphNotifyAdapter == null) {
            EClass graphClass = ApuGraphPackage.eINSTANCE.getApuGraph();
            EClass graphSourceClass = ApuGraphPackage.eINSTANCE.getApuGraphSource();
            EClass graphSinkClass = ApuGraphPackage.eINSTANCE.getApuGraphSink();
            EClass graphKernelClass = ApuGraphPackage.eINSTANCE.getApuKernel();
            graphNotifyAdapter = new UsagesNotificationAdapter(Arrays.asList(graphClass, graphSourceClass, graphSinkClass, graphKernelClass));
            graphNotifyAdapter.recordFeature(graphClass.getEStructuralFeature(0)).recordFeature(graphClass.getEStructuralFeature(2)).recordFeature(graphClass.getEStructuralFeature(3)).recordFeature(graphClass.getEStructuralFeature(1)).recordFeature(graphSourceClass.getEStructuralFeature(0)).recordFeature(graphSinkClass.getEStructuralFeature(0)).recordFeature(graphKernelClass.getEStructuralFeature(0));
        }
        return graphNotifyAdapter;
    }

    private static NotificationFilter createNotificationFilter() {
        return NotificationFilter.ANY;
    }
}

