/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.npw.listeners;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeListener;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventParser;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangePayload;
import com.nxp.s32ds.cle.uct.internal.npw.UctMessages;
import com.nxp.s32ds.cle.uct.internal.npw.UctProjectParticipant;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class UctComponentChangeListener
implements ComponentChangeListener {
    private static final String SDK_UCT = "uctSdk";
    private static final String SDK_EXTERNAL_ID = "sdkExternalId";
    private static final String BUNDLE_ID = "com.nxp.s32ds.cle.uct.npw";
    private static final String MEX_FILE_EXT = "mex";
    private static final String CTSDK_DETACH_STATUSHANDLER_ID = "com.nxp.s32ds.cle.uct.status.handler.sdk.detach";

    public void onComponentChange(ComponentChangeEvent event) {
        block10: {
            String actionId;
            ComponentChangeEventParser eventParser;
            Map parameters = event.getParameters();
            if (parameters == null || !"com.nxp.s32ds.cle.ide.component.project".equals((eventParser = new ComponentChangeEventParser(event)).getArchetype()) || !"s32ds.project".equals(eventParser.getComponentId())) break block10;
            switch (actionId = eventParser.getActionId()) {
                case "s32ds.project.action.sdk.attach": {
                    this.executeSDKAttachAction(eventParser);
                    break;
                }
                case "s32ds.project.action.sdk.detach": {
                    this.executeSDKDetachAction(eventParser);
                    break;
                }
                default: {
                    String msg = NLS.bind((String)UctMessages.UCT_project_component_action_unsupported_error, (Object)actionId);
                    Status status = new Status(4, BUNDLE_ID, msg);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                }
            }
        }
    }

    private void executeSDKDetachAction(ComponentChangeEventParser eventParser) {
        ComponentChangePayload payload = eventParser.getPayload();
        Map payloadContext = payload.getParameters();
        if (payloadContext.containsKey("s32ds.project.sdk")) {
            Object componentSDK = payloadContext.get("s32ds.project.sdk");
            if (!(componentSDK instanceof ISDK)) {
                Status status = new Status(4, BUNDLE_ID, UctMessages.UCT_project_component_sdk_instance_error);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                return;
            }
            ISDK sdk = (ISDK)componentSDK;
            if (sdk.getTags().contains("uct") && payloadContext.containsKey("s32ds.project")) {
                Object componentProject = payloadContext.get("s32ds.project");
                if (!(componentProject instanceof IProject)) {
                    Status status = new Status(4, BUNDLE_ID, UctMessages.UCT_project_component_project_instance_error);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                    return;
                }
                try {
                    IResource[] members = ((IProject)componentProject).members();
                    Optional<IResource> mexResource = Stream.of(members).filter(p -> MEX_FILE_EXT.equals(p.getFileExtension())).findAny();
                    if (mexResource.isPresent()) {
                        Status status = new Status(1, BUNDLE_ID, UctMessages.UCT_remove_resource_request);
                        RcpStatusHandlers.handleStatus((String)CTSDK_DETACH_STATUSHANDLER_ID, (IStatus)status, (Object)mexResource.get());
                    }
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
        }
    }

    private void executeSDKAttachAction(ComponentChangeEventParser eventParser) {
        ComponentChangePayload payload = eventParser.getPayload();
        Map payloadContext = payload.getParameters();
        if (payloadContext.containsKey("s32ds.project.sdk")) {
            Object componentSDK = payloadContext.get("s32ds.project.sdk");
            if (!(componentSDK instanceof ISDK)) {
                Status status = new Status(4, BUNDLE_ID, UctMessages.UCT_project_component_sdk_instance_error);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                return;
            }
            ISDK sdk = (ISDK)componentSDK;
            if (sdk.getTags().contains("uct") && payloadContext.containsKey("s32ds.project")) {
                Object componentProject = payloadContext.get("s32ds.project");
                if (!(componentProject instanceof IProject)) {
                    Status status = new Status(4, BUNDLE_ID, UctMessages.UCT_project_component_project_instance_error);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                    return;
                }
                IProject project = (IProject)componentProject;
                ProjectContextSaver projectSettigs = new ProjectContextSaver(project);
                Map projectContext = projectSettigs.getProjectContext();
                if (projectContext == null) {
                    String msg = NLS.bind((String)UctMessages.UCT_project_context_load_error, (Object)project.getName());
                    Status status = new Status(4, BUNDLE_ID, msg);
                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                    return;
                }
                projectContext.put(SDK_UCT, SDKSupportPlugin.getEclipsePath((ISDK)sdk).toOSString());
                projectContext.put(SDK_EXTERNAL_ID, sdk.getExternalId());
                UctProjectParticipant participant = new UctProjectParticipant();
                IWorkspaceRunnable participate = participant.participate(projectContext, project);
                try {
                    participate.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
        }
    }
}

