/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.internal.npw;

import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.context.ExecutableContext;
import com.freescale.s32ds.cross.core.model.context.LibraryContext;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.sdk.SDKContextUtil;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.uct.core.UctDescriptors;
import com.nxp.s32ds.cle.uct.internal.npw.UctMessages;
import com.nxp.s32ds.cle.uct.internal.npw.UctProjectParameterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class UctParameterHandler
extends DefaultParameterHandler {
    private static final String LANG_C = "c";

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        ChangeResult onInit = super.onInit(tag, newValue, context);
        return onInit;
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        ArrayList uctSpecificSdks = new ArrayList();
        ChangeResult onEdit = super.onEdit(tag, newValue, context);
        CProjectContext cprojectContext = (CProjectContext)context;
        CoreNatureData coreData = cprojectContext.getConfiguration().getCoreNature();
        String langParam = cprojectContext.getStringValue("language");
        String deviceId = cprojectContext.getProcessor().getDevice();
        DeviceCoreDescriptor descriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)coreData.getCoreNatureId());
        if (descriptor == null) {
            return onEdit;
        }
        HashMap attachedSdksByTags = SDKContextUtil.getSdksGroupByTags((CProjectContext)cprojectContext);
        if (attachedSdksByTags == null) {
            attachedSdksByTags = new HashMap();
        }
        if (attachedSdksByTags.containsKey("uct")) {
            uctSpecificSdks.addAll((Collection)attachedSdksByTags.get("uct"));
        }
        Boolean isEnable = Boolean.FALSE;
        if (newValue instanceof Boolean) {
            isEnable = (Boolean)newValue;
        }
        if (UctDescriptors.checkRestrictionByDeviceCore((String)deviceId, (String)descriptor.getCoreId())) {
            if (LANG_C.equals(langParam)) {
                if (cprojectContext instanceof ExecutableContext) {
                    if (isEnable == Boolean.FALSE && !uctSpecificSdks.isEmpty()) {
                        return new ChangeResult(false, UctMessages.UCT_disable_message_error);
                    }
                    if (isEnable == Boolean.TRUE && uctSpecificSdks.isEmpty()) {
                        return new ChangeResult(false, UctMessages.UCT_enable_message_error);
                    }
                }
                if (cprojectContext instanceof LibraryContext) {
                    ArrayList<ContextChange> changeContext = new ArrayList<ContextChange>();
                    changeContext.add(UctProjectParameterUtil.modifyLangSupport((AbstractContext)cprojectContext, isEnable));
                    return new ChangeResult(changeContext);
                }
            } else {
                return new ChangeResult(false, UctMessages.UCT_lang_message_error);
            }
        }
        return onEdit;
    }
}

