/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.debugger.gdb;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class GDBHardwareDebuggingLaunchConfigurationSupport
implements LaunchConfigurationCreator {
    public static final String BUNDLE_ID = "com.nxp.s32ds.cle.cdt.debugger.gdb";
    private static final String DEBUGGER_ID = "gdb";
    private static final String JTAG_LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.cdt.debug.gdbjtag.launchConfigurationType";
    private static final String ATTR_GDB_JTAG_DEVICE = "org.eclipse.cdt.debug.gdbjtag.core.jtagDevice";
    private static final String ATTR_GDB_JTAG_IP_ADDRESS = "org.eclipse.cdt.debug.gdbjtag.core.ipAddress";
    private static final String ATTR_GDB_JTAG_PORT_NUMBER = "org.eclipse.cdt.debug.gdbjtag.core.portNumber";
    private static final String ATTR_DSF_GDB_DEBUG_NAME = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final int SERVER_DEFAULT_PORT = 10000;

    private int getGDBServerPort(String coreId) {
        DeviceCoreDescriptor descriptor = DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptor(coreId);
        String debuggerId = DEBUGGER_ID;
        String serverPort = "";
        if (descriptor != null) {
            serverPort = DeviceCoreDebuggerDescriptors.getServerPort((String)descriptor.getId(), (String)debuggerId);
        }
        if (serverPort.isEmpty()) {
            return 10000;
        }
        return Integer.valueOf(serverPort);
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        IResource launchResource;
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(JTAG_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debugerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        workingCopy = debugerLaunchType.newInstance((IContainer)container, component);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", String.valueOf(component) + ".elf");
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workConfig, Map<String, Object> attributes) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        String coreId = LaunchConfigurationUtil.extractHardwareCoreId(attributes);
        workConfig.setContainer((IContainer)project);
        workConfig.setMappedResources(new IResource[]{project});
        workConfig.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workConfig.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", component);
        workConfig.setAttribute(ATTR_DSF_GDB_DEBUG_NAME, LaunchConfigurationUtil.getGDBClientValue((String)coreId, (String)DEBUGGER_ID));
        workConfig.setAttribute(ATTR_GDB_JTAG_PORT_NUMBER, this.getGDBServerPort(coreId));
        workConfig.setAttribute(ATTR_GDB_JTAG_DEVICE, "Generic TCP/IP");
        workConfig.setAttribute(ATTR_GDB_JTAG_IP_ADDRESS, "localhost");
    }
}

