/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.example.internal.registry.core.ExampleProjectFacade;
import com.nxp.s32ds.cle.ide.example.internal.registry.core.ExampleRegistryActivator;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesSelectionPage;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.Messages;
import com.nxp.s32ds.ext.ide.core.refactoring.RenameRefactorService;
import com.nxp.s32ds.ext.ide.ui.refactoring.RenameHelper;
import com.nxp.s32ds.ext.ide.ui.refactoring.RenameOperationContext;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ExamplesWizard
extends Wizard
implements IShellProvider,
INewWizard {
    private static final String PLUGIN_ID = "com.nxp.s32ds.cle.ide.ui";
    private static final String PROCESSOR_EXPERT_FILE = "ProcessorExpert.pe";
    private static final String PE_JOB_TITLE = "Open Processor Expert file";
    private static final String UPDATE_SELECTION_JOB_TITLE = "Selecting project";
    List<IValidator> pathValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.validators");
    List<IValidator> nameValidators = ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators");
    private final CompositeValidator compositeNameValidator = new CompositeValidator(this.nameValidators);
    private final CompositeValidator compositePathValidatior = new CompositeValidator(this.pathValidators);
    ExampleProjectFacade exampleFacade = new ExampleProjectFacade(ExampleRegistryActivator.getDefault().getExampleRegistry());
    ExamplesSelectionPage selectionPage = new ExamplesSelectionPage(this.exampleFacade){

        @Override
        protected IStatus validate() {
            if (ExamplesWizard.this.selectionPage.isFolder()) {
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", Messages.Folder_selection_message);
            }
            if (this.getProjectSet() == null) {
                return ValidationStatus.ok();
            }
            IStatus nameStatus = ExamplesWizard.this.compositeNameValidator.validate((Object)this.getName());
            if (!nameStatus.isOK()) {
                return nameStatus;
            }
            String path = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + File.separator;
            path = String.valueOf(path) + this.getName() + File.separator;
            IStatus status = ExamplesWizard.this.compositePathValidatior.validate((Object)path);
            if (!status.isOK()) {
                return status;
            }
            if (this.getProjectSet().getProjects().count() > 1L) {
                for (IProjectDescription project : this.getProjectSet().getProjects().collect(Collectors.toList())) {
                    String nameToCheck = project.getName().startsWith(this.getProjectSet().getName()) ? project.getName().replaceFirst(this.getProjectSet().getName(), this.getName()) : project.getName();
                    status = ExamplesWizard.this.compositeNameValidator.validate((Object)nameToCheck);
                    if (status.isOK()) {
                        status = ExamplesWizard.this.compositePathValidatior.validate((Object)(String.valueOf(path) + nameToCheck));
                    }
                    if (status.isOK()) continue;
                    return status;
                }
            }
            return ValidationStatus.ok();
        }
    };

    public ExamplesWizard() {
        this.setHelpAvailable(false);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.selectionPage);
    }

    public boolean canFinish() {
        if (!this.selectionPage.validate().isOK()) {
            return false;
        }
        return this.selectionPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            final RenameOperationContext renameContext = new RenameOperationContext(this.selectionPage.getName(), this.selectionPage.getProjectSet(), RenameRefactorService.getImportRefactoringParticipants());
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor arg0) throws CoreException, InvocationTargetException, InterruptedException {
                                final List projectsPerfomed = RenameHelper.performRename((IProgressMonitor)monitor, (RenameOperationContext)renameContext);
                                for (final IProject itr : projectsPerfomed) {
                                    UIJob openPeFile = new UIJob(ExamplesWizard.PE_JOB_TITLE){

                                        public IStatus runInUIThread(IProgressMonitor ipm) {
                                            IFile file = itr.getFile(ExamplesWizard.PROCESSOR_EXPERT_FILE);
                                            if (file != null && file.exists()) {
                                                try {
                                                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                                                }
                                                catch (PartInitException e) {
                                                    Status status = new Status(4, ExamplesWizard.PLUGIN_ID, e.getMessage(), (Throwable)e);
                                                    ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                                                }
                                            }
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    openPeFile.schedule();
                                }
                                UIJob selectProject = new UIJob(ExamplesWizard.UPDATE_SELECTION_JOB_TITLE){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        if (!projectsPerfomed.isEmpty()) {
                                            IProject projectToSelect = (IProject)projectsPerfomed.get(0);
                                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                            BasicNewResourceWizard.selectAndReveal((IResource)projectToSelect, (IWorkbenchWindow)window);
                                        }
                                        return Status.OK_STATUS;
                                    }
                                };
                                selectProject.schedule();
                            }
                        }.run(monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Status status = new Status(4, PLUGIN_ID, 1, t.getLocalizedMessage(), t);
            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, (String)message, (IStatus)status);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.Wizard_title);
    }
}

