/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.example.internal.registry.core.ExampleProjectFacade;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExampleLabelProvider;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesContentProvider;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesFilter;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesTreeViewListener;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.Messages;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.IExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IVisualComponent;
import java.util.ArrayList;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class ExamplesViewer {
    private TreeViewer treeView;
    private ExamplesFilter filter;
    private boolean folderSelected = false;
    private Composite composite;

    public ExamplesViewer(Composite parent, ExampleProjectFacade projetFacade) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, true, 1, 1);
        layoutData.heightHint = 500;
        layoutData.widthHint = 800;
        parent.setLayoutData((Object)layoutData);
        Label lblText = new Label(this.composite, 0);
        lblText.setText(Messages.Project_name);
        GridData gdlblText = new GridData(4, 4, false, false, 1, 1);
        gdlblText.heightHint = 20;
        lblText.setLayoutData((Object)gdlblText);
        Text name = new Text(this.composite, 526336);
        name.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        name.setEditable(false);
        name.addModifyListener(e -> this.nameChanged(name.getText()));
        GridData gdFilter = new GridData(4, 4, true, false, 2, 1);
        gdFilter.heightHint = 15;
        final Text searchField = new Text(this.composite, 2048);
        searchField.setLayoutData((Object)gdFilter);
        searchField.setMessage(Messages.Enter_search_text);
        searchField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                ExamplesViewer.this.filter.setSearchText(searchField.getText());
                ExamplesViewer.this.treeView.refresh();
                ExamplesViewer.this.treeView.expandAll();
            }
        });
        SashForm center = new SashForm(this.composite, 256);
        GridData ldCenter = new GridData(4, 4, true, true, 2, 1);
        center.setLayoutData((Object)ldCenter);
        Composite topPart = this.createComoposite((Composite)center);
        Composite bottomPart = this.createComoposite((Composite)center);
        Label lblTile = new Label(topPart, 0);
        lblTile.setText(Messages.Examples);
        this.treeView = new TreeViewer(topPart, 67584);
        this.treeView.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeView.setContentProvider((IContentProvider)new ExamplesContentProvider());
        this.treeView.setLabelProvider((IBaseLabelProvider)new ExampleLabelProvider());
        this.treeView.setInput((Object)projetFacade.convertToTreeVisualComponents());
        Label lblDecription = new Label(bottomPart, 0);
        lblDecription.setText(Messages.Description);
        StyledText description = new StyledText(bottomPart, 2882);
        description.setAlwaysShowScrollBars(false);
        description.setEditable(false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)description);
        this.treeView.addSelectionChangedListener(e -> {
            Object selection = ExamplesViewer.getSelection(e.getSelection());
            if (selection instanceof IExampleObject) {
                this.folderSelected = false;
                IExampleObject exampleObject = (IExampleObject)selection;
                IExampleComponent modelingComponent = exampleObject.getModelingComponent();
                description.setText(modelingComponent.getDescription() == null ? "" : modelingComponent.getDescription());
                if (exampleObject.hasChilds()) {
                    IPath location = new Path(modelingComponent.getLocation()).removeLastSegments(2);
                    ArrayList<IProjectDescription> projectList = new ArrayList<IProjectDescription>();
                    projectList.addAll(exampleObject.getRelatedProjectsObjects());
                    projectList.add(exampleObject.getProjectObject());
                    ProjectSet projects = new ProjectSet(modelingComponent.getID(), modelingComponent.getDescription(), location, projectList);
                    this.projectSelected(projects);
                } else {
                    this.projectSelected(new ProjectSet(exampleObject.getProjectObject()));
                }
                name.setText(modelingComponent.getID() == null ? "" : modelingComponent.getID());
                name.setEditable(true);
            }
            if (selection instanceof IVisualComponent) {
                this.folderSelected = true;
                description.setText("");
                name.setEditable(false);
                name.setText("");
                this.folderSelected();
                return;
            }
        });
        ExamplesTreeViewListener treeListener = new ExamplesTreeViewListener(this.treeView.getTree());
        this.treeView.getTree().addListener(16, (Listener)treeListener);
        this.treeView.getTree().addListener(12, (Listener)treeListener);
        this.treeView.getTree().addListener(1, (Listener)treeListener);
        this.treeView.getTree().addListener(5, (Listener)treeListener);
        this.treeView.getTree().addListener(32, (Listener)treeListener);
        this.filter = new ExamplesFilter();
        this.treeView.setFilters(new ViewerFilter[]{this.filter});
        this.treeView.expandAll();
        searchField.setFocus();
    }

    private Composite createComoposite(Composite cmps) {
        return new Composite(cmps, 2048){
            {
                this.setLayout((Layout)new GridLayout(1, false));
            }
        };
    }

    public TreeViewer getTreeView() {
        return this.treeView;
    }

    protected abstract void projectSelected(ProjectSet var1);

    protected abstract void nameChanged(String var1);

    protected abstract void folderSelected();

    private static Object getSelection(ISelection selection) {
        return selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
    }

    public boolean isFolderSelected() {
        return this.folderSelected;
    }

    public Control getControl() {
        return this.composite;
    }
}

