/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.example.internal.registry.core.ExampleProjectFacade;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesViewer;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.Messages;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.ValidationExampleUtil;
import java.io.File;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public abstract class ExamplesSelectionPage
extends WizardPage {
    private static final String PLUGIN_ID = "com.nxp.s32ds.cle.ide.ui";
    private static final String HELP_CONTEXT_ID = ".import_example_project_context";
    private final ExampleProjectFacade projectFacade;
    private ExamplesViewer composite;
    private ProjectSet projectSet = null;
    private String name = "";
    private Object pathToValidate;
    private boolean isFolder = false;

    public boolean isFolder() {
        return this.isFolder;
    }

    protected ExamplesSelectionPage(ExampleProjectFacade projectFacade) {
        super("Select project");
        this.projectFacade = projectFacade;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.Wizard_page_title);
        this.composite = new ExamplesViewer(parent, this.projectFacade){

            @Override
            protected void projectSelected(ProjectSet project) {
                ExamplesSelectionPage.this.projectSet = project;
                this.updateStatus();
            }

            private boolean updateStatus() {
                ExamplesSelectionPage.this.isFolder = ExamplesSelectionPage.this.composite.isFolderSelected();
                IStatus status = ExamplesSelectionPage.this.validate();
                ExamplesSelectionPage.this.setPageComplete(status.isOK());
                ExamplesSelectionPage.this.setErrorMessage(status.isOK() || status.getSeverity() == 8 ? null : status.getMessage());
                return status.isOK();
            }

            @Override
            protected void nameChanged(String name) {
                ExamplesSelectionPage.this.name = name;
                if (ExamplesSelectionPage.this.projectSet != null) {
                    if (ExamplesSelectionPage.this.projectSet.getProjects().count() == 1L) {
                        ExamplesSelectionPage.this.pathToValidate = name;
                        this.updateStatus();
                    } else {
                        for (IProjectDescription description : ExamplesSelectionPage.this.projectSet.getProjects().collect(Collectors.toList())) {
                            ExamplesSelectionPage.this.pathToValidate = (Path)ValidationExampleUtil.calculateExamplePath((IPath)new Path(String.valueOf(ExamplesSelectionPage.this.projectSet.getName()) + File.separator + description.getName()), (String)ExamplesSelectionPage.this.projectSet.getName(), (String)name);
                            if (!this.updateStatus()) break;
                        }
                    }
                }
            }

            @Override
            protected void folderSelected() {
                this.updateStatus();
            }
        };
        this.setControl(this.composite.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.composite.getControl(), "com.nxp.s32ds.cle.ide.ui.import_example_project_context");
        this.setPageComplete(false);
    }

    public void dispose() {
        this.getControl().dispose();
        super.dispose();
    }

    public ProjectSet getProjectSet() {
        return this.projectSet;
    }

    public String getName() {
        return this.name;
    }

    protected abstract IStatus validate();

    public Object getPathToValidate() {
        return this.pathToValidate;
    }
}

