/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerContributor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerContributor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.CoreDebuggerDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.DeviceCoreDebuggerDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.DeviceDebuggerDescriptorImplementation;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class HardwareDebuggerCoreActivator
implements BundleActivator {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.cle.runtime.hardware.debugger.core";
    public static final String CONTRIBUTOR_ELEMENT = "contributor";
    public static final String CONTRIBUTOR_CLASS_ATTRIBUTE = "class";
    public static final String CORES_EXTENSION_POINT = "cores";
    public static final String CORE_DEBUGER_ELEMENT = "coreDebugger";
    public static final String CORE_DEBUGER_CORE_ID_ATTRIBUTE = "coreId";
    public static final String CORE_DEBUGER_DEBUGER_ID_ATTRIBUTE = "debuggerId";
    public static final String CORE_DEBUGER_CLIENT_PATH_ATTRIBUTE = "clientPath";
    public static final String CORE_DEBUGER_CORE_PORT_ATTRIBUTE = "port";
    public static final String DEVICES_EXTENSION_POINT = "devices";
    public static final String DEVICE_DEBUGER_ELEMENT = "deviceDebugger";
    public static final String DEVICE_DEBUGER_DEVICE_ID_ATTRIBUTE = "deviceId";
    public static final String DEVICE_DEBUGER_DEBUGER_ID_ATTRIBUTE = "debuggerId";
    public static final String DEVICE_DEBUGER_INITIALIZATION_SCRIPT_PATH_ATTRIBUTE = "initializationScriptPath";
    public static final String DEVICECORES_EXTENSION_POINT = "deviceCores";
    public static final String DEVICECORES_DEBUGER_ELEMENT = "deviceCoreDebugger";
    public static final String DEVICECORES_EXTENSION_POINT_DEBUGER_ID_ELEMENT = "debuggerId";
    public static final String DEVICECORES_EXTENSION_POINT_DEVICECORE_ID_ELEMENT = "deviceCoreId";
    public static final String DEVICECORES_EXTENSION_POINT_SERVER_PORT_ELEMENT = "serverPort";
    public static final String DEVICECORES_EXTENSION_POINT_INIT_SCRIPT_ELEMENT = "initializationScriptPath";
    private static HardwareDebuggerCoreActivator activator;
    private static BundleContext context;
    private ServiceTracker<CoreDebuggerRegistry, CoreDebuggerRegistry> coreDebuggerRegistryServiceTracker;
    private CoreDebuggerRegistry coreDebuggerRegistryService;
    private ServiceTracker<DeviceDebuggerRegistry, DeviceDebuggerRegistry> deviceDebuggerRegistryServiceTracker;
    private DeviceDebuggerRegistry deviceDebuggerRegistryService;
    private ServiceTracker<DeviceCoreDebuggerRegistry, DeviceCoreDebuggerRegistry> deviceCoresDebuggerRegistryServiceTracker;
    private DeviceCoreDebuggerRegistry deviceCoresDebuggerRegistryService;

    public static HardwareDebuggerCoreActivator getDefault() {
        return activator;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        activator = this;
        String coreRegistryClassName = CoreDebuggerRegistry.class.getName();
        this.coreDebuggerRegistryServiceTracker = new ServiceTracker(context, coreRegistryClassName, null);
        this.coreDebuggerRegistryServiceTracker.open();
        this.coreDebuggerRegistryService = (CoreDebuggerRegistry)this.coreDebuggerRegistryServiceTracker.getService();
        String deviceRegistryClassName = DeviceDebuggerRegistry.class.getName();
        this.deviceDebuggerRegistryServiceTracker = new ServiceTracker(context, deviceRegistryClassName, null);
        this.deviceDebuggerRegistryServiceTracker.open();
        this.deviceDebuggerRegistryService = (DeviceDebuggerRegistry)this.deviceDebuggerRegistryServiceTracker.getService();
        String deviceCoresRegistryClassName = DeviceCoreDebuggerRegistry.class.getName();
        this.deviceCoresDebuggerRegistryServiceTracker = new ServiceTracker(context, deviceCoresRegistryClassName, null);
        this.deviceCoresDebuggerRegistryServiceTracker.open();
        this.deviceCoresDebuggerRegistryService = (DeviceCoreDebuggerRegistry)this.deviceCoresDebuggerRegistryServiceTracker.getService();
        this.registerCores(this.coreDebuggerRegistryService);
        this.registerDevices(this.deviceDebuggerRegistryService);
        this.registerDeviceCores(this.deviceCoresDebuggerRegistryService);
    }

    private void registerDeviceCores(DeviceCoreDebuggerRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = DEVICECORES_EXTENSION_POINT;
        String deviceCoreDebugger = DEVICECORES_DEBUGER_ELEMENT;
        String deviceCoreId = DEVICECORES_EXTENSION_POINT_DEVICECORE_ID_ELEMENT;
        String debuggerId = "debuggerId";
        List deviceCoreDebuggerElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)deviceCoreDebugger, (String[])new String[]{deviceCoreId, debuggerId});
        for (IConfigurationElement element : deviceCoreDebuggerElements) {
            DeviceCoreDebuggerDescriptorImplementation reference = new DeviceCoreDebuggerDescriptorImplementation(element);
            registry.addDeviceCoreDebuggerDescriptor((DeviceCoreDebuggerDescriptor)reference);
        }
    }

    private void registerCores(CoreDebuggerRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = CORES_EXTENSION_POINT;
        String coreDebugger = CORE_DEBUGER_ELEMENT;
        String coreId = CORE_DEBUGER_CORE_ID_ATTRIBUTE;
        String debuggerId = "debuggerId";
        List familyDeviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)coreDebugger, (String[])new String[]{coreId, debuggerId});
        for (IConfigurationElement element : familyDeviceElements) {
            CoreDebuggerDescriptorImplementation reference = new CoreDebuggerDescriptorImplementation(element);
            registry.addCoreDebuggerDescriptor((CoreDebuggerDescriptor)reference);
        }
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<CoreDebuggerContributor> clazz = CoreDebuggerContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (CoreDebuggerContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    private void registerDevices(DeviceDebuggerRegistry registry) {
        String ns = BUNDLE_SYMBOLIC_NAME;
        String ep = DEVICES_EXTENSION_POINT;
        String deviceDebugger = DEVICE_DEBUGER_ELEMENT;
        String deviceCoreId = DEVICE_DEBUGER_DEVICE_ID_ATTRIBUTE;
        String debuggerId = "debuggerId";
        List familyDeviceElements = Extensions.getConfigrationElements((String)ns, (String)ep, (String)deviceDebugger, (String[])new String[]{deviceCoreId, debuggerId});
        for (IConfigurationElement element : familyDeviceElements) {
            DeviceDebuggerDescriptorImplementation reference = new DeviceDebuggerDescriptorImplementation(element);
            registry.addDeviceDebuggerDescriptor((DeviceDebuggerDescriptor)reference);
        }
        String contributor = CONTRIBUTOR_ELEMENT;
        String attribute = CONTRIBUTOR_CLASS_ATTRIBUTE;
        Class<DeviceDebuggerContributor> clazz = DeviceDebuggerContributor.class;
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)contributor, (String)attribute, clazz);
        for (DeviceDebuggerContributor executable : executables) {
            executable.contribute(registry);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.coreDebuggerRegistryServiceTracker.close();
        this.coreDebuggerRegistryServiceTracker = null;
        this.coreDebuggerRegistryService = null;
        this.deviceDebuggerRegistryServiceTracker.close();
        this.deviceDebuggerRegistryServiceTracker = null;
        this.deviceDebuggerRegistryService = null;
        this.deviceCoresDebuggerRegistryServiceTracker.close();
        this.deviceCoresDebuggerRegistryServiceTracker = null;
        this.deviceCoresDebuggerRegistryService = null;
        activator = null;
        context = null;
    }

    public CoreDebuggerRegistry getCoreDebuggerRegistry() {
        return this.coreDebuggerRegistryService;
    }

    public DeviceDebuggerRegistry getDeviceDebuggerRegistry() {
        return this.deviceDebuggerRegistryService;
    }

    public DeviceCoreDebuggerRegistry getDeviceCoresDebuggerRegistry() {
        return this.deviceCoresDebuggerRegistryService;
    }
}

