/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.debugger.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.CoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerRegistry;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.HardwareDebuggerCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeviceCoreDebuggerDescriptors {
    public static DeviceCoreDebuggerRegistry getDeviceCoreDebuggerRegistry() {
        DeviceCoreDebuggerRegistry deviceCoresRegistry = HardwareDebuggerCoreActivator.getDefault().getDeviceCoresDebuggerRegistry();
        return deviceCoresRegistry;
    }

    public static String getInitScript(String deviceCoreId, String debuggerId) {
        List debuggerDescriptors = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getDeviceCoreDebuggerDescriptorsByDeviceCoreId(deviceCoreId);
        for (DeviceCoreDebuggerDescriptor debugerDescriptor : debuggerDescriptors) {
            if (!debugerDescriptor.getDebuggerId().equals(debuggerId)) continue;
            return debugerDescriptor.getInitScript();
        }
        return "";
    }

    public static String getServerPort(String deviceCoreId, String debuggerId) {
        DeviceCoreDebuggerRegistry registry = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry();
        List descriptors = registry.getDeviceCoreDebuggerDescriptorsByDebuggerId(debuggerId);
        DeviceCoreDebuggerDescriptor descriptor = null;
        for (DeviceCoreDebuggerDescriptor iter : descriptors) {
            if (!iter.getDeviceCoreId().equals(deviceCoreId)) continue;
            descriptor = iter;
            break;
        }
        if (descriptor == null) {
            return "";
        }
        String serverPort = descriptor.getServerPort();
        if (serverPort == null) {
            return "";
        }
        return serverPort;
    }

    public static List<DeviceCoreDebuggerDescriptor> getDeviceCoreDebuggerDescriptorById(String debuggerId) {
        return DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerRegistry().getDeviceCoreDebuggerDescriptorsByDebuggerId(debuggerId);
    }

    public static List<DeviceCoreDescriptor> getDeviceCoreDescriptors(String debuggerId) {
        ArrayList<DeviceCoreDescriptor> result = new ArrayList<DeviceCoreDescriptor>();
        HardwareDebuggerCoreActivator activator = HardwareDebuggerCoreActivator.getDefault();
        CoreDebuggerRegistry coreDebuggerRegistry = activator.getCoreDebuggerRegistry();
        HashSet<String> coreIds = new HashSet<String>();
        List coreDebuggerDescriptors = coreDebuggerRegistry.getCoreDebuggerDescriptorsByDebuggerId(debuggerId);
        for (CoreDebuggerDescriptor coreDebuggerDescriptor : coreDebuggerDescriptors) {
            String coreId = coreDebuggerDescriptor.getCoreId();
            coreIds.add(coreId);
        }
        DeviceDebuggerRegistry deviceDebuggerRegistry = activator.getDeviceDebuggerRegistry();
        List deviceDebuggerDescriptors = deviceDebuggerRegistry.getDeviceDebuggerDescriptorsByDebuggerId(debuggerId);
        for (DeviceDebuggerDescriptor deviceDebuggerDescriptor : deviceDebuggerDescriptors) {
            String deviceId = deviceDebuggerDescriptor.getDeviceId();
            List deviceCoreDescriptors = DeviceDescriptors.getDeviceRegistry().getDeviceCoreDescriptorsByDeviceId(deviceId);
            result.addAll(deviceCoreDescriptors);
        }
        return result;
    }
}

