/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.lang.intrernal.registry.core;

import com.nxp.s32ds.cle.runtime.lang.intrernal.registry.core.LangDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.lang.registry.LangContributor;
import com.nxp.s32ds.cle.runtime.lang.registry.LangRegistry;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class LangRegistryCoreActivator
implements BundleActivator {
    private static LangRegistryCoreActivator activator;
    private static BundleContext context;
    private ServiceTracker<LangRegistry, LangRegistry> langRegistryServiceTracker;
    private LangRegistry langRegistryService;

    public static LangRegistryCoreActivator getDefault() {
        return activator;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        activator = this;
        String langRegistryClassName = LangRegistry.class.getName();
        this.langRegistryServiceTracker = new ServiceTracker(context, langRegistryClassName, null);
        this.langRegistryServiceTracker.open();
        this.langRegistryService = (LangRegistry)this.langRegistryServiceTracker.getService();
        if (this.langRegistryService != null) {
            this.registerLangs(this.langRegistryService);
        }
    }

    private void registerLangs(LangRegistry registry) {
        String ns = "com.nxp.s32ds.cle.runtime.lang.registry.core";
        String ep = "langs";
        Extensions.getConfigrationElements((String)ns, (String)ep, (String)"lang", (String[])new String[0]).stream().map(LangDescriptorImplementation::new).forEach(arg_0 -> ((LangRegistry)registry).addLangDescriptor(arg_0));
        List executables = Extensions.createSimpleExecutableExtensions((String)ns, (String)ep, (String)"contributor", (String)"class", LangContributor.class);
        executables.forEach(executable -> executable.contribute(registry));
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.langRegistryServiceTracker.close();
        this.langRegistryServiceTracker = null;
        this.langRegistryService = null;
        activator = null;
        context = null;
    }

    public LangRegistry getLangRegistry() {
        return this.langRegistryService;
    }

    public static IStatus log(IStatus status) {
        Platform.getLog((Bundle)context.getBundle()).log(status);
        return status;
    }

    public static void logInfo(String message) {
        LangRegistryCoreActivator.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
    }

    public static void logWarning(String message) {
        LangRegistryCoreActivator.log((IStatus)new Status(2, context.getBundle().getSymbolicName(), message));
    }

    public static void logError(String message) {
        LangRegistryCoreActivator.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message));
    }
}

