/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.core.vsdk;

import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariableListener;
import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.mdt.ide.core.vsdk.MdtVsdkHelperListener;
import com.nxp.s32ds.mdt.ide.internal.core.MdtIdeCoreActivator;
import com.nxp.s32ds.mdt.ide.internal.core.vsdk.Messages;
import com.nxp.s32ds.mdt.ide.internal.core.vsdk.VsdkHelperVariableListener;
import java.nio.file.Path;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;

public abstract class MdtVsdkHelper {
    private static final String VSDK_PROPERTIES_FILE_NAME = "vsdk.properties";
    protected final RcpVariableListener listener;
    protected volatile boolean changed = true;
    protected ListenerList<MdtVsdkHelperListener> listenerList = new ListenerList(1);

    public MdtVsdkHelper() {
        this.listener = new VsdkHelperVariableListener(this);
        this.addListener(() -> {
            boolean bl = this.changed = true;
        });
    }

    public abstract RcpVariable getVsdkVariable();

    public abstract String getVsdkPathVariable();

    public abstract RcpVariable getVsdkExtVariable();

    public Path getVsdkPropertiesFilePath() throws CoreException {
        return RcpVariables.INSTANCE.getPath(this.getVsdkExtVariable()).resolve(VSDK_PROPERTIES_FILE_NAME);
    }

    public void addListener(MdtVsdkHelperListener listener) {
        this.listenerList.add((Object)listener);
    }

    public void removeListener(MdtVsdkHelperListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void notifyChanged() {
        for (MdtVsdkHelperListener vsdkHelperListener : this.listenerList) {
            try {
                vsdkHelperListener.vsdkChanged();
            }
            catch (Exception e) {
                MdtIdeCoreActivator.getInstance().logError(Messages.VsdkHelperBase_error_during_listener_call, e);
            }
        }
    }

    protected abstract void cleanup();

    protected abstract void initializeValues() throws CoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init() {
        if (this.changed) {
            MdtVsdkHelper mdtVsdkHelper = this;
            synchronized (mdtVsdkHelper) {
                if (this.changed) {
                    this.cleanup();
                    try {
                        this.initializeValues();
                    }
                    catch (CoreException e) {
                        MdtIdeCoreActivator.getInstance().logError(Messages.VsdkHelperBase_cannot_intialize_vsdk_support, e);
                    }
                    this.changed = false;
                }
            }
        }
    }
}

