/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.core.vsdk;

import com.nxp.s32ds.mdt.ide.internal.core.MdtIdeCoreActivator;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class EmitterProperties {
    private static final String FULL_PATH_KEY = "emitter.full.path";
    private String fullPath;

    public EmitterProperties(String name, String fileName) throws CoreException {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument name is null or empty.");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument fileName is null.");
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream inStream = new FileInputStream(fileName);){
                Properties props = new Properties();
                props.load(inStream);
                this.fullPath = props.getProperty(String.valueOf(name) + "." + FULL_PATH_KEY);
                if (this.fullPath == null) {
                    throw new CoreException(MdtIdeCoreActivator.getInstance().createError(NLS.bind((String)"{0} emitter is not configured in {1}", (Object)name, (Object)fileName)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(MdtIdeCoreActivator.getInstance().createError(NLS.bind((String)"Cannot read {0} emitter configuration from {1}. Caused by: {2}", (Object[])new Object[]{name, fileName, e.getMessage()}), e));
        }
    }

    public String getBaseDir() {
        return this.fullPath;
    }

    public String getScriptLocation() {
        return String.valueOf(this.getBaseDir()) + "/bin/" + EmitterProperties.getScriptName();
    }

    private static String getScriptName() {
        return Platform.getOS().equals("win32") ? "runItByIDE.cmd" : "runItByIDE.sh";
    }
}

