/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.core.adapters;

import com.nxp.s32ds.mdt.ide.core.adapters.UsagesNotificationAdapter;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;

public class UsagesNotificationResourceSetListener
implements ResourceSetListener {
    private final UsagesNotificationAdapter adapter;
    private final NotificationFilter notificationsFilter;
    private final List<String> operationsFilter;

    public UsagesNotificationResourceSetListener(UsagesNotificationAdapter adapter, NotificationFilter notificationsFilter, List<String> operationsFilter) {
        this.adapter = adapter;
        this.notificationsFilter = notificationsFilter;
        this.operationsFilter = operationsFilter;
        this.resetAdapterNotifyState();
    }

    public NotificationFilter getFilter() {
        return this.notificationsFilter;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        if (this.isOperationFiltered(event)) {
            return null;
        }
        for (Notification notification : event.getNotifications()) {
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject)) continue;
            this.addNotifyAdapterToAllContents((EObject)notifier, notification);
        }
        return null;
    }

    private boolean isOperationFiltered(ResourceSetChangeEvent event) {
        if (event == null) {
            return false;
        }
        Transaction transaction = event.getTransaction();
        if (transaction == null) {
            return false;
        }
        Map opts = transaction.getOptions();
        for (Map.Entry entry : opts.entrySet()) {
            if (!entry.getKey().equals("executing_command")) continue;
            String value = entry.getValue().toString();
            if (!this.operationsFilter.stream().anyMatch(op -> value.startsWith((String)op))) continue;
            return true;
        }
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPrecommitOnly() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    public void resetAdapterNotifyState() {
        this.adapter.resetNotifyState();
    }

    private void addNotifyAdapterToAllContents(EObject target, Notification notification) {
        this.addNotifyAdapter(target, notification);
    }

    private void addNotifyAdapter(EObject target, Notification notification) {
        EList adapters = target.eAdapters();
        if (!adapters.contains((Object)this.adapter) && this.adapter.isApplicable(target)) {
            adapters.add((Object)this.adapter);
            this.adapter.notifyChanged(notification);
        }
    }
}

