/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.core.adapters;

import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.ide.internal.core.MdtIdeCoreActivator;
import com.nxp.s32ds.mdt.ide.internal.core.expressions.Messages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class UsagesNotificationAdapter
extends AdapterImpl {
    private static final int NOTIFY_STATUS_CODE = 100;
    public static final String USAGE_NOTIFICATION_HANDLER_ID = "com.nxp.s32ds.ext.emf.ecore.semantic.elementModificationNotificationHandler";
    private final List<EClass> classList;
    private final Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();
    private Set<Object> usagesNames = new HashSet<Object>();
    private boolean notifyState = true;
    private EObject previousContainer = null;

    public UsagesNotificationAdapter(List<EClass> classList) {
        this.classList = classList;
    }

    public UsagesNotificationAdapter(EClass clazz) {
        this(Arrays.asList(clazz));
    }

    public UsagesNotificationAdapter recordFeature(EStructuralFeature feature) {
        this.features.add(feature);
        return this;
    }

    public void resetNotifyState() {
        this.notifyState = true;
    }

    public void notifyChanged(Notification msg) {
        this.usagesNames.clear();
        if (!this.notifyState) {
            return;
        }
        Object notifier = msg.getNotifier();
        if (this.isApplicable(notifier) && this.needToNotify(msg)) {
            this.processNotification();
        }
    }

    public boolean isApplicable(Object notifier) {
        if (notifier instanceof EObject) {
            EObject obj = (EObject)notifier;
            return this.classList.stream().anyMatch(c -> c == obj.eClass());
        }
        return false;
    }

    public boolean needToNotify(Notification notification) {
        EStructuralFeature feature;
        Object featureObj = notification.getFeature();
        if (featureObj instanceof EStructuralFeature && this.features.contains(feature = (EStructuralFeature)featureObj)) {
            EObject newObj = (EObject)notification.getNotifier();
            if (this.usagesFound(newObj)) {
                this.previousContainer = newObj;
                return true;
            }
            newObj = newObj.eContainer();
            while (newObj != null) {
                if (this.usagesFound(newObj)) {
                    Object oldValue = notification.getOldValue();
                    Object newValue = notification.getNewValue();
                    if (oldValue != null && newValue != null && (oldValue.equals(newValue) || oldValue.toString().isEmpty()) && this.previousContainer != null && this.previousContainer.equals(newObj)) {
                        return false;
                    }
                    this.previousContainer = newObj;
                    return true;
                }
                newObj = newObj.eContainer();
            }
        }
        return false;
    }

    public boolean usagesFound(EObject obj) {
        List<EObject> usages = MdtIdeCore.findUsages(obj, (IProgressMonitor)new NullProgressMonitor());
        this.collectUsagesNames(usages);
        return usages.size() > 0;
    }

    private void collectUsagesNames(List<EObject> usages) {
        for (EObject usage : usages) {
            EStructuralFeature feature = usage.eClass().getEStructuralFeature("name");
            if (feature == null) continue;
            this.usagesNames.add(usage.eGet(feature));
        }
    }

    private void processNotification() {
        Status status = new Status(2, "com.nxp.s32ds.mdt.ide.core", 100, null, null);
        try {
            this.notifyState = false;
            this.notifyState = (Boolean)RcpStatusHandlers.handleStatus((String)USAGE_NOTIFICATION_HANDLER_ID, (IStatus)status, this.usagesNames);
        }
        catch (CoreException ex) {
            MdtIdeCoreActivator.getInstance().log(MdtIdeCoreActivator.getInstance().createError(Messages.Error_calling_notify_status_handler, ex));
        }
    }
}

