/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.util;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcesses;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.Messages;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

public class ApuProgramsReconcileUtil {
    public static IStatus handleReconcile(ApuProcess process) {
        try {
            ApuGraph graph = ApuProgramsReconcileUtil.reloadResource(process);
            ApuProgramsReconcileUtil.reconcileSingleGraph(process, graph, false);
            ApuProgramsReconcileUtil.reconcileBrokenGraphs(process, graph);
            return Status.OK_STATUS;
        }
        catch (CoreException ex) {
            EcoreUtil.delete((EObject)process);
            return ex.getStatus();
        }
    }

    public static IStatus cleanupApuProgram(ApuProgram program) {
        BasicEList toBeDeleted = new BasicEList();
        for (ApuProcess process : program.getProcesses()) {
            if (process.getGraph().eResource() != null) continue;
            toBeDeleted.add((Object)process);
        }
        for (ApuProcess process : toBeDeleted) {
            EcoreUtil.delete((EObject)process);
        }
        if (!toBeDeleted.isEmpty()) {
            return new Status(2, "com.nxp.s32ds.gte.apugraph", Messages.ReconcileGraphAction_warning_graphs_have_been_removed_reason);
        }
        return Status.OK_STATUS;
    }

    private static ApuGraph reloadResource(ApuProcess process) throws CoreException {
        ApuGraph suspectGraph = process.getGraph();
        Resource suspectResource = suspectGraph.eResource();
        try {
            String uriFragment = suspectResource.getURIFragment((EObject)suspectGraph);
            suspectResource.unload();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", StandardCharsets.UTF_8.name());
            suspectResource.load(options);
            EObject obj = suspectResource.getEObject(uriFragment);
            if (!(obj instanceof ApuGraph)) {
                throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.gte.apugraph", Messages.ReconcileGraphAction_graph_not_found));
            }
            return (ApuGraph)obj;
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.nxp.s32ds.gte.apugraph", Messages.ReconcileGraphAction_graph_not_found));
        }
    }

    private static void reconcileSingleGraph(ApuProcess process, ApuGraph graph, boolean replacePorts) {
        EcoreUtil.replace((EObject)process.getGraph(), (EObject)graph);
        ApuProgramsReconcileUtil.reloadKernels(graph);
        ApuProcesses.reconcileInputs(process, (EList<ApuGraphSource>)graph.getGraphSources(), replacePorts);
        ApuProcesses.reconcileOutputs(process, (EList<ApuGraphSink>)graph.getGraphSinks(), replacePorts);
        ApuProgramsReconcileUtil.updateGraphName(process, graph);
        process.setGraph(graph);
    }

    private static void reconcileBrokenGraphs(ApuProcess process, ApuGraph graph) {
        ApuProgram program = process.getProgram();
        for (ApuProcess p : program.getProcesses()) {
            if (p.getGraph().eResource() != null || !graph.getIdentifier().equals(p.getGraph().getIdentifier())) continue;
            ApuProgramsReconcileUtil.reconcileSingleGraph(p, graph, true);
        }
    }

    public static void updateGraphName(ApuProcess process, ApuGraph graph) {
        String identifier = graph.getName();
        String orgProcessName = process.getName();
        int len = orgProcessName.length();
        if (len < 1) {
            return;
        }
        String lastSymbol = orgProcessName.substring(len - 1, len);
        if (!Character.isDigit(lastSymbol.charAt(0))) {
            return;
        }
        String nameBeforePostfix = orgProcessName.substring(0, len - 1);
        if (nameBeforePostfix.equals(identifier)) {
            return;
        }
        List list = process.getProgram().getProcesses().stream().map(ApuProcess::getName).collect(Collectors.toList());
        String pattern = String.valueOf(identifier) + "{0}";
        String newName = ApuUsages.composeNextName(list, (String)pattern);
        process.setName(newName);
    }

    private static void reloadKernels(ApuGraph graph) {
        for (ApuKernel kernel : graph.getKernels()) {
            Resource suspectResource = kernel.getKernelInfo().eResource();
            if (suspectResource == null) {
                ApuProgramsReconcileUtil.logKernelNotFoundError(kernel);
                return;
            }
            suspectResource.unload();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", StandardCharsets.UTF_8.name());
            try {
                suspectResource.load(options);
            }
            catch (IOException iOException) {
                ApuProgramsReconcileUtil.logKernelNotFoundError(kernel);
            }
        }
    }

    private static void logKernelNotFoundError(ApuKernel kernel) {
        String errorMsg = NLS.bind((String)Messages.ReconcileGraphAction_error_kernel_info_not_found, (Object)kernel.getIdentifier());
        Status theStatus = new Status(4, "com.nxp.s32ds.gte.apugraph", errorMsg);
        Log.log((IStatus)theStatus, (String)"com.nxp.s32ds.gte.apugraph");
    }
}

