/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.util;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.ide.resources.FilePathValidator;
import com.nxp.s32ds.ext.ide.resources.ResourceNameValidator;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.gte.apuflow.ApuConsumer;
import com.nxp.s32ds.gte.apuflow.ApuContent;
import com.nxp.s32ds.gte.apuflow.ApuDefinition;
import com.nxp.s32ds.gte.apuflow.ApuPort;
import com.nxp.s32ds.gte.apuflow.ApuProducer;
import com.nxp.s32ds.gte.apuflow.ApuUsage;
import com.nxp.s32ds.gte.apuflow.util.ApuFlowValidator;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apuprogram.ApuColorType;
import com.nxp.s32ds.gte.apuprogram.ApuCpuType;
import com.nxp.s32ds.gte.apuprogram.ApuDataArgument;
import com.nxp.s32ds.gte.apuprogram.ApuDataDescriptor;
import com.nxp.s32ds.gte.apuprogram.ApuDefine;
import com.nxp.s32ds.gte.apuprogram.ApuImage;
import com.nxp.s32ds.gte.apuprogram.ApuImageInlet;
import com.nxp.s32ds.gte.apuprogram.ApuImageOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuNumber;
import com.nxp.s32ds.gte.apuprogram.ApuNumberInlet;
import com.nxp.s32ds.gte.apuprogram.ApuNumberOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuPointer;
import com.nxp.s32ds.gte.apuprogram.ApuPointerInlet;
import com.nxp.s32ds.gte.apuprogram.ApuPointerOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessIndirect;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessPort;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramInlet;
import com.nxp.s32ds.gte.apuprogram.ApuProgramOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuProgramPackage;
import com.nxp.s32ds.gte.apuprogram.ApuProgramPlugin;
import com.nxp.s32ds.gte.apuprogram.ApuProgramPort;
import com.nxp.s32ds.gte.apuprogram.ApuPrograms;
import com.nxp.s32ds.gte.apuprogram.ApuRoi;
import com.nxp.s32ds.gte.apuprogram.ApuUnit;
import com.nxp.s32ds.gte.apuprogram.ApuVariable;
import com.nxp.s32ds.gte.apuprogram.Messages;
import com.nxp.s32ds.gte.apuprogram.UmatDataType;
import com.nxp.s32ds.gte.apuprogram.util.ApuProgramValidationUtils;
import com.nxp.s32ds.gte.apuprogram.validation.Apex2ProgramModelValidator;
import com.nxp.s32ds.gte.apuprogram.validation.Apex2ProgramModelValidatorProvider;
import com.nxp.s32ds.mdt.ide.c.evaluation.MdtCDefineEvaluator;
import com.nxp.s32ds.mdt.ide.validation.UniqueValueValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.util.NLS;

public class ApuProgramValidator
extends EObjectValidator {
    public static final ApuProgramValidator INSTANCE = new ApuProgramValidator();
    public static final String DIAGNOSTIC_SOURCE = "com.nxp.s32ds.gte.apuprogram";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected ApuFlowValidator apuFlowValidator = ApuFlowValidator.INSTANCE;

    protected EPackage getEPackage() {
        return ApuProgramPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateApuDataArgument((ApuDataArgument)value, diagnostics, context);
            }
            case 1: {
                return this.validateApuDataDescriptor((ApuDataDescriptor)value, diagnostics, context);
            }
            case 2: {
                return this.validateApuRoi((ApuRoi)value, diagnostics, context);
            }
            case 3: {
                return this.validateApuDefine((ApuDefine)value, diagnostics, context);
            }
            case 4: {
                return this.validateApuVariable((ApuVariable)value, diagnostics, context);
            }
            case 5: {
                return this.validateApuProgram((ApuProgram)value, diagnostics, context);
            }
            case 6: {
                return this.validateApuProgramPort((ApuProgramPort)value, diagnostics, context);
            }
            case 7: {
                return this.validateApuProgramInlet((ApuProgramInlet)value, diagnostics, context);
            }
            case 8: {
                return this.validateApuProgramOutlet((ApuProgramOutlet)value, diagnostics, context);
            }
            case 9: {
                return this.validateApuImage((ApuImage)value, diagnostics, context);
            }
            case 10: {
                return this.validateApuImageInlet((ApuImageInlet)value, diagnostics, context);
            }
            case 11: {
                return this.validateApuImageOutlet((ApuImageOutlet)value, diagnostics, context);
            }
            case 12: {
                return this.validateApuNumber((ApuNumber)value, diagnostics, context);
            }
            case 13: {
                return this.validateApuNumberInlet((ApuNumberInlet)value, diagnostics, context);
            }
            case 14: {
                return this.validateApuNumberOutlet((ApuNumberOutlet)value, diagnostics, context);
            }
            case 15: {
                return this.validateApuPointer((ApuPointer)value, diagnostics, context);
            }
            case 16: {
                return this.validateApuPointerInlet((ApuPointerInlet)value, diagnostics, context);
            }
            case 17: {
                return this.validateApuPointerOutlet((ApuPointerOutlet)value, diagnostics, context);
            }
            case 18: {
                return this.validateApuProcess((ApuProcess)value, diagnostics, context);
            }
            case 19: {
                return this.validateApuProcessPort((ApuProcessPort)value, diagnostics, context);
            }
            case 20: {
                return this.validateApuProcessIndirect((ApuProcessIndirect)value, diagnostics, context);
            }
            case 21: {
                return this.validateApuProcessInput((ApuProcessInput)value, diagnostics, context);
            }
            case 22: {
                return this.validateApuProcessOutput((ApuProcessOutput)value, diagnostics, context);
            }
            case 23: {
                return this.validateApuColorType((ApuColorType)((Object)value), diagnostics, context);
            }
            case 24: {
                return this.validateApuCpuType((ApuCpuType)((Object)value), diagnostics, context);
            }
            case 25: {
                return this.validateApuUnit((ApuUnit)((Object)value), diagnostics, context);
            }
            case 26: {
                return this.validateUmatDataType((UmatDataType)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateApuDataArgument(ApuDataArgument apuDataArgument, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(apuDataArgument, diagnostics, context);
    }

    public boolean validateApuDataDescriptor(ApuDataDescriptor apuDataDescriptor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuDataDescriptor, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuDataDescriptor, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDataDescriptor_ImageWidthHeightPositive(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDataDescriptor_PixelWidthHeightPositive(apuDataDescriptor, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDataDescriptor_AmountPositive(apuDataDescriptor, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuDataDescriptor_ImageWidthHeightPositive(ApuDataDescriptor apuDataDescriptor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuDataDescriptor, apuDataDescriptor.getImageHeight(), false, true);
        boolean result = true;
        result = status.isOK();
        if (!result) {
            result = false;
            this.addToDiagnostic(4, null, "_UI_Apu_Process_Indirect_Rows_Positive_Value", apuDataDescriptor.eContainer(), diagnostics, context);
        }
        if (!(result = (status = ApuProgramValidationUtils.isPositiveNumber(apuDataDescriptor, apuDataDescriptor.getImageWidth(), false, true)).isOK())) {
            this.addToDiagnostic(4, null, "_UI_Apu_Process_Indirect_Columns_Positive_Value", apuDataDescriptor.eContainer(), diagnostics, context);
        }
        return result;
    }

    public boolean validateApuDataDescriptor_PixelWidthHeightPositive(ApuDataDescriptor apuDataDescriptor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuDataDescriptor, apuDataDescriptor.getPixelHeight(), false, true);
        boolean result = true;
        result = status.isOK();
        if (!result) {
            this.addToDiagnostic(4, status.getMessage(), apuDataDescriptor.eContainer(), diagnostics, context);
        }
        if (!(result = (status = ApuProgramValidationUtils.isPositiveNumber(apuDataDescriptor, apuDataDescriptor.getPixelWidth(), false, true)).isOK())) {
            this.addToDiagnostic(4, status.getMessage(), apuDataDescriptor.eContainer(), diagnostics, context);
        }
        return result;
    }

    public boolean validateApuDataDescriptor_AmountPositive(ApuDataDescriptor apuDataDescriptor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuDataDescriptor, apuDataDescriptor.getAmount(), false, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), apuDataDescriptor, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuRoi(ApuRoi apuRoi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuRoi, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuRoi, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuRoi_heightIsValid(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuRoi_widthIsValid(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuRoi_xOffsetIsValid(apuRoi, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuRoi_yOffsetIsValid(apuRoi, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuRoi_heightIsValid(ApuRoi apuRoi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuRoi, apuRoi.getHeigth(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_ApuRoi_Height_Equal_Greater_Zero", apuRoi, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuRoi_widthIsValid(ApuRoi apuRoi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuRoi, apuRoi.getWidth(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_ApuRoi_Width_Equal_Greater_Zero", apuRoi, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuRoi_xOffsetIsValid(ApuRoi apuRoi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuRoi, apuRoi.getXOffset(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_ApuRoi_XOffset_Equal_Greater_Zero", apuRoi, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuRoi_yOffsetIsValid(ApuRoi apuRoi, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuRoi, apuRoi.getYOffset(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_ApuRoi_YOffset_Equal_Greater_Zero", apuRoi, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuDefine(ApuDefine apuDefine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuDefine, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuDefine, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDefine_NameShouldBeValidCIdentifier(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDefine_NameShouldBeUnique(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDefine_ValueNotEmpty(apuDefine, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuDefine_NameNotEmpty(apuDefine, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuDefine_NameShouldBeValidCIdentifier(ApuDefine apuDefine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuDefine.getName() == null || apuDefine.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuDefine.getName());
        if (!result.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, result.getMessage(), apuDefine, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuDefine_NameShouldBeUnique(ApuDefine apuDefine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuDefine.getName() == null || apuDefine.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuDefine.eContainer().eContents()) {
            if (eObject.equals(apuDefine)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Define name \"{0}\" in Program \"{1}\"", (Object)apuDefine.getName(), (Object)apuDefine.eContainer().eGet(apuDefine.eContainer().eClass().getEStructuralFeature("name")));
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuDefine, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage(), apuDefine, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuDefine_ValueNotEmpty(ApuDefine apuDefine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuDefine.getValue() == null || apuDefine.getValue().isEmpty()) {
            this.addToDiagnostic(4, "Define's value should not be empty", apuDefine, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuDefine_NameNotEmpty(ApuDefine apuDefine, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuDefine.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostic(4, "Defines name shouldn't be empty", apuDefine, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuVariable(ApuVariable apuVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuVariable, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuVariable, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuVariable_NameShouldBeValidCIdentifier(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuVariable_NameShouldBeUnique(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuVariable_ValueIsNumberDefineVariable(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuVariable_NameShouldntBeEmpty(apuVariable, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuVariable_ValueShouldntBeEmpty(apuVariable, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuVariable_NameShouldBeValidCIdentifier(ApuVariable apuVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuVariable.getName() == null || apuVariable.getName().trim().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuVariable.getName());
        if (!result.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, result.getMessage(), apuVariable, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuVariable_NameShouldBeUnique(ApuVariable apuVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuVariable.getName() == null || apuVariable.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuVariable.eContainer().eContents()) {
            if (eObject.equals(apuVariable)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Variable name \"{0}\" in Program \"{1}\"", (Object)apuVariable.getName(), (Object)apuVariable.eContainer().eGet(apuVariable.eContainer().eClass().getEStructuralFeature("name")));
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuVariable, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage(), apuVariable, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuVariable_ValueIsNumberDefineVariable(ApuVariable apuVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuVariable.getName();
        if (name == null || name.trim().isEmpty()) {
            return true;
        }
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuVariable, apuVariable.getValue(), true, false);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), apuVariable, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuVariable_NameShouldntBeEmpty(ApuVariable apuVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuVariable.getName();
        if (name == null || name.trim().isEmpty()) {
            this.addToDiagnostic(4, NLS.bind((String)Messages.ApuVariable_paramenter_is_empty, (Object)Messages.ApuVariable_name), apuVariable, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuVariable_ValueShouldntBeEmpty(ApuVariable apuVariable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String value = apuVariable.getValue();
        if (value == null || value.trim().isEmpty()) {
            this.addToDiagnostic(4, NLS.bind((String)Messages.ApuVariable_paramenter_is_empty, (Object)Messages.ApuVariable_value), apuVariable, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgram(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuProgram, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuProgram, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_OneInlet(apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_OneOutlet(apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_validateUnderlying(apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_AtLeastOneGraphProcess(apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_GraphInstancesHaveSameChunkSettings(apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_CanEvaluateConstants(apuProgram, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgram_NameShouldntBeEmpty(apuProgram, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProgram_OneInlet(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProgram.getInlets() == null || apuProgram.getInlets().isEmpty()) {
            this.addToDiagnostic(4, "APU Program must have at least one Inlet", (EObject)apuProgram, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgram_OneOutlet(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProgram.getOutlets() == null || apuProgram.getOutlets().isEmpty()) {
            this.addToDiagnostic(4, "APU Program must have at least one Outlet", (EObject)apuProgram, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgram_validateUnderlying(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<ApuGraph> graphs = ApuPrograms.getGraphs(apuProgram);
        boolean result = true;
        for (ApuGraph apuGraph : graphs) {
            if (apuGraph.eIsProxy()) {
                ApuProcess process = ApuPrograms.getProcess(apuProgram, apuGraph);
                this.addToDiagnostic(4, null, "_UI_Cannot_find_related_APU_Graph", (EObject)process, diagnostics, context);
                result = false;
                continue;
            }
            boolean bl = result = result && Diagnostician.INSTANCE.validate((EObject)apuGraph, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProgram_AtLeastOneGraphProcess(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProgram.getProcesses().isEmpty()) {
            this.addToDiagnostic(4, "APU Program must have at least one Process from Graph", (EObject)apuProgram, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgram_GraphInstancesHaveSameChunkSettings(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean[] result = new boolean[]{true};
        EList<ApuProcess> processes = apuProgram.getProcesses();
        processes.stream().collect(Collectors.groupingBy(process -> process.getGraph().getName())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> {
            Map<String, List<ApuProcessInput>> inputNames = ((List)e.getValue()).stream().flatMap(p -> p.getProcessInputs().stream()).collect(Collectors.groupingBy(ApuProcessPort::getName));
            inputNames.entrySet().forEach(entry -> {
                blArray[0] = result[0] & this.validateInputsForGraph((List)entry.getValue(), diagnostics, context);
            });
        });
        return result[0];
    }

    public boolean validateApuProgram_CanEvaluateConstants(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (ApuDefine define : apuProgram.getDefines()) {
            if (this.validateApuDefine_NameShouldBeValidCIdentifier(define, null, null) && this.validateApuDefine_ValueNotEmpty(define, null, null) && this.validateApuDefine_NameNotEmpty(define, null, null)) continue;
            return true;
        }
        for (ApuVariable variable : apuProgram.getVariables()) {
            if (this.validateApuVariable_NameShouldBeValidCIdentifier(variable, null, null) && this.validateApuVariable_NameShouldntBeEmpty(variable, null, null) && this.validateApuVariable_ValueShouldntBeEmpty(variable, null, null)) continue;
            return true;
        }
        Apex2ProgramModelValidator modelValidator = ApuProgramValidator.getModelValidator();
        IStatus status = ApuProgramValidationUtils.canEvaluate(apuProgram);
        return modelValidator.createDiagnostic(diagnostics, status, (EObject)apuProgram, context);
    }

    public boolean validateApuProgram_NameShouldntBeEmpty(ApuProgram apuProgram, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuProgram.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostic(4, "Program name shouldn't be empty", (EObject)apuProgram, diagnostics, context);
            return false;
        }
        return true;
    }

    private boolean validateInputsForGraph(List<ApuProcessInput> inputs, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<Integer> sizeX = ApuProgramValidator.collectInputValue(inputs, i -> i.getChunkSizeX());
        Set<Integer> sizeY = ApuProgramValidator.collectInputValue(inputs, i -> i.getChunkSizeY());
        boolean valid = true;
        if (sizeX.size() > 1 && diagnostics != null) {
            valid = false;
            inputs.forEach(input -> this.addToDiagnostic(4, "Chunk sizes X should be equal for all instances of the process.", (EObject)input, diagnostics, context));
        }
        if (sizeY.size() > 1 && diagnostics != null) {
            valid = false;
            inputs.forEach(input -> this.addToDiagnostic(4, "Chunk sizes Y should be equal for all instances of the process.", (EObject)input, diagnostics, context));
        }
        return valid;
    }

    private void addToDiagnostic(int severity, String msg, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{msg, ApuProgramValidator.getObjectLabel((EObject)eObject, context)}, new Object[]{eObject}, context));
        }
    }

    private void addToDiagnostic(int severity, String message, String uiMessageId, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            Object[] objectArray;
            if (message != null && !message.isEmpty()) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = message;
                objectArray = objectArray2;
                objectArray2[1] = ApuProgramValidator.getObjectLabel((EObject)eObject, context);
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = ApuProgramValidator.getObjectLabel((EObject)eObject, context);
            }
            diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, uiMessageId, objectArray, new Object[]{eObject}, context));
        }
    }

    private static Set<Integer> collectInputValue(List<ApuProcessInput> inputs, Function<? super ApuProcessInput, ? extends String> function) {
        HashSet<Integer> sizes = new HashSet<Integer>();
        inputs.forEach(input -> Stream.of(input).map(function).map(s -> ApuProgramValidator.evaluateInputValue(input, s)).findFirst().ifPresent(e -> {
            boolean bl = sizes.add((Integer)e);
        }));
        return sizes;
    }

    private static Integer evaluateInputValue(ApuProcessInput input, String s) {
        try {
            return MdtCDefineEvaluator.INSTANCE.evalInteger((EObject)input, s);
        }
        catch (CoreException coreException) {
            return -1;
        }
    }

    public boolean validateApuProgramPort(ApuProgramPort apuProgramPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuProgramPort, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuProgramPort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuProgramPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuProgramPort, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProgramPort_NameShouldBeValidCIdentifier(ApuProgramPort apuProgramPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProgramPort.getName() == null || apuProgramPort.getName().isEmpty()) {
            return true;
        }
        IStatus status = new CIdentifierValidator().validate((Object)apuProgramPort.getName());
        if (!Status.OK_STATUS.equals(status)) {
            this.addToDiagnostic(4, status.getMessage().replace("\n", ""), (EObject)apuProgramPort, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgramPort_NameShouldntBeEmpty(ApuProgramPort apuProgramPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuProgramPort.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostic(4, "Program port's name shouldn't be empty", (EObject)apuProgramPort, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgramInlet(ApuProgramInlet apuProgramInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuProgramInlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuProgramInlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuProgramInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramInlet_NameShouldBeUnique(apuProgramInlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProgramInlet_NameShouldBeUnique(ApuProgramInlet apuProgramInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProgramInlet.getName() == null || apuProgramInlet.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuProgramInlet.getProgram().getProgramInlets()) {
            if (eObject.equals(apuProgramInlet)) continue;
            eList.add((Object)eObject);
        }
        for (EObject eObject : apuProgramInlet.getProgram().getProgramOutlets()) {
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Inlet/Outlet name \"{0}\" in Program \"{1}\"", (Object)apuProgramInlet.getName(), (Object)apuProgramInlet.getProgram().getName());
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuProgramInlet, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage(), (EObject)apuProgramInlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProgramOutlet(ApuProgramOutlet apuProgramOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuProgramOutlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuProgramOutlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuProgramOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramOutlet_NameShouldBeUnique(apuProgramOutlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProgramOutlet_NameShouldBeUnique(ApuProgramOutlet apuProgramOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProgramOutlet.getName() == null || apuProgramOutlet.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuProgramOutlet.getProgram().getProgramInlets()) {
            eList.add((Object)eObject);
        }
        for (EObject eObject : apuProgramOutlet.getProgram().getProgramOutlets()) {
            if (eObject.equals(apuProgramOutlet)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Inlet/Outlet name \"{0}\" in Program \"{1}\"", (Object)apuProgramOutlet.getName(), (Object)apuProgramOutlet.getProgram().getName());
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuProgramOutlet, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage(), (EObject)apuProgramOutlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuImage, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuImage, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageNameHas_Special_Characters(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageType_Has_Special_Characters(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageNameTooLong(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageTypeTooLong(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_PathTooLong(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImagePathIsValid(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImageNameShouldntBeEmpty(apuImage, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImageTypeShouldntBeEmpty(apuImage, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuImage_imageNameHas_Special_Characters(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String imageName = apuImage.getImageName();
        if (imageName == null || imageName.isEmpty()) {
            return true;
        }
        ResourceNameValidator validator = new ResourceNameValidator();
        IStatus status = validator.validate((Object)imageName);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage().replace("\n", ""), apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_imageType_Has_Special_Characters(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String imageType = apuImage.getImageType();
        if (imageType == null || imageType.isEmpty()) {
            return true;
        }
        ResourceNameValidator validator = new ResourceNameValidator();
        IStatus status = validator.validate((Object)imageType);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage().replace("\n", ""), apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_imageNameTooLong(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuImage == null) {
            return false;
        }
        String imageName = apuImage.getImageName();
        if (imageName == null) {
            return false;
        }
        if (imageName.length() > 260) {
            this.addToDiagnostic(4, "Image name is too long (max - 260)", apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_imageTypeTooLong(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuImage.getImageType() != null && apuImage.getImageType().length() > 260) {
            this.addToDiagnostic(4, "Image name is too long (max - 260)", apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_PathTooLong(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuImage.getPath().length() > 260) {
            this.addToDiagnostic(4, "Image name is too long (max - 260)", apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_ImagePathIsValid(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String path = apuImage.getPath();
        if (path == null || path.isEmpty()) {
            return true;
        }
        FilePathValidator validator = new FilePathValidator();
        IStatus status = validator.validate((Object)path);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage().replace("\n", ""), apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_ImageNameShouldntBeEmpty(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuImage.getImageName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostic(4, "Image name shouldn't be empty", apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImage_ImageTypeShouldntBeEmpty(ApuImage apuImage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String type = apuImage.getImageType();
        if (type == null || type.isEmpty()) {
            this.addToDiagnostic(4, "Image type shouldn't be empty", apuImage, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImageInlet(ApuImageInlet apuImageInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuImageInlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuImageInlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImageInlet_NameShouldBeValidCIdentifier(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramInlet_NameShouldBeUnique(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageNameHas_Special_Characters(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageType_Has_Special_Characters(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageNameTooLong(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageTypeTooLong(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_PathTooLong(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImagePathIsValid(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImageNameShouldntBeEmpty(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImageTypeShouldntBeEmpty(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImageInlet_widthGreaterThanEqualZero(apuImageInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImageInlet_heightGreaterThanEqualZero(apuImageInlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuImageInlet_NameShouldBeValidCIdentifier(ApuImageInlet apuImageInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuImageInlet.getName() == null || apuImageInlet.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuImageInlet.getName());
        if (!result.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, result.getMessage(), apuImageInlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImageInlet_widthGreaterThanEqualZero(ApuImageInlet apuImageInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuImageInlet, apuImageInlet.getImageWidth(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_Apu_Width_Equal_Greater_Zero", apuImageInlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImageInlet_heightGreaterThanEqualZero(ApuImageInlet apuImageInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuImageInlet, apuImageInlet.getImageHeight(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_Apu_Height_Equal_Greater_Zero", apuImageInlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImageOutlet(ApuImageOutlet apuImageOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuImageOutlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuImageOutlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramOutlet_NameShouldBeUnique(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageNameHas_Special_Characters(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageType_Has_Special_Characters(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageNameTooLong(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_imageTypeTooLong(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_PathTooLong(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImagePathIsValid(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImageNameShouldntBeEmpty(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImage_ImageTypeShouldntBeEmpty(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImageOutlet_widthGreaterThanEqualZero(apuImageOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuImageOutlet_heightGreaterThanEqualZero(apuImageOutlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuImageOutlet_widthGreaterThanEqualZero(ApuImageOutlet apuImageOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuImageOutlet, apuImageOutlet.getImageWidth(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_Apu_Width_Equal_Greater_Zero", apuImageOutlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuImageOutlet_heightGreaterThanEqualZero(ApuImageOutlet apuImageOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuImageOutlet, apuImageOutlet.getImageHeight(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_Apu_Height_Equal_Greater_Zero", apuImageOutlet, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuNumber(ApuNumber apuNumber, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuNumber, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuNumber, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuNumber, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuNumber_ValueGreaterEqualThanZero(apuNumber, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuNumber_ValueGreaterEqualThanZero(ApuNumber apuNumber, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ApuProgram apuProgram = (ApuProgram)EObjects.eContainer((EObject)apuNumber, ApuProgram.class);
        if (!this.validateApuProgram_CanEvaluateConstants(apuProgram, null, null)) {
            return true;
        }
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuNumber, apuNumber.getValue(), true, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), "_UI_Apu_Number_Value_Equal_Greater_Zero", apuNumber, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuNumberInlet(ApuNumberInlet apuNumberInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuNumberInlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuNumberInlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramInlet_NameShouldBeUnique(apuNumberInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuNumber_ValueGreaterEqualThanZero(apuNumberInlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuNumberOutlet(ApuNumberOutlet apuNumberOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuNumberOutlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuNumberOutlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramOutlet_NameShouldBeUnique(apuNumberOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuNumber_ValueGreaterEqualThanZero(apuNumberOutlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuPointer(ApuPointer apuPointer, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(apuPointer, diagnostics, context);
    }

    public boolean validateApuPointerInlet(ApuPointerInlet apuPointerInlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuPointerInlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuPointerInlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuPointerInlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramInlet_NameShouldBeUnique(apuPointerInlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuPointerOutlet(ApuPointerOutlet apuPointerOutlet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuPointerOutlet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuPointerOutlet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuDefinition_must_have_name((ApuDefinition)apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldBeValidCIdentifier(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramPort_NameShouldntBeEmpty(apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuPointerOutlet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProgramOutlet_NameShouldBeUnique(apuPointerOutlet, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProcess(ApuProcess apuProcess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment((EObject)apuProcess, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms((EObject)apuProcess, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique((EObject)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuContent_must_have_container((ApuContent)apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcess_NameShouldBeValidCIdentifier(apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcess_NameShouldBeUnique(apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcess_ProcessShouldBeConsistentWithGraph(apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcess_NameShouldntBeEmpty(apuProcess, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcess_ValidProcessInputs(apuProcess, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProcess_NameShouldBeValidCIdentifier(ApuProcess apuProcess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProcess.getName() == null || apuProcess.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuProcess.getName());
        if (!result.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, result.getMessage(), (EObject)apuProcess, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcess_NameShouldBeUnique(ApuProcess apuProcess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProcess.getName() == null || apuProcess.getName().isEmpty()) {
            return true;
        }
        BasicEList eList = new BasicEList();
        for (EObject eObject : apuProcess.getProgram().getProcesses()) {
            if (eObject.equals(apuProcess)) continue;
            eList.add((Object)eObject);
        }
        String message = NLS.bind((String)"Duplicate Process name \"{0}\" in Program \"{1}\"", (Object)apuProcess.getName(), (Object)apuProcess.getProgram().getName());
        UniqueValueValidator validator = new UniqueValueValidator((EObject)apuProcess, "name", message);
        IStatus status = validator.validate((Object)eList);
        if (!status.equals(Status.OK_STATUS)) {
            this.addToDiagnostic(4, status.getMessage(), (EObject)apuProcess, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcess_ProcessShouldBeConsistentWithGraph(ApuProcess apuProcess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.processShouldBeConsistentWithGraph(apuProcess);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), (EObject)apuProcess, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcess_NameShouldntBeEmpty(ApuProcess apuProcess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuProcess.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostic(4, "Process name shouldn't be empty", (EObject)apuProcess, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcess_ValidProcessInputs(ApuProcess apuProcess, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        boolean needsValidation = false;
        EList<ApuProcessInput> inputs = apuProcess.getProcessInputs();
        if (inputs.size() == 0) {
            return result;
        }
        List filteredVecInputs = inputs.stream().filter(input -> ApuPrograms.isVectorInput(input)).collect(Collectors.toList());
        if (filteredVecInputs.size() == 0) {
            return result;
        }
        for (ApuProcessInput apuProcessInput : filteredVecInputs) {
            if (ApuProgramValidationUtils.isChunkSizeEmptyOrZero(apuProcessInput.getChunkSizeX(), apuProcessInput.getChunkSizeY())) continue;
            needsValidation = true;
            break;
        }
        if (needsValidation) {
            for (ApuProcessInput filteredVecInput : filteredVecInputs) {
                if (!ApuProgramValidationUtils.isPositiveNumber(filteredVecInput, filteredVecInput.getChunkSizeX(), false, true).isOK()) {
                    result = false;
                    this.addToDiagnostic(4, NLS.bind((String)Messages.ApuProgram_Chunk_Size, (Object)Messages.ApuProgram_X, (Object)Messages.ApuProgram_Chunk_Size_value_set_incorrectly), filteredVecInput, diagnostics, context);
                }
                if (ApuProgramValidationUtils.isPositiveNumber(filteredVecInput, filteredVecInput.getChunkSizeY(), false, true).isOK()) continue;
                result = false;
                this.addToDiagnostic(4, NLS.bind((String)Messages.ApuProgram_Chunk_Size, (Object)Messages.ApuProgram_Y, (Object)Messages.ApuProgram_Chunk_Size_value_set_incorrectly), filteredVecInput, diagnostics, context);
            }
        }
        return result;
    }

    public boolean validateApuProcessPort(ApuProcessPort apuProcessPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuProcessPort, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuProcessPort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProcessPort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessPort_NameShouldntBeEmpty(apuProcessPort, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProcessPort_NameShouldntBeEmpty(ApuProcessPort apuProcessPort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String name = apuProcessPort.getName();
        if (name == null || name.isEmpty()) {
            this.addToDiagnostic(4, "Process port's name shouldn't be empty", apuProcessPort, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessIndirect(ApuProcessIndirect apuProcessIndirect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuProcessIndirect, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuProcessIndirect, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessPort_NameShouldntBeEmpty(apuProcessIndirect, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessIndirect_NameShouldBeValidCIdentifier(apuProcessIndirect, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProcessIndirect_NameShouldBeValidCIdentifier(ApuProcessIndirect apuProcessIndirect, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProcessIndirect.getName() == null || apuProcessIndirect.getName().isEmpty()) {
            return true;
        }
        CIdentifierValidator validator = new CIdentifierValidator();
        IStatus result = validator.validate((Object)apuProcessIndirect.getName());
        if (!result.isOK()) {
            this.addToDiagnostic(4, result.getMessage(), apuProcessIndirect, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessInput(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuProcessInput, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuProcessInput, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessPort_NameShouldntBeEmpty(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuConsumer_must_have_producer((ApuConsumer)apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessInput_InletShouldHaveTheSameType(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessInput_KernelHasCompatiblePixelType(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessInput_ChunkSizeXMustBeMultipleOfImageWidth(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessInput_ChunkSizeXMustBeMultipleOfImageHeight(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessInput_NameOfProcessInputShouldBeEqualWithGraphInput(apuProcessInput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessInput_NrBytesPositive(apuProcessInput, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProcessInput_InletShouldHaveTheSameType(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isValid = true;
        boolean isVector = ApuPrograms.isVectorInput(apuProcessInput);
        ApuProducer producer = apuProcessInput.getProducer();
        if (producer == null || producer instanceof ApuPointerInlet) {
            return true;
        }
        if (isVector && producer instanceof ApuProgramInlet && !(producer instanceof ApuImageInlet)) {
            isValid = false;
        }
        if (!isVector && producer instanceof ApuImageInlet) {
            isValid = false;
        }
        if (!isValid) {
            this.addToDiagnostic(2, isVector ? "Input port with the 'vector' type of memory part should be connected to Image/Pointer inlet" : "Input port with the 'scalar' type of memory part should be connected to Number/Pointer inlet", apuProcessInput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessInput_KernelHasCompatiblePixelType(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean isCompatible = ApuPrograms.underlyingKernelHasCompatiblePyxelType(apuProcessInput);
        if (!isCompatible) {
            this.addToDiagnostic(2, "Input UMat type is incompatible with underlying kernel Element data type", apuProcessInput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessInput_ChunkSizeXMustBeMultipleOfImageWidth(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int imageWidth;
        int chunkSizeX;
        IStatus statusChunkSizeX = ApuProgramValidationUtils.isPositiveNumber(apuProcessInput, apuProcessInput.getChunkSizeX(), true, true);
        IStatus statusImageWidth = ApuProgramValidationUtils.isPositiveNumber(apuProcessInput, apuProcessInput.getDataDescriptor().getImageWidth(), true, true);
        if (!statusChunkSizeX.isOK() && !statusImageWidth.isOK()) {
            return true;
        }
        ApuProgram program = (ApuProgram)EObjects.eContainer((EObject)apuProcessInput, ApuProgram.class);
        try {
            chunkSizeX = ApuProgramValidationUtils.evalInteger(program, apuProcessInput.getChunkSizeX());
            imageWidth = ApuProgramValidationUtils.evalInteger(program, apuProcessInput.getDataDescriptor().getImageWidth());
        }
        catch (CoreException coreException) {
            return true;
        }
        if (chunkSizeX == 0) {
            return true;
        }
        if (imageWidth == ApuProgramValidationUtils.DEFAULT_IMAGE_WIDTH) {
            return true;
        }
        if (imageWidth % chunkSizeX > 0) {
            this.addToDiagnostic(4, "Columns must be multiple of chunkSizeX", apuProcessInput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessInput_ChunkSizeXMustBeMultipleOfImageHeight(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        int imageHeight;
        int chunkSizeY;
        IStatus statusChunkSizeY = ApuProgramValidationUtils.isPositiveNumber(apuProcessInput, apuProcessInput.getChunkSizeY(), true, true);
        IStatus statusImageHeight = ApuProgramValidationUtils.isPositiveNumber(apuProcessInput, apuProcessInput.getDataDescriptor().getImageHeight(), true, true);
        if (!statusChunkSizeY.isOK() && !statusImageHeight.isOK()) {
            return true;
        }
        ApuProgram program = (ApuProgram)EObjects.eContainer((EObject)apuProcessInput, ApuProgram.class);
        try {
            chunkSizeY = ApuProgramValidationUtils.evalInteger(program, apuProcessInput.getChunkSizeY());
            imageHeight = ApuProgramValidationUtils.evalInteger(program, apuProcessInput.getDataDescriptor().getImageHeight());
        }
        catch (CoreException coreException) {
            return true;
        }
        if (chunkSizeY == 0) {
            return true;
        }
        if (imageHeight == ApuProgramValidationUtils.DEFAULT_IMAGE_WIDTH) {
            return true;
        }
        if (imageHeight % chunkSizeY > 0) {
            this.addToDiagnostic(4, "Rows must be multiple of chunkSizeY", apuProcessInput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessInput_NameOfProcessInputShouldBeEqualWithGraphInput(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String sourceName;
        String inputName = apuProcessInput.getName();
        if (!inputName.equals(sourceName = apuProcessInput.getGraphSource().getName())) {
            this.addToDiagnostic(4, "Name of process input should be equal with graph input", apuProcessInput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessInput_NrBytesPositive(ApuProcessInput apuProcessInput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = ApuProgramValidationUtils.isPositiveNumber(apuProcessInput, apuProcessInput.getNrBytes(), false, true);
        if (!status.isOK()) {
            this.addToDiagnostic(4, status.getMessage(), apuProcessInput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessOutput(ApuProcessOutput apuProcessOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(apuProcessOutput, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(apuProcessOutput, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuUsage_must_have_definition((ApuUsage)apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuPort_must_have_node((ApuPort)apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessPort_NameShouldntBeEmpty(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.apuFlowValidator.validateApuProducer_must_have_consumer((ApuProducer)apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessOutput_OutletOfOutputIsExclusive(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessOutput_ConsumerShouldHaveTheSameType(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessOutput_NameOfProcessOutputShouldBeEqualWithGraphOutput(apuProcessOutput, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateApuProcessOutput_CorrespondedUmatE0DataTypes(apuProcessOutput, diagnostics, context);
        }
        return result;
    }

    public boolean validateApuProcessOutput_OutletOfOutputIsExclusive(ApuProcessOutput apuProcessOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (apuProcessOutput.getProgramOutlets().size() > 0 && apuProcessOutput.getConsumers().size() > apuProcessOutput.getProgramOutlets().size()) {
            this.addToDiagnostic(4, "Output should be connected to one outlet OR to one or more graph inputs", apuProcessOutput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessOutput_ConsumerShouldHaveTheSameType(ApuProcessOutput apuProcessOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        ApuMemoryPart part = ApuPrograms.getOutputMemPart(apuProcessOutput);
        if (part == null) {
            return true;
        }
        EList consumers = apuProcessOutput.getConsumers();
        for (ApuConsumer consumer : consumers) {
            IStatus status = null;
            status = consumer instanceof ApuProcessInput ? ApuProgramValidationUtils.validateConsumerMemoryPart((ApuProcessInput)consumer, part) : ApuProgramValidationUtils.validateConsumerMemoryPart((ApuProgramOutlet)consumer, part);
            if (status.isOK()) continue;
            this.addToDiagnostic(2, status.getMessage(), apuProcessOutput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessOutput_NameOfProcessOutputShouldBeEqualWithGraphOutput(ApuProcessOutput apuProcessOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String sinkName;
        String outputName = apuProcessOutput.getName();
        if (!outputName.equals(sinkName = apuProcessOutput.getGraphSink().getName())) {
            this.addToDiagnostic(4, "Name of process output should be equal with graph output", apuProcessOutput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuProcessOutput_CorrespondedUmatE0DataTypes(ApuProcessOutput apuProcessOutput, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!ApuPrograms.isKernelHasCompatiblePyxelTypeWithProcessOutput(apuProcessOutput)) {
            this.addToDiagnostic(2, "Output UMat type is incompatible with underlying kernel Element data type", apuProcessOutput, diagnostics, context);
            return false;
        }
        return true;
    }

    public boolean validateApuColorType(ApuColorType apuColorType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuCpuType(ApuCpuType apuCpuType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateApuUnit(ApuUnit apuUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateUmatDataType(UmatDataType umatDataType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return ApuProgramPlugin.INSTANCE;
    }

    public boolean validate_EveryProxyResolves(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        EContentsEList.FeatureIterator i = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (i.hasNext()) {
            EObject eCrossReferenceObject = (EObject)i.next();
            if (!eCrossReferenceObject.eIsProxy()) continue;
            result = false;
            if (diagnostics == null) break;
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_UnresolvedProxy_diagnostic", new Object[]{ApuProgramValidator.getFeatureLabel((EStructuralFeature)i.feature(), context), ApuProgramValidator.getObjectLabel((EObject)eObject, context), "Some dependent elements have been changed, please update element"}, new Object[]{eObject}, context));
        }
        return result;
    }

    public static Apex2ProgramModelValidator getModelValidator() {
        return Apex2ProgramModelValidatorProvider.INSTANCE.getValidator();
    }
}

