/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.util;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.orbit.c.defines.impl.CDefineImpl;
import com.nxp.s32ds.gte.apuflow.ApuPort;
import com.nxp.s32ds.gte.apugraph.ApuGraphPort;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apuprogram.ApuDefine;
import com.nxp.s32ds.gte.apuprogram.ApuImage;
import com.nxp.s32ds.gte.apuprogram.ApuPointerOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramFactory;
import com.nxp.s32ds.gte.apuprogram.ApuProgramOutlet;
import com.nxp.s32ds.gte.apuprogram.ApuPrograms;
import com.nxp.s32ds.gte.apuprogram.ApuVariable;
import com.nxp.s32ds.gte.apuprogram.Messages;
import com.nxp.s32ds.mdt.ide.c.evaluation.MdtCDefineEvaluator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class ApuProgramValidationUtils {
    private static final String BUNDLE_NAME = "com.nxp.s32ds.gte.apuprogram";
    private static final String ZERO = "0";
    public static final int DEFAULT_IMAGE_HEIGHT = Integer.valueOf(ApuProgramFactory.eINSTANCE.createApuDataDescriptor().getImageHeight());
    public static final int DEFAULT_IMAGE_WIDTH = Integer.valueOf(ApuProgramFactory.eINSTANCE.createApuDataDescriptor().getImageWidth());

    public static IStatus isPositiveNumber(EObject eObject, String value, boolean allowZero, boolean integerOnly) {
        ApuProgram program = (ApuProgram)EObjects.eContainer((EObject)eObject, ApuProgram.class);
        if (!ApuProgramValidationUtils.canEvaluate(program).isOK()) {
            return Status.OK_STATUS;
        }
        if (value == null || value.trim().isEmpty()) {
            return new Status(4, BUNDLE_NAME, Messages.ApuProgram_ValueVaidationErrorMessage);
        }
        if (ApuProgramValidationUtils.isNumeric(value)) {
            return ApuProgramValidationUtils.checkNumericPositive(value, allowZero, integerOnly);
        }
        if (eObject == null) {
            return new Status(4, BUNDLE_NAME, Messages.ApuProgramValidationUtils_eObject_null);
        }
        if (program == null) {
            return new Status(4, BUNDLE_NAME, Messages.ApuProgramValidationUtils_program_null);
        }
        String script = ApuProgramValidationUtils.buildScript(value, program);
        try {
            String evaluatedValue = integerOnly ? String.valueOf(ApuProgramValidationUtils.evalIntegerInternal((EObject)program, script)) : String.valueOf(ApuProgramValidationUtils.evalDoubleInternal((EObject)program, script));
            return ApuProgramValidationUtils.checkNumericPositive(evaluatedValue, allowZero, integerOnly);
        }
        catch (CoreException e) {
            return new Status(4, BUNDLE_NAME, e.getMessage());
        }
    }

    public static boolean isChunkSizeEmptyOrZero(String chunkSizeX, String chunkSizeY) {
        return !(!chunkSizeX.trim().isEmpty() && !ZERO.equals(chunkSizeX) || !chunkSizeY.trim().isEmpty() && !ZERO.equals(chunkSizeY));
    }

    public static double evalDouble(ApuProgram program, String value) throws CoreException {
        if (!ApuProgramValidationUtils.canEvaluate(program).isOK()) {
            return 0.0;
        }
        return ApuProgramValidationUtils.evalDoubleInternal((EObject)program, ApuProgramValidationUtils.buildScript(value, program));
    }

    public static int evalInteger(ApuProgram program, String value) throws CoreException {
        if (!ApuProgramValidationUtils.canEvaluate(program).isOK()) {
            return 0;
        }
        return ApuProgramValidationUtils.evalIntegerInternal((EObject)program, ApuProgramValidationUtils.buildScript(value, program));
    }

    private static double evalDoubleInternal(EObject eObject, String script) throws CoreException {
        return MdtCDefineEvaluator.INSTANCE.evalDouble(eObject, script);
    }

    private static int evalIntegerInternal(EObject eObject, String script) throws CoreException {
        return Double.valueOf(String.valueOf(MdtCDefineEvaluator.INSTANCE.evalInteger(eObject, script))).intValue();
    }

    public static IStatus canEvaluate(ApuProgram program) {
        if (program == null) {
            return Status.OK_STATUS;
        }
        List defines = program.getDefines().stream().map(d -> new CDefineImpl(d.getName(), d.getValue())).collect(Collectors.toList());
        defines.addAll(program.getVariables().stream().map(v -> new CDefineImpl(v.getName(), v.getValue())).collect(Collectors.toList()));
        return MdtCDefineEvaluator.INSTANCE.checkScript((EObject)program, defines);
    }

    private static String buildScript(String value, ApuProgram program) {
        List defines = program.getDefines().stream().map(d -> new CDefineImpl(d.getName(), d.getValue())).collect(Collectors.toList());
        defines.addAll(program.getVariables().stream().map(v -> new CDefineImpl(v.getName(), v.getValue())).collect(Collectors.toList()));
        StringBuilder sb = new StringBuilder();
        sb.append(MdtCDefineEvaluator.INSTANCE.buildConstantsScript(defines));
        if (sb.length() > 0) {
            sb.append("\n");
        }
        sb.append(value);
        String script = sb.toString();
        return script;
    }

    private static IStatus checkNumericPositive(String value, boolean allowZero, boolean integerOnly) {
        if (integerOnly && value.contains(".")) {
            return new Status(4, BUNDLE_NAME, NLS.bind((String)Messages.ApuProgramValidationUtils_Parameters_Value_Integer, (Object)value));
        }
        double num = Double.valueOf(value);
        if (num < 0.0) {
            return allowZero ? new Status(4, BUNDLE_NAME, NLS.bind((String)Messages.ApuProgram_Parameters_Value_Greater_Equal_Zero, (Object)value)) : new Status(4, BUNDLE_NAME, NLS.bind((String)Messages.ApuProgram_Parameters_Value_Positive, (Object)value));
        }
        if (num > 0.0) {
            return Status.OK_STATUS;
        }
        return allowZero ? Status.OK_STATUS : new Status(4, BUNDLE_NAME, NLS.bind((String)Messages.ApuProgram_Parameters_Value_Positive, (Object)value));
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public static boolean isVariable(String value, ApuProgram program) {
        for (ApuVariable var : program.getVariables()) {
            if (!var.getName().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefine(String value, ApuProgram program) {
        for (ApuDefine def : program.getDefines()) {
            if (!def.getName().equals(value)) continue;
            return true;
        }
        return false;
    }

    public static IStatus validateConsumerMemoryPart(ApuProcessInput input, ApuMemoryPart outMemoryPart) {
        ApuMemoryPart inMemoryPart = ApuPrograms.getInputMemPart(input);
        if (inMemoryPart == null) {
            return Status.OK_STATUS;
        }
        if (inMemoryPart == outMemoryPart) {
            return Status.OK_STATUS;
        }
        return new Status(2, BUNDLE_NAME, Messages.InputShouldBeConnectedToPortWithSameMemoryPart);
    }

    public static IStatus validateConsumerMemoryPart(ApuProgramOutlet outlet, ApuMemoryPart outPortMemoryPart) {
        ApuMemoryPart outletMemoryPart;
        if (outlet instanceof ApuPointerOutlet) {
            return Status.OK_STATUS;
        }
        ApuMemoryPart apuMemoryPart = outletMemoryPart = outlet instanceof ApuImage ? ApuMemoryPart.ATTR_CMEM : ApuMemoryPart.ATTR_DMEM;
        if (outletMemoryPart == outPortMemoryPart) {
            return Status.OK_STATUS;
        }
        return outPortMemoryPart == ApuMemoryPart.ATTR_CMEM ? new Status(2, BUNDLE_NAME, Messages.VectorOutputShouldBeConnectedToImageOrPointerOutlet) : new Status(2, BUNDLE_NAME, Messages.ScalarOutputShouldBeConnectedToNumberOrPointerOutlet);
    }

    public static IStatus processShouldBeConsistentWithGraph(ApuProcess apuProcess) {
        for (ApuProcessInput input : apuProcess.getProcessInputs()) {
            if (ApuProgramValidationUtils.graphPortExists(input.getGraphPort(), apuProcess)) continue;
            return ApuProgramValidationUtils.errorStatus(Messages.GraphPortForInputIsNotFound, input.getName());
        }
        for (ApuProcessOutput output : apuProcess.getProcessOutputs()) {
            if (ApuProgramValidationUtils.graphPortExists(output.getGraphPort(), apuProcess)) continue;
            return ApuProgramValidationUtils.errorStatus(Messages.GraphPortForOutputIsNotFound, output.getName());
        }
        for (ApuPort port : apuProcess.getGraph().getPorts()) {
            if (ApuProgramValidationUtils.processPortExists(port, apuProcess)) continue;
            return ApuProgramValidationUtils.errorStatus(Messages.ProcessPortForPortIsNotFound, port.getIdentifier());
        }
        return Status.OK_STATUS;
    }

    private static IStatus errorStatus(String message, String param) {
        return new Status(4, BUNDLE_NAME, NLS.bind((String)message, (Object)param));
    }

    private static boolean graphPortExists(ApuGraphPort graphPort, ApuProcess process) {
        for (ApuPort port : process.getGraph().getPorts()) {
            if (!graphPort.equals(port)) continue;
            return true;
        }
        return false;
    }

    private static boolean processPortExists(ApuPort port, ApuProcess process) {
        for (ApuProcessInput input : process.getProcessInputs()) {
            if (!input.getGraphPort().equals(port)) continue;
            return true;
        }
        for (ApuProcessOutput output : process.getProcessOutputs()) {
            if (!output.getGraphPort().equals(port)) continue;
            return true;
        }
        return false;
    }
}

