/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram.util;

import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramOutlet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;

public class ApuProgramNormalizationUtils {
    public static void normalize(ApuProgram sourceProgram) {
        ArrayList<ApuProcess> markedProcesses = new ArrayList<ApuProcess>();
        ArrayList<ApuProcess> normalizedProcesses = new ArrayList<ApuProcess>();
        for (ApuProgramOutlet outlet : ApuProgramNormalizationUtils.orderOutlets(sourceProgram.getProgramOutlets())) {
            ApuProcess currProcess;
            if (outlet.getProcessOutput() == null || markedProcesses.contains(currProcess = outlet.getProcessOutput().getProcess())) continue;
            List<ApuProcess> unmarkedPredecessors = ApuProgramNormalizationUtils.findUnmarkedPredecessors(currProcess, markedProcesses);
            normalizedProcesses.addAll(unmarkedPredecessors);
            normalizedProcesses.add(currProcess);
            markedProcesses.addAll(unmarkedPredecessors);
            markedProcesses.add(currProcess);
        }
        ApuProgramNormalizationUtils.updateItemsOrder(sourceProgram, normalizedProcesses);
    }

    private static ApuProgram updateItemsOrder(ApuProgram sourceProgram, List<ApuProcess> normalizedProcesses) {
        EList<ApuProcess> list = sourceProgram.getProcesses();
        for (ApuProcess process : normalizedProcesses) {
            int newIndex = normalizedProcesses.indexOf(process);
            list.move(newIndex, (Object)process);
        }
        return sourceProgram;
    }

    private static List<ApuProcess> findUnmarkedPredecessors(ApuProcess currProcess, List<ApuProcess> markedProcesses) {
        ArrayList<ApuProcess> result = new ArrayList<ApuProcess>();
        for (ApuProcessInput input : ApuProgramNormalizationUtils.orderInputs(currProcess.getProcessInputs())) {
            ApuProcess predecessor;
            if (input.getProcessOutput() == null || markedProcesses.contains(predecessor = input.getProcessOutput().getProcess())) continue;
            List<ApuProcess> list = ApuProgramNormalizationUtils.findUnmarkedPredecessors(predecessor, markedProcesses);
            result.addAll(list);
            result.add(predecessor);
            markedProcesses.addAll(list);
            markedProcesses.add(predecessor);
        }
        return result;
    }

    private static EList<ApuProcessInput> orderInputs(EList<ApuProcessInput> processInputs) {
        ECollections.sort(processInputs, (Comparator)new Comparator<ApuProcessInput>(){

            @Override
            public int compare(ApuProcessInput i1, ApuProcessInput i2) {
                return i1.getName().compareTo(i2.getName());
            }
        });
        return processInputs;
    }

    private static EList<ApuProgramOutlet> orderOutlets(EList<ApuProgramOutlet> programOutlets) {
        ECollections.sort(programOutlets, (Comparator)new Comparator<ApuProgramOutlet>(){

            @Override
            public int compare(ApuProgramOutlet o1, ApuProgramOutlet o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return programOutlets;
    }
}

