/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram;

import com.nxp.s32ds.gte.apuflow.ApuUsages;
import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortAttributesInfo;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apukernel.ApuMemoryPart;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProcesses;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.UmatDataType;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ApuPrograms {
    private static final String PROCESS_NAME = "%s_%s";
    private static final String PROCESS_ID = "apu_%s";

    public static Diagnostic addProcess(ApuProgram program, ApuGraph graph) {
        if (program == null) {
            return Diagnostic.CANCEL_INSTANCE;
        }
        if (graph == null) {
            return Diagnostic.CANCEL_INSTANCE;
        }
        String identifier = graph.getName();
        List list = program.getProcesses().stream().map(ApuProcess::getName).collect(Collectors.toList());
        String pattern = String.valueOf(identifier) + "{0}";
        String name = ApuUsages.composeNextName(list, (String)pattern);
        ApuProcess process = ApuProcesses.createProcess(graph, name);
        process.setProgram(program);
        return Diagnostic.OK_INSTANCE;
    }

    public static EList<ApuProcess> getProcesses(ApuProgram program) {
        BasicEList list = new BasicEList();
        if (program == null) {
            return list;
        }
        HashSet<String> keys = new HashSet<String>();
        EList<ApuProcess> apuProcesses = program.getProcesses();
        for (ApuProcess apuProcess : apuProcesses) {
            String identifier = apuProcess.getGraph().getIdentifier();
            if (keys.contains(identifier)) continue;
            keys.add(identifier);
            list.add((Object)apuProcess);
        }
        return list;
    }

    public static String proposeProcessName(ApuProgram program, String identifier) {
        int index = 0;
        if (program != null) {
            EList<ApuProcess> processes = program.getProcesses();
            for (ApuProcess kernel : processes) {
                String usage;
                ApuGraph graph = kernel.getGraph();
                if (graph == null || !Objects.equals(usage = graph.getName(), identifier)) continue;
                ++index;
            }
        }
        return String.format(PROCESS_NAME, identifier, index);
    }

    public static String composeProcessId(ApuProcess process) {
        ApuGraph graph;
        String name = null;
        if (process != null && (graph = process.getGraph()) != null) {
            name = graph.getName();
        }
        return String.format(PROCESS_ID, name).toUpperCase();
    }

    public static boolean isVectorInput(EObject eObject) {
        if (eObject == null || !(eObject instanceof ApuProcessInput)) {
            return false;
        }
        ApuProcessInput input = (ApuProcessInput)eObject;
        ApuGraphSource source = input.getGraphSource();
        if (source == null) {
            return false;
        }
        EList kernelInputs = source.getKernelInputs();
        if (kernelInputs.isEmpty()) {
            return false;
        }
        ApuKernelInput first = (ApuKernelInput)kernelInputs.get(0);
        if (first == null) {
            return false;
        }
        ApuKernelPortInfo portInfo = first.getPortInfo();
        if (portInfo == null) {
            return false;
        }
        ApuKernelPortAttributesInfo portAttributesInfo = portInfo.getPortAttrbutesInfo();
        if (portAttributesInfo == null) {
            return false;
        }
        ApuMemoryPart memoryPart = portAttributesInfo.getMemoryPart();
        if (memoryPart == null) {
            return false;
        }
        return memoryPart.equals((Object)ApuMemoryPart.ATTR_CMEM);
    }

    public static ApuMemoryPart getInputMemPart(ApuProcessInput input) {
        if (input == null) {
            return null;
        }
        ApuGraphSource source = input.getGraphSource();
        if (source == null) {
            return null;
        }
        EList kernelInputs = source.getKernelInputs();
        if (kernelInputs.isEmpty()) {
            return null;
        }
        ApuKernelInput first = (ApuKernelInput)kernelInputs.get(0);
        if (first == null) {
            return null;
        }
        ApuKernelPortInfo portInfo = first.getPortInfo();
        if (portInfo == null) {
            return null;
        }
        ApuKernelPortAttributesInfo portAttributesInfo = portInfo.getPortAttrbutesInfo();
        if (portAttributesInfo == null) {
            return null;
        }
        return portAttributesInfo.getMemoryPart();
    }

    public static ApuMemoryPart getOutputMemPart(ApuProcessOutput output) {
        if (output == null) {
            return null;
        }
        ApuGraphSink sink = output.getGraphSink();
        if (sink == null) {
            return null;
        }
        ApuKernelOutput kernelOutput = sink.getKernelOutput();
        if (kernelOutput == null) {
            return null;
        }
        ApuKernelPortInfo portInfo = kernelOutput.getPortInfo();
        if (portInfo == null) {
            return null;
        }
        ApuKernelPortAttributesInfo portAttributesInfo = portInfo.getPortAttrbutesInfo();
        if (portAttributesInfo == null) {
            return null;
        }
        return portAttributesInfo.getMemoryPart();
    }

    public static boolean underlyingKernelHasCompatiblePyxelType(ApuProcessInput apuProcessInput) {
        if (apuProcessInput == null) {
            return false;
        }
        ApuGraphSource graphSource = apuProcessInput.getGraphSource();
        if (graphSource == null) {
            return false;
        }
        EList kernelInputs = graphSource.getKernelInputs();
        if (kernelInputs.isEmpty()) {
            return false;
        }
        ApuKernelPortInfo portInfo = ((ApuKernelInput)kernelInputs.get(0)).getPortInfo();
        if (portInfo == null) {
            return false;
        }
        UmatDataType umatType = apuProcessInput.getUmatType();
        ApuDataType e0DataType = portInfo.getPortElementsInfo().getE0DataType();
        if (umatType == null || e0DataType == null) {
            return false;
        }
        return ApuPrograms.typesAreCompatible(umatType, e0DataType);
    }

    public static boolean isKernelHasCompatiblePyxelTypeWithProcessOutput(ApuProcessOutput apuProcessOutput) {
        ApuGraphSink graphSink = apuProcessOutput.getGraphSink();
        if (graphSink == null) {
            return false;
        }
        ApuKernelOutput kernelOutput = graphSink.getKernelOutput();
        if (kernelOutput == null) {
            return false;
        }
        UmatDataType umatType = apuProcessOutput.getUmatType();
        ApuDataType e0DataType = kernelOutput.getPortInfo().getPortElementsInfo().getE0DataType();
        if (umatType == null || e0DataType == null) {
            return false;
        }
        return ApuPrograms.typesAreCompatible(umatType, e0DataType);
    }

    private static boolean typesAreCompatible(UmatDataType uMatType, ApuDataType e0Type) {
        String kernelType = String.valueOf(e0Type);
        String inputType = String.valueOf((Object)uMatType);
        if (!kernelType.isEmpty() && !inputType.isEmpty()) {
            Pattern pattern = Pattern.compile("[1-9]{1,2}[UuSs]");
            Matcher matcherKernel = pattern.matcher(kernelType);
            Matcher matcherInput = pattern.matcher(inputType);
            if (matcherKernel.find() && matcherInput.find()) {
                boolean s32input;
                if (matcherKernel.group(0).toLowerCase().equals(matcherInput.group(0).toLowerCase())) {
                    return true;
                }
                boolean s32kernel = kernelType.trim().toLowerCase().contains("d32s") || kernelType.trim().toLowerCase().contains("d32u");
                boolean bl = s32input = inputType.trim().toLowerCase().contains("_32s") || inputType.trim().toLowerCase().contains("_32u");
                return s32kernel && s32input;
            }
        }
        return false;
    }

    public static List<ApuGraph> getGraphs(ApuProgram program) {
        return ApuPrograms.getProcesses(program).stream().map(ApuProcess::getGraph).collect(Collectors.toList());
    }

    public static ApuProcess getProcess(ApuProgram program, ApuGraph graph) {
        return ApuPrograms.getProcesses(program).stream().filter(pr -> pr.getGraph() == graph).findAny().orElse(null);
    }

    public static List<ApuProcess> getProcesses(ApuProgram program, ApuGraph graph) {
        return program.getProcesses().stream().filter(pr -> pr.getGraph() == graph).collect(Collectors.toList());
    }

    public static void update(ApuProgram program) {
        String name = program.getName();
        program.setName(name.concat("_temp"));
        program.setName(name);
    }
}

