/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphPort;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apugraph.ApuGraphs;
import com.nxp.s32ds.gte.apugraph.ApuKernel;
import com.nxp.s32ds.gte.apugraph.ApuKernelInput;
import com.nxp.s32ds.gte.apugraph.ApuKernelOutput;
import com.nxp.s32ds.gte.apugraph.ApuKernelPort;
import com.nxp.s32ds.gte.apukernel.ApuDataType;
import com.nxp.s32ds.gte.apukernel.ApuKernelPortInfo;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcessInput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessOutput;
import com.nxp.s32ds.gte.apuprogram.ApuProcessPort;
import com.nxp.s32ds.gte.apuprogram.ApuProgram;
import com.nxp.s32ds.gte.apuprogram.ApuProgramFactory;
import com.nxp.s32ds.gte.apuprogram.ApuProgramInlet;
import com.nxp.s32ds.gte.apuprogram.ApuProgramOutlet;
import com.nxp.s32ds.gte.apuprogram.UmatDataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ApuProcesses {
    private static final String PPOCESS_NAME = "%s_%s";

    public static ApuProcess createProcess(ApuGraph graph) {
        String identifier = graph != null ? graph.getIdentifier() : "";
        String name = String.format(PPOCESS_NAME, identifier, 0);
        return ApuProcesses.createProcess(graph, name);
    }

    public static ApuProcess createProcess(ApuGraph graph, String name) {
        ApuProcess process = ApuProgramFactory.eINSTANCE.createApuProcess();
        if (graph != null) {
            process.setName(name);
            process.setGraph(graph);
            ApuProcesses.reconcileInputs(process, (EList<ApuGraphSource>)graph.getGraphSources());
            ApuProcesses.reconcileOutputs(process, (EList<ApuGraphSink>)graph.getGraphSinks());
        }
        return process;
    }

    public static UmatDataType convertApuDataTypeToUmatDataType(ApuDataType apuType) {
        switch (apuType.getValue()) {
            case 1: {
                return UmatDataType.VSDK_CV_8UC1;
            }
            case 2: {
                return UmatDataType.VSDK_CV_8SC1;
            }
            case 3: {
                return UmatDataType.VSDK_CV_16UC1;
            }
            case 4: {
                return UmatDataType.VSDK_CV_16SC1;
            }
            case 5: {
                return UmatDataType.VSDK_CV_32SC1;
            }
            case 6: {
                return UmatDataType.VSDK_CV_32SC1;
            }
        }
        return UmatDataType.VSDK_CV_8UC1;
    }

    public static ApuDataType convertUmatDataTypeToApuDataType(UmatDataType umatType) {
        switch (umatType.getValue()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ApuDataType.D08S;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ApuDataType.D08U;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return ApuDataType.D16S;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return ApuDataType.D16U;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return ApuDataType.D32S;
            }
        }
        return ApuDataType.D08S;
    }

    public static List<ApuKernelPort> getKernelPortInfos(ApuKernel kernel) {
        ArrayList<ApuKernelPort> result = new ArrayList<ApuKernelPort>();
        if (kernel == null) {
            return result;
        }
        EList kernelPortInfos = kernel.getKernelInfo().getPortInfos();
        EList kernelInputs = kernel.getKernelInputs();
        EList kernelOutputs = kernel.getKernelOutputs();
        HashMap<ApuKernelPortInfo, Object> portInfo2port = new HashMap<ApuKernelPortInfo, Object>();
        for (ApuKernelInput input : kernelInputs) {
            portInfo2port.put(input.getPortInfo(), input);
        }
        for (ApuKernelOutput output : kernelOutputs) {
            portInfo2port.put(output.getPortInfo(), output);
        }
        for (ApuKernelPortInfo portInfo : kernelPortInfos) {
            ApuKernelPort port = (ApuKernelPort)portInfo2port.get(portInfo);
            if (port == null) continue;
            result.add(port);
        }
        return result;
    }

    public static List<ApuProcess> getProcessTypes(ApuProgram program) {
        ArrayList<ApuProcess> result = new ArrayList<ApuProcess>();
        if (program != null) {
            HashSet<ApuGraph> graphs = new HashSet<ApuGraph>();
            EList<ApuProcess> processes = program.getProcesses();
            for (ApuProcess process : processes) {
                ApuGraph graph = process.getGraph();
                if (graph == null || !graphs.add(graph)) continue;
                result.add(process);
            }
        }
        return result;
    }

    public static EList<ApuGraph> getGraphs(ApuProgram program) {
        BasicEList list = new BasicEList();
        if (program == null) {
            return list;
        }
        HashSet<String> keys = new HashSet<String>();
        EList<ApuProcess> apuProcesses = program.getProcesses();
        for (ApuProcess apuProcess : apuProcesses) {
            String identifier;
            ApuGraph graph = apuProcess.getGraph();
            if (graph == null || keys.contains(identifier = graph.getIdentifier())) continue;
            keys.add(identifier);
            list.add((Object)graph);
        }
        return list;
    }

    static <P extends ApuProcessPort> Map<ApuGraphPort, P> buildPortMap(EList<P> list) {
        LinkedHashMap<ApuGraphPort, ApuProcessPort> result = new LinkedHashMap<ApuGraphPort, ApuProcessPort>();
        for (ApuProcessPort port : list) {
            ApuGraphPort portInfo = port.getGraphPort();
            if (portInfo == null) continue;
            result.put(portInfo, port);
        }
        return result;
    }

    public static void reconcileOutputs(ApuProcess process, EList<ApuGraphSink> ports) {
        ApuProcesses.reconcileOutputs(process, ports, false);
    }

    public static void reconcileInputs(ApuProcess process, EList<ApuGraphSource> graphSources) {
        ApuProcesses.reconcileInputs(process, graphSources, false);
    }

    public static void reconcileOutputs(ApuProcess process, EList<ApuGraphSink> ports, boolean withReplace) {
        EList<ApuProcessOutput> processOutputs = process.getProcessOutputs();
        Map<ApuGraphPort, ApuProcessOutput> outputs = ApuProcesses.buildPortMap(processOutputs);
        HashMap<ApuProcessOutput, ApuProgramOutlet> outletsMap = new HashMap<ApuProcessOutput, ApuProgramOutlet>();
        HashMap<ApuProcessOutput, ApuProcessInput> inputsMap = new HashMap<ApuProcessOutput, ApuProcessInput>();
        for (ApuGraphPort graphPort : ports) {
            if (!(graphPort instanceof ApuGraphSink)) continue;
            ApuGraphSink sink = (ApuGraphSink)graphPort;
            ApuProcessOutput existing = outputs.remove(graphPort);
            if (existing == null) {
                Optional<ApuGraphPort> opt;
                existing = ApuProgramFactory.eINSTANCE.createApuProcessOutput();
                ApuKernelOutput kernelOutput = sink.getKernelOutput();
                if (kernelOutput != null) {
                    ApuDataType dataType = sink.getKernelOutput().getPortInfo().getPortElementsInfo().getE0DataType();
                    UmatDataType umatDataType = ApuProcesses.convertApuDataTypeToUmatDataType(dataType);
                    existing.setUmatType(umatDataType);
                }
                if (withReplace && (opt = outputs.keySet().stream().filter(p -> p.getIdentifier().equals(graphPort.getIdentifier())).findFirst()).isPresent()) {
                    ApuGraphPort same = opt.get();
                    ApuProcessOutput old = outputs.remove(same);
                    for (ApuProgramOutlet outlet : old.getProgramOutlets()) {
                        outletsMap.put(existing, outlet);
                    }
                    for (ApuProcessInput input : old.getProcessInputs()) {
                        inputsMap.put(existing, input);
                    }
                    processOutputs.remove((Object)old);
                }
                existing.setProcess(process);
            }
            existing.setName(graphPort.getIdentifier());
            existing.setGraphSink(sink);
            existing.getDataDescriptor().setPixelType(ApuGraphs.getApuDataTypeOfSink((ApuGraphSink)sink));
        }
        if (withReplace) {
            outletsMap.forEach((k, v) -> v.setProcessOutput((ApuProcessOutput)k));
            inputsMap.forEach((k, v) -> v.setProcessOutput((ApuProcessOutput)k));
        }
        Collection<ApuProcessOutput> remains = outputs.values();
        for (ApuProcessOutput remained : remains) {
            processOutputs.remove((Object)remained);
        }
    }

    public static void reconcileInputs(ApuProcess process, EList<ApuGraphSource> graphSources, boolean withReplace) {
        EList<ApuProcessInput> processInputs = process.getProcessInputs();
        Map<ApuGraphPort, ApuProcessInput> inputs = ApuProcesses.buildPortMap(processInputs);
        HashMap<ApuProcessInput, ApuProgramInlet> inletsMap = new HashMap<ApuProcessInput, ApuProgramInlet>();
        HashMap<ApuProcessInput, ApuProcessOutput> outputsMap = new HashMap<ApuProcessInput, ApuProcessOutput>();
        for (ApuGraphSource source : graphSources) {
            ApuProcessInput existing = inputs.remove(source);
            if (existing == null) {
                Optional<ApuGraphPort> opt;
                existing = ApuProgramFactory.eINSTANCE.createApuProcessInput();
                EList kernelInputs = source.getKernelInputs();
                if (!kernelInputs.isEmpty()) {
                    ApuDataType dataType = ((ApuKernelInput)kernelInputs.get(0)).getPortInfo().getPortElementsInfo().getE0DataType();
                    UmatDataType umatDataType = ApuProcesses.convertApuDataTypeToUmatDataType(dataType);
                    existing.setUmatType(umatDataType);
                }
                if (withReplace && (opt = inputs.keySet().stream().filter(p -> p.getIdentifier().equals(source.getIdentifier())).findFirst()).isPresent()) {
                    ApuGraphPort same = opt.get();
                    ApuProcessInput old = inputs.remove(same);
                    inletsMap.put(existing, old.getProgramInlet());
                    outputsMap.put(existing, old.getProcessOutput());
                    processInputs.remove((Object)old);
                }
                existing.setProcess(process);
            }
            existing.setGraphSource(source);
            existing.setName(source.getName());
            existing.getDataDescriptor().setPixelType(ApuGraphs.getApuDataTypeOfSource((ApuGraphSource)source));
        }
        if (withReplace) {
            inletsMap.forEach((k, v) -> k.setProgramInlet((ApuProgramInlet)v));
            outputsMap.forEach((k, v) -> k.setProcessOutput((ApuProcessOutput)v));
        }
        Collection<ApuProcessInput> remains = inputs.values();
        for (ApuProcessInput remained : remains) {
            processInputs.remove((Object)remained);
        }
    }
}

