/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram;

import com.nxp.s32ds.gte.apugraph.ApuGraph;
import com.nxp.s32ds.gte.apugraph.ApuGraphSink;
import com.nxp.s32ds.gte.apugraph.ApuGraphSource;
import com.nxp.s32ds.gte.apuprogram.ApuProcess;
import com.nxp.s32ds.gte.apuprogram.ApuProcesses;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;

public class ApuProcessReconciler
extends AdapterImpl {
    public void notifyChanged(Notification msg) {
        int featureID;
        Object notifier = msg.getNotifier();
        if (notifier instanceof ApuProcess) {
            ApuProcess process = (ApuProcess)notifier;
            featureID = msg.getFeatureID(ApuProcess.class);
            switch (featureID) {
                case 3: {
                    this.graphChanged(process, msg);
                    break;
                }
            }
        }
        if (notifier instanceof ApuGraph) {
            ApuGraph graph = (ApuGraph)notifier;
            featureID = msg.getFeatureID(ApuGraph.class);
            switch (featureID) {
                case 3: {
                    this.graphSinksChanged(graph, msg);
                    break;
                }
                case 2: {
                    this.graphSourcesChanged(graph, msg);
                    break;
                }
            }
        }
        super.notifyChanged(msg);
    }

    protected void graphChanged(ApuProcess process, Notification msg) {
        Object newValue;
        Object oldValue = msg.getOldValue();
        if (oldValue instanceof ApuGraph) {
            ApuGraph oldGraph = (ApuGraph)oldValue;
            EList eAdapters = oldGraph.eAdapters();
            eAdapters.remove((Object)this);
        }
        if ((newValue = msg.getNewValue()) instanceof ApuGraph) {
            ApuGraph newGraph = (ApuGraph)newValue;
            EList eAdapters = newGraph.eAdapters();
            eAdapters.add((Object)this);
            ApuProcesses.reconcileInputs(process, (EList<ApuGraphSource>)newGraph.getGraphSources());
            ApuProcesses.reconcileOutputs(process, (EList<ApuGraphSink>)newGraph.getGraphSinks());
        }
    }

    protected void graphSinksChanged(ApuGraph graph, Notification msg) {
        if (this.target instanceof ApuProcess) {
            ApuProcess process = (ApuProcess)this.target;
            EList graphSinks = graph.getGraphSinks();
            ApuProcesses.reconcileOutputs(process, (EList<ApuGraphSink>)graphSinks);
        }
    }

    protected void graphSourcesChanged(ApuGraph graph, Notification msg) {
        if (this.target instanceof ApuProcess) {
            ApuProcess process = (ApuProcess)this.target;
            EList graphSources = graph.getGraphSources();
            ApuProcesses.reconcileInputs(process, (EList<ApuGraphSource>)graphSources);
        }
    }
}

