/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.apuprogram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ApuCpuType implements Enumerator
{
    UCHAR(0, "uchar", "uchar"),
    CHAR(1, "char", "char"),
    USHORT(2, "ushort", "ushort"),
    SHORT(3, "short", "short"),
    UINT(4, "uint", "uint"),
    INT(5, "int", "int"),
    FLOAT(6, "float", "float"),
    DOUBLE(7, "double", "double");

    public static final int UCHAR_VALUE = 0;
    public static final int CHAR_VALUE = 1;
    public static final int USHORT_VALUE = 2;
    public static final int SHORT_VALUE = 3;
    public static final int UINT_VALUE = 4;
    public static final int INT_VALUE = 5;
    public static final int FLOAT_VALUE = 6;
    public static final int DOUBLE_VALUE = 7;
    private static final ApuCpuType[] VALUES_ARRAY;
    public static final List<ApuCpuType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ApuCpuType[]{UCHAR, CHAR, USHORT, SHORT, UINT, INT, FLOAT, DOUBLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ApuCpuType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApuCpuType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApuCpuType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApuCpuType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApuCpuType get(int value) {
        switch (value) {
            case 0: {
                return UCHAR;
            }
            case 1: {
                return CHAR;
            }
            case 2: {
                return USHORT;
            }
            case 3: {
                return SHORT;
            }
            case 4: {
                return UINT;
            }
            case 5: {
                return INT;
            }
            case 6: {
                return FLOAT;
            }
            case 7: {
                return DOUBLE;
            }
        }
        return null;
    }

    private ApuCpuType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

