/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.actions.ReplaceWithOursTheirsMenu;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.commands.shared.AbortRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.ContinueRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.SkipRebaseCommand;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitJob;
import org.eclipse.egit.ui.internal.commit.CommitMessageHistory;
import org.eclipse.egit.ui.internal.commit.CommitProposalProcessor;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.components.ToggleableWarningLabel;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.egit.ui.internal.decorators.ProblemLabelDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageArea;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponent;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.operations.DeletePathsOperationUI;
import org.eclipse.egit.ui.internal.operations.IgnoreOperationUI;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingViewContentProvider;
import org.eclipse.egit.ui.internal.staging.StagingViewLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

public class StagingView
extends ViewPart
implements IShowInSource,
IShowInTarget {
    public static final String VIEW_ID = "org.eclipse.egit.ui.StagingView";
    private static final String EMPTY_STRING = "";
    private static final String SORT_ITEM_TOOLBAR_ID = "sortItem";
    private static final String EXPAND_ALL_ITEM_TOOLBAR_ID = "expandAllItem";
    private static final String COLLAPSE_ALL_ITEM_TOOLBAR_ID = "collapseAllItem";
    private static final String STORE_SORT_STATE = "sortItemState";
    private static final String HORIZONTAL_SASH_FORM_WEIGHT = "HORIZONTAL_SASH_FORM_WEIGHT";
    private static final String STAGING_SASH_FORM_WEIGHT = "STAGING_SASH_FORM_WEIGHT";
    private ISelection initialSelection;
    private FormToolkit toolkit;
    private Form form;
    private SashForm mainSashForm;
    private Section stagedSection;
    private Section unstagedSection;
    private Section commitMessageSection;
    private TreeViewer stagedViewer;
    private TreeViewer unstagedViewer;
    private ToggleableWarningLabel warningLabel;
    private Text filterText;
    private SpellcheckableMessageArea commitMessageText;
    private Text committerText;
    private Text authorText;
    private CommitMessageComponent commitMessageComponent;
    private boolean reactOnSelection = true;
    private boolean isViewHidden;
    private ISelectionListener selectionChangedListener;
    private IPartListener2 partListener;
    private ToolBarManager unstagedToolBarManager;
    private ToolBarManager stagedToolBarManager;
    private Action listPresentationAction;
    private Action treePresentationAction;
    private Action compactTreePresentationAction;
    private Action unstagedExpandAllAction;
    private Action unstagedCollapseAllAction;
    private Action stagedExpandAllAction;
    private Action stagedCollapseAllAction;
    private Action compareModeAction;
    @Nullable
    private Repository currentRepository;
    private Presentation presentation = Presentation.LIST;
    private Set<IPath> pathsToExpandInStaged = new HashSet<IPath>();
    private Set<IPath> pathsToExpandInUnstaged = new HashSet<IPath>();
    private final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"GitRepositoriesView.GitDirectories.relative".equals(event.getKey())) {
                return;
            }
            Repository repo = StagingView.this.currentRepository;
            if (repo == null) {
                return;
            }
            if (Activator.getDefault().getRepositoryUtil().contains(repo)) {
                return;
            }
            StagingView.this.reload(null);
        }
    };
    private final IPropertyChangeListener uiPrefsListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("commit_dialog_warn_about_message_second_line".equals(event.getProperty())) {
                StagingView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!StagingView.this.commitMessageSection.isDisposed()) {
                            StagingView.this.updateMessage();
                        }
                    }
                });
            }
        }
    };
    private Action signedOffByAction;
    private Action addChangeIdAction;
    private Action amendPreviousCommitAction;
    private Action openNewCommitsAction;
    private Action columnLayoutAction;
    private Action fileNameModeAction;
    private Action refreshAction;
    private Action sortAction;
    private SashForm stagingSashForm;
    private IndexDiffChangedListener myIndexDiffListener = new IndexDiffChangedListener(){

        public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
            StagingView.this.reload(repository);
        }
    };
    private IndexDiffCacheEntry cacheEntry;
    private UndoRedoActionGroup undoRedoActionGroup;
    private Button commitButton;
    private Button commitAndPushButton;
    private Section rebaseSection;
    private Button rebaseContinueButton;
    private Button rebaseSkipButton;
    private Button rebaseAbortButton;
    private Button ignoreErrors;
    private ListenerHandle refsChangedListener;
    private LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
    private boolean disposed;

    private Image getImage(ImageDescriptor descriptor) {
        return (Image)this.resources.get((DeviceResourceDescriptor)descriptor);
    }

    public void init(IViewSite site, IMemento viewMemento) throws PartInitException {
        super.init(site, viewMemento);
        this.initialSelection = site.getWorkbenchWindow().getSelectionService().getSelection();
    }

    public void createPartControl(final Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StagingView.this.commitMessageComponent.isAmending() || StagingView.this.userEnteredCommitMessage()) {
                    StagingView.this.saveCommitMessageComponentState();
                } else {
                    StagingView.this.deleteCommitMessageComponentState();
                }
                StagingView.this.resources.dispose();
                StagingView.this.toolkit.dispose();
            }
        });
        this.form = this.toolkit.createForm(parent);
        parent.addControlListener(new ControlListener(){
            private int[] defaultWeights = new int[]{1, 1};

            public void controlResized(ControlEvent e) {
                Rectangle b = parent.getBounds();
                int oldOrientation = StagingView.this.mainSashForm.getOrientation();
                if (oldOrientation == 256 && b.height > b.width) {
                    StagingView.this.mainSashForm.setOrientation(512);
                    StagingView.this.mainSashForm.setWeights(this.defaultWeights);
                } else if (oldOrientation == 512 && b.height <= b.width) {
                    StagingView.this.mainSashForm.setOrientation(256);
                    StagingView.this.mainSashForm.setWeights(this.defaultWeights);
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.form.setImage(this.getImage(UIIcons.REPOSITORY));
        this.form.setText(UIText.StagingView_NoSelectionTitle);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        this.toolkit.decorateFormHeading(this.form);
        GridLayoutFactory.swtDefaults().applyTo(this.form.getBody());
        this.mainSashForm = new SashForm(this.form.getBody(), 256);
        this.saveSashFormWeightsOnDisposal(this.mainSashForm, HORIZONTAL_SASH_FORM_WEIGHT);
        this.toolkit.adapt((Control)this.mainSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mainSashForm);
        this.stagingSashForm = new SashForm((Composite)this.mainSashForm, this.getStagingFormOrientation());
        this.saveSashFormWeightsOnDisposal(this.stagingSashForm, STAGING_SASH_FORM_WEIGHT);
        this.toolkit.adapt((Control)this.stagingSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.stagingSashForm);
        this.unstagedSection = this.toolkit.createSection((Composite)this.stagingSashForm, 256);
        this.unstagedSection.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createUnstagedToolBarComposite();
        Composite unstagedComposite = this.toolkit.createComposite((Composite)this.unstagedSection);
        this.toolkit.paintBordersFor(unstagedComposite);
        this.unstagedSection.setClient((Control)unstagedComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(unstagedComposite);
        this.unstagedViewer = this.createViewer(unstagedComposite, true, selection -> this.unstage((IStructuredSelection)selection));
        Composite rebaseAndCommitComposite = this.toolkit.createComposite((Composite)this.mainSashForm);
        rebaseAndCommitComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.rebaseSection = this.toolkit.createSection(rebaseAndCommitComposite, 256);
        this.rebaseSection.setText(UIText.StagingView_RebaseLabel);
        Composite rebaseComposite = this.toolkit.createComposite((Composite)this.rebaseSection);
        this.toolkit.paintBordersFor(rebaseComposite);
        this.rebaseSection.setClient((Control)rebaseComposite);
        this.rebaseSection.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        rebaseComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).create());
        GridDataFactory buttonGridData = GridDataFactory.fillDefaults().align(4, 0x1000000);
        this.rebaseAbortButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseAbort, 8);
        this.rebaseAbortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseAbort();
            }
        });
        this.rebaseAbortButton.setImage(this.getImage(UIIcons.REBASE_ABORT));
        buttonGridData.applyTo((Control)this.rebaseAbortButton);
        this.rebaseSkipButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseSkip, 8);
        this.rebaseSkipButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseSkip();
            }
        });
        this.rebaseSkipButton.setImage(this.getImage(UIIcons.REBASE_SKIP));
        buttonGridData.applyTo((Control)this.rebaseSkipButton);
        this.rebaseContinueButton = this.toolkit.createButton(rebaseComposite, UIText.StagingView_RebaseContinue, 8);
        this.rebaseContinueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.rebaseContinue();
            }
        });
        this.rebaseContinueButton.setImage(this.getImage(UIIcons.REBASE_CONTINUE));
        buttonGridData.applyTo((Control)this.rebaseContinueButton);
        StagingView.showControl((Control)this.rebaseSection, false);
        this.commitMessageSection = this.toolkit.createSection(rebaseAndCommitComposite, 256);
        this.commitMessageSection.setText(UIText.StagingView_CommitMessage);
        this.commitMessageSection.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Composite commitMessageToolbarComposite = this.toolkit.createComposite((Composite)this.commitMessageSection);
        commitMessageToolbarComposite.setBackground(null);
        commitMessageToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.commitMessageSection.setTextClient((Control)commitMessageToolbarComposite);
        ToolBarManager commitMessageToolBarManager = new ToolBarManager(0x800100);
        this.amendPreviousCommitAction = new Action(UIText.StagingView_Ammend_Previous_Commit, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setAmendingButtonSelection(this.isChecked());
                StagingView.this.updateMessage();
            }
        };
        this.amendPreviousCommitAction.setImageDescriptor(UIIcons.AMEND_COMMIT);
        commitMessageToolBarManager.add((IAction)this.amendPreviousCommitAction);
        this.signedOffByAction = new Action(UIText.StagingView_Add_Signed_Off_By, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setSignedOffButtonSelection(this.isChecked());
            }
        };
        this.signedOffByAction.setImageDescriptor(UIIcons.SIGNED_OFF);
        commitMessageToolBarManager.add((IAction)this.signedOffByAction);
        this.addChangeIdAction = new Action(UIText.StagingView_Add_Change_ID, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setChangeIdButtonSelection(this.isChecked());
            }
        };
        this.addChangeIdAction.setImageDescriptor(UIIcons.GERRIT);
        commitMessageToolBarManager.add((IAction)this.addChangeIdAction);
        commitMessageToolBarManager.createControl(commitMessageToolbarComposite);
        Composite commitMessageComposite = this.toolkit.createComposite((Composite)this.commitMessageSection);
        this.commitMessageSection.setClient((Control)commitMessageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(commitMessageComposite);
        this.warningLabel = new ToggleableWarningLabel(commitMessageComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).applyTo((Control)this.warningLabel);
        Composite commitMessageTextComposite = this.toolkit.createComposite(commitMessageComposite);
        this.toolkit.paintBordersFor(commitMessageTextComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitMessageTextComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(2, 2, 2, 2).applyTo(commitMessageTextComposite);
        final CommitProposalProcessor commitProposalProcessor = new CommitProposalProcessor(){

            @Override
            protected Collection<String> computeFileNameProposals() {
                return StagingView.this.getStagedFileNames();
            }

            @Override
            protected Collection<String> computeMessageProposals() {
                return CommitMessageHistory.getCommitHistory();
            }
        };
        this.commitMessageText = new CommitMessageArea(commitMessageTextComposite, EMPTY_STRING, this.toolkit.getBorderStyle()){

            @Override
            protected CommitProposalProcessor getCommitProposalProcessor() {
                return commitProposalProcessor;
            }

            @Override
            protected IHandlerService getHandlerService() {
                return CommonUtils.getService((IServiceLocator)StagingView.this.getSite(), IHandlerService.class);
            }
        };
        this.commitMessageText.setData("FormWidgetFactory.drawBorder", "textBorder");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.commitMessageText);
        UIUtils.addBulbDecorator((Control)this.commitMessageText.getTextWidget(), UIText.CommitDialog_ContentAssist);
        Composite composite = this.toolkit.createComposite(commitMessageComposite);
        this.toolkit.paintBordersFor(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        this.toolkit.createLabel(composite, UIText.StagingView_Author).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.authorText = this.toolkit.createText(composite, null);
        this.authorText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.toolkit.createLabel(composite, UIText.StagingView_Committer).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.committerText = this.toolkit.createText(composite, null);
        this.committerText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite buttonsContainer = this.toolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).indent(0, 8).applyTo((Control)buttonsContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonsContainer);
        this.ignoreErrors = this.toolkit.createButton(buttonsContainer, UIText.StagingView_IgnoreErrors, 32);
        this.ignoreErrors.setSelection(false);
        this.ignoreErrors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.updateMessage();
                StagingView.this.updateCommitButtons();
            }
        });
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (StagingView.this.isDisposed()) {
                    StagingView.this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
                    return;
                }
                StagingView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StagingView.this.updateIgnoreErrorsButtonVisibility();
                        StagingView.this.updateMessage();
                        StagingView.this.updateCommitButtons();
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().align(1, 1).grab(true, true).applyTo((Control)this.ignoreErrors);
        this.updateIgnoreErrorsButtonVisibility();
        Label filler = this.toolkit.createLabel(buttonsContainer, EMPTY_STRING);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)filler);
        Composite commitButtonsContainer = this.toolkit.createComposite(buttonsContainer);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)commitButtonsContainer);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(commitButtonsContainer);
        this.commitAndPushButton = this.toolkit.createButton(commitButtonsContainer, UIText.StagingView_CommitAndPush, 8);
        this.commitAndPushButton.setImage(this.getImage(UIIcons.PUSH));
        this.commitAndPushButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.commit(true);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.commitAndPushButton);
        this.commitButton = this.toolkit.createButton(commitButtonsContainer, UIText.StagingView_Commit, 8);
        this.commitButton.setImage(this.getImage(UIIcons.COMMIT));
        this.commitButton.setText(UIText.StagingView_Commit);
        this.commitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StagingView.this.commit(false);
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.commitButton);
        this.stagedSection = this.toolkit.createSection((Composite)this.stagingSashForm, 256);
        this.createStagedToolBarComposite();
        Composite stagedComposite = this.toolkit.createComposite((Composite)this.stagedSection);
        this.toolkit.paintBordersFor(stagedComposite);
        this.stagedSection.setClient((Control)stagedComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(stagedComposite);
        this.stagedViewer = this.createViewer(stagedComposite, false, selection -> this.stage((IStructuredSelection)selection));
        this.stagedViewer.getLabelProvider().addListener(event -> {
            this.updateMessage();
            this.updateCommitButtons();
        });
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part == StagingView.this.getSite().getPart()) {
                    return;
                }
                if (selection instanceof StructuredSelection) {
                    StagingView.this.reactOnSelection((StructuredSelection)selection);
                }
            }
        };
        this.partListener = new PartListener();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore.contains("StagingView_SyncWithSelection")) {
            this.reactOnSelection = preferenceStore.getBoolean("StagingView_SyncWithSelection");
        } else {
            preferenceStore.setDefault("StagingView_SyncWithSelection", true);
        }
        preferenceStore.addPropertyChangeListener(this.uiPrefsListener);
        InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId()).addPreferenceChangeListener(this.prefListener);
        this.updateSectionText();
        this.updateToolbar();
        this.enableCommitWidgets(false);
        this.refreshAction.setEnabled(false);
        this.createPopupMenu(this.unstagedViewer);
        this.createPopupMenu(this.stagedViewer);
        ICommitMessageComponentNotifications listener = new ICommitMessageComponentNotifications(){

            @Override
            public void updateSignedOffToggleSelection(boolean selection) {
                StagingView.this.signedOffByAction.setChecked(selection);
            }

            @Override
            public void updateChangeIdToggleSelection(boolean selection) {
                StagingView.this.addChangeIdAction.setChecked(selection);
                StagingView.this.commitAndPushButton.setImage(StagingView.this.getImage(selection ? UIIcons.GERRIT : UIIcons.PUSH));
            }

            @Override
            public void statusUpdated() {
                StagingView.this.updateMessage();
            }
        };
        this.commitMessageComponent = new CommitMessageComponent(listener);
        this.commitMessageComponent.attachControls(this.commitMessageText, this.authorText, this.committerText);
        this.commitMessageText.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (UIUtils.isSubmitKeyEvent((KeyEvent)event)) {
                    event.doit = false;
                    StagingView.this.commit(false);
                }
            }
        });
        this.commitMessageText.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String commitButtonTooltip = MessageFormat.format(UIText.StagingView_CommitToolTip, UIUtils.SUBMIT_KEY_STROKE.format());
                StagingView.this.commitButton.setToolTipText(commitButtonTooltip);
            }

            public void focusLost(FocusEvent e) {
                StagingView.this.commitButton.setToolTipText(null);
            }
        });
        IWorkbenchPartSite site = this.getSite();
        ISelectionService srv = CommonUtils.getService((IServiceLocator)site, ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        CommonUtils.getService((IServiceLocator)site, IPartService.class).addPartListener(this.partListener);
        UIUtils.notifySelectionChangedWithCurrentSelection(this.selectionChangedListener, (IServiceLocator)site);
        site.setSelectionProvider((ISelectionProvider)this.unstagedViewer);
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                StagingViewContentProvider contentProvider = StagingView.this.getContentProvider((ContentViewer)((TreeViewer)viewer));
                if (element instanceof StagingEntry) {
                    return contentProvider.isInFilter((StagingEntry)element);
                }
                if (element instanceof StagingFolderEntry) {
                    return contentProvider.hasVisibleChildren((StagingFolderEntry)element);
                }
                return true;
            }
        };
        this.unstagedViewer.addFilter(filter);
        this.stagedViewer.addFilter(filter);
        this.restoreSashFormWeights();
        this.reactOnInitialSelection();
        IWorkbenchSiteProgressService service = CommonUtils.getService((IServiceLocator)this.getSite(), IWorkbenchSiteProgressService.class);
        if (service != null && this.reactOnSelection) {
            service.showBusyForFamily(org.eclipse.egit.core.JobFamilies.INDEX_DIFF_CACHE_UPDATE);
        }
    }

    private boolean commitAndPushEnabled(boolean commitEnabled) {
        Repository repo = this.currentRepository;
        if (repo == null) {
            return false;
        }
        return commitEnabled && !repo.getRepositoryState().isRebasing();
    }

    private void updateIgnoreErrorsButtonVisibility() {
        boolean visible = this.getPreferenceStore().getBoolean("checkBeforeCommitting") && this.getPreferenceStore().getBoolean("blockCommit");
        StagingView.showControl((Control)this.ignoreErrors, visible);
        this.mainSashForm.layout();
    }

    private int getProblemsSeverity() {
        StagingEntry[] entries;
        int result = -1;
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)this.stagedViewer);
        StagingEntry[] stagingEntryArray = entries = stagedContentProvider.getStagingEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            if (entry.getProblemSeverity() >= 1 && result < entry.getProblemSeverity()) {
                result = entry.getProblemSeverity();
            }
            ++n2;
        }
        return result;
    }

    private void updateCommitButtons() {
        Repository repo;
        Object indexDiff = this.cacheEntry != null ? this.cacheEntry.getIndexDiff() : ((repo = this.currentRepository) == null ? null : this.doReload(repo));
        boolean indexDiffAvailable = StagingView.indexDiffAvailable(indexDiff);
        boolean noConflicts = StagingView.noConflicts(indexDiff);
        boolean commitEnabled = !this.isCommitBlocked() && noConflicts && indexDiffAvailable;
        boolean commitAndPushEnabled = this.commitAndPushEnabled(commitEnabled);
        this.commitButton.setEnabled(commitEnabled);
        this.commitAndPushButton.setEnabled(commitAndPushEnabled);
    }

    private void saveSashFormWeightsOnDisposal(final SashForm sashForm, final String settingsKey) {
        sashForm.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StagingView.this.getDialogSettings().put(settingsKey, StagingView.intArrayToString(sashForm.getWeights()));
            }
        });
    }

    private IDialogSettings getDialogSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)StagingView.class.getName());
    }

    private static String intArrayToString(int[] ints) {
        StringBuilder res = new StringBuilder();
        if (ints != null && ints.length > 0) {
            res.append(String.valueOf(ints[0]));
            int i = 1;
            while (i < ints.length) {
                res.append(',');
                res.append(String.valueOf(ints[i]));
                ++i;
            }
        }
        return res.toString();
    }

    private void restoreSashFormWeights() {
        this.restoreSashFormWeights(this.mainSashForm, HORIZONTAL_SASH_FORM_WEIGHT);
        this.restoreSashFormWeights(this.stagingSashForm, STAGING_SASH_FORM_WEIGHT);
    }

    private void restoreSashFormWeights(SashForm sashForm, String settingsKey) {
        IDialogSettings settings = this.getDialogSettings();
        String weights = settings.get(settingsKey);
        if (weights != null && !weights.isEmpty()) {
            sashForm.setWeights(StagingView.stringToIntArray(weights));
        }
    }

    private static int[] stringToIntArray(String s) {
        String[] parts = s.split(",");
        int[] ints = new int[parts.length];
        int i = 0;
        while (i < parts.length) {
            ints[i] = Integer.parseInt(parts[i]);
            ++i;
        }
        return ints;
    }

    private void reactOnInitialSelection() {
        StructuredSelection sel = null;
        if (this.initialSelection instanceof StructuredSelection) {
            sel = (StructuredSelection)this.initialSelection;
        } else if (this.initialSelection != null && !this.initialSelection.isEmpty()) {
            sel = this.getSelectionOfActiveEditor();
        }
        if (sel != null) {
            this.reactOnSelection(sel);
        }
        this.initialSelection = null;
    }

    private StructuredSelection getSelectionOfActiveEditor() {
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        return StagingView.getSelectionOfPart((IWorkbenchPart)activeEditor);
    }

    private static StructuredSelection getSelectionOfPart(IWorkbenchPart part) {
        StructuredSelection sel = null;
        if (part instanceof IEditorPart) {
            IResource resource = StagingView.getResource((IEditorPart)part);
            if (resource != null) {
                sel = new StructuredSelection((Object)resource);
            } else {
                Repository repository = StagingView.getRepository((IEditorPart)part);
                if (repository != null) {
                    sel = new StructuredSelection((Object)repository);
                }
            }
        } else {
            ISelection selection = part.getSite().getPage().getSelection();
            if (selection instanceof StructuredSelection) {
                sel = (StructuredSelection)selection;
            }
        }
        return sel;
    }

    @Nullable
    private static Repository getRepository(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (!(input instanceof IURIEditorInput)) {
            return null;
        }
        return (Repository)AdapterUtils.adapt((Object)input, Repository.class);
    }

    private static IResource getResource(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return AdapterUtils.adaptToAnyResource((Object)input);
    }

    private boolean getSortCheckState() {
        return this.getDialogSettings().getBoolean(STORE_SORT_STATE);
    }

    private void executeRebaseOperation(AbstractRebaseCommandHandler command) {
        try {
            command.execute(this.currentRepository);
        }
        catch (ExecutionException e) {
            Activator.showError(e.getMessage(), e);
        }
    }

    protected void rebaseAbort() {
        AbortRebaseCommand abortCommand = new AbortRebaseCommand();
        this.executeRebaseOperation(abortCommand);
    }

    protected void rebaseSkip() {
        SkipRebaseCommand skipCommand = new SkipRebaseCommand();
        this.executeRebaseOperation(skipCommand);
    }

    protected void rebaseContinue() {
        ContinueRebaseCommand continueCommand = new ContinueRebaseCommand();
        this.executeRebaseOperation(continueCommand);
    }

    private void createUnstagedToolBarComposite() {
        Composite unstagedToolbarComposite = this.toolkit.createComposite((Composite)this.unstagedSection);
        unstagedToolbarComposite.setBackground(null);
        unstagedToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.unstagedSection.setTextClient((Control)unstagedToolbarComposite);
        this.unstagedExpandAllAction = new Action(UIText.UIUtils_ExpandAll, 1){

            public void run() {
                StagingView.this.unstagedViewer.expandAll();
                StagingView.enableAutoExpand((AbstractTreeViewer)StagingView.this.unstagedViewer);
            }
        };
        this.unstagedExpandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.unstagedExpandAllAction.setId(EXPAND_ALL_ITEM_TOOLBAR_ID);
        this.unstagedCollapseAllAction = new Action(UIText.UIUtils_CollapseAll, 1){

            public void run() {
                StagingView.this.unstagedViewer.collapseAll();
                StagingView.disableAutoExpand((AbstractTreeViewer)StagingView.this.unstagedViewer);
            }
        };
        this.unstagedCollapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.unstagedCollapseAllAction.setId(COLLAPSE_ALL_ITEM_TOOLBAR_ID);
        this.sortAction = new Action(UIText.StagingView_UnstagedSort, 2){

            public void run() {
                StagingEntryComparator comparator = (StagingEntryComparator)StagingView.this.unstagedViewer.getComparator();
                comparator.setAlphabeticSort(!this.isChecked());
                comparator = (StagingEntryComparator)StagingView.this.stagedViewer.getComparator();
                comparator.setAlphabeticSort(!this.isChecked());
                StagingView.this.unstagedViewer.refresh();
                StagingView.this.stagedViewer.refresh();
            }
        };
        this.sortAction.setImageDescriptor(UIIcons.STATE_SORT);
        this.sortAction.setId(SORT_ITEM_TOOLBAR_ID);
        this.sortAction.setChecked(this.getSortCheckState());
        this.unstagedToolBarManager = new ToolBarManager(0x800100);
        this.unstagedToolBarManager.add((IAction)this.sortAction);
        this.unstagedToolBarManager.add((IAction)this.unstagedExpandAllAction);
        this.unstagedToolBarManager.add((IAction)this.unstagedCollapseAllAction);
        this.unstagedToolBarManager.update(true);
        this.unstagedToolBarManager.createControl(unstagedToolbarComposite);
    }

    private void createStagedToolBarComposite() {
        Composite stagedToolbarComposite = this.toolkit.createComposite((Composite)this.stagedSection);
        stagedToolbarComposite.setBackground(null);
        stagedToolbarComposite.setLayout((Layout)StagingView.createRowLayoutWithoutMargin());
        this.stagedSection.setTextClient((Control)stagedToolbarComposite);
        this.stagedExpandAllAction = new Action(UIText.UIUtils_ExpandAll, 1){

            public void run() {
                StagingView.this.stagedViewer.expandAll();
                StagingView.enableAutoExpand((AbstractTreeViewer)StagingView.this.stagedViewer);
            }
        };
        this.stagedExpandAllAction.setImageDescriptor(UIIcons.EXPAND_ALL);
        this.stagedExpandAllAction.setId(EXPAND_ALL_ITEM_TOOLBAR_ID);
        this.stagedCollapseAllAction = new Action(UIText.UIUtils_CollapseAll, 1){

            public void run() {
                StagingView.this.stagedViewer.collapseAll();
                StagingView.disableAutoExpand((AbstractTreeViewer)StagingView.this.stagedViewer);
            }
        };
        this.stagedCollapseAllAction.setImageDescriptor(UIIcons.COLLAPSEALL);
        this.stagedCollapseAllAction.setId(COLLAPSE_ALL_ITEM_TOOLBAR_ID);
        this.stagedToolBarManager = new ToolBarManager(0x800100);
        this.stagedToolBarManager.add((IAction)this.stagedExpandAllAction);
        this.stagedToolBarManager.add((IAction)this.stagedCollapseAllAction);
        this.stagedToolBarManager.update(true);
        this.stagedToolBarManager.createControl(stagedToolbarComposite);
    }

    private static RowLayout createRowLayoutWithoutMargin() {
        RowLayout layout = new RowLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        return layout;
    }

    private static void addListenerToDisableAutoExpandOnCollapse(TreeViewer treeViewer) {
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                StagingView.disableAutoExpand(event.getTreeViewer());
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
    }

    private static void enableAutoExpand(AbstractTreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(-1);
    }

    private static void disableAutoExpand(AbstractTreeViewer treeViewer) {
        treeViewer.setAutoExpandLevel(0);
    }

    public Repository getCurrentRepository() {
        return this.currentRepository;
    }

    public ShowInContext getShowInContext() {
        if (this.stagedViewer != null && this.stagedViewer.getTree().isFocusControl()) {
            return this.getShowInContext(this.stagedViewer);
        }
        if (this.unstagedViewer != null && this.unstagedViewer.getTree().isFocusControl()) {
            return this.getShowInContext(this.unstagedViewer);
        }
        return null;
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof RepositoryTreeNode)) continue;
                RepositoryTreeNode node = (RepositoryTreeNode)element;
                this.reload(node.getRepository());
                return true;
            }
        }
        return false;
    }

    private ShowInContext getShowInContext(TreeViewer treeViewer) {
        IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object selectedElement : selection.toList()) {
            IProblemDecoratable entry;
            if (selectedElement instanceof StagingEntry) {
                entry = (StagingEntry)selectedElement;
                IFile file = ((StagingEntry)entry).getFile();
                if (file != null) {
                    elements.add(file);
                    continue;
                }
                elements.add(((StagingEntry)entry).getLocation());
                continue;
            }
            if (!(selectedElement instanceof StagingFolderEntry)) continue;
            entry = (StagingFolderEntry)selectedElement;
            IContainer container = ((StagingFolderEntry)entry).getContainer();
            if (container != null) {
                elements.add(container);
                continue;
            }
            elements.add(((StagingFolderEntry)entry).getLocation());
        }
        return new ShowInContext(null, (ISelection)new StructuredSelection(elements));
    }

    private int getStagingFormOrientation() {
        boolean columnLayout = Activator.getDefault().getPreferenceStore().getBoolean("StagingView_ColumnLayout");
        if (columnLayout) {
            return 256;
        }
        return 512;
    }

    private void enableAllWidgets(boolean enabled) {
        if (this.isDisposed()) {
            return;
        }
        this.enableCommitWidgets(enabled);
        this.commitMessageText.setEnabled(enabled);
        this.enableStagingWidgets(enabled);
    }

    private void enableStagingWidgets(boolean enabled) {
        if (this.isDisposed()) {
            return;
        }
        this.unstagedViewer.getControl().setEnabled(enabled);
        this.stagedViewer.getControl().setEnabled(enabled);
    }

    private void enableCommitWidgets(boolean enabled) {
        if (this.isDisposed()) {
            return;
        }
        this.committerText.setEnabled(enabled);
        this.enableAuthorText(enabled);
        this.amendPreviousCommitAction.setEnabled(enabled);
        this.signedOffByAction.setEnabled(enabled);
        this.addChangeIdAction.setEnabled(enabled);
        this.commitButton.setEnabled(enabled);
        this.commitAndPushButton.setEnabled(enabled);
    }

    private void enableAuthorText(boolean enabled) {
        Repository repo = this.currentRepository;
        if (repo != null && repo.getRepositoryState().equals((Object)RepositoryState.CHERRY_PICKING_RESOLVED)) {
            this.authorText.setEnabled(false);
        } else {
            this.authorText.setEnabled(enabled);
        }
    }

    private void updateToolbar() {
        ControlContribution controlContribution = new ControlContribution("StagingView.searchText"){

            protected Control createControl(Composite parent) {
                Composite toolbarComposite = StagingView.this.toolkit.createComposite(parent, 0);
                toolbarComposite.setBackground(null);
                GridLayout headLayout = new GridLayout();
                headLayout.numColumns = 2;
                headLayout.marginHeight = 0;
                headLayout.marginWidth = 0;
                headLayout.marginTop = 0;
                headLayout.marginBottom = 0;
                headLayout.marginLeft = 0;
                headLayout.marginRight = 0;
                toolbarComposite.setLayout((Layout)headLayout);
                StagingView.this.filterText = new Text(toolbarComposite, 896);
                StagingView.this.filterText.setMessage(UIText.StagingView_Find);
                GridData data = new GridData(768);
                data.widthHint = 150;
                StagingView.this.filterText.setLayoutData((Object)data);
                final Display display = Display.getCurrent();
                StagingView.this.filterText.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        final StagingViewSearchThread searchThread = new StagingViewSearchThread(StagingView.this);
                        display.timerExec(200, new Runnable(){

                            @Override
                            public void run() {
                                searchThread.start();
                            }
                        });
                    }
                });
                return toolbarComposite;
            }
        };
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IContributionItem)controlContribution);
        this.refreshAction = new Action(UIText.StagingView_Refresh, 1){

            public void run() {
                if (StagingView.this.cacheEntry != null) {
                    StagingView.this.schedule(StagingView.this.cacheEntry.createRefreshResourcesAndIndexDiffJob(), false);
                }
            }
        };
        this.refreshAction.setImageDescriptor(UIIcons.ELCL16_REFRESH);
        toolbar.add((IAction)this.refreshAction);
        BooleanPrefAction linkSelectionAction = new BooleanPrefAction((IPersistentPreferenceStore)this.getPreferenceStore(), "StagingView_SyncWithSelection", UIText.StagingView_LinkSelection){

            @Override
            public void apply(boolean value) {
                StagingView.this.reactOnSelection = value;
            }
        };
        linkSelectionAction.setImageDescriptor(UIIcons.ELCL16_SYNCED);
        toolbar.add((IAction)linkSelectionAction);
        toolbar.add((IContributionItem)new Separator());
        this.compareModeAction = new Action(UIText.StagingView_CompareMode, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_CompareMode", this.isChecked());
            }
        };
        this.compareModeAction.setImageDescriptor(UIIcons.ELCL16_COMPARE_VIEW);
        this.compareModeAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_CompareMode"));
        toolbar.add((IAction)this.compareModeAction);
        toolbar.add((IContributionItem)new Separator());
        this.openNewCommitsAction = new Action(UIText.StagingView_OpenNewCommits, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ShowNewCommits", this.isChecked());
            }
        };
        this.openNewCommitsAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ShowNewCommits"));
        this.columnLayoutAction = new Action(UIText.StagingView_ColumnLayout, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ColumnLayout", this.isChecked());
                StagingView.this.stagingSashForm.setOrientation(this.isChecked() ? 256 : 512);
            }
        };
        this.columnLayoutAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ColumnLayout"));
        this.fileNameModeAction = new Action(UIText.StagingView_ShowFileNamesFirst, 2){

            public void run() {
                boolean enable = this.isChecked();
                StagingView.this.getLabelProvider((ContentViewer)StagingView.this.stagedViewer).setFileNameMode(enable);
                StagingView.this.getLabelProvider((ContentViewer)StagingView.this.unstagedViewer).setFileNameMode(enable);
                StagingView.this.getContentProvider((ContentViewer)StagingView.this.stagedViewer).setFileNameMode(enable);
                StagingView.this.getContentProvider((ContentViewer)StagingView.this.unstagedViewer).setFileNameMode(enable);
                StagingEntryComparator comparator = (StagingEntryComparator)StagingView.this.unstagedViewer.getComparator();
                comparator.setFileNamesFirst(enable);
                comparator = (StagingEntryComparator)StagingView.this.stagedViewer.getComparator();
                comparator.setFileNamesFirst(enable);
                StagingView.this.getPreferenceStore().setValue("StagingView_FileNameMode", enable);
                StagingView.this.refreshViewersPreservingExpandedElements();
            }
        };
        this.fileNameModeAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        IMenuManager dropdownMenu = actionBars.getMenuManager();
        MenuManager presentationMenu = new MenuManager(UIText.StagingView_Presentation);
        this.listPresentationAction = new Action(UIText.StagingView_List, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                StagingView.this.switchToListMode();
                StagingView.this.refreshViewers();
            }
        };
        this.listPresentationAction.setImageDescriptor(UIIcons.FLAT);
        presentationMenu.add((IAction)this.listPresentationAction);
        this.treePresentationAction = new Action(UIText.StagingView_Tree, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                StagingView.this.presentation = Presentation.TREE;
                StagingView.this.setPresentation(StagingView.this.presentation, false);
                StagingView.this.listPresentationAction.setChecked(false);
                StagingView.this.compactTreePresentationAction.setChecked(false);
                StagingView.this.setExpandCollapseActionsVisible(false, StagingView.this.isExpandAllowed(false), true);
                StagingView.this.setExpandCollapseActionsVisible(true, StagingView.this.isExpandAllowed(true), true);
                StagingView.this.refreshViewers();
            }
        };
        this.treePresentationAction.setImageDescriptor(UIIcons.HIERARCHY);
        presentationMenu.add((IAction)this.treePresentationAction);
        this.compactTreePresentationAction = new Action(UIText.StagingView_CompactTree, 8){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                StagingView.this.switchToCompactModeInternal(false);
                StagingView.this.refreshViewers();
            }
        };
        this.compactTreePresentationAction.setImageDescriptor(UIIcons.COMPACT);
        presentationMenu.add((IAction)this.compactTreePresentationAction);
        this.presentation = this.readPresentation("StagingView_Presentation", Presentation.LIST);
        switch (this.presentation) {
            case LIST: {
                this.listPresentationAction.setChecked(true);
                this.setExpandCollapseActionsVisible(false, false, false);
                this.setExpandCollapseActionsVisible(true, false, false);
                break;
            }
            case TREE: {
                this.treePresentationAction.setChecked(true);
                break;
            }
            case COMPACT_TREE: {
                this.compactTreePresentationAction.setChecked(true);
                break;
            }
        }
        dropdownMenu.add((IContributionItem)presentationMenu);
        dropdownMenu.add((IContributionItem)new Separator());
        dropdownMenu.add((IAction)this.openNewCommitsAction);
        dropdownMenu.add((IAction)this.columnLayoutAction);
        dropdownMenu.add((IAction)this.fileNameModeAction);
        dropdownMenu.add((IAction)this.compareModeAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new GlobalDeleteActionHandler());
        IUndoContext workspaceContext = (IUndoContext)AdapterUtils.adapt((Object)ResourcesPlugin.getWorkspace(), IUndoContext.class);
        this.undoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)this.getViewSite(), workspaceContext, true);
        this.undoRedoActionGroup.fillActionBars(actionBars);
        actionBars.updateActionBars();
    }

    private Presentation readPresentation(String key, Presentation def) {
        String presentationString = this.getPreferenceStore().getString(key);
        if (presentationString.length() > 0) {
            try {
                return Presentation.valueOf(presentationString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return def;
    }

    private void setPresentation(Presentation newOne, boolean auto) {
        Presentation old = this.presentation;
        this.presentation = newOne;
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("StagingView_Presentation", newOne.name());
        if (auto && old != newOne) {
            store.setValue("StagingView_Presentation_Changed", true);
        } else {
            store.setToDefault("StagingView_Presentation_Changed");
        }
    }

    private void setExpandCollapseActionsVisible(boolean staged, boolean visibleExpandAll, boolean visibleCollapseAll) {
        ToolBarManager toolBarManager = staged ? this.stagedToolBarManager : this.unstagedToolBarManager;
        IContributionItem[] iContributionItemArray = toolBarManager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            String id = item.getId();
            if (EXPAND_ALL_ITEM_TOOLBAR_ID.equals(id)) {
                item.setVisible(visibleExpandAll);
            } else if (COLLAPSE_ALL_ITEM_TOOLBAR_ID.equals(id)) {
                item.setVisible(visibleCollapseAll);
            }
            ++n2;
        }
        (staged ? this.stagedExpandAllAction : this.unstagedExpandAllAction).setEnabled(visibleExpandAll);
        (staged ? this.stagedCollapseAllAction : this.unstagedCollapseAllAction).setEnabled(visibleCollapseAll);
        toolBarManager.update(true);
    }

    private boolean isExpandAllowed(boolean staged) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)(staged ? this.stagedViewer : this.unstagedViewer));
        return contentProvider.getCount() <= this.getMaxLimitForListMode();
    }

    private TreeViewer createTree(Composite composite) {
        Tree tree = this.toolkit.createTree(composite, 65538);
        TreeViewer treeViewer = new TreeViewer(tree);
        return treeViewer;
    }

    private IBaseLabelProvider createLabelProvider(TreeViewer treeViewer) {
        StagingViewLabelProvider baseProvider = new StagingViewLabelProvider(this);
        baseProvider.setFileNameMode(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        ProblemLabelDecorator decorator = new ProblemLabelDecorator((StructuredViewer)treeViewer);
        return new TreeDecoratingLabelProvider((ILabelProvider)baseProvider, decorator);
    }

    private StagingViewContentProvider createStagingContentProvider(boolean unstaged) {
        StagingViewContentProvider provider = new StagingViewContentProvider(this, unstaged);
        provider.setFileNameMode(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        return provider;
    }

    private TreeViewer createViewer(Composite parent, final boolean unstaged, final Consumer<IStructuredSelection> dropAction) {
        TreeViewer viewer = this.createTree(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
        viewer.getTree().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        viewer.setLabelProvider(this.createLabelProvider(viewer));
        StagingViewContentProvider contentProvider = this.createStagingContentProvider(unstaged);
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new StagingDragListener((ISelectionProvider)viewer, contentProvider, unstaged));
        viewer.addDropSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                event.detail = 1;
                if (event.data instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.data;
                    if (selection instanceof StagingDragSelection && ((StagingDragSelection)selection).isFromUnstaged() == unstaged) {
                        return;
                    }
                    dropAction.accept(selection);
                }
            }
        });
        viewer.addOpenListener(event -> this.compareWith(event));
        viewer.setComparator((ViewerComparator)new StagingEntryComparator(this.getSortCheckState(), this.getPreferenceStore().getBoolean("StagingView_FileNameMode")));
        StagingView.enableAutoExpand((AbstractTreeViewer)viewer);
        StagingView.addListenerToDisableAutoExpandOnCollapse(viewer);
        return viewer;
    }

    private void setStagingViewerInput(TreeViewer stagingViewer, StagingViewUpdate newInput, Object[] previous, Set<IPath> additionalPaths) {
        final Tree tree = stagingViewer.getTree();
        tree.setRedraw(false);
        Cursor oldCursor = tree.getCursor();
        tree.setCursor(tree.getDisplay().getSystemCursor(1));
        try {
            TreeItem topItem = tree.getTopItem();
            final LinkedHashSet precedingObjects = new LinkedHashSet();
            if (topItem != null) {
                new TreeItemVisitor(tree.getItems()){

                    @Override
                    public boolean visit(TreeItem treeItem) {
                        precedingObjects.add(treeItem.getData());
                        return true;
                    }
                }.traverse(topItem);
                precedingObjects.remove(null);
            }
            boolean preserveTop = true;
            boolean keepSelectionVisible = false;
            StagingViewUpdate oldInput = (StagingViewUpdate)stagingViewer.getInput();
            if (oldInput != null && oldInput.repository == newInput.repository && oldInput.indexDiff != null) {
                StagingViewerUpdate stagingViewerUpdate;
                StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)stagingViewer);
                ViewerComparator comparator = stagingViewer.getComparator();
                Map<String, Object> oldPaths = StagingView.buildElementMap(stagingViewer, contentProvider, comparator);
                stagingViewer.setInput((Object)newInput);
                if (previous != null) {
                    this.expandPreviousExpandedAndPaths(previous, stagingViewer, additionalPaths);
                }
                if ((stagingViewerUpdate = StagingView.updateSelection(stagingViewer, contentProvider, oldPaths, StagingView.buildElementMap(stagingViewer, contentProvider, comparator))) == StagingViewerUpdate.REMOVED) {
                    keepSelectionVisible = true;
                } else if (stagingViewerUpdate == StagingViewerUpdate.ADDED) {
                    preserveTop = false;
                }
            } else {
                stagingViewer.setInput((Object)newInput);
                if (previous != null) {
                    this.expandPreviousExpandedAndPaths(previous, stagingViewer, additionalPaths);
                }
            }
            if (preserveTop) {
                TreeItem[] selection = tree.getSelection();
                TreeItem initialItem = keepSelectionVisible && selection.length > 0 ? selection[0] : null;
                new TreeItemVisitor(tree.getItems()){

                    @Override
                    public boolean visit(TreeItem treeItem) {
                        if (precedingObjects.contains(treeItem.getData())) {
                            tree.setTopItem(treeItem);
                            return false;
                        }
                        return true;
                    }
                }.traverse(initialItem);
            }
        }
        finally {
            tree.setRedraw(true);
            tree.setCursor(oldCursor);
        }
    }

    private static Map<String, Object> buildElementMap(TreeViewer stagingViewer, StagingViewContentProvider contentProvider, ViewerComparator comparator) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object[] elements = contentProvider.getElements(null);
        comparator.sort((Viewer)stagingViewer, elements);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            StagingView.visitElement(stagingViewer, contentProvider, comparator, element, result);
            ++n2;
        }
        return result;
    }

    private static boolean visitElement(TreeViewer stagingViewer, StagingViewContentProvider contentProvider, ViewerComparator comparator, Object element, Map<String, Object> paths) {
        if (element instanceof StagingEntry) {
            StagingEntry stagingEntry = (StagingEntry)element;
            if (contentProvider.isInFilter(stagingEntry)) {
                String path = stagingEntry.getPath();
                paths.put(path, stagingEntry);
                return true;
            }
            return false;
        }
        if (element instanceof StagingFolderEntry) {
            StagingFolderEntry stagingFolderEntry = (StagingFolderEntry)element;
            Object[] children = contentProvider.getChildren(stagingFolderEntry);
            comparator.sort((Viewer)stagingViewer, children);
            IPath path = stagingFolderEntry.getPath();
            String pathString = path.toString();
            paths.put(pathString, stagingFolderEntry);
            boolean hasVisibleChildren = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (StagingView.visitElement(stagingViewer, contentProvider, comparator, child, paths)) {
                    hasVisibleChildren = true;
                }
                ++n2;
            }
            if (hasVisibleChildren) {
                return true;
            }
            paths.remove(pathString);
            return false;
        }
        return false;
    }

    private static StagingViewerUpdate updateSelection(TreeViewer stagingViewer, StagingViewContentProvider contentProvider, Map<String, Object> oldPaths, Map<String, Object> newPaths) {
        LinkedHashMap<String, Object> addedPaths = new LinkedHashMap<String, Object>(newPaths);
        addedPaths.keySet().removeAll(oldPaths.keySet());
        if (!addedPaths.isEmpty()) {
            ArrayList<IProblemDecoratable> newSelection = new ArrayList<IProblemDecoratable>();
            LinkedHashSet elements = new LinkedHashSet(addedPaths.values());
            LinkedHashSet<StagingFolderEntry> excludeChildren = new LinkedHashSet<StagingFolderEntry>();
            for (Object element : elements) {
                if (element instanceof StagingEntry) {
                    StagingEntry stagingEntry = (StagingEntry)element;
                    if (excludeChildren.contains(stagingEntry.getParent())) continue;
                    newSelection.add(stagingEntry);
                    continue;
                }
                if (!(element instanceof StagingFolderEntry)) continue;
                StagingFolderEntry stagingFolderEntry = (StagingFolderEntry)element;
                StagingFolderEntry parent = stagingFolderEntry.getParent();
                if (excludeChildren.contains(parent)) {
                    excludeChildren.add(stagingFolderEntry);
                    continue;
                }
                if (!elements.containsAll(contentProvider.getStagingEntriesFiltered(stagingFolderEntry))) continue;
                newSelection.add(stagingFolderEntry);
                excludeChildren.add(stagingFolderEntry);
            }
            stagingViewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
            return StagingViewerUpdate.ADDED;
        }
        LinkedHashMap<String, Object> removedPaths = new LinkedHashMap<String, Object>(oldPaths);
        removedPaths.keySet().removeAll(newPaths.keySet());
        if (!removedPaths.isEmpty()) {
            Collection removedElements = removedPaths.values();
            Object firstRemovedElement = removedElements.iterator().next();
            Object parent = contentProvider.getParent(firstRemovedElement);
            Object candidate = null;
            boolean visitSubsequentSiblings = false;
            for (Object oldElement : oldPaths.values()) {
                if (oldElement == firstRemovedElement) {
                    visitSubsequentSiblings = true;
                }
                if (visitSubsequentSiblings) {
                    if (removedElements.contains(oldElement)) continue;
                    if (contentProvider.getParent(oldElement) == parent) {
                        candidate = oldElement;
                        break;
                    }
                    if (candidate == null) continue;
                    break;
                }
                if (candidate != null && oldElement != parent && contentProvider.getParent(oldElement) != parent) continue;
                candidate = oldElement;
            }
            if (candidate == null && !newPaths.isEmpty()) {
                candidate = newPaths.values().iterator().next();
            }
            if (candidate != null) {
                stagingViewer.setSelection((ISelection)new StructuredSelection(candidate), true);
                return StagingViewerUpdate.REMOVED;
            }
        }
        return StagingViewerUpdate.UNCHANGED;
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private StagingViewLabelProvider getLabelProvider(ContentViewer viewer) {
        IBaseLabelProvider base = viewer.getLabelProvider();
        ILabelProvider labelProvider = ((TreeDecoratingLabelProvider)base).getLabelProvider();
        return (StagingViewLabelProvider)labelProvider;
    }

    private StagingViewContentProvider getContentProvider(ContentViewer viewer) {
        return (StagingViewContentProvider)viewer.getContentProvider();
    }

    private void updateSectionText() {
        this.stagedSection.setText(MessageFormat.format(UIText.StagingView_StagedChanges, this.getSectionCount(this.stagedViewer)));
        this.unstagedSection.setText(MessageFormat.format(UIText.StagingView_UnstagedChanges, this.getSectionCount(this.unstagedViewer)));
    }

    private String getSectionCount(TreeViewer viewer) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)viewer);
        int count = contentProvider.getCount();
        int shownCount = contentProvider.getShownCount();
        if (shownCount == count) {
            return Integer.toString(count);
        }
        return String.valueOf(shownCount) + "/" + count;
    }

    private void updateMessage() {
        if (this.hasErrorsOrWarnings()) {
            this.warningLabel.showMessage(UIText.StagingView_MessageErrors);
            this.commitMessageSection.redraw();
        } else {
            String message = this.commitMessageComponent.getStatus().getMessage();
            boolean needsRedraw = false;
            if (message != null) {
                this.warningLabel.showMessage(message);
                needsRedraw = true;
            } else {
                needsRedraw = this.warningLabel.getVisible();
                this.warningLabel.hideMessage();
            }
            if (needsRedraw) {
                this.commitMessageSection.redraw();
            }
        }
    }

    private void compareWith(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof StagingEntry)) {
            return;
        }
        StagingEntry stagingEntry = (StagingEntry)selection.getFirstElement();
        if (stagingEntry.isSubmodule()) {
            return;
        }
        switch (stagingEntry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareIndexWithHead", selection);
                break;
            }
            case CONFLICTING: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.MergeTool", selection);
                break;
            }
            default: {
                if (Activator.getDefault().getPreferenceStore().getBoolean("StagingView_CompareMode")) {
                    CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareWithIndex", selection);
                    break;
                }
                this.openSelectionInEditor((ISelection)selection);
            }
        }
    }

    private void createPopupMenu(final TreeViewer treeViewer) {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Control control = treeViewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                final IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                LinkedHashSet<StagingEntry> stagingEntrySet = new LinkedHashSet<StagingEntry>();
                LinkedHashSet<StagingFolderEntry> stagingFolderSet = new LinkedHashSet<StagingFolderEntry>();
                boolean submoduleSelected = false;
                boolean folderSelected = false;
                boolean onlyFoldersSelected = true;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof StagingFolderEntry) {
                        StagingFolderEntry folder = (StagingFolderEntry)element;
                        folderSelected = true;
                        if (onlyFoldersSelected) {
                            stagingFolderSet.add(folder);
                        }
                        StagingViewContentProvider contentProvider = StagingView.this.getContentProvider((ContentViewer)treeViewer);
                        stagingEntrySet.addAll(contentProvider.getStagingEntriesFiltered(folder));
                    } else if (element instanceof StagingEntry) {
                        if (onlyFoldersSelected) {
                            stagingFolderSet.clear();
                        }
                        onlyFoldersSelected = false;
                        StagingEntry entry = (StagingEntry)element;
                        if (entry.isSubmodule()) {
                            submoduleSelected = true;
                        }
                        stagingEntrySet.add(entry);
                    }
                    ++n2;
                }
                ArrayList stagingEntryList = new ArrayList(stagingEntrySet);
                StructuredSelection fileSelection = new StructuredSelection(stagingEntryList);
                stagingEntrySet = null;
                if (!folderSelected) {
                    Action openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel, (IStructuredSelection)fileSelection){
                        private final /* synthetic */ IStructuredSelection val$fileSelection;
                        {
                            this.val$fileSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            StagingView.this.openSelectionInEditor((ISelection)this.val$fileSelection);
                        }
                    };
                    openWorkingTreeVersion.setEnabled(!submoduleSelected && StagingView.this.anyElementIsExistingFile((IStructuredSelection)fileSelection));
                    menuMgr.add((IAction)openWorkingTreeVersion);
                    String label = ((StagingEntry)stagingEntryList.get(0)).isStaged() ? UIText.CommitFileDiffViewer_CompareWorkingDirectoryMenuLabel : UIText.StagingView_CompareWithIndexMenuLabel;
                    Action openCompareWithIndex = new Action(label, (IStructuredSelection)fileSelection){
                        private final /* synthetic */ IStructuredSelection val$fileSelection;
                        {
                            this.val$fileSelection = iStructuredSelection;
                            super($anonymous0);
                        }

                        public void run() {
                            CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareWithIndex", this.val$fileSelection);
                        }
                    };
                    menuMgr.add((IAction)openCompareWithIndex);
                }
                Set availableActions = StagingView.getAvailableActions((IStructuredSelection)fileSelection);
                boolean addReplaceWithFileInGitIndex = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_FILE_IN_GIT_INDEX);
                boolean addReplaceWithHeadRevision = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_HEAD_REVISION);
                boolean addStage = availableActions.contains((Object)StagingEntry.Action.STAGE);
                boolean addUnstage = availableActions.contains((Object)StagingEntry.Action.UNSTAGE);
                boolean addDelete = availableActions.contains((Object)StagingEntry.Action.DELETE);
                boolean addIgnore = availableActions.contains((Object)StagingEntry.Action.IGNORE);
                boolean addLaunchMergeTool = availableActions.contains((Object)StagingEntry.Action.LAUNCH_MERGE_TOOL);
                boolean addReplaceWithOursTheirsMenu = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_OURS_THEIRS_MENU);
                if (addStage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_StageItemMenuLabel){

                        public void run() {
                            StagingView.this.stage(selection);
                        }
                    });
                }
                if (addUnstage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_UnstageItemMenuLabel){

                        public void run() {
                            StagingView.this.unstage(selection);
                        }
                    });
                }
                boolean selectionIncludesNonWorkspaceResources = StagingView.this.selectionIncludesNonWorkspaceResources((ISelection)fileSelection);
                if (addReplaceWithFileInGitIndex) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithFileInGitIndex, (IStructuredSelection)fileSelection, false));
                    } else {
                        menuMgr.add(StagingView.this.createItem(UIText.StagingView_replaceWithFileInGitIndex, "org.eclipse.egit.ui.team.Discard", (IStructuredSelection)fileSelection));
                    }
                }
                if (addReplaceWithHeadRevision) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithHeadRevision, (IStructuredSelection)fileSelection, true));
                    } else {
                        menuMgr.add(StagingView.this.createItem(UIText.StagingView_replaceWithHeadRevision, "org.eclipse.egit.ui.team.ReplaceWithHead", (IStructuredSelection)fileSelection));
                    }
                }
                if (addIgnore) {
                    if (!stagingFolderSet.isEmpty()) {
                        menuMgr.add((IAction)new IgnoreFoldersAction(stagingFolderSet));
                    }
                    menuMgr.add((IAction)new IgnoreAction((IStructuredSelection)fileSelection));
                }
                if (addDelete) {
                    menuMgr.add((IAction)new DeleteAction((IStructuredSelection)fileSelection));
                }
                if (addLaunchMergeTool) {
                    menuMgr.add(StagingView.this.createItem(UIText.StagingView_MergeTool, "org.eclipse.egit.ui.team.MergeTool", (IStructuredSelection)fileSelection));
                }
                if (addReplaceWithOursTheirsMenu) {
                    MenuManager replaceWithMenu = new MenuManager(UIText.StagingView_ReplaceWith);
                    ReplaceWithOursTheirsMenu oursTheirsMenu = new ReplaceWithOursTheirsMenu();
                    oursTheirsMenu.initialize((IServiceLocator)StagingView.this.getSite());
                    replaceWithMenu.add((IContributionItem)oursTheirsMenu);
                    menuMgr.add((IContributionItem)replaceWithMenu);
                }
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add(StagingView.this.createShowInMenu());
            }
        });
    }

    private boolean anyElementIsExistingFile(IStructuredSelection s) {
        for (Object element : s.toList()) {
            StagingEntry entry;
            if (!(element instanceof StagingEntry) || (entry = (StagingEntry)element).getType() != 1 || !entry.getLocation().toFile().exists()) continue;
            return true;
        }
        return false;
    }

    Presentation getPresentation() {
        return this.presentation;
    }

    String getFilterString() {
        if (this.filterText != null && !this.filterText.isDisposed()) {
            return this.filterText.getText().trim();
        }
        return EMPTY_STRING;
    }

    public void refreshViewers() {
        StagingView.syncExec(new Runnable(){

            @Override
            public void run() {
                StagingView.this.refreshViewersInternal();
            }
        });
    }

    public void refreshViewersPreservingExpandedElements() {
        StagingView.syncExec(new Runnable(){

            @Override
            public void run() {
                Object[] unstagedExpanded = StagingView.this.unstagedViewer.getVisibleExpandedElements();
                Object[] stagedExpanded = StagingView.this.stagedViewer.getVisibleExpandedElements();
                StagingView.this.refreshViewersInternal();
                StagingView.this.unstagedViewer.setExpandedElements(unstagedExpanded);
                StagingView.this.stagedViewer.setExpandedElements(stagedExpanded);
            }
        });
    }

    private void refreshViewersInternal() {
        this.unstagedViewer.refresh();
        this.stagedViewer.refresh();
        this.updateSectionText();
    }

    private IContributionItem createShowInMenu() {
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        return UIUtils.createShowInMenu(workbenchWindow);
    }

    private static List<IPath> getSelectedPaths(IStructuredSelection selection) {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        for (StagingEntry stagingEntry : selection) {
            paths.add(stagingEntry.getLocation());
        }
        return paths;
    }

    private boolean selectionIncludesNonWorkspaceResources(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object selectedObject : structuredSelection) {
            if (!(selectedObject instanceof StagingEntry)) {
                return false;
            }
            StagingEntry stagingEntry = (StagingEntry)selectedObject;
            IFile file = stagingEntry.getFile();
            if (file != null && file.isAccessible()) continue;
            return true;
        }
        return false;
    }

    private void openSelectionInEditor(ISelection s) {
        Repository repo = this.currentRepository;
        if (repo == null || s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        for (Object element : iss.toList()) {
            if (!(element instanceof StagingEntry)) continue;
            StagingEntry entry = (StagingEntry)element;
            String relativePath = entry.getPath();
            File file = new Path(repo.getWorkTree().getAbsolutePath()).append(relativePath).toFile();
            DiffViewer.openFileInEditor(file, -1);
        }
    }

    private static Set<StagingEntry.Action> getAvailableActions(IStructuredSelection selection) {
        EnumSet<StagingEntry.Action> availableActions = EnumSet.noneOf(StagingEntry.Action.class);
        for (StagingEntry stagingEntry : selection) {
            if (availableActions.isEmpty()) {
                availableActions.addAll(stagingEntry.getAvailableActions());
                continue;
            }
            availableActions.retainAll(stagingEntry.getAvailableActions());
        }
        return availableActions;
    }

    private IAction createItem(String text, final String commandId, final IStructuredSelection selection) {
        return new Action(text){

            public void run() {
                CommonUtils.runCommand(commandId, selection);
            }
        };
    }

    private boolean shouldUpdateSelection() {
        return !this.isDisposed() && !this.isViewHidden && this.reactOnSelection;
    }

    private void reactOnSelection(StructuredSelection selection) {
        if (selection.size() != 1 || !this.shouldUpdateSelection()) {
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof RepositoryTreeNode) {
            RepositoryTreeNode repoNode = (RepositoryTreeNode)firstElement;
            if (this.currentRepository != repoNode.getRepository()) {
                this.reload(repoNode.getRepository());
            }
        } else if (firstElement instanceof Repository) {
            Repository repo = (Repository)firstElement;
            if (this.currentRepository != repo) {
                this.reload(repo);
            }
        } else {
            Repository repo = (Repository)AdapterUtils.adapt((Object)firstElement, Repository.class);
            if (repo != null) {
                if (this.currentRepository != repo) {
                    this.reload(repo);
                }
            } else {
                IResource resource = AdapterUtils.adaptToAnyResource((Object)firstElement);
                if (resource != null) {
                    this.showResource(resource);
                }
            }
        }
    }

    private void showResource(final IResource resource) {
        if (resource == null || !resource.isAccessible()) {
            return;
        }
        Job.getJobManager().cancel(JobFamilies.UPDATE_SELECTION);
        Job job = new Job(UIText.StagingView_GetRepo){

            protected IStatus run(IProgressMonitor monitor) {
                Repository newRep;
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
                if (mapping != null && (newRep = mapping.getRepository()) != null && newRep != StagingView.this.currentRepository) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    StagingView.this.reload(newRep);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.UPDATE_SELECTION == family;
            }

            public boolean shouldRun() {
                return StagingView.this.shouldUpdateSelection();
            }
        };
        job.setSystem(true);
        this.schedule(job, false);
    }

    private void stage(IStructuredSelection selection) {
        StagingViewContentProvider contentProvider = this.getContentProvider((ContentViewer)this.unstagedViewer);
        final Repository repository = this.currentRepository;
        Iterator iterator = selection.iterator();
        final ArrayList<String> addPaths = new ArrayList<String>();
        final ArrayList<String> rmPaths = new ArrayList<String>();
        this.resetPathsToExpand();
        while (iterator.hasNext()) {
            RepositoryMapping mapping;
            Object element = iterator.next();
            if (element instanceof StagingEntry) {
                StagingEntry entry = (StagingEntry)element;
                this.selectEntryForStaging(entry, addPaths, rmPaths);
                StagingView.addPathAndParentPaths(entry.getParentPath(), this.pathsToExpandInStaged);
                continue;
            }
            if (element instanceof StagingFolderEntry) {
                StagingFolderEntry folder = (StagingFolderEntry)element;
                List<StagingEntry> entries = contentProvider.getStagingEntriesFiltered(folder);
                for (StagingEntry entry : entries) {
                    this.selectEntryForStaging(entry, addPaths, rmPaths);
                }
                StagingView.addExpandedPathsBelowFolder(folder, this.unstagedViewer, this.pathsToExpandInStaged);
                continue;
            }
            IResource resource = AdapterUtils.adaptToAnyResource(element);
            if (resource == null || (mapping = RepositoryMapping.getMapping((IResource)resource)) == null || mapping.getRepository() != this.currentRepository) continue;
            String path = mapping.getRepoRelativePath(resource);
            if (EMPTY_STRING.equals(path)) {
                addPaths.add(".");
                continue;
            }
            addPaths.add(path);
        }
        if (!addPaths.isEmpty()) {
            Job addJob = new Job(UIText.StagingView_AddJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Throwable throwable = null;
                        Object var3_7 = null;
                        try (Git git = new Git(repository);){
                            AddCommand add = git.add();
                            for (String addPath : addPaths) {
                                add.addFilepattern(addPath);
                            }
                            add.call();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (NoFilepatternException noFilepatternException) {
                    }
                    catch (JGitInternalException e1) {
                        Activator.handleError(e1.getCause().getMessage(), e1.getCause(), true);
                    }
                    catch (Exception e1) {
                        Activator.handleError(e1.getMessage(), e1, true);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == JobFamilies.ADD_TO_INDEX;
                }
            };
            this.schedule(addJob, true);
        }
        if (!rmPaths.isEmpty()) {
            Job removeJob = new Job(UIText.StagingView_RemoveJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        Throwable throwable = null;
                        Object var3_7 = null;
                        try (Git git = new Git(repository);){
                            RmCommand rm = git.rm().setCached(true);
                            for (String rmPath : rmPaths) {
                                rm.addFilepattern(rmPath);
                            }
                            rm.call();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (NoFilepatternException noFilepatternException) {
                    }
                    catch (JGitInternalException e) {
                        Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
                    }
                    catch (Exception e) {
                        Activator.handleError(e.getMessage(), e, true);
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == JobFamilies.REMOVE_FROM_INDEX;
                }
            };
            this.schedule(removeJob, true);
        }
    }

    private void selectEntryForStaging(StagingEntry entry, List<String> addPaths, List<String> rmPaths) {
        switch (entry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                break;
            }
            case MODIFIED: 
            case MODIFIED_AND_CHANGED: 
            case MODIFIED_AND_ADDED: 
            case UNTRACKED: 
            case CONFLICTING: {
                addPaths.add(entry.getPath());
                break;
            }
            case MISSING: 
            case MISSING_AND_CHANGED: {
                rmPaths.add(entry.getPath());
            }
        }
    }

    private void unstage(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        final List<String> paths = this.processUnstageSelection(selection);
        if (paths.isEmpty()) {
            return;
        }
        final Repository repository = this.currentRepository;
        Job resetJob = new Job(UIText.StagingView_ResetJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (Git git = new Git(repository);){
                        ResetCommand reset = git.reset();
                        for (String path : paths) {
                            reset.addPath(path);
                        }
                        reset.call();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (GitAPIException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == JobFamilies.RESET;
            }
        };
        this.schedule(resetJob, true);
    }

    private List<String> processUnstageSelection(IStructuredSelection selection) {
        ArrayList<String> paths = new ArrayList<String>();
        this.resetPathsToExpand();
        for (Object element : selection.toList()) {
            if (element instanceof StagingEntry) {
                StagingEntry entry = (StagingEntry)element;
                this.addUnstagePath(entry, paths);
                StagingView.addPathAndParentPaths(entry.getParentPath(), this.pathsToExpandInUnstaged);
                continue;
            }
            if (!(element instanceof StagingFolderEntry)) continue;
            StagingFolderEntry folder = (StagingFolderEntry)element;
            List<StagingEntry> entries = this.getContentProvider((ContentViewer)this.stagedViewer).getStagingEntriesFiltered(folder);
            for (StagingEntry entry : entries) {
                this.addUnstagePath(entry, paths);
            }
            StagingView.addExpandedPathsBelowFolder(folder, this.stagedViewer, this.pathsToExpandInUnstaged);
        }
        return paths;
    }

    private void addUnstagePath(StagingEntry entry, List<String> paths) {
        switch (entry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                paths.add(entry.getPath());
                return;
            }
        }
    }

    private void resetPathsToExpand() {
        this.pathsToExpandInStaged = new HashSet<IPath>();
        this.pathsToExpandInUnstaged = new HashSet<IPath>();
    }

    private static void addExpandedPathsBelowFolder(StagingFolderEntry folder, TreeViewer treeViewer, Set<IPath> addToSet) {
        Object[] expandedElements;
        Object[] objectArray = expandedElements = treeViewer.getVisibleExpandedElements();
        int n = expandedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object expandedElement = objectArray[n2];
            if (expandedElement instanceof StagingFolderEntry) {
                StagingFolderEntry expandedFolder = (StagingFolderEntry)expandedElement;
                if (folder.getPath().isPrefixOf(expandedFolder.getPath())) {
                    StagingView.addPathAndParentPaths(expandedFolder.getPath(), addToSet);
                }
            }
            ++n2;
        }
    }

    private static void addPathAndParentPaths(IPath initialPath, Set<IPath> addToSet) {
        IPath p = initialPath;
        while (p.segmentCount() >= 1) {
            addToSet.add(p);
            p = p.removeLastSegments(1);
        }
    }

    private boolean isValidRepo(Repository repository) {
        return repository != null && !repository.isBare() && repository.getWorkTree().exists();
    }

    private void clearRepository(@Nullable Repository repository) {
        this.saveCommitMessageComponentState();
        this.currentRepository = null;
        StagingViewUpdate update = new StagingViewUpdate(null, null, null);
        this.setStagingViewerInput(this.unstagedViewer, update, null, null);
        this.setStagingViewerInput(this.stagedViewer, update, null, null);
        this.enableCommitWidgets(false);
        this.refreshAction.setEnabled(false);
        this.updateSectionText();
        if (repository != null && repository.isBare()) {
            this.form.setText(UIText.StagingView_BareRepoSelection);
        } else {
            this.form.setText(UIText.StagingView_NoSelectionTitle);
        }
        this.updateIgnoreErrorsButtonVisibility();
    }

    protected void updateRebaseButtonVisibility(final boolean isRebasing) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (StagingView.this.isDisposed()) {
                    return;
                }
                StagingView.showControl((Control)StagingView.this.rebaseSection, isRebasing);
                StagingView.this.rebaseSection.getParent().layout(true);
            }
        });
    }

    private static void showControl(Control c, boolean show) {
        c.setVisible(show);
        GridData g = (GridData)c.getLayoutData();
        g.exclude = !show;
    }

    public void setAmending(boolean isAmending) {
        if (this.isDisposed()) {
            return;
        }
        if (this.amendPreviousCommitAction.isChecked() != isAmending) {
            this.amendPreviousCommitAction.setChecked(isAmending);
            this.amendPreviousCommitAction.run();
        }
    }

    public void setCommitMessage(String message) {
        this.commitMessageText.setText(message);
    }

    public void reload(final Repository repository) {
        if (this.isDisposed()) {
            return;
        }
        if (repository == null) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StagingView.this.clearRepository(null);
                }
            });
            return;
        }
        if (!this.isValidRepo(repository)) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    StagingView.this.clearRepository(repository);
                }
            });
            return;
        }
        final boolean repositoryChanged = this.currentRepository != repository;
        this.currentRepository = repository;
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                int stagedElementsCount;
                if (StagingView.this.isDisposed()) {
                    return;
                }
                IndexDiffData indexDiff = StagingView.this.doReload(repository);
                boolean indexDiffAvailable = StagingView.indexDiffAvailable(indexDiff);
                boolean noConflicts = StagingView.noConflicts(indexDiff);
                if (repositoryChanged) {
                    StagingView.this.resetPathsToExpand();
                    if (StagingView.this.refsChangedListener != null) {
                        StagingView.this.refsChangedListener.remove();
                    }
                    StagingView.this.refsChangedListener = repository.getListenerList().addRefsChangedListener(new RefsChangedListener(){

                        public void onRefsChanged(RefsChangedEvent event) {
                            StagingView.this.updateRebaseButtonVisibility(repository.getRepositoryState().isRebasing());
                        }
                    });
                }
                StagingViewUpdate update = new StagingViewUpdate(repository, indexDiff, null);
                Object[] unstagedExpanded = StagingView.this.unstagedViewer.getVisibleExpandedElements();
                Object[] stagedExpanded = StagingView.this.stagedViewer.getVisibleExpandedElements();
                int unstagedElementsCount = StagingView.this.updateAutoExpand(StagingView.this.unstagedViewer, StagingView.getUnstaged(indexDiff));
                int elementsCount = unstagedElementsCount + (stagedElementsCount = StagingView.this.updateAutoExpand(StagingView.this.stagedViewer, StagingView.getStaged(indexDiff)));
                if (elementsCount > StagingView.this.getMaxLimitForListMode()) {
                    StagingView.this.listPresentationAction.setEnabled(false);
                    if (StagingView.this.presentation == Presentation.LIST) {
                        StagingView.this.compactTreePresentationAction.setChecked(true);
                        StagingView.this.switchToCompactModeInternal(true);
                    } else {
                        StagingView.this.setExpandCollapseActionsVisible(false, unstagedElementsCount <= StagingView.this.getMaxLimitForListMode(), true);
                        StagingView.this.setExpandCollapseActionsVisible(true, stagedElementsCount <= StagingView.this.getMaxLimitForListMode(), true);
                    }
                } else {
                    StagingView.this.listPresentationAction.setEnabled(true);
                    boolean changed = StagingView.this.getPreferenceStore().getBoolean("StagingView_Presentation_Changed");
                    if (changed) {
                        StagingView.this.listPresentationAction.setChecked(true);
                        StagingView.this.switchToListMode();
                    } else if (StagingView.this.presentation != Presentation.LIST) {
                        StagingView.this.setExpandCollapseActionsVisible(false, true, true);
                        StagingView.this.setExpandCollapseActionsVisible(true, true, true);
                    }
                }
                StagingView.this.setStagingViewerInput(StagingView.this.unstagedViewer, update, unstagedExpanded, StagingView.this.pathsToExpandInUnstaged);
                StagingView.this.setStagingViewerInput(StagingView.this.stagedViewer, update, stagedExpanded, StagingView.this.pathsToExpandInStaged);
                StagingView.this.resetPathsToExpand();
                StagingView.this.refreshAction.setEnabled(true);
                StagingView.this.updateRebaseButtonVisibility(repository.getRepositoryState().isRebasing());
                StagingView.this.updateIgnoreErrorsButtonVisibility();
                boolean rebaseContinueEnabled = indexDiffAvailable && repository.getRepositoryState().isRebasing() && noConflicts;
                StagingView.this.rebaseContinueButton.setEnabled(rebaseContinueEnabled);
                StagingView.this.form.setText(GitLabels.getStyledLabelSafe(repository).toString());
                StagingView.this.updateCommitMessageComponent(repositoryChanged, indexDiffAvailable);
                StagingView.this.enableCommitWidgets(indexDiffAvailable && noConflicts);
                StagingView.this.updateCommitButtons();
                StagingView.this.updateSectionText();
            }
        });
    }

    private int getMaxLimitForListMode() {
        return Activator.getDefault().getPreferenceStore().getInt("StagingView_MaxLimitListMode");
    }

    private static int getUnstaged(@Nullable IndexDiffData indexDiff) {
        if (indexDiff == null) {
            return 0;
        }
        int size = indexDiff.getUntracked().size();
        size += indexDiff.getMissing().size();
        size += indexDiff.getModified().size();
        return size += indexDiff.getConflicting().size();
    }

    private static int getStaged(@Nullable IndexDiffData indexDiff) {
        if (indexDiff == null) {
            return 0;
        }
        int size = indexDiff.getAdded().size();
        size += indexDiff.getChanged().size();
        return size += indexDiff.getRemoved().size();
    }

    private int updateAutoExpand(TreeViewer viewer, int newSize) {
        if (newSize > this.getMaxLimitForListMode()) {
            StagingView.disableAutoExpand((AbstractTreeViewer)viewer);
        }
        return newSize;
    }

    private void switchToCompactModeInternal(boolean auto) {
        this.setPresentation(Presentation.COMPACT_TREE, auto);
        this.listPresentationAction.setChecked(false);
        this.treePresentationAction.setChecked(false);
        if (auto) {
            this.setExpandCollapseActionsVisible(false, false, true);
            this.setExpandCollapseActionsVisible(true, false, true);
        } else {
            this.setExpandCollapseActionsVisible(false, this.isExpandAllowed(false), true);
            this.setExpandCollapseActionsVisible(true, this.isExpandAllowed(true), true);
        }
    }

    private void switchToListMode() {
        this.setPresentation(Presentation.LIST, false);
        this.treePresentationAction.setChecked(false);
        this.compactTreePresentationAction.setChecked(false);
        this.setExpandCollapseActionsVisible(false, false, false);
        this.setExpandCollapseActionsVisible(true, false, false);
    }

    private static boolean noConflicts(IndexDiffData indexDiff) {
        return indexDiff == null ? true : indexDiff.getConflicting().isEmpty();
    }

    private static boolean indexDiffAvailable(IndexDiffData indexDiff) {
        return indexDiff != null;
    }

    private boolean hasErrorsOrWarnings() {
        return this.getPreferenceStore().getBoolean("checkBeforeCommitting") ? this.getProblemsSeverity() >= Integer.parseInt(this.getPreferenceStore().getString("warnBeforeCommitting")) && !this.ignoreErrors.getSelection() : false;
    }

    private boolean isCommitBlocked() {
        return this.getPreferenceStore().getBoolean("checkBeforeCommitting") && this.getPreferenceStore().getBoolean("blockCommit") ? this.getProblemsSeverity() >= Integer.parseInt(this.getPreferenceStore().getString("blockCommitCombo")) && !this.ignoreErrors.getSelection() : false;
    }

    private IndexDiffData doReload(@NonNull Repository repository) {
        IndexDiffCacheEntry entry = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository);
        if (this.cacheEntry != null && this.cacheEntry != entry) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        this.cacheEntry = entry;
        this.cacheEntry.addIndexDiffChangedListener(this.myIndexDiffListener);
        return this.cacheEntry.getIndexDiff();
    }

    private void expandPreviousExpandedAndPaths(Object[] previous, TreeViewer viewer, Set<IPath> additionalPaths) {
        Object element;
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)viewer);
        int count = stagedContentProvider.getCount();
        this.updateAutoExpand(viewer, count);
        if (viewer.getAutoExpandLevel() == -1) {
            return;
        }
        if (this.getPresentation() == Presentation.LIST) {
            return;
        }
        HashSet<IPath> paths = new HashSet<IPath>(additionalPaths);
        Object[] objectArray = previous;
        int n = previous.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof StagingFolderEntry) {
                StagingView.addPathAndParentPaths(((StagingFolderEntry)element).getPath(), paths);
            }
            ++n2;
        }
        objectArray = viewer.getVisibleExpandedElements();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            if (element instanceof StagingFolderEntry) {
                StagingView.addPathAndParentPaths(((StagingFolderEntry)element).getPath(), paths);
            }
            ++n2;
        }
        ArrayList<StagingFolderEntry> expand = new ArrayList<StagingFolderEntry>();
        this.calculateNodesToExpand(paths, stagedContentProvider.getElements(null), expand);
        viewer.setExpandedElements(expand.toArray());
    }

    private void calculateNodesToExpand(Set<IPath> paths, Object[] elements, List<StagingFolderEntry> result) {
        if (elements == null) {
            return;
        }
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StagingFolderEntry folder;
            Object element = objectArray[n2];
            if (element instanceof StagingFolderEntry && paths.contains((folder = (StagingFolderEntry)element).getPath())) {
                result.add(folder);
                this.calculateNodesToExpand(paths, folder.getChildren(), result);
            }
            ++n2;
        }
    }

    private void clearCommitMessageToggles() {
        this.amendPreviousCommitAction.setChecked(false);
        this.addChangeIdAction.setChecked(false);
        this.signedOffByAction.setChecked(false);
    }

    void updateCommitMessageComponent(boolean repositoryChanged, boolean indexDiffAvailable) {
        if (repositoryChanged) {
            if (this.commitMessageComponent.isAmending() || this.userEnteredCommitMessage()) {
                this.saveCommitMessageComponentState();
            } else {
                this.deleteCommitMessageComponentState();
            }
        }
        if (!indexDiffAvailable) {
            return;
        }
        CommitHelper helper = new CommitHelper(this.currentRepository);
        CommitMessageComponentState oldState = null;
        if (repositoryChanged || this.commitMessageComponent.getRepository() != this.currentRepository) {
            oldState = this.loadCommitMessageComponentState();
            this.commitMessageComponent.setRepository(this.currentRepository);
            if (oldState == null) {
                this.loadInitialState(helper);
            } else {
                this.loadExistingState(helper, oldState);
            }
        } else if (!this.commitMessageComponent.getHeadCommit().equals((AnyObjectId)helper.getPreviousCommit()) || !this.commitMessageComponent.isAmending()) {
            if (!this.commitMessageComponent.isAmending() && this.userEnteredCommitMessage()) {
                this.addHeadChangedWarning(this.commitMessageComponent.getCommitMessage());
            } else {
                this.loadInitialState(helper);
            }
        }
        this.amendPreviousCommitAction.setChecked(this.commitMessageComponent.isAmending());
        this.amendPreviousCommitAction.setEnabled(helper.amendAllowed());
        this.updateMessage();
    }

    public void resetCommitMessageComponent() {
        if (this.currentRepository != null) {
            String commitMessage = this.commitMessageComponent.getCommitMessage();
            if (commitMessage.trim().length() > 0) {
                CommitMessageHistory.saveCommitHistory(commitMessage);
            }
            this.loadInitialState(new CommitHelper(this.currentRepository));
        }
    }

    private void loadExistingState(CommitHelper helper, CommitMessageComponentState oldState) {
        boolean headCommitChanged = !oldState.getHeadCommit().equals((AnyObjectId)this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.setAuthor(oldState.getAuthor());
        if (headCommitChanged) {
            this.addHeadChangedWarning(oldState.getCommitMessage());
        } else {
            this.commitMessageComponent.setCommitMessage(oldState.getCommitMessage());
        }
        this.commitMessageComponent.setCommitter(oldState.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        boolean amendAllowed = helper.amendAllowed();
        this.commitMessageComponent.setAmendAllowed(amendAllowed);
        if (!amendAllowed) {
            this.commitMessageComponent.setAmending(false);
        } else if (!headCommitChanged && oldState.getAmend()) {
            this.commitMessageComponent.setAmending(true);
        } else {
            this.commitMessageComponent.setAmending(false);
        }
        this.commitMessageComponent.updateUIFromState();
        this.commitMessageComponent.updateSignedOffAndChangeIdButton();
        this.commitMessageComponent.enableListeners(true);
    }

    private void addHeadChangedWarning(String commitMessage) {
        if (!commitMessage.startsWith(UIText.StagingView_headCommitChanged)) {
            String message = String.valueOf(UIText.StagingView_headCommitChanged) + Text.DELIMITER + Text.DELIMITER + commitMessage;
            this.commitMessageComponent.setCommitMessage(message);
        }
    }

    private void loadInitialState(CommitHelper helper) {
        this.commitMessageComponent.enableListeners(false);
        this.commitMessageComponent.resetState();
        this.commitMessageComponent.setAuthor(helper.getAuthor());
        this.commitMessageComponent.setCommitMessage(helper.getCommitMessage());
        this.commitMessageComponent.setCommitter(helper.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        this.commitMessageComponent.setAmendAllowed(helper.amendAllowed());
        this.commitMessageComponent.setAmending(false);
        this.commitMessageComponent.setDefaults();
        this.commitMessageComponent.updateUI();
        this.commitMessageComponent.enableListeners(true);
    }

    private boolean userEnteredCommitMessage() {
        if (this.commitMessageComponent.getRepository() == null) {
            return false;
        }
        String message = this.commitMessageComponent.getCommitMessage().replace(UIText.StagingView_headCommitChanged, EMPTY_STRING);
        if (message == null || message.trim().length() == 0) {
            return false;
        }
        String chIdLine = "Change-Id: I" + ObjectId.zeroId().name();
        Repository repo = this.currentRepository;
        if (repo != null && GerritUtil.getCreateChangeId((Config)repo.getConfig()) && this.commitMessageComponent.getCreateChangeId()) {
            if (message.trim().equals(chIdLine)) {
                return false;
            }
            message = message.replace(chIdLine, EMPTY_STRING);
        }
        return !Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_signed_off_by") || !this.commitMessageComponent.isSignedOff() || !message.trim().equals("Signed-off-by: " + this.commitMessageComponent.getCommitter());
    }

    private ObjectId getCommitId(RevCommit commit) {
        if (commit == null) {
            return ObjectId.zeroId();
        }
        return commit.getId();
    }

    private void saveCommitMessageComponentState() {
        Repository repo = this.commitMessageComponent.getRepository();
        if (repo != null) {
            CommitMessageComponentStateManager.persistState(repo, this.commitMessageComponent.getState());
        }
    }

    private void deleteCommitMessageComponentState() {
        if (this.commitMessageComponent.getRepository() != null) {
            CommitMessageComponentStateManager.deleteState(this.commitMessageComponent.getRepository());
        }
    }

    private CommitMessageComponentState loadCommitMessageComponentState() {
        return CommitMessageComponentStateManager.loadState(this.currentRepository);
    }

    private Collection<String> getStagedFileNames() {
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)this.stagedViewer);
        StagingEntry[] entries = stagedContentProvider.getStagingEntries();
        ArrayList<String> files = new ArrayList<String>();
        StagingEntry[] stagingEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            files.add(entry.getPath());
            ++n2;
        }
        return files;
    }

    private void commit(boolean pushUpstream) {
        if (!this.isCommitWithoutFilesAllowed()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.StagingView_committingNotPossible, (String)UIText.StagingView_noStagedFiles);
            return;
        }
        if (!this.commitMessageComponent.checkCommitInfo()) {
            return;
        }
        if (!UIUtils.saveAllEditors(this.currentRepository, UIText.StagingView_cancelCommitAfterSaving)) {
            return;
        }
        String commitMessage = this.commitMessageComponent.getCommitMessage();
        CommitOperation commitOperation = null;
        try {
            commitOperation = new CommitOperation(this.currentRepository, this.commitMessageComponent.getAuthor(), this.commitMessageComponent.getCommitter(), commitMessage);
        }
        catch (CoreException e) {
            Activator.handleError(UIText.StagingView_commitFailed, e, true);
            return;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            commitOperation.setAmending(true);
        }
        boolean gerritMode = this.addChangeIdAction.isChecked();
        commitOperation.setComputeChangeId(gerritMode);
        CommitJob.PushMode pushMode = null;
        if (pushUpstream) {
            pushMode = gerritMode ? CommitJob.PushMode.GERRIT : CommitJob.PushMode.UPSTREAM;
        }
        final CommitJob commitJob = new CommitJob(this.currentRepository, commitOperation).setOpenCommitEditor(this.openNewCommitsAction.isChecked()).setPushUpstream(pushMode);
        this.enableAllWidgets(false);
        commitJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                StagingView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StagingView.this.enableAllWidgets(true);
                        if (commitJob.getResult().isOK()) {
                            StagingView.this.commitMessageText.setText(StagingView.EMPTY_STRING);
                        }
                    }
                });
            }
        });
        this.schedule(commitJob, true);
        CommitMessageHistory.saveCommitHistory(commitMessage);
        this.clearCommitMessageToggles();
    }

    private void schedule(Job job, boolean useRepositoryRule) {
        IWorkbenchSiteProgressService service;
        if (useRepositoryRule) {
            job.setRule(RuleUtil.getRule((Repository)this.currentRepository));
        }
        if ((service = CommonUtils.getService((IServiceLocator)this.getSite(), IWorkbenchSiteProgressService.class)) != null) {
            service.schedule(job, 0L, true);
        } else {
            job.schedule();
        }
    }

    private boolean isCommitWithoutFilesAllowed() {
        if (this.stagedViewer.getTree().getItemCount() > 0) {
            return true;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            return true;
        }
        return CommitHelper.isCommitWithoutFilesAllowed(this.currentRepository);
    }

    public void setFocus() {
        Tree tree = this.unstagedViewer.getTree();
        if (tree.getItemCount() > 0 && !this.isAutoStageOnCommitEnabled()) {
            this.unstagedViewer.getControl().setFocus();
            return;
        }
        this.commitMessageText.setFocus();
    }

    private boolean isAutoStageOnCommitEnabled() {
        IPreferenceStore uiPreferences = Activator.getDefault().getPreferenceStore();
        return uiPreferences.getBoolean("auto_stage_on_commit");
    }

    public void dispose() {
        super.dispose();
        ISelectionService srv = CommonUtils.getService((IServiceLocator)this.getSite(), ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        CommonUtils.getService((IServiceLocator)this.getSite(), IPartService.class).removePartListener(this.partListener);
        if (this.cacheEntry != null) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        if (this.undoRedoActionGroup != null) {
            this.undoRedoActionGroup.dispose();
        }
        InstanceScope.INSTANCE.getNode(org.eclipse.egit.core.Activator.getPluginId()).removePreferenceChangeListener(this.prefListener);
        if (this.refsChangedListener != null) {
            this.refsChangedListener.remove();
        }
        this.getPreferenceStore().removePropertyChangeListener(this.uiPrefsListener);
        this.getDialogSettings().put(STORE_SORT_STATE, this.sortAction.isChecked());
        this.currentRepository = null;
        this.disposed = true;
    }

    private boolean isDisposed() {
        return this.disposed;
    }

    private static void syncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
    }

    private void asyncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    private class DeleteAction
    extends Action {
        private final IStructuredSelection selection;

        DeleteAction(IStructuredSelection selection) {
            super(UIText.StagingView_DeleteItemMenuLabel);
            this.selection = selection;
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(StagingView.getSelectedPaths(this.selection), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }
    }

    private class GlobalDeleteActionHandler
    extends Action {
        private GlobalDeleteActionHandler() {
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(StagingView.getSelectedPaths(this.getSelection()), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }

        public boolean isEnabled() {
            if (!StagingView.this.unstagedViewer.getTree().isFocusControl()) {
                return false;
            }
            IStructuredSelection selection = this.getSelection();
            if (selection.isEmpty()) {
                return false;
            }
            for (Object element : selection.toList()) {
                if (!(element instanceof StagingEntry)) {
                    return false;
                }
                StagingEntry entry = (StagingEntry)element;
                if (entry.getAvailableActions().contains((Object)StagingEntry.Action.DELETE)) continue;
                return false;
            }
            return true;
        }

        private IStructuredSelection getSelection() {
            return (IStructuredSelection)StagingView.this.unstagedViewer.getSelection();
        }
    }

    private static class IgnoreAction
    extends Action {
        private final IStructuredSelection selection;

        IgnoreAction(IStructuredSelection selection) {
            super(UIText.StagingView_IgnoreItemMenuLabel);
            this.selection = selection;
        }

        public void run() {
            IgnoreOperationUI operation = new IgnoreOperationUI(StagingView.getSelectedPaths(this.selection));
            operation.run();
        }
    }

    private static class IgnoreFoldersAction
    extends Action {
        private final Set<StagingFolderEntry> selection;

        IgnoreFoldersAction(Set<StagingFolderEntry> selection) {
            super(UIText.StagingView_IgnoreFolderMenuLabel);
            this.selection = selection;
        }

        public void run() {
            ArrayList<IPath> paths = new ArrayList<IPath>();
            for (StagingFolderEntry folder : this.selection) {
                paths.add(folder.getLocation());
            }
            IgnoreOperationUI operation = new IgnoreOperationUI(paths);
            operation.run();
        }
    }

    private final class PartListener
    implements IPartListener2 {
        StructuredSelection lastSelection;

        private PartListener() {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            this.updateHiddenState(partRef, false);
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            this.updateHiddenState(partRef, false);
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            this.updateHiddenState(partRef, true);
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            this.updateHiddenState(partRef, true);
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (this.isMe(partRef)) {
                if (this.lastSelection != null) {
                    StagingView.this.reactOnSelection(this.lastSelection);
                    this.lastSelection = null;
                }
                return;
            }
            IWorkbenchPart part = partRef.getPart(false);
            StructuredSelection sel = StagingView.getSelectionOfPart(part);
            if (StagingView.this.isViewHidden) {
                this.lastSelection = sel;
            } else {
                this.lastSelection = null;
                if (sel != null) {
                    StagingView.this.reactOnSelection(sel);
                }
            }
        }

        private void updateHiddenState(IWorkbenchPartReference partRef, boolean hidden) {
            if (this.isMe(partRef)) {
                StagingView.this.isViewHidden = hidden;
            }
        }

        private boolean isMe(IWorkbenchPartReference partRef) {
            return partRef.getPart(false) == StagingView.this;
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }

    public static enum Presentation {
        LIST,
        TREE,
        COMPACT_TREE;

    }

    private class ReplaceAction
    extends Action {
        IStructuredSelection selection;
        private final boolean headRevision;

        ReplaceAction(@NonNull String text, IStructuredSelection selection, boolean headRevision) {
            super(text);
            this.selection = selection;
            this.headRevision = headRevision;
        }

        private void getSelectedFiles(@NonNull List<String> files, @NonNull List<String> inaccessibleFiles) {
            for (Object selectedItem : this.selection) {
                if (!(selectedItem instanceof StagingEntry)) continue;
                StagingEntry stagingEntry = (StagingEntry)selectedItem;
                String path = stagingEntry.getPath();
                files.add(path);
                IFile resource = stagingEntry.getFile();
                if (resource != null && resource.isAccessible()) continue;
                inaccessibleFiles.add(path);
            }
        }

        private void replaceWith(@NonNull List<String> files, @NonNull List<String> inaccessibleFiles) {
            Repository repository = StagingView.this.currentRepository;
            if (files.isEmpty() || repository == null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Git git = new Git(repository);){
                    IndexDiffCacheEntry indexDiffCacheForRepository;
                    CheckoutCommand checkoutCommand = git.checkout();
                    if (this.headRevision) {
                        checkoutCommand.setStartPoint("HEAD");
                    }
                    for (String path : files) {
                        checkoutCommand.addPath(path);
                    }
                    checkoutCommand.call();
                    if (!inaccessibleFiles.isEmpty() && (indexDiffCacheForRepository = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(repository)) != null) {
                        indexDiffCacheForRepository.refreshFiles(inaccessibleFiles);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.handleError(UIText.StagingView_checkoutFailed, e, true);
            }
        }

        public void run() {
            String question = UIText.DiscardChangesAction_confirmActionMessage;
            ILaunchConfiguration launch = LaunchFinder.getRunningLaunchConfiguration(Collections.singleton(StagingView.this.getCurrentRepository()), null);
            question = launch != null ? MessageFormat.format(question, "\n\n" + MessageFormat.format(UIText.LaunchFinder_RunningLaunchMessage, launch.getName())) : MessageFormat.format(question, StagingView.EMPTY_STRING);
            boolean performAction = MessageDialog.openConfirm((Shell)StagingView.this.form.getShell(), (String)UIText.DiscardChangesAction_confirmActionTitle, (String)question);
            if (!performAction) {
                return;
            }
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<String> inaccessibleFiles = new ArrayList<String>();
            this.getSelectedFiles(files, inaccessibleFiles);
            this.replaceWith(files, inaccessibleFiles);
        }
    }

    private static class StagingDragListener
    extends DragSourceAdapter {
        private final ISelectionProvider provider;
        private final StagingViewContentProvider contentProvider;
        private final boolean unstaged;

        public StagingDragListener(ISelectionProvider provider, StagingViewContentProvider contentProvider, boolean unstaged) {
            this.provider = provider;
            this.contentProvider = contentProvider;
            this.unstaged = unstaged;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = !this.provider.getSelection().isEmpty();
        }

        public void dragFinished(DragSourceEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StagingDragSelection(selection, this.unstaged));
                return;
            }
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                HashSet<String> files = new HashSet<String>();
                for (Object selected : selection.toList()) {
                    if (selected instanceof StagingEntry) {
                        this.add((StagingEntry)selected, files);
                        continue;
                    }
                    if (!(selected instanceof StagingFolderEntry)) continue;
                    StagingFolderEntry folder = (StagingFolderEntry)selected;
                    for (StagingEntry entry : this.contentProvider.getStagingEntriesFiltered(folder)) {
                        this.add(entry, files);
                    }
                }
                if (!files.isEmpty()) {
                    event.data = files.toArray(new String[files.size()]);
                    return;
                }
            }
        }

        private void add(StagingEntry entry, Collection<String> files) {
            File file = entry.getLocation().toFile();
            if (file.exists()) {
                files.add(file.getAbsolutePath());
            }
        }
    }

    private static class StagingDragSelection
    implements IStructuredSelection {
        private final IStructuredSelection delegate;
        private final boolean fromUnstaged;

        public StagingDragSelection(IStructuredSelection original, boolean fromUnstaged) {
            this.delegate = original;
            this.fromUnstaged = fromUnstaged;
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Object getFirstElement() {
            return this.delegate.getFirstElement();
        }

        public Iterator iterator() {
            return this.delegate.iterator();
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public List toList() {
            return this.delegate.toList();
        }

        public boolean isFromUnstaged() {
            return this.fromUnstaged;
        }
    }

    private static class StagingEntryComparator
    extends ViewerComparator {
        private boolean alphabeticSort;
        private Comparator<String> comparator;
        private boolean fileNamesFirst;

        private StagingEntryComparator(boolean alphabeticSort, boolean fileNamesFirst) {
            this.alphabeticSort = alphabeticSort;
            this.setFileNamesFirst(fileNamesFirst);
            this.comparator = CommonUtils.STRING_ASCENDING_COMPARATOR;
        }

        public boolean isFileNamesFirst() {
            return this.fileNamesFirst;
        }

        public void setFileNamesFirst(boolean fileNamesFirst) {
            this.fileNamesFirst = fileNamesFirst;
        }

        private void setAlphabeticSort(boolean sort) {
            this.alphabeticSort = sort;
        }

        private boolean isAlphabeticSort() {
            return this.alphabeticSort;
        }

        public int category(Object element) {
            StagingEntry stagingEntry;
            if (!this.isAlphabeticSort() && (stagingEntry = this.getStagingEntry(element)) != null) {
                return this.getState(stagingEntry);
            }
            return super.category(element);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.getStagingEntryText(e1);
            String name2 = this.getStagingEntryText(e2);
            return this.comparator.compare(name1, name2);
        }

        private String getStagingEntryText(Object element) {
            String text = StagingView.EMPTY_STRING;
            StagingEntry stagingEntry = this.getStagingEntry(element);
            if (stagingEntry != null) {
                text = this.isFileNamesFirst() ? stagingEntry.getName() : stagingEntry.getPath();
            }
            return text;
        }

        @Nullable
        private StagingEntry getStagingEntry(Object element) {
            TreeItem item;
            StagingEntry entry = null;
            if (element instanceof StagingEntry) {
                entry = (StagingEntry)element;
            }
            if (element instanceof TreeItem && (item = (TreeItem)element).getData() instanceof StagingEntry) {
                entry = (StagingEntry)item.getData();
            }
            return entry;
        }

        private int getState(StagingEntry entry) {
            switch (entry.getState()) {
                case CONFLICTING: {
                    return 1;
                }
                case MODIFIED: {
                    return 2;
                }
                case MODIFIED_AND_ADDED: {
                    return 3;
                }
                case MODIFIED_AND_CHANGED: {
                    return 4;
                }
                case ADDED: {
                    return 5;
                }
                case CHANGED: {
                    return 6;
                }
                case MISSING: {
                    return 7;
                }
                case MISSING_AND_CHANGED: {
                    return 8;
                }
                case REMOVED: {
                    return 9;
                }
                case UNTRACKED: {
                    return 10;
                }
            }
            return super.category((Object)entry);
        }
    }

    static class StagingViewSearchThread
    extends Thread {
        private StagingView stagingView;
        private static final Object lock = new Object();
        private static volatile int globalThreadIndex = 0;
        private int currentThreadIx;

        public StagingViewSearchThread(StagingView stagingView) {
            super("staging_view_filter_thread" + ++globalThreadIndex);
            this.stagingView = stagingView;
            this.currentThreadIx = globalThreadIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = lock;
            synchronized (object) {
                if (this.currentThreadIx < globalThreadIndex) {
                    return;
                }
                this.stagingView.refreshViewersPreservingExpandedElements();
            }
        }
    }

    static class StagingViewUpdate {
        Repository repository;
        IndexDiffData indexDiff;
        Collection<String> changedResources;

        StagingViewUpdate(Repository theRepository, IndexDiffData theIndexDiff, Collection<String> theChanges) {
            this.repository = theRepository;
            this.indexDiff = theIndexDiff;
            this.changedResources = theChanges;
        }
    }

    private static enum StagingViewerUpdate {
        ADDED,
        REMOVED,
        UNCHANGED;

    }

    private static class TreeDecoratingLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private final DecoratingLabelProvider provider;

        public TreeDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            this.provider = new DecoratingLabelProvider(provider, decorator);
        }

        public Image getImage(Object element) {
            return this.provider.getImage(element);
        }

        public String getText(Object element) {
            return this.provider.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.provider.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.provider.removeListener(listener);
        }

        public void dispose() {
            this.provider.dispose();
        }

        public ILabelProvider getLabelProvider() {
            return this.provider.getLabelProvider();
        }
    }

    private static abstract class TreeItemVisitor {
        private final TreeItem[] roots;

        public TreeItemVisitor(TreeItem[] roots) {
            this.roots = roots;
        }

        public abstract boolean visit(TreeItem var1);

        public void traverse(TreeItem treeItem) {
            if (treeItem == null && (treeItem = this.getLastItem(this.roots)) == null) {
                return;
            }
            if (treeItem.isDisposed()) {
                return;
            }
            if (treeItem.getData() != null && this.visit(treeItem)) {
                this.traversePrecedingSiblings(treeItem);
            }
        }

        private TreeItem getLastItem(TreeItem[] treeItems) {
            TreeItem result;
            if (treeItems.length == 0) {
                return null;
            }
            TreeItem lastItem = treeItems[treeItems.length - 1];
            if (lastItem.getExpanded() && (result = this.getLastItem(lastItem.getItems())) != null) {
                return result;
            }
            return lastItem;
        }

        private boolean traversePrecedingSiblings(TreeItem treeItem) {
            TreeItem parent = treeItem.getParentItem();
            if (parent == null) {
                return this.traversePrecedingSiblings(this.roots, treeItem);
            }
            if (!this.traversePrecedingSiblings(parent.getItems(), treeItem)) {
                return false;
            }
            return this.traversePrecedingSiblings(parent);
        }

        private boolean traversePrecedingSiblings(TreeItem[] siblings, TreeItem treeItem) {
            boolean start = false;
            int i = siblings.length - 1;
            while (i >= 0) {
                TreeItem sibling = siblings[i];
                if (start) {
                    if (!this.traverseChildren(sibling)) {
                        return false;
                    }
                } else if (sibling == treeItem) {
                    start = true;
                }
                --i;
            }
            return true;
        }

        private boolean traverseChildren(TreeItem treeItem) {
            if (treeItem.getExpanded()) {
                TreeItem[] children = treeItem.getItems();
                int i = children.length - 1;
                while (i >= 0) {
                    if (!this.traverseChildren(children[i])) {
                        return false;
                    }
                    --i;
                }
            }
            return this.visit(treeItem);
        }
    }
}

