/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.GitCreateProjectViaWizardWizard;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class ImportProjectsCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String path;
        List selectedNodes = this.getSelectedNodes(event);
        if (selectedNodes == null || selectedNodes.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        if (!(selectedNodes.get(0) instanceof RepositoryTreeNode)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
            return null;
        }
        RepositoryTreeNode node = (RepositoryTreeNode)selectedNodes.get(0);
        switch (node.getType()) {
            case REPO: 
            case WORKINGDIR: {
                path = node.getRepository().getWorkTree().toString();
                break;
            }
            case FOLDER: {
                path = ((File)((FolderNode)node).getObject()).getPath().toString();
                break;
            }
            default: {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)UIText.ImportProjectsWrongSelection, (String)UIText.ImportProjectsSelectionInRepositoryRequired);
                return null;
            }
        }
        IWizardDescriptor descriptor = this.findSmartImportWizardDescriptor();
        if (descriptor != null) {
            this.openSmartImportWizard(event, descriptor, path);
        } else {
            this.openGitCreateProjectViaWizardWizard(event, node, path);
        }
        return null;
    }

    private IWizardDescriptor findSmartImportWizardDescriptor() {
        String smartImportWizardId = "org.eclipse.e4.ui.importer.wizard";
        return PlatformUI.getWorkbench().getImportWizardRegistry().findWizard("org.eclipse.e4.ui.importer.wizard");
    }

    private void openSmartImportWizard(ExecutionEvent event, IWizardDescriptor descriptor, String path) throws ExecutionException {
        try {
            IWorkbenchWizard wizard = descriptor.createWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)new File(path)));
            WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)wizard);
            dlg.setTitle(wizard.getWindowTitle());
            dlg.setHelpAvailable(false);
            dlg.open();
        }
        catch (CoreException e) {
            throw new ExecutionException("Error during opening smart import wizard.", (Throwable)e);
        }
    }

    private void openGitCreateProjectViaWizardWizard(ExecutionEvent event, RepositoryTreeNode node, String path) {
        WizardDialog dlg = new WizardDialog(this.getShell(event), (IWizard)new GitCreateProjectViaWizardWizard(node.getRepository(), path)){

            protected IDialogSettings getDialogBoundsSettings() {
                return Activator.getDefault().getDialogSettings();
            }
        };
        dlg.setHelpAvailable(false);
        dlg.open();
    }
}

