/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIPreferences;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkSourceViewer;
import org.eclipse.egit.ui.internal.dialogs.HyperlinkTokenScanner;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.CommitGraphTable;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.history.CommitNavigationListener;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.FindToolbar;
import org.eclipse.egit.ui.internal.history.GenerateHistoryJob;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.RenameTracker;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTWalk;
import org.eclipse.egit.ui.internal.history.TableLoader;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RenameCallback;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class GitHistoryPage
extends HistoryPage
implements RefsChangedListener,
TableLoader,
IShowInSource,
IShowInTargetList {
    private static final int INITIAL_ITEM = -1;
    private static final String POPUP_ID = "org.eclipse.egit.ui.historyPageContributions";
    private static final String DESCRIPTION_PATTERN = "{0} - {1}";
    private static final String NAME_PATTERN = "{0}: {1} [{2}]";
    private static final String PREF_SHOWALLFILTER = "org.eclipse.egit.ui.githistorypage.showallfilter";
    private ShowFilter showAllFilter = ShowFilter.SHOWALLRESOURCE;
    private GitHistoryPageActions actions;
    private StyledText errorText;
    private final IPersistentPreferenceStore store = (IPersistentPreferenceStore)Activator.getDefault().getPreferenceStore();
    private ListenerHandle myRefsChangedHandle;
    private HistoryPageInput input;
    private String name;
    private boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
    private Composite topControl;
    private Composite historyControl;
    private SashForm graphDetailSplit;
    private SashForm revInfoSplit;
    private CommitGraphTable graph;
    private CommitMessageViewer commentViewer;
    private DiffViewer diffViewer;
    private CommitFileDiffViewer fileViewer;
    private Composite warningComposite;
    private CLabel warningLabel;
    private final MenuManager popupMgr = new MenuManager(null, "org.eclipse.egit.ui.historyPageContributions");
    private GenerateHistoryJob job;
    private final ResourceManager resources = new LocalResourceManager(JFaceResources.getResources());
    private AnyObjectId currentHeadId;
    private Repository currentRepo;
    private boolean currentShowAllBranches;
    private boolean currentShowAdditionalRefs;
    private boolean currentShowNotes;
    private boolean currentFollowRenames;
    private Set<String> fileViewerInterestingPaths;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getProperty();
            if ("HistoryView_MaxBranchLength".equals(prop) || "HistoryView_MaxTagLength".equals(prop)) {
                GitHistoryPage.this.graph.getTableView().refresh();
            }
            if ("resourcehistory_show_comment_wrap".equals(prop)) {
                GitHistoryPage.this.setWrap((Boolean)event.getNewValue());
            }
        }
    };
    private List<FilterPath> pathFilters;
    private Runnable refschangedRunnable;
    private final RenameTracker renameTracker = new RenameTracker();
    private ScrolledComposite commentAndDiffScrolledComposite;
    private Composite commentAndDiffComposite;
    private volatile boolean resizing;
    private final HistoryPageRule pageSchedulingRule;
    private SearchBar searchBar;

    public static boolean canShowHistoryFor(Object object) {
        if (object instanceof HistoryPageInput) {
            return true;
        }
        if (object instanceof IResource) {
            return GitHistoryPage.typeOk((IResource)object);
        }
        if (object instanceof RepositoryTreeNode) {
            return true;
        }
        IResource resource = AdapterUtils.adaptToAnyResource((Object)object);
        if (resource != null && GitHistoryPage.typeOk(resource)) {
            return true;
        }
        return AdapterUtils.adapt((Object)object, Repository.class) != null;
    }

    private static boolean typeOk(IResource object) {
        switch (object.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public GitHistoryPage() {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        this.pageSchedulingRule = new HistoryPageRule();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    public void createControl(Composite parent) {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        this.historyControl = this.createMainPanel(parent);
        this.warningComposite = new Composite(this.historyControl, 0);
        this.warningComposite.setLayout((Layout)new GridLayout(2, false));
        this.warningComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.warningLabel = new CLabel(this.warningComposite, 0);
        this.warningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.warningLabel.setToolTipText(UIText.GitHistoryPage_IncompleteListTooltip);
        Link preferencesLink = new Link(this.warningComposite, 0);
        preferencesLink.setText(UIText.GitHistoryPage_PreferencesLink);
        preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String preferencePageId = "org.eclipse.egit.ui.internal.preferences.HistoryPreferencePage";
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)GitHistoryPage.this.getSite().getShell(), (String)preferencePageId, (String[])new String[]{preferencePageId}, null);
                dialog.open();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.historyControl);
        this.graphDetailSplit = new SashForm(this.historyControl, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.graphDetailSplit);
        this.graph = new CommitGraphTable((Composite)this.graphDetailSplit, this.getSite(), this.popupMgr, this, this.resources);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
        this.revInfoSplit = new SashForm((Composite)this.graphDetailSplit, 256);
        this.commentAndDiffScrolledComposite = new ScrolledComposite((Composite)this.revInfoSplit, 768);
        this.commentAndDiffScrolledComposite.setExpandHorizontal(true);
        this.commentAndDiffScrolledComposite.setExpandVertical(true);
        this.commentAndDiffComposite = new Composite((Composite)this.commentAndDiffScrolledComposite, 0);
        this.commentAndDiffScrolledComposite.setContent((Control)this.commentAndDiffComposite);
        this.commentAndDiffComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.commentViewer = new CommitMessageViewer(this.commentAndDiffComposite, this.getPartSite());
        this.commentViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.commentViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                GitHistoryPage.this.resizeCommentAndDiffScrolledComposite();
            }
        });
        this.commentAndDiffComposite.setBackground(this.commentViewer.getControl().getBackground());
        HyperlinkSourceViewer.Configuration configuration = new HyperlinkSourceViewer.Configuration(EditorsUI.getPreferenceStore()){

            public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                return 0;
            }

            @Override
            protected IHyperlinkDetector[] internalGetHyperlinkDetectors(ISourceViewer sourceViewer) {
                IHyperlinkDetector[] registered = super.internalGetHyperlinkDetectors(sourceViewer);
                if (registered == null) {
                    return new IHyperlinkDetector[]{new CommitMessageViewer.KnownHyperlinksDetector()};
                }
                IHyperlinkDetector[] result = new IHyperlinkDetector[registered.length + 1];
                System.arraycopy(registered, 0, result, 0, registered.length);
                result[registered.length] = new CommitMessageViewer.KnownHyperlinksDetector();
                return result;
            }

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return new String[]{"__dftl_partition_content_type", "__egit_commit_msg_header", "__egit_commit_msg_footer"};
            }

            public IPresentationReconciler getPresentationReconciler(ISourceViewer viewer) {
                PresentationReconciler reconciler = new PresentationReconciler();
                reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(viewer));
                DefaultDamagerRepairer hyperlinkDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer));
                reconciler.setDamager((IPresentationDamager)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                reconciler.setRepairer((IPresentationRepairer)hyperlinkDamagerRepairer, "__dftl_partition_content_type");
                TextAttribute headerDefault = new TextAttribute(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
                DefaultDamagerRepairer headerDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new HyperlinkTokenScanner((SourceViewerConfiguration)this, viewer, headerDefault));
                reconciler.setDamager((IPresentationDamager)headerDamagerRepairer, "__egit_commit_msg_header");
                reconciler.setRepairer((IPresentationRepairer)headerDamagerRepairer, "__egit_commit_msg_header");
                DefaultDamagerRepairer footerDamagerRepairer = new DefaultDamagerRepairer((ITokenScanner)new FooterTokenScanner((SourceViewerConfiguration)this, viewer));
                reconciler.setDamager((IPresentationDamager)footerDamagerRepairer, "__egit_commit_msg_footer");
                reconciler.setRepairer((IPresentationRepairer)footerDamagerRepairer, "__egit_commit_msg_footer");
                return reconciler;
            }
        };
        this.commentViewer.configure((SourceViewerConfiguration)configuration);
        this.diffViewer = new DiffViewer(this.commentAndDiffComposite, null, 0);
        this.diffViewer.configure((SourceViewerConfiguration)new DiffViewer.Configuration(EditorsUI.getPreferenceStore()));
        this.diffViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.setWrap(this.store.getBoolean("resourcehistory_show_comment_wrap"));
        this.commentAndDiffScrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!GitHistoryPage.this.resizing && GitHistoryPage.this.commentViewer.getTextWidget().getWordWrap()) {
                    GitHistoryPage.this.resizeCommentAndDiffScrolledComposite();
                }
            }
        });
        this.fileViewer = new CommitFileDiffViewer((Composite)this.revInfoSplit, (IWorkbenchSite)this.getSite());
        this.fileViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                ArrayList<FileDiff> diffs = new ArrayList<FileDiff>();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    for (Object obj : sel.toList()) {
                        if (!(obj instanceof FileDiff)) continue;
                        diffs.add((FileDiff)((Object)obj));
                    }
                }
                GitHistoryPage.this.formatDiffs(diffs);
            }
        });
        this.layoutSashForm(this.graphDetailSplit, "resourcehistory_graph_split");
        this.layoutSashForm(this.revInfoSplit, "resourcehistory_rev_split");
        this.attachCommitSelectionChanged();
        this.initActions();
        this.getSite().setSelectionProvider((ISelectionProvider)this.graph.getTableView());
        this.getSite().registerContextMenu(POPUP_ID, this.popupMgr, (ISelectionProvider)this.graph.getTableView());
        this.layout();
        this.myRefsChangedHandle = Repository.getGlobalListenerList().addRefsChangedListener((RefsChangedListener)this);
        IToolBarManager manager = this.getSite().getActionBars().getToolBarManager();
        this.searchBar = new SearchBar(String.valueOf(GitHistoryPage.class.getName()) + ".searchBar", this.graph, this.actions.findAction, this.getSite().getActionBars());
        manager.prependToGroup("org.eclipse.team.ui.historyView", (IContributionItem)this.searchBar);
        this.getSite().getActionBars().updateActionBars();
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    private void layoutSashForm(final SashForm sf, final String key) {
        sf.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] w = sf.getWeights();
                GitHistoryPage.this.store.putValue(key, UIPreferences.intArrayToString(w));
                if (GitHistoryPage.this.store.needsSaving()) {
                    try {
                        GitHistoryPage.this.store.save();
                    }
                    catch (IOException e1) {
                        Activator.handleError(e1.getMessage(), e1, false);
                    }
                }
            }
        });
        int[] weights = UIPreferences.stringToIntArray(this.store.getString(key), 2);
        if (weights == null) {
            weights = UIPreferences.stringToIntArray(this.store.getDefaultString(key), 2);
        }
        sf.setWeights(weights);
    }

    private Composite createMainPanel(Composite parent) {
        this.topControl = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        this.topControl.setLayout((Layout)layout);
        Composite c = new Composite(this.topControl, 0);
        layout.topControl = c;
        this.errorText = new StyledText(this.topControl, 0);
        this.errorText.setFont(UIUtils.getFont("org.eclipse.egit.ui.CommitMessageFont"));
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        c.setLayout((Layout)parentLayout);
        return c;
    }

    private void layout() {
        boolean showComment = this.store.getBoolean("resourcehistory_show_rev_comment");
        boolean showFiles = this.store.getBoolean("resourcehistory_show_rev_detail");
        if (showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(null);
        } else if (showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.commentViewer.getControl());
        } else if (!showComment && showFiles) {
            this.graphDetailSplit.setMaximizedControl(null);
            this.revInfoSplit.setMaximizedControl(this.fileViewer.getControl());
        } else if (!showComment && !showFiles) {
            this.graphDetailSplit.setMaximizedControl(this.graph.getControl());
        }
        this.historyControl.layout();
    }

    private void attachCommitSelectionChanged() {
        this.graph.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                block10: {
                    ISelection s = event.getSelection();
                    if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                        GitHistoryPage.this.commentViewer.setInput(null);
                        GitHistoryPage.this.fileViewer.setInput(null);
                        return;
                    }
                    IStructuredSelection sel = (IStructuredSelection)s;
                    if (sel.size() > 1) {
                        GitHistoryPage.this.commentViewer.setInput(null);
                        GitHistoryPage.this.fileViewer.setInput(null);
                        return;
                    }
                    if (GitHistoryPage.this.input == null) {
                        return;
                    }
                    PlotCommit c = (PlotCommit)sel.getFirstElement();
                    GitHistoryPage.this.commentViewer.setInput(c);
                    PlotWalk walk = new PlotWalk(GitHistoryPage.this.input.getRepository());
                    try {
                        try {
                            RevCommit unfilteredCommit = walk.parseCommit((AnyObjectId)c);
                            RevCommit[] revCommitArray = unfilteredCommit.getParents();
                            int n = revCommitArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                RevCommit parent = revCommitArray[n2];
                                walk.parseBody((RevObject)parent);
                                ++n2;
                            }
                            GitHistoryPage.this.fileViewer.setInput(unfilteredCommit);
                        }
                        catch (IOException e) {
                            GitHistoryPage.this.fileViewer.setInput(c);
                            walk.dispose();
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        walk.dispose();
                        throw throwable;
                    }
                    walk.dispose();
                }
                if (GitHistoryPage.this.input.getSingleFile() != null) {
                    GitHistoryPage.this.fileViewer.selectFirstInterestingElement();
                }
            }
        });
        this.commentViewer.addCommitNavigationListener(new CommitNavigationListener(){

            @Override
            public void showCommit(RevCommit c) {
                GitHistoryPage.this.graph.selectCommit(c);
            }
        });
    }

    private void initActions() {
        try {
            this.showAllFilter = ShowFilter.valueOf(Activator.getDefault().getPreferenceStore().getString(PREF_SHOWALLFILTER));
        }
        catch (IllegalArgumentException e) {
            this.showAllFilter = ShowFilter.SHOWALLRESOURCE;
        }
        this.actions = new GitHistoryPageActions(this);
        this.setupToolBar();
        this.setupViewMenu();
    }

    private void setupToolBar() {
        IToolBarManager mgr = this.getSite().getActionBars().getToolBarManager();
        mgr.add(this.actions.findAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actions.showAllRepoVersionsAction);
        mgr.add((IAction)this.actions.showAllProjectVersionsAction);
        mgr.add((IAction)this.actions.showAllFolderVersionsAction);
        mgr.add((IAction)this.actions.showAllResourceVersionsAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actions.compareModeAction);
        mgr.add((IAction)this.actions.showAllBranchesAction);
    }

    private void setupViewMenu() {
        IMenuManager viewMenuMgr = this.getSite().getActionBars().getMenuManager();
        viewMenuMgr.add(this.actions.refreshAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        MenuManager showSubMenuMgr = new MenuManager(UIText.GitHistoryPage_ShowSubMenuLabel);
        viewMenuMgr.add((IContributionItem)showSubMenuMgr);
        showSubMenuMgr.add((IAction)this.actions.showAllBranchesAction);
        showSubMenuMgr.add((IAction)this.actions.showAdditionalRefsAction);
        showSubMenuMgr.add((IAction)this.actions.showNotesAction);
        showSubMenuMgr.add((IAction)this.actions.followRenamesAction);
        showSubMenuMgr.add((IContributionItem)new Separator());
        showSubMenuMgr.add(this.actions.findAction);
        showSubMenuMgr.add((IAction)this.actions.showCommentAction);
        showSubMenuMgr.add((IAction)this.actions.showFilesAction);
        showSubMenuMgr.add((IContributionItem)new Separator());
        showSubMenuMgr.add((IAction)this.actions.showRelativeDateAction);
        showSubMenuMgr.add((IAction)this.actions.showEmailAddressesAction);
        MenuManager showInMessageManager = new MenuManager(UIText.GitHistoryPage_InRevisionCommentSubMenuLabel);
        showSubMenuMgr.add((IContributionItem)showInMessageManager);
        showInMessageManager.add((IAction)this.actions.showBranchSequenceAction);
        showInMessageManager.add((IAction)this.actions.showTagSequenceAction);
        showInMessageManager.add((IAction)this.actions.wrapCommentAction);
        showInMessageManager.add((IAction)this.actions.fillCommentAction);
        MenuManager filterSubMenuMgr = new MenuManager(UIText.GitHistoryPage_FilterSubMenuLabel);
        viewMenuMgr.add((IContributionItem)filterSubMenuMgr);
        filterSubMenuMgr.add((IAction)this.actions.showAllRepoVersionsAction);
        filterSubMenuMgr.add((IAction)this.actions.showAllProjectVersionsAction);
        filterSubMenuMgr.add((IAction)this.actions.showAllFolderVersionsAction);
        filterSubMenuMgr.add((IAction)this.actions.showAllResourceVersionsAction);
        viewMenuMgr.add((IContributionItem)new Separator());
        viewMenuMgr.add((IAction)this.actions.compareModeAction);
        viewMenuMgr.add((IAction)this.actions.reuseCompareEditorAction);
    }

    public void dispose() {
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.listener);
        if (this.myRefsChangedHandle != null) {
            this.myRefsChangedHandle.remove();
            this.myRefsChangedHandle = null;
        }
        this.resources.dispose();
        for (ActionFactory.IWorkbenchAction action : this.actions.actionsToDispose) {
            action.dispose();
        }
        this.actions.actionsToDispose.clear();
        this.releaseGenerateHistoryJob();
        if (this.popupMgr != null) {
            IContributionItem i;
            IContributionItem[] iContributionItemArray = this.popupMgr.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
            iContributionItemArray = this.getSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                i = iContributionItemArray[n2];
                if (i instanceof ActionFactory.IWorkbenchAction) {
                    ((ActionFactory.IWorkbenchAction)i).dispose();
                }
                ++n2;
            }
        }
        this.renameTracker.reset(null);
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        Job.getJobManager().cancel(JobFamilies.HISTORY_DIFF);
        super.dispose();
    }

    public void setFocus() {
        if (this.repoHasBeenRemoved(this.currentRepo)) {
            this.clearHistoryPage();
        }
        this.graph.getControl().setFocus();
    }

    private boolean repoHasBeenRemoved(Repository repo) {
        return repo != null && repo.getDirectory() != null && !repo.getDirectory().exists();
    }

    private void clearHistoryPage() {
        this.currentRepo = null;
        this.name = "";
        this.input = null;
        this.clearCommentViewer();
        this.clearFileViewer();
        this.setInput(null);
    }

    private void clearCommentViewer() {
        this.commentViewer.setRepository(null);
        this.commentViewer.setInput(null);
    }

    private void clearFileViewer() {
        this.fileViewer.setTreeWalk(null, null);
        this.fileViewer.setInput(null);
    }

    public Control getControl() {
        return this.topControl;
    }

    public void refresh() {
        if (this.repoHasBeenRemoved(this.currentRepo)) {
            this.clearHistoryPage();
        }
        this.input = null;
        this.inputSet();
    }

    public void setCompareMode(boolean compareMode) {
        this.store.setValue("resourcehistory_compare_mode", compareMode);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.graph.getTableView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRefsChanged(RefsChangedEvent e) {
        if (this.input == null || e.getRepository() != this.input.getRepository()) {
            return;
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        GitHistoryPage gitHistoryPage = this;
        synchronized (gitHistoryPage) {
            if (this.refschangedRunnable == null) {
                this.refschangedRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!GitHistoryPage.this.getControl().isDisposed()) {
                            if (GitTraceLocation.HISTORYVIEW.isActive()) {
                                GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Executing async repository changed event");
                            }
                            GitHistoryPage.this.refschangedRunnable = null;
                            GitHistoryPage.this.initAndStartRevWalk(true);
                        }
                    }
                };
                this.getControl().getDisplay().asyncExec(this.refschangedRunnable);
            }
        }
    }

    public boolean setInput(Object object) {
        try {
            this.setWarningText(null);
            this.trace = GitTraceLocation.HISTORYVIEW.isActive();
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), object);
            }
            if (object == this.getInput()) {
                return true;
            }
            this.input = null;
            boolean bl = super.setInput(object);
            return bl;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    public boolean inputSet() {
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            if (this.input != null) {
                return true;
            }
            Object o = super.getInput();
            if (o == null) {
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            boolean showHead = false;
            boolean showRef = false;
            boolean showTag = false;
            Repository repo = null;
            RevCommit selection = null;
            Ref ref = null;
            if (o instanceof IResource) {
                RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)((IResource)o));
                if (mapping != null) {
                    repo = mapping.getRepository();
                    this.input = new HistoryPageInput(repo, new IResource[]{(IResource)o});
                    showHead = true;
                }
            } else if (o instanceof RepositoryTreeNode) {
                RepositoryTreeNode repoNode = (RepositoryTreeNode)o;
                repo = repoNode.getRepository();
                switch (repoNode.getType()) {
                    case FILE: {
                        File file = (File)((FileNode)repoNode).getObject();
                        this.input = new HistoryPageInput(repo, new File[]{file});
                        showHead = true;
                        break;
                    }
                    case FOLDER: {
                        File folder = (File)((FolderNode)repoNode).getObject();
                        this.input = new HistoryPageInput(repo, new File[]{folder});
                        showHead = true;
                        break;
                    }
                    case REF: {
                        this.input = new HistoryPageInput(repo);
                        ref = (Ref)((RefNode)repoNode).getObject();
                        showRef = true;
                        break;
                    }
                    case ADDITIONALREF: {
                        this.input = new HistoryPageInput(repo);
                        ref = (Ref)((AdditionalRefNode)repoNode).getObject();
                        showRef = true;
                        break;
                    }
                    case TAG: {
                        this.input = new HistoryPageInput(repo);
                        ref = (Ref)((TagNode)repoNode).getObject();
                        showTag = true;
                        break;
                    }
                    default: {
                        this.input = new HistoryPageInput(repo);
                        showHead = true;
                        break;
                    }
                }
            } else if (o instanceof HistoryPageInput) {
                this.input = (HistoryPageInput)o;
            } else {
                RepositoryMapping mapping;
                IResource resource = AdapterUtils.adaptToAnyResource((Object)o);
                if (resource != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
                    repo = mapping.getRepository();
                    this.input = new HistoryPageInput(repo, new IResource[]{resource});
                }
            }
            if (repo == null && (repo = (Repository)AdapterUtils.adapt((Object)o, Repository.class)) != null) {
                File file = (File)AdapterUtils.adapt((Object)o, File.class);
                this.input = file == null ? new HistoryPageInput(repo) : new HistoryPageInput(repo, new File[]{file});
            }
            selection = (RevCommit)AdapterUtils.adapt((Object)o, RevCommit.class);
            if (this.input == null) {
                this.name = "";
                this.setErrorMessage(UIText.GitHistoryPage_NoInputMessage);
                return false;
            }
            IResource[] inResources = this.input.getItems();
            File[] inFiles = this.input.getFileList();
            this.name = GitHistoryPage.calculateName(this.input);
            boolean filtersActive = inResources != null || inFiles != null;
            this.actions.showAllRepoVersionsAction.setEnabled(filtersActive);
            this.actions.showAllProjectVersionsAction.setEnabled(filtersActive);
            this.actions.showAllFolderVersionsAction.setEnabled(inResources != null);
            this.actions.showAllResourceVersionsAction.setEnabled(filtersActive);
            this.setErrorMessage(null);
            try {
                this.initAndStartRevWalk(false);
            }
            catch (IllegalStateException e) {
                Activator.handleError(e.getMessage(), e, true);
                if (this.trace) {
                    GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
                }
                return false;
            }
            if (showHead) {
                this.showHead(repo);
            }
            if (showRef) {
                this.showRef(ref, repo);
            }
            if (showTag) {
                this.showTag(ref, repo);
            }
            if (selection != null) {
                this.graph.selectCommitStored(selection);
            }
            return true;
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showHead(Repository repo) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                RevWalk rw = new RevWalk(repo);
                try {
                    ObjectId head = repo.resolve("HEAD");
                    if (head == null) {
                        return;
                    }
                    RevCommit c = rw.parseCommit((AnyObjectId)head);
                    this.graph.selectCommitStored(c);
                    return;
                }
                finally {
                    if (rw == null) return;
                    rw.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private void showRef(Ref ref, Repository repo) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk rw = new RevWalk(repo);){
                RevCommit c = rw.parseCommit((AnyObjectId)ref.getLeaf().getObjectId());
                this.graph.selectCommit(c);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private void showTag(Ref ref, Repository repo) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk rw = new RevWalk(repo);){
                RevTag t;
                RevObject anyCommit;
                RevCommit c = null;
                RevObject any = rw.parseAny((AnyObjectId)ref.getLeaf().getObjectId());
                if (any instanceof RevCommit) {
                    c = (RevCommit)any;
                } else if (any instanceof RevTag && (anyCommit = rw.parseAny((AnyObjectId)(t = rw.parseTag((AnyObjectId)any)).getObject())) instanceof RevCommit) {
                    c = (RevCommit)anyCommit;
                }
                if (c != null) {
                    this.graph.selectCommit(c);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private static String calculateName(HistoryPageInput in) {
        int n;
        int n2;
        Object[] objectArray;
        String repositoryName = Activator.getDefault().getRepositoryUtil().getRepositoryName(in.getRepository());
        if (in.getItems() == null && in.getFileList() == null) {
            return NLS.bind((String)UIText.GitHistoryPage_RepositoryNamePattern, (Object)repositoryName);
        }
        if (in.getItems() != null && in.getItems().length == 1) {
            String type;
            IResource resource = in.getItems()[0];
            switch (resource.getType()) {
                case 1: {
                    type = UIText.GitHistoryPage_FileType;
                    break;
                }
                case 4: {
                    type = UIText.GitHistoryPage_ProjectType;
                    break;
                }
                default: {
                    type = UIText.GitHistoryPage_FolderType;
                }
            }
            String path = resource.getFullPath().makeRelative().toString();
            if (resource.getType() == 2) {
                path = String.valueOf(path) + '/';
            }
            return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{type, path, repositoryName});
        }
        if (in.getFileList() != null && in.getFileList().length == 1) {
            String path;
            String type;
            File resource = in.getFileList()[0];
            if (resource.isDirectory()) {
                type = UIText.GitHistoryPage_FolderType;
                path = String.valueOf(resource.getPath()) + '/';
            } else {
                type = UIText.GitHistoryPage_FileType;
                path = resource.getPath();
            }
            return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{type, path, repositoryName});
        }
        int count = 0;
        StringBuilder b = new StringBuilder();
        if (in.getItems() != null) {
            count = in.getItems().length;
            objectArray = in.getItems();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IResource res = objectArray[n];
                b.append(res.getFullPath());
                if (res.getType() == 2) {
                    b.append('/');
                }
                if (b.length() > 100) {
                    b.append("...  ");
                    break;
                }
                b.append(", ");
                ++n;
            }
        }
        if (in.getFileList() != null) {
            count = in.getFileList().length;
            objectArray = in.getFileList();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                IResource file = objectArray[n];
                b.append(GitHistoryPage.getRepoRelativePath(in.getRepository(), (File)file));
                if (file.isDirectory()) {
                    b.append('/');
                }
                if (b.length() > 100) {
                    b.append("...  ");
                    break;
                }
                b.append(", ");
                ++n;
            }
        }
        if (b.length() > 2) {
            b.setLength(b.length() - 2);
        }
        String multiResourcePrefix = NLS.bind((String)UIText.GitHistoryPage_MultiResourcesType, (Object)count);
        return NLS.bind((String)NAME_PATTERN, (Object[])new Object[]{multiResourcePrefix, b.toString(), repositoryName});
    }

    private static String getRepoRelativePath(Repository repo, File file) {
        Path workdirPath = new Path(repo.getWorkTree().getPath());
        IPath filePath = new Path(file.getPath()).setDevice(null);
        return filePath.removeFirstSegments(workdirPath.segmentCount()).toString();
    }

    public void setErrorMessage(final String message) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), (Object)message);
        }
        this.getHistoryPageSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (GitHistoryPage.this.topControl.isDisposed()) {
                    return;
                }
                StackLayout layout = (StackLayout)GitHistoryPage.this.topControl.getLayout();
                if (message != null) {
                    GitHistoryPage.this.errorText.setText(message);
                    layout.topControl = GitHistoryPage.this.errorText;
                } else {
                    GitHistoryPage.this.errorText.setText("");
                    layout.topControl = GitHistoryPage.this.historyControl;
                }
                GitHistoryPage.this.topControl.layout();
            }
        });
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    public boolean isValidInput(Object object) {
        return GitHistoryPage.canShowHistoryFor(object);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getDescription() {
        String filterHint = null;
        switch (this.showAllFilter) {
            case SHOWALLREPO: {
                filterHint = UIText.GitHistoryPage_AllChangesInRepoHint;
                break;
            }
            case SHOWALLPROJECT: {
                filterHint = UIText.GitHistoryPage_AllChangesInProjectHint;
                break;
            }
            case SHOWALLFOLDER: {
                filterHint = UIText.GitHistoryPage_AllChangesInFolderHint;
                break;
            }
            case SHOWALLRESOURCE: {
                filterHint = UIText.GitHistoryPage_AllChangesOfResourceHint;
            }
        }
        return NLS.bind((String)DESCRIPTION_PATTERN, (Object)this.getName(), (Object)filterHint);
    }

    public String getName() {
        return this.name;
    }

    public HistoryPageInput getInputInternal() {
        return this.input;
    }

    void setWarningTextInUIThread(final Job j) {
        this.graph.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GitHistoryPage.this.graph.getControl().isDisposed() && GitHistoryPage.this.job == j) {
                    GitHistoryPage.this.setWarningText(UIText.GitHistoryPage_ListIncompleteWarningMessage);
                }
            }
        });
    }

    void showCommitList(final Job j, final SWTCommitList list, final SWTCommit[] asArray, final RevCommit toSelect, final boolean incomplete, final RevFlag highlightFlag) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation(), new Object[]{list.size()});
        }
        if (this.job != j || this.graph.getControl().isDisposed()) {
            return;
        }
        this.graph.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GitHistoryPage.this.graph.getControl().isDisposed() && GitHistoryPage.this.job == j) {
                    GitHistoryPage.this.graph.setInput(highlightFlag, list, asArray, GitHistoryPage.this.input, true);
                    if (toSelect != null) {
                        GitHistoryPage.this.graph.selectCommit(toSelect);
                    }
                    if (GitHistoryPage.this.getFollowRenames()) {
                        GitHistoryPage.this.updateInterestingPathsOfFileViewer();
                    }
                    if (GitHistoryPage.this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Setting input to table");
                    }
                    final Object currentInput = GitHistoryPage.this.getInput();
                    GitHistoryPage.this.searchBar.setInput(new ICommitsProvider(){

                        @Override
                        public Object getSearchContext() {
                            return currentInput;
                        }

                        @Override
                        public SWTCommit[] getCommits() {
                            return asArray;
                        }

                        @Override
                        public RevFlag getHighlight() {
                            return highlightFlag;
                        }
                    });
                    ((GitHistoryPage)GitHistoryPage.this).actions.findAction.setEnabled(true);
                    if (GitHistoryPage.this.store.getBoolean("resourcehistory_show_findtoolbar")) {
                        GitHistoryPage.this.searchBar.setVisible(true);
                    }
                    if (incomplete) {
                        GitHistoryPage.this.setWarningText(UIText.GitHistoryPage_ListIncompleteWarningMessage);
                    } else {
                        GitHistoryPage.this.setWarningText(null);
                    }
                    GitHistoryPage.this.setErrorMessage(null);
                }
            }
        });
        if (this.trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
    }

    private void updateInterestingPathsOfFileViewer() {
        this.fileViewer.setInterestingPaths(this.fileViewerInterestingPaths);
    }

    private void setWarningText(String warning) {
        if (this.warningComposite == null || this.warningComposite.isDisposed()) {
            return;
        }
        GridData gd = (GridData)this.warningComposite.getLayoutData();
        gd.exclude = warning == null;
        this.warningComposite.setVisible(!gd.exclude);
        if (warning != null) {
            this.warningLabel.setText(warning);
        } else {
            this.warningLabel.setText("");
        }
        this.warningComposite.getParent().layout(true);
    }

    void initAndStartRevWalk(boolean forceNewWalk) throws IllegalStateException {
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            if (this.input == null) {
                return;
            }
            Repository db = this.input.getRepository();
            if (this.repoHasBeenRemoved(db)) {
                this.clearHistoryPage();
                return;
            }
            AnyObjectId headId = this.resolveHead(db, true);
            if (headId == null) {
                this.graph.getTableView().setInput((Object)new SWTCommit[0]);
                this.currentHeadId = null;
                return;
            }
            ArrayList<FilterPath> paths = this.buildFilterPaths(this.input.getItems(), this.input.getFileList(), db);
            if (forceNewWalk || this.shouldRedraw(db, headId, paths)) {
                this.releaseGenerateHistoryJob();
                SWTWalk walk = this.createNewWalk(db, headId);
                this.setWalkStartPoints((RevWalk)walk, db, headId);
                this.setupFileViewer((RevWalk)walk, db, paths);
                this.setupCommentViewer(db);
                this.loadInitialHistory((RevWalk)walk);
            } else {
                this.graph.setHistoryPageInput(this.input);
            }
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private boolean shouldRedraw(Repository db, AnyObjectId headId, List<FilterPath> paths) {
        boolean pathChanged = this.pathChanged(this.pathFilters, paths);
        boolean headChanged = headId == null || !headId.equals(this.currentHeadId);
        boolean repoChanged = false;
        boolean allBranchesChanged = this.currentShowAllBranches ^ this.store.getBoolean("resourcehistory_show_all_branches");
        this.currentShowAllBranches = this.store.getBoolean("resourcehistory_show_all_branches");
        boolean additionalRefsChange = this.currentShowAdditionalRefs ^ this.store.getBoolean("resourcehistory_show_additionalrefs");
        this.currentShowAdditionalRefs = this.store.getBoolean("resourcehistory_show_additionalrefs");
        boolean showNotesChanged = this.currentShowNotes ^ this.store.getBoolean("resourcehistory_show_notes");
        this.currentShowNotes = this.store.getBoolean("resourcehistory_show_notes");
        boolean followRenamesChanged = this.currentFollowRenames ^ this.getFollowRenames();
        this.currentFollowRenames = this.getFollowRenames();
        if (!db.equals(this.currentRepo)) {
            repoChanged = true;
            this.currentRepo = db;
        }
        return pathChanged || headChanged || repoChanged || allBranchesChanged || additionalRefsChange || showNotesChanged || followRenamesChanged;
    }

    protected boolean getFollowRenames() {
        return this.store.getBoolean("resourcehistory_follow_renames");
    }

    private AnyObjectId resolveHead(Repository db, boolean acceptNull) {
        ObjectId headId;
        try {
            headId = db.resolve("HEAD");
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(db)), e);
        }
        if (headId == null && !acceptNull) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorParsingHead, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(db)));
        }
        return headId;
    }

    private ArrayList<FilterPath> buildFilterPaths(IResource[] inResources, File[] inFiles, Repository db) throws IllegalStateException {
        ArrayList<FilterPath> paths;
        block18: {
            block19: {
                block17: {
                    if (inResources == null) break block17;
                    paths = new ArrayList<FilterPath>(inResources.length);
                    IResource[] iResourceArray = inResources;
                    int n = inResources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource r = iResourceArray[n2];
                        RepositoryMapping map = RepositoryMapping.getMapping((IResource)r);
                        if (map != null) {
                            String path;
                            if (db != map.getRepository()) {
                                throw new IllegalStateException(UIText.RepositoryAction_multiRepoSelection);
                            }
                            if (this.showAllFilter == ShowFilter.SHOWALLFOLDER) {
                                path = r.getParent() instanceof IWorkspaceRoot ? map.getRepoRelativePath((IResource)r.getProject()) : map.getRepoRelativePath((IResource)r.getParent());
                                if (path != null && path.length() > 0) {
                                    paths.add(new FilterPath(path, false));
                                }
                            } else if (this.showAllFilter == ShowFilter.SHOWALLPROJECT) {
                                path = map.getRepoRelativePath((IResource)r.getProject());
                                if (path != null && path.length() > 0) {
                                    paths.add(new FilterPath(path, false));
                                }
                            } else if (this.showAllFilter != ShowFilter.SHOWALLREPO && (path = map.getRepoRelativePath(r)) != null && path.length() > 0) {
                                paths.add(new FilterPath(path, r.getType() == 1));
                            }
                        }
                        ++n2;
                    }
                    break block18;
                }
                if (inFiles == null) break block19;
                Path workdirPath = new Path(db.getWorkTree().getPath());
                Path gitDirPath = new Path(db.getDirectory().getPath());
                int segmentCount = workdirPath.segmentCount();
                paths = new ArrayList(inFiles.length);
                File[] fileArray = inFiles;
                int n = inFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    block22: {
                        boolean isRegularFile;
                        Path filePath;
                        block21: {
                            File file;
                            block20: {
                                file = fileArray[n3];
                                if (this.showAllFilter != ShowFilter.SHOWALLFOLDER) break block20;
                                filePath = new Path(file.getParentFile().getPath());
                                isRegularFile = false;
                                break block21;
                            }
                            if (this.showAllFilter == ShowFilter.SHOWALLPROJECT || this.showAllFilter == ShowFilter.SHOWALLREPO) break block22;
                            filePath = new Path(file.getPath());
                            isRegularFile = file.isFile();
                        }
                        if (gitDirPath.isPrefixOf((IPath)filePath)) {
                            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_FileOrFolderPartOfGitDirMessage, (Object)filePath.toOSString()));
                        }
                        IPath pathToAdd = filePath.removeFirstSegments(segmentCount).setDevice(null);
                        if (!pathToAdd.isEmpty()) {
                            paths.add(new FilterPath(pathToAdd.toString(), isRegularFile));
                        }
                    }
                    ++n3;
                }
                break block18;
            }
            paths = new ArrayList(0);
        }
        return paths;
    }

    private boolean pathChanged(List<FilterPath> o, List<FilterPath> n) {
        if (o == null) {
            return !n.isEmpty();
        }
        return !o.equals(n);
    }

    @NonNull
    private SWTWalk createNewWalk(Repository db, AnyObjectId headId) {
        this.currentHeadId = headId;
        SWTWalk walk = new SWTWalk(db);
        try {
            if (this.store.getBoolean("resourcehistory_show_additionalrefs")) {
                walk.addAdditionalRefs(db.getRefDatabase().getAdditionalRefs());
            }
            walk.addAdditionalRefs(db.getRefDatabase().getRefs("refs/notes/").values());
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorReadingAdditionalRefs, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(db)), e);
        }
        walk.sort(RevSort.COMMIT_TIME_DESC, true);
        walk.sort(RevSort.BOUNDARY, true);
        walk.setRetainBody(false);
        return walk;
    }

    private void setWalkStartPoints(RevWalk walk, Repository db, AnyObjectId headId) {
        try {
            if (this.store.getBoolean("resourcehistory_show_all_branches")) {
                this.markStartAllRefs(walk, "refs/heads/");
                this.markStartAllRefs(walk, "refs/remotes/");
                this.markStartAllRefs(walk, "refs/tags/");
            }
            if (this.store.getBoolean("resourcehistory_show_additionalrefs")) {
                this.markStartAdditionalRefs(walk);
            }
            if (this.store.getBoolean("resourcehistory_show_notes")) {
                this.markStartAllRefs(walk, "refs/notes/");
            } else {
                this.markUninteresting(walk, "refs/notes/");
            }
            walk.markStart(walk.parseCommit(headId));
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)UIText.GitHistoryPage_errorSettingStartPoints, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(db)), e);
        }
    }

    private void setupCommentViewer(Repository db) {
        this.commentViewer.setRepository(db);
        this.commentViewer.refresh();
    }

    private TreeWalk setupFileViewer(RevWalk walk, Repository db, List<FilterPath> paths) {
        TreeWalk fileWalker = this.createFileWalker(walk, db, paths);
        this.fileViewer.setTreeWalk(db, fileWalker);
        this.fileViewer.setInterestingPaths(this.fileViewerInterestingPaths);
        this.fileViewer.refresh();
        return fileWalker;
    }

    private void formatDiffs(final List<FileDiff> diffs) {
        Job.getJobManager().cancel(JobFamilies.HISTORY_DIFF);
        if (diffs.isEmpty()) {
            if (UIUtils.isUsable((Viewer)this.diffViewer)) {
                Document document = new Document();
                this.diffViewer.setDocument((IDocument)document);
            }
            return;
        }
        final Repository repository = this.fileViewer.getRepository();
        Job formatJob = new Job(UIText.GitHistoryPage_FormatDiffJobName){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                int maxLines = Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxDiffLines");
                final DiffDocument document = new DiffDocument();
                final DiffRegionFormatter formatter = new DiffRegionFormatter((IDocument)document, document.getLength(), maxLines);
                monitor.beginTask("", diffs.size());
                for (FileDiff diff : diffs) {
                    if (monitor.isCanceled() || diff.getCommit().getParentCount() > 1 || document.getNumberOfLines() > maxLines) break;
                    monitor.setTaskName(diff.getPath());
                    try {
                        formatter.write(repository, diff);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    monitor.worked(1);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                UIJob uiJob = new UIJob(UIText.GitHistoryPage_FormatDiffJobName){

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        if (uiMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (UIUtils.isUsable((Viewer)GitHistoryPage.this.diffViewer)) {
                            document.connect(formatter);
                            GitHistoryPage.this.diffViewer.setDocument((IDocument)document);
                            GitHistoryPage.this.resizeCommentAndDiffScrolledComposite();
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return JobFamilies.HISTORY_DIFF.equals(family);
                    }
                };
                uiJob.setRule((ISchedulingRule)GitHistoryPage.this.pageSchedulingRule);
                GitHistoryPage.this.schedule((Job)uiJob);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.HISTORY_DIFF.equals(family);
            }
        };
        formatJob.setRule((ISchedulingRule)this.pageSchedulingRule);
        this.schedule(formatJob);
    }

    private void setWrap(boolean wrap) {
        this.commentViewer.getTextWidget().setWordWrap(wrap);
        this.diffViewer.getTextWidget().setWordWrap(wrap);
        this.resizeCommentAndDiffScrolledComposite();
    }

    private void resizeCommentAndDiffScrolledComposite() {
        this.resizing = true;
        long start = 0L;
        int lines = 0;
        if (this.trace) {
            IDocument document = this.diffViewer.getDocument();
            lines = document != null ? document.getNumberOfLines() : 0;
            System.out.println("Lines: " + lines);
            if (lines > 1) {
                new Exception("resizeCommentAndDiffScrolledComposite").printStackTrace(System.out);
            }
            start = System.currentTimeMillis();
        }
        Point size = this.commentAndDiffComposite.computeSize(-1, -1);
        this.commentAndDiffScrolledComposite.setMinSize(size);
        this.resizing = false;
        if (this.trace) {
            long stop = System.currentTimeMillis();
            long time = stop - start;
            long lps = (long)(lines * 1000) / (time + 1L);
            System.out.println("Resize + diff: " + time + " ms, line/s: " + lps);
        }
    }

    private TreeWalk createFileWalker(RevWalk walk, Repository db, List<FilterPath> paths) {
        TreeWalk fileWalker = new TreeWalk(db);
        fileWalker.setRecursive(true);
        fileWalker.setFilter(TreeFilter.ANY_DIFF);
        if (this.store.getBoolean("resourcehistory_follow_renames") && !paths.isEmpty() && this.allRegularFiles(paths)) {
            this.pathFilters = paths;
            ArrayList<String> selectedPaths = new ArrayList<String>(paths.size());
            for (FilterPath filterPath : paths) {
                selectedPaths.add(filterPath.getPath());
            }
            this.fileViewerInterestingPaths = new HashSet<String>(selectedPaths);
            TreeFilter followFilter = this.createFollowFilterFor(selectedPaths);
            walk.setTreeFilter(followFilter);
            walk.setRevFilter(this.renameTracker.getFilter());
        } else if (paths.size() > 0) {
            this.pathFilters = paths;
            ArrayList<String> stringPaths = new ArrayList<String>(paths.size());
            for (FilterPath p : paths) {
                stringPaths.add(p.getPath());
            }
            walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(stringPaths), (TreeFilter)TreeFilter.ANY_DIFF));
            this.fileViewerInterestingPaths = new HashSet<String>(stringPaths);
        } else {
            this.pathFilters = null;
            walk.setTreeFilter(TreeFilter.ALL);
            this.fileViewerInterestingPaths = null;
        }
        return fileWalker;
    }

    private TreeFilter createFollowFilterFor(List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            throw new IllegalArgumentException("paths must not be null nor empty");
        }
        DiffConfig diffConfig = (DiffConfig)this.currentRepo.getConfig().get(DiffConfig.KEY);
        ArrayList<FollowFilter> followFilters = new ArrayList<FollowFilter>(paths.size());
        for (String path : paths) {
            followFilters.add(this.createFollowFilter(path, diffConfig));
        }
        if (followFilters.size() == 1) {
            FollowFilter followFilter = (FollowFilter)followFilters.get(0);
            this.renameTracker.reset(followFilter.getPath());
            return (TreeFilter)followFilters.get(0);
        }
        return OrTreeFilter.create(followFilters);
    }

    private FollowFilter createFollowFilter(String path, DiffConfig diffConfig) {
        FollowFilter followFilter = FollowFilter.create((String)path, (DiffConfig)diffConfig);
        followFilter.setRenameCallback(new RenameCallback(){

            public void renamed(DiffEntry entry) {
                GitHistoryPage.this.renameTracker.getCallback().renamed(entry);
                if (GitHistoryPage.this.fileViewerInterestingPaths != null) {
                    GitHistoryPage.this.fileViewerInterestingPaths.add(entry.getOldPath());
                    GitHistoryPage.this.fileViewerInterestingPaths.add(entry.getNewPath());
                }
            }
        });
        return followFilter;
    }

    private boolean allRegularFiles(List<FilterPath> paths) {
        for (FilterPath filterPath : paths) {
            if (filterPath.isRegularFile()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void loadItem(int item) {
        if (this.job != null && this.job.loadMoreItemsThreshold() < item) {
            this.loadHistory(item);
        }
    }

    @Override
    public void loadCommit(RevCommit c) {
        if (this.job == null) {
            return;
        }
        this.job.setLoadHint(c);
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling GenerateHistoryJob");
        }
        this.schedule(this.job);
    }

    private void loadInitialHistory(@NonNull RevWalk walk) {
        this.job = new GenerateHistoryJob(this, this.graph.getControl(), walk, this.resources);
        this.job.setRule(this.pageSchedulingRule);
        this.job.setLoadHint(-1);
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling initial GenerateHistoryJob");
        }
        this.schedule(this.job);
    }

    private void loadHistory(int itemToLoad) {
        if (this.job == null) {
            return;
        }
        this.job.setLoadHint(itemToLoad);
        if (this.trace) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Scheduling incremental GenerateHistoryJob");
        }
        this.schedule(this.job);
    }

    private IWorkbenchPartSite getPartSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        IWorkbenchPartSite site = null;
        if (part != null) {
            site = part.getSite();
        }
        return site;
    }

    private void schedule(Job j) {
        IWorkbenchSiteProgressService p;
        IWorkbenchPartSite site = this.getPartSite();
        if (site != null && (p = (IWorkbenchSiteProgressService)AdapterUtils.adapt((Object)site, IWorkbenchSiteProgressService.class)) != null) {
            p.schedule(j, 0L, true);
            return;
        }
        j.schedule();
    }

    private void markStartAllRefs(RevWalk walk, String prefix) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        for (Map.Entry refEntry : this.input.getRepository().getRefDatabase().getRefs(prefix).entrySet()) {
            Ref ref = (Ref)refEntry.getValue();
            if (ref.isSymbolic()) continue;
            this.markStartRef(walk, ref);
        }
    }

    private void markStartAdditionalRefs(RevWalk walk) throws IOException {
        List additionalRefs = this.input.getRepository().getRefDatabase().getAdditionalRefs();
        for (Ref ref : additionalRefs) {
            this.markStartRef(walk, ref);
        }
    }

    private void markStartRef(RevWalk walk, Ref ref) throws IOException, IncorrectObjectTypeException {
        try {
            RevObject refTarget = walk.parseAny((AnyObjectId)ref.getLeaf().getObjectId());
            RevObject peeled = walk.peel(refTarget);
            if (peeled instanceof RevCommit) {
                walk.markStart((RevCommit)peeled);
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private void markUninteresting(RevWalk walk, String prefix) throws IOException, MissingObjectException, IncorrectObjectTypeException {
        for (Map.Entry refEntry : this.input.getRepository().getRefDatabase().getRefs(prefix).entrySet()) {
            RevObject refTarget;
            Ref ref = (Ref)refEntry.getValue();
            if (ref.isSymbolic() || !((refTarget = walk.parseAny((AnyObjectId)ref.getLeaf().getObjectId())) instanceof RevCommit)) continue;
            walk.markUninteresting((RevCommit)refTarget);
        }
    }

    private void releaseGenerateHistoryJob() {
        if (this.job != null) {
            if (this.job.getState() != 0) {
                this.job.cancel();
            }
            this.job.release();
            this.job = null;
        }
    }

    public ShowInContext getShowInContext() {
        if (this.fileViewer != null && this.fileViewer.getControl().isFocusControl()) {
            return this.fileViewer.getShowInContext();
        }
        return null;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.team.ui.GenericHistoryView"};
    }

    public String getRenamedPath(String path, ObjectId commit) {
        return this.renameTracker.getPath(commit, path);
    }

    private static class FilterPath {
        private String path;
        private boolean regularFile;

        public FilterPath(String path, boolean regularFile) {
            this.path = path;
            this.regularFile = regularFile;
        }

        public String getPath() {
            return this.path;
        }

        public boolean isRegularFile() {
            return this.regularFile;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FilterPath)) {
                return false;
            }
            FilterPath other = (FilterPath)obj;
            if (this.path == null) {
                return other.path == null;
            }
            return this.path.equals(other.path);
        }

        public int hashCode() {
            if (this.path != null) {
                return this.path.hashCode();
            }
            return super.hashCode();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Path: ");
            builder.append(this.getPath());
            builder.append("regular: ");
            builder.append(this.isRegularFile());
            return builder.toString();
        }
    }

    private static class FooterTokenScanner
    extends HyperlinkTokenScanner {
        private static final Pattern ITALIC_LINE = Pattern.compile("^[A-Z](?:[A-Za-z]+-)+by: ");
        private final IToken italicToken;

        public FooterTokenScanner(SourceViewerConfiguration configuration, ISourceViewer viewer) {
            super(configuration, viewer);
            TextAttribute italic;
            Object defaults = this.defaultToken.getData();
            if (defaults instanceof TextAttribute) {
                TextAttribute defaultAttribute = (TextAttribute)defaults;
                int style = defaultAttribute.getStyle() ^ 2;
                italic = new TextAttribute(defaultAttribute.getForeground(), defaultAttribute.getBackground(), style, defaultAttribute.getFont());
            } else {
                italic = new TextAttribute(null, null, 2);
            }
            this.italicToken = new Token((Object)italic);
        }

        @Override
        protected IToken scanToken() {
            try {
                String line;
                Matcher m;
                IRegion region = this.document.getLineInformationOfOffset(this.currentOffset);
                if (this.currentOffset == region.getOffset() && (m = ITALIC_LINE.matcher(line = this.document.get(this.currentOffset, region.getLength()))).find()) {
                    this.currentOffset = Math.min(this.endOfRange, this.currentOffset + region.getLength());
                    return this.italicToken;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class GitHistoryPageActions {
        List<ActionFactory.IWorkbenchAction> actionsToDispose = new ArrayList<ActionFactory.IWorkbenchAction>();
        BooleanPrefAction showRelativeDateAction;
        BooleanPrefAction showEmailAddressesAction;
        BooleanPrefAction showNotesAction;
        BooleanPrefAction showTagSequenceAction;
        BooleanPrefAction showBranchSequenceAction;
        BooleanPrefAction wrapCommentAction;
        BooleanPrefAction fillCommentAction;
        IAction findAction;
        IAction refreshAction;
        BooleanPrefAction showCommentAction;
        BooleanPrefAction showFilesAction;
        ActionFactory.IWorkbenchAction compareModeAction;
        ActionFactory.IWorkbenchAction showAllBranchesAction;
        ActionFactory.IWorkbenchAction showAdditionalRefsAction;
        BooleanPrefAction followRenamesAction;
        ActionFactory.IWorkbenchAction reuseCompareEditorAction;
        ShowFilterAction showAllRepoVersionsAction;
        ShowFilterAction showAllProjectVersionsAction;
        ShowFilterAction showAllFolderVersionsAction;
        ShowFilterAction showAllResourceVersionsAction;
        private GitHistoryPage historyPage;

        GitHistoryPageActions(GitHistoryPage historyPage) {
            this.historyPage = historyPage;
            this.createActions();
        }

        private static String formatAccelerator(int accelerator) {
            return SWTKeySupport.getKeyFormatterForPlatform().format(SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator));
        }

        private void createActions() {
            this.createFindToolbarAction();
            this.createRefreshAction();
            this.createFilterActions();
            this.createCompareModeAction();
            this.createReuseCompareEditorAction();
            this.createShowAllBranchesAction();
            this.createShowAdditionalRefsAction();
            this.createShowCommentAction();
            this.createShowFilesAction();
            this.createShowRelativeDateAction();
            this.createShowEmailAddressesAction();
            this.createShowNotesAction();
            this.createShowTagSequenceAction();
            this.createShowBranchSequenceAction();
            this.createWrapCommentAction();
            this.createFillCommentAction();
            this.createFollowRenamesAction();
            this.wrapCommentAction.setEnabled(this.showCommentAction.isChecked());
            this.fillCommentAction.setEnabled(this.showCommentAction.isChecked());
        }

        private void createFindToolbarAction() {
            this.findAction = new Action(UIText.GitHistoryPage_FindMenuLabel, UIIcons.ELCL16_FIND){

                public void run() {
                    historyPage.store.setValue("resourcehistory_show_findtoolbar", this.isChecked());
                    if (historyPage.store.needsSaving()) {
                        try {
                            historyPage.store.save();
                        }
                        catch (IOException e) {
                            Activator.handleError(e.getMessage(), e, false);
                        }
                    }
                    historyPage.searchBar.setVisible(this.isChecked());
                }

                public void setChecked(boolean checked) {
                    super.setChecked(checked);
                    int accelerator = this.getAccelerator();
                    if (checked) {
                        this.setToolTipText(NLS.bind((String)UIText.GitHistoryPage_FindHideTooltip, (Object)GitHistoryPageActions.formatAccelerator(accelerator)));
                    } else {
                        this.setToolTipText(NLS.bind((String)UIText.GitHistoryPage_FindShowTooltip, (Object)GitHistoryPageActions.formatAccelerator(accelerator)));
                    }
                }
            };
            this.findAction.setAccelerator(SWT.MOD1 | 0x46);
            this.findAction.setEnabled(false);
            boolean isChecked = this.historyPage.store.getBoolean("resourcehistory_show_findtoolbar");
            this.findAction.setChecked(isChecked);
            this.historyPage.getSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), this.findAction);
            this.historyPage.getSite().getActionBars().updateActionBars();
        }

        private void createRefreshAction() {
            this.refreshAction = new Action(UIText.GitHistoryPage_RefreshMenuLabel, UIIcons.ELCL16_REFRESH){

                public void run() {
                    historyPage.refresh();
                }
            };
        }

        private void createFilterActions() {
            this.showAllRepoVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLREPO, UIIcons.REPOSITORY, UIText.GitHistoryPage_AllInRepoMenuLabel, UIText.GitHistoryPage_AllInRepoTooltip);
            this.showAllProjectVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLPROJECT, UIIcons.FILTERPROJECT, UIText.GitHistoryPage_AllInProjectMenuLabel, UIText.GitHistoryPage_AllInProjectTooltip);
            this.showAllFolderVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLFOLDER, UIIcons.FILTERFOLDER, UIText.GitHistoryPage_AllInParentMenuLabel, UIText.GitHistoryPage_AllInParentTooltip);
            this.showAllResourceVersionsAction = new ShowFilterAction(ShowFilter.SHOWALLRESOURCE, UIIcons.FILTERRESOURCE, UIText.GitHistoryPage_AllOfResourceMenuLabel, UIText.GitHistoryPage_AllOfResourceTooltip);
            this.showAllRepoVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllRepoVersionsAction.filter);
            this.showAllProjectVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllProjectVersionsAction.filter);
            this.showAllFolderVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllFolderVersionsAction.filter);
            this.showAllResourceVersionsAction.setChecked(this.historyPage.showAllFilter == this.showAllResourceVersionsAction.filter);
        }

        private void createCompareModeAction() {
            this.compareModeAction = new BooleanPrefAction(this, "resourcehistory_compare_mode", UIText.GitHistoryPage_CompareModeMenuLabel){

                @Override
                void apply(boolean value) {
                }
            };
            this.compareModeAction.setImageDescriptor(UIIcons.ELCL16_COMPARE_VIEW);
            this.compareModeAction.setToolTipText(UIText.GitHistoryPage_compareMode);
            this.actionsToDispose.add(this.compareModeAction);
        }

        private void createReuseCompareEditorAction() {
            this.reuseCompareEditorAction = new CompareUtils.ReuseCompareEditorAction();
            this.actionsToDispose.add(this.reuseCompareEditorAction);
        }

        private void createShowAllBranchesAction() {
            this.showAllBranchesAction = new BooleanPrefAction(this, "resourcehistory_show_all_branches", UIText.GitHistoryPage_ShowAllBranchesMenuLabel){

                @Override
                void apply(boolean value) {
                    historyPage.refresh();
                }
            };
            this.showAllBranchesAction.setImageDescriptor(UIIcons.BRANCH);
            this.showAllBranchesAction.setToolTipText(UIText.GitHistoryPage_showAllBranches);
            this.actionsToDispose.add(this.showAllBranchesAction);
        }

        private void createShowAdditionalRefsAction() {
            this.showAdditionalRefsAction = new BooleanPrefAction(this, "resourcehistory_show_additionalrefs", UIText.GitHistoryPage_ShowAdditionalRefsMenuLabel){

                @Override
                void apply(boolean value) {
                    historyPage.refresh();
                }
            };
            this.actionsToDispose.add(this.showAdditionalRefsAction);
        }

        private void createFollowRenamesAction() {
            this.followRenamesAction = new BooleanPrefAction(this, "resourcehistory_follow_renames", UIText.GitHistoryPage_FollowRenames){

                @Override
                void apply(boolean follow) {
                    historyPage.refresh();
                }
            };
            this.followRenamesAction.apply(this.followRenamesAction.isChecked());
            this.actionsToDispose.add(this.followRenamesAction);
        }

        private void createShowCommentAction() {
            this.showCommentAction = new BooleanPrefAction(this, "resourcehistory_show_rev_comment", UIText.ResourceHistory_toggleRevComment){

                @Override
                void apply(boolean value) {
                    historyPage.layout();
                    wrapCommentAction.setEnabled(this.isChecked());
                    fillCommentAction.setEnabled(this.isChecked());
                }
            };
            this.actionsToDispose.add(this.showCommentAction);
        }

        private void createShowFilesAction() {
            this.showFilesAction = new BooleanPrefAction(this, "resourcehistory_show_rev_detail", UIText.ResourceHistory_toggleRevDetail){

                @Override
                void apply(boolean value) {
                    historyPage.layout();
                }
            };
            this.actionsToDispose.add(this.showFilesAction);
        }

        private void createShowRelativeDateAction() {
            this.showRelativeDateAction = new BooleanPrefAction(this, "resourcehistory_show_relative_date", UIText.ResourceHistory_toggleRelativeDate){

                @Override
                void apply(boolean date) {
                }
            };
            this.showRelativeDateAction.apply(this.showRelativeDateAction.isChecked());
            this.actionsToDispose.add(this.showRelativeDateAction);
        }

        private void createShowEmailAddressesAction() {
            this.showEmailAddressesAction = new BooleanPrefAction(this, "resourcehistory_show_email_addresses", UIText.GitHistoryPage_toggleEmailAddresses){

                @Override
                void apply(boolean date) {
                }
            };
            this.showEmailAddressesAction.apply(this.showEmailAddressesAction.isChecked());
            this.actionsToDispose.add(this.showEmailAddressesAction);
        }

        private void createShowNotesAction() {
            this.showNotesAction = new BooleanPrefAction(this, "resourcehistory_show_notes", UIText.ResourceHistory_toggleShowNotes){

                @Override
                void apply(boolean value) {
                    historyPage.refresh();
                }
            };
            this.showNotesAction.apply(this.showNotesAction.isChecked());
            this.actionsToDispose.add(this.showNotesAction);
        }

        private void createShowTagSequenceAction() {
            this.showTagSequenceAction = new BooleanPrefAction(this, "HistoryView_ShowTagSequence", UIText.ResourceHistory_ShowTagSequence){

                @Override
                void apply(boolean value) {
                }
            };
            this.showTagSequenceAction.apply(this.showTagSequenceAction.isChecked());
            this.actionsToDispose.add(this.showTagSequenceAction);
        }

        private void createShowBranchSequenceAction() {
            this.showBranchSequenceAction = new BooleanPrefAction(this, "HistoryView_ShowBranchSequence", UIText.ResourceHistory_ShowBranchSequence){

                @Override
                void apply(boolean value) {
                }
            };
            this.showBranchSequenceAction.apply(this.showBranchSequenceAction.isChecked());
            this.actionsToDispose.add(this.showBranchSequenceAction);
        }

        private void createWrapCommentAction() {
            this.wrapCommentAction = new BooleanPrefAction(this, "resourcehistory_show_comment_wrap", UIText.ResourceHistory_toggleCommentWrap){

                @Override
                void apply(boolean wrap) {
                }
            };
            this.wrapCommentAction.apply(this.wrapCommentAction.isChecked());
            this.actionsToDispose.add(this.wrapCommentAction);
        }

        private void createFillCommentAction() {
            this.fillCommentAction = new BooleanPrefAction(this, "resourcehistory_fill_comment_paragraph", UIText.ResourceHistory_toggleCommentFill){

                @Override
                void apply(boolean fill) {
                }
            };
            this.fillCommentAction.apply(this.fillCommentAction.isChecked());
            this.actionsToDispose.add(this.fillCommentAction);
        }

        private abstract class BooleanPrefAction
        extends Action
        implements IPropertyChangeListener,
        ActionFactory.IWorkbenchAction {
            private final String prefName;

            BooleanPrefAction(String pn, String text) {
                this.setText(text);
                this.prefName = pn;
                GitHistoryPageActions.this.historyPage.store.addPropertyChangeListener((IPropertyChangeListener)this);
                this.setChecked(GitHistoryPageActions.this.historyPage.store.getBoolean(this.prefName));
            }

            public void run() {
                GitHistoryPageActions.this.historyPage.store.setValue(this.prefName, this.isChecked());
                if (GitHistoryPageActions.this.historyPage.store.needsSaving()) {
                    try {
                        GitHistoryPageActions.this.historyPage.store.save();
                    }
                    catch (IOException e) {
                        Activator.handleError(e.getMessage(), e, false);
                    }
                }
            }

            abstract void apply(boolean var1);

            public void propertyChange(PropertyChangeEvent event) {
                if (this.prefName.equals(event.getProperty())) {
                    this.setChecked(GitHistoryPageActions.this.historyPage.store.getBoolean(this.prefName));
                    this.apply(this.isChecked());
                }
            }

            public void dispose() {
                GitHistoryPageActions.this.historyPage.store.removePropertyChangeListener((IPropertyChangeListener)this);
            }
        }

        private class ShowFilterAction
        extends Action {
            private final ShowFilter filter;

            ShowFilterAction(ShowFilter filter, ImageDescriptor icon, String menuLabel, String toolTipText) {
                super(null, 2);
                this.filter = filter;
                this.setImageDescriptor(icon);
                this.setText(menuLabel);
                this.setToolTipText(toolTipText);
            }

            public void run() {
                String oldName = GitHistoryPageActions.this.historyPage.getName();
                String oldDescription = GitHistoryPageActions.this.historyPage.getDescription();
                if (!this.isChecked() && GitHistoryPageActions.this.historyPage.showAllFilter == this.filter) {
                    GitHistoryPageActions.this.historyPage.showAllFilter = ShowFilter.SHOWALLRESOURCE;
                    GitHistoryPageActions.this.showAllResourceVersionsAction.setChecked(true);
                    GitHistoryPageActions.this.historyPage.initAndStartRevWalk(false);
                }
                if (this.isChecked() && GitHistoryPageActions.this.historyPage.showAllFilter != this.filter) {
                    GitHistoryPageActions.this.historyPage.showAllFilter = this.filter;
                    if (this != GitHistoryPageActions.this.showAllRepoVersionsAction) {
                        GitHistoryPageActions.this.showAllRepoVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllProjectVersionsAction) {
                        GitHistoryPageActions.this.showAllProjectVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllFolderVersionsAction) {
                        GitHistoryPageActions.this.showAllFolderVersionsAction.setChecked(false);
                    }
                    if (this != GitHistoryPageActions.this.showAllResourceVersionsAction) {
                        GitHistoryPageActions.this.showAllResourceVersionsAction.setChecked(false);
                    }
                    GitHistoryPageActions.this.historyPage.initAndStartRevWalk(false);
                }
                GitHistoryPageActions.this.historyPage.firePropertyChange(GitHistoryPageActions.this.historyPage, "org.eclipse.team.ui.name", oldName, GitHistoryPageActions.this.historyPage.getName());
                GitHistoryPageActions.this.historyPage.firePropertyChange(GitHistoryPageActions.this.historyPage, "org.eclipse.team.ui.description", oldDescription, GitHistoryPageActions.this.historyPage.getDescription());
                Activator.getDefault().getPreferenceStore().setValue(GitHistoryPage.PREF_SHOWALLFILTER, GitHistoryPageActions.this.historyPage.showAllFilter.toString());
            }

            public String toString() {
                return "ShowFilter[" + this.filter.toString() + "]";
            }
        }
    }

    private static class HistoryPageRule
    implements ISchedulingRule {
        private HistoryPageRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    }

    private static interface ICommitsProvider {
        public Object getSearchContext();

        public SWTCommit[] getCommits();

        public RevFlag getHighlight();
    }

    private static class SearchBar
    extends ControlContribution {
        private IActionBars bars;
        private FindToolbar toolbar;
        private Object searchContext;
        private String lastText;
        private ObjectId lastObjectId;
        private Object lastSearchContext;
        private ICommitsProvider provider;
        private boolean wasVisible = false;
        private final CommitGraphTable graph;
        private final IAction openCloseToggle;
        private final Listener selectionListener = new Listener(){

            public void handleEvent(Event evt) {
                RevCommit commit = (RevCommit)evt.data;
                lastObjectId = commit.getId();
                graph.selectCommit(commit);
            }
        };
        private final KeyListener keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                if (key == 27) {
                    this.setVisible(false);
                    e.doit = false;
                }
            }
        };
        private final FindToolbar.StatusListener statusListener = new FindToolbar.StatusListener(){

            @Override
            public void setMessage(FindToolbar originator, String text) {
                IStatusLineManager status = bars.getStatusLineManager();
                if (status != null) {
                    status.setMessage(text);
                }
            }
        };
        private final Listener mouseListener = new Listener(){
            private boolean hasFocus;
            private boolean hadFocusOnMouseDown;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 15: {
                        toolbar.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                hasFocus = true;
                            }
                        });
                        break;
                    }
                    case 16: {
                        this.hasFocus = false;
                        break;
                    }
                    case 3: {
                        this.hadFocusOnMouseDown = this.hasFocus;
                        break;
                    }
                    case 4: {
                        if (this.hadFocusOnMouseDown) break;
                        graph.getControl().setFocus();
                        toolbar.setFocus();
                        break;
                    }
                }
            }
        };

        public SearchBar(String id, CommitGraphTable graph, IAction openCloseAction, IActionBars bars) {
            super(id);
            super.setVisible(false);
            this.graph = graph;
            this.openCloseToggle = openCloseAction;
            this.bars = bars;
        }

        private void beforeHide() {
            this.lastText = this.toolbar.getText();
            this.lastSearchContext = this.searchContext;
            this.statusListener.setMessage(this.toolbar, "");
            this.toolbar = null;
            this.openCloseToggle.setChecked(false);
            this.wasVisible = false;
        }

        public void setVisible(boolean visible) {
            if (visible != this.isVisible()) {
                if (!visible) {
                    this.beforeHide();
                }
                super.setVisible(visible);
                this.bars.updateActionBars();
                if (visible && this.toolbar != null) {
                    this.openCloseToggle.setChecked(true);
                    this.graph.getControl().setFocus();
                    this.toolbar.setFocus();
                } else if (!visible && !this.graph.getControl().isDisposed()) {
                    this.graph.getControl().setFocus();
                }
            }
        }

        public boolean isDynamic() {
            return true;
        }

        protected Control createControl(Composite parent) {
            boolean hasInput;
            this.toolbar = new FindToolbar(parent);
            this.toolbar.setBackground(null);
            this.toolbar.addKeyListener(this.keyListener);
            this.toolbar.addListener(15, this.mouseListener);
            this.toolbar.addListener(16, this.mouseListener);
            this.toolbar.addListener(3, this.mouseListener);
            this.toolbar.addListener(4, this.mouseListener);
            this.toolbar.addListener(24, e -> {
                String string = this.lastText = this.toolbar.getText();
            });
            this.toolbar.addStatusListener(this.statusListener);
            this.toolbar.addSelectionListener(this.selectionListener);
            boolean bl = hasInput = this.provider != null;
            if (hasInput) {
                this.setInput(this.provider);
            }
            if (this.lastText != null) {
                if (this.lastSearchContext != null && this.lastSearchContext.equals(this.searchContext)) {
                    this.toolbar.setPreselect(this.lastObjectId);
                }
                this.toolbar.setText(this.lastText, hasInput);
            }
            this.lastSearchContext = null;
            this.lastObjectId = null;
            if (this.wasVisible) {
                return this.toolbar;
            }
            this.wasVisible = true;
            this.toolbar.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (toolbar != null && !toolbar.isDisposed()) {
                        graph.getControl().setFocus();
                        toolbar.setFocus();
                    }
                }
            });
            return this.toolbar;
        }

        public void setInput(ICommitsProvider provider) {
            this.provider = provider;
            if (this.toolbar != null) {
                this.searchContext = provider.getSearchContext();
                this.toolbar.setInput(provider.getHighlight(), this.graph.getTableView().getTable(), provider.getCommits());
            }
        }
    }

    static enum ShowFilter {
        SHOWALLRESOURCE,
        SHOWALLFOLDER,
        SHOWALLPROJECT,
        SHOWALLREPO;

    }
}

