/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard.ui;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.dashboard.internal.DashboardControlsProvider;
import com.nxp.swtools.utils.view.ToolView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;

public class DashboardView
extends ToolView {
    @NonNull
    public static final String ID = "com.nxp.swtools.dashboard.DashboardView";
    @Nullable
    private Control defaultControl;
    @Nullable
    private PerspectiveAdapter perspectiveListener;
    @Nullable
    private DelayedExecution delayedUiRefresher;

    public final void createPartControl(Composite parent) {
        assert (parent != null);
        final DashboardControlsProvider factory = new DashboardControlsProvider(null, null, false);
        this.defaultControl = factory.createDashboardControls(parent);
        this.delayedUiRefresher = factory.getDelayedUiRefresher();
        this.perspectiveListener = new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                factory.getDelayedUiRefresher().requestExecution("perspective activated");
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                factory.getDelayedUiRefresher().requestExecution("perspective changed");
            }
        };
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this.perspectiveListener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this.perspectiveListener);
        super.dispose();
    }

    public void setFocus() {
        if (this.defaultControl != null) {
            this.defaultControl.setFocus();
        }
    }

    public boolean isUpdated() {
        return this.delayedUiRefresher != null ? !this.delayedUiRefresher.isExecRequested() : false;
    }
}

