/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard.ui;

import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.dashboard.Messages;
import com.nxp.swtools.dashboard.internal.DashboardControlsProvider;
import com.nxp.swtools.dashboard.internal.DashboardUiUtils;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.resources.ToolsImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DashboardDialog
extends Dialog {
    private static boolean shouldSelectPerspective;
    @Nullable
    private static DashboardDialog dialogOpened;
    @NonNull
    private DashboardControlsProvider contentProvider;
    @Nullable
    private ControlDecoration closeButtonDecorator;

    public DashboardDialog(@NonNull Shell parent, @Nullable String header) {
        super(parent);
        this.contentProvider = new DashboardControlsProvider(() -> this.okPressed(), header, shouldSelectPerspective);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.get().Dashboard_DialogTitle);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)newShell, "com.nxp.swtools.dashboard.DashboardDialog");
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        assert (parent != null);
        return this.contentProvider.createDashboardControls(parent);
    }

    protected void updateCloseButtonDecorator() {
        ControlDecoration decorator = this.closeButtonDecorator;
        if (decorator != null) {
            String msg = DashboardUiUtils.getDisabledProductErrorMessage();
            if (msg == null) {
                decorator.hide();
            } else {
                decorator.setImage(ToolsImages.getStatusDecoratorImg((int)2));
                decorator.setDescriptionText(msg);
                decorator.show();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.contentProvider.backgroundColor);
        Button closeButton = this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        this.closeButtonDecorator = new ControlDecoration((Control)closeButton, 16512);
        this.updateCloseButtonDecorator();
    }

    public static void createAndOpen(@Nullable String header, boolean shouldSelPerspective) {
        if (dialogOpened != null) {
            return;
        }
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        SharedConfigurationAdapter listener = null;
        try {
            DashboardDialog dlg;
            shouldSelectPerspective = shouldSelPerspective;
            dialogOpened = dlg = new DashboardDialog(ShellProvider.getAnyShellParent(), header);
            listener = new SharedConfigurationAdapter(){

                public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                    if (IConfigChangeContext.ConfigChangeType.TOOL_TOGGLE.equals((Object)changeContext.getChangeType())) {
                        dlg.updateCloseButtonDecorator();
                    }
                }
            };
            sharedConfig.addListener((ISharedConfigurationListener)listener);
            dlg.open();
        }
        catch (Throwable throwable) {
            dialogOpened = null;
            if (listener != null) {
                sharedConfig.removeListener(listener);
            }
            throw throwable;
        }
        dialogOpened = null;
        if (listener != null) {
            sharedConfig.removeListener((ISharedConfigurationListener)listener);
        }
    }

    public static @Nullable DashboardDialog getDashboardDialogForTest() {
        return dialogOpened;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isUpdated() {
        return !this.contentProvider.getDelayedUiRefresher().isExecRequested();
    }
}

