/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard.internal;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.dashboard.Messages;
import com.nxp.swtools.dashboard.internal.DashboardUiUtils;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.utils.ProblemsViewIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

class FilteredProblems {
    @NonNull
    final String toolId;
    @Nullable
    final String functionName;
    @Nullable
    final ITool toolToSwitchPerspective;
    int highestLevel = -1;
    int numErrors = 0;
    int numWarnings = 0;
    int numInfo = 0;
    final Predicate<@NonNull IValidationProblem> filterValidationProblems;
    final Predicate<@NonNull IGenericProblem> filterGenericProblems;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static @NonNull FilteredProblems countNumberOfProblemsForFunction(@NonNull String toolId, @NonNull String functionName, @Nullable ITool toolToSwitchPerspective) {
        FilteredProblems result = new FilteredProblems(toolId, functionName, toolToSwitchPerspective);
        @NonNull Collection problems = ValidationEngineFactory.getProblemsCollection();
        Stream<@NonNull IGenericProblem> funcProblems = problems.stream().map(p -> p instanceof IGenericProblem ? (IGenericProblem)p : null).filter(Objects::nonNull).filter(result.filterGenericProblems);
        assert (funcProblems != null);
        result.countProblems(funcProblems);
        @NonNull Collection validationProblems = ValidationEngineFactory.getValidationProblemsCollection();
        Stream<@NonNull IValidationProblem> funcValidationProblems = validationProblems.stream().filter(result.filterValidationProblems);
        assert (funcValidationProblems != null);
        result.countProblems(funcValidationProblems);
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static @NonNull FilteredProblems countNumberOfProblemsForTool(@NonNull ITool tool) {
        FilteredProblems result = new FilteredProblems(tool.getToolId(), null, tool);
        @NonNull Collection problems = ValidationEngineFactory.getProblemsCollection();
        Stream<@NonNull IGenericProblem> toolProblems = problems.stream().map(p -> p instanceof IGenericProblem ? (IGenericProblem)p : null).filter(Objects::nonNull).filter(result.filterGenericProblems);
        assert (toolProblems != null);
        result.countProblems(toolProblems);
        @NonNull Collection validationProblems = ValidationEngineFactory.getValidationProblemsCollection();
        Stream<@NonNull IValidationProblem> funcValidationProblems = validationProblems.stream().filter(result.filterValidationProblems);
        assert (funcValidationProblems != null);
        result.countProblems(funcValidationProblems);
        return result;
    }

    private FilteredProblems(@NonNull String toolId, @Nullable String functionName, @Nullable ITool toolToSwitchPerspective) {
        this.toolId = toolId;
        this.toolToSwitchPerspective = toolToSwitchPerspective;
        this.functionName = functionName;
        this.filterValidationProblems = p -> toolId.equals(p.getTool().getName()) && Objects.equals(functionName, p.getConfiguration().getConfigurationName()) || this.isProblemSourceMatch(p.getDependency().getSource());
        this.filterGenericProblems = p -> this.isProblemSourceMatch(p.getSource());
    }

    boolean isProblemSourceMatch(@NonNull String source) {
        String realFuncName;
        String expFuncName;
        if (source.isEmpty() && this.toolId.equals("McuConfiguration")) {
            return true;
        }
        if (this.functionName != null) {
            expFuncName = this.functionName;
        } else {
            if (this.toolId.equals(source)) {
                return true;
            }
            expFuncName = "";
        }
        if (source.startsWith(String.valueOf(this.toolId) + ": ")) {
            realFuncName = source.substring(this.toolId.length() + ": ".length());
        } else if (source.startsWith(String.valueOf(this.toolId) + ':')) {
            realFuncName = source.substring(this.toolId.length() + 1);
        } else {
            return false;
        }
        return expFuncName.equals(realFuncName) || expFuncName.isEmpty();
    }

    @Nullable String getProblemsDescription() {
        if (this.highestLevel < 0) {
            return null;
        }
        ArrayList<@NonNull String> prblmList = new ArrayList<String>();
        if (this.numErrors > 0) {
            prblmList.add(String.valueOf(String.valueOf(this.numErrors)) + Messages.get().FilteredProblems_Errors);
        }
        if (this.numWarnings > 0) {
            prblmList.add(String.valueOf(String.valueOf(this.numWarnings)) + Messages.get().FilteredProblems_Warnings);
        }
        if (this.numInfo > 0) {
            prblmList.add(String.valueOf(String.valueOf(this.numInfo)) + Messages.get().FilteredProblems_InfoMsgs);
        }
        if (prblmList.isEmpty()) {
            assert (false);
            return null;
        }
        return String.format(Messages.get().Dashboard_ProblemsTooltip, CollectionsUtils.formatList(prblmList, (String)", ", null));
    }

    void countProblems(@NonNull Stream<? extends @NonNull IBaseProblem> problems) {
        problems.forEach(p -> {
            this.highestLevel = Integer.max(p.getProblemLevel(), this.highestLevel);
            switch (p.getProblemLevel()) {
                case 2: 
                case 3: {
                    ++this.numErrors;
                    break;
                }
                case 1: {
                    ++this.numWarnings;
                    break;
                }
                case 0: {
                    ++this.numInfo;
                }
            }
        });
    }

    @Nullable Control createProblemsButtonIfNeeded(@NonNull Composite parent, @Nullable Runnable selectProblemSource, @Nullable Runnable endModalAction) {
        String tooltip = this.getProblemsDescription();
        if (tooltip == null) {
            return null;
        }
        ToolBar toolBar = new ToolBar(parent, 0x800100);
        ToolItem prblmBtn = new ToolItem(toolBar, 8);
        prblmBtn.setImage(ProblemsViewIcons.getIcon((int)this.highestLevel));
        DashboardUiUtils.assignActionToWidget((Widget)prblmBtn, DashboardUiUtils.endModalAndRun(endModalAction, () -> {
            if (this.toolToSwitchPerspective != null) {
                DashboardUiUtils.switchPerspective(this.toolToSwitchPerspective);
            }
            if (selectProblemSource != null) {
                selectProblemSource.run();
            }
            PerspectivesHelper.showView((String)"com.nxp.swtools.validation.problems.view");
        }));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)toolBar, tooltip);
        return toolBar;
    }

    public void mergeWith(@NonNull FilteredProblems filtProblems) {
        assert (this.functionName == null) : "this is expected to call only for instance without any function";
        assert (this.toolToSwitchPerspective == filtProblems.toolToSwitchPerspective) : "expected to be called for the same tool";
        this.highestLevel = Integer.max(this.highestLevel, filtProblems.highestLevel);
        this.numErrors += filtProblems.numErrors;
        this.numWarnings += filtProblems.numWarnings;
        this.numInfo += filtProblems.numInfo;
    }
}

