/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard.internal;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.ITooltipProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.ExpandableSection;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.dashboard.Messages;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.IToolFunction;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.tooltip.IToolTipable;
import com.nxp.swtools.utils.tooltip.ToolTipableFormatter;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class DashboardUiUtils {
    static final GridLayout TWO_COLUMN_GRID_LAYOUT;
    static final GridData TOP_GROUP_GRID_DATA;

    static {
        TOP_GROUP_GRID_DATA = new GridData(4, 128, true, false, 1, 1);
        TWO_COLUMN_GRID_LAYOUT = new GridLayout(2, false);
        DashboardUiUtils.TWO_COLUMN_GRID_LAYOUT.marginLeft = 10;
    }

    static @NonNull Runnable endModalAndRun(@Nullable Runnable endModalAction, @NonNull Runnable action) {
        if (endModalAction != null) {
            return () -> {
                endModalAction.run();
                action.run();
            };
        }
        return action;
    }

    private static @Nullable SwToolsProduct getDisabledProductInCurrentPerspective(@NonNull AtomicBoolean isProcessorSupported) {
        SwToolsProduct product;
        isProcessorSupported.set(false);
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (sharedConfig.isEmpty()) {
            return null;
        }
        String perspectiveId = PerspectivesHelper.getActivePerspectiveId();
        SwToolsProduct swToolsProduct = product = perspectiveId != null ? SwToolsProductConfiguration.getRegisteredProductForPerspective((String)perspectiveId) : null;
        if (product == null) {
            return null;
        }
        StorageTool storageTool = sharedConfig.getTools().getTool(product.getProductId());
        ITool tool = Tools.getTool((String)product.getProductId());
        isProcessorSupported.set(tool != null && tool.isProcessorSupported(sharedConfig));
        boolean isToolDisabled = storageTool != null && !storageTool.isEnabled() || !isProcessorSupported.get();
        return isToolDisabled ? product : null;
    }

    public static @Nullable String getDisabledProductErrorMessage() {
        AtomicBoolean isProcessorSupported = new AtomicBoolean(false);
        SwToolsProduct product = DashboardUiUtils.getDisabledProductInCurrentPerspective(isProcessorSupported);
        if (product == null) {
            return null;
        }
        if (isProcessorSupported.get()) {
            return String.format(Messages.get().Dashboard_ErrorCurrentToolIsDisabledSupported, product.getProductName());
        }
        return String.format(Messages.get().Dashboard_ErrorCurrentToolIsDisabledUnsupported, product.getProductName());
    }

    static @NonNull String getExpandItemId(@NonNull ExpandableSection item) {
        Composite parent = item.getParent();
        if (parent == null) {
            return "";
        }
        Object barData = parent.getData();
        return barData != null && barData instanceof ITool ? String.valueOf(((ITool)barData).getToolId()) + '.' + item.getText() : UtilsText.safeString((String)item.getText());
    }

    static Label addLabel(@NonNull Composite parent) {
        Label lbl = new Label(parent, 64);
        return lbl;
    }

    static @NonNull Control addSingleRowLabelToGrid(@NonNull Composite parent, @Nullable String text) {
        assert (parent.getLayout() instanceof GridLayout);
        Label lbl = new Label(parent, 0);
        lbl.setText(text);
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, ((GridLayout)parent.getLayout()).numColumns, 1));
        return lbl;
    }

    static @NonNull Composite addGroupAsRowToGrid(@NonNull Composite parent, int cols) {
        GridLayout parGridLayout = (GridLayout)parent.getLayout();
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)new GridData(16384, 128, true, false, parGridLayout.numColumns, 1));
        GridLayout newGridLayout = new GridLayout(cols, false);
        newGridLayout.marginHeight = 0;
        newGridLayout.marginWidth = 0;
        result.setLayout((Layout)newGridLayout);
        return result;
    }

    static @NonNull Label createNameLabel(@NonNull Composite parent, @Nullable String name) {
        assert (parent.getLayout() instanceof GridLayout);
        Label nameLbl = new Label(parent, 16384);
        nameLbl.setText(" " + name + ":");
        nameLbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        return nameLbl;
    }

    static @NonNull Control addNameValueToGrid(@NonNull Composite parent, @Nullable String name, @NonNull String value) {
        assert (parent.getLayout() instanceof GridLayout);
        Label nameLbl = DashboardUiUtils.createNameLabel(parent, name);
        Label valLbl = DashboardUiUtils.addLabel(parent);
        valLbl.setText(value);
        valLbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)nameLbl, String.valueOf(name) + ": " + value);
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)valLbl, String.valueOf(name) + ": " + value);
        return valLbl;
    }

    static void addNameValueToGridIfNonEmpty(@NonNull Composite parent, @Nullable String name, @Nullable String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        DashboardUiUtils.addNameValueToGrid(parent, name, value);
    }

    static @NonNull Control addLinkToCell(@NonNull Composite parent, final @NonNull String text, final @Nullable Runnable run) {
        final StyledText link = new StyledText(parent, 4);
        link.setText(text);
        link.setEditable(false);
        link.setWordWrap(false);
        link.setBackground(parent.getDisplay().getSystemColor(22));
        link.setForeground(parent.getDisplay().getSystemColor(36));
        link.setCursor(parent.getDisplay().getSystemCursor(21));
        StyleRange hyperlinkStyle = new StyleRange();
        hyperlinkStyle.start = 0;
        hyperlinkStyle.length = text.length();
        hyperlinkStyle.underline = true;
        link.setStyleRange(hyperlinkStyle);
        link.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                Point clickPoint = new Point(arg0.x, arg0.y);
                try {
                    int offset = link.getOffsetAtLocation(clickPoint);
                    if (link.getStyleRangeAtOffset(offset) != null) {
                        if (run != null) {
                            run.run();
                        } else {
                            SWTFactoryProxy.INSTANCE.openWithExtermalApps(UtilsText.safeString((String)text));
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        });
        link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        link.setCaret(null);
        return link;
    }

    static @NonNull Button addButtonToCell(@NonNull Composite parent, @Nullable String iconImg, @NonNull String text, final @NonNull Runnable run) {
        Button btn = new Button(parent, 2);
        btn.setText(text);
        if (iconImg != null) {
            Image img = ToolsImages.getImage((String)iconImg);
            if (img == null) {
                assert (false) : "image not found: " + iconImg;
            } else {
                btn.setImage(img);
                btn.setSize(2 * btn.getBorderWidth() + img.getImageData().width, 2 * btn.getBorderWidth() + img.getImageData().height);
            }
        }
        btn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                run.run();
            }
        });
        return btn;
    }

    static @NonNull Composite createTopLevelGroup(@NonNull Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayoutData((Object)TOP_GROUP_GRID_DATA);
        result.setLayout((Layout)TWO_COLUMN_GRID_LAYOUT);
        return result;
    }

    static @NonNull GridLayout createTopLevelGridLayout(int cols) {
        GridLayout gridLayout = new GridLayout(cols, true);
        gridLayout.horizontalSpacing *= 2;
        gridLayout.verticalSpacing *= 2;
        return gridLayout;
    }

    static @NonNull ITooltipProvider getHtmlTooltipableForFunction(final @NonNull IToolFunction function) {
        return new ITooltipProvider(){

            public String getToolTipText() {
                StringBuilder result = new StringBuilder(ToolTipableFormatter.getToolTipText((IToolTipable)function));
                result.append("<br/>");
                result.append("<br/>");
                result.append(UtilsText.htmlB((String)Messages.get().Dashboard_FuncGroupSettingsHeaderForTooltip));
                result.append(": ");
                result.append("<br/>");
                result.append(function.getSettingsSummary());
                return result.toString();
            }
        };
    }

    static void switchPerspective(@NonNull ITool tool) {
        SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProduct((String)tool.getToolId());
        assert (product != null);
        PerspectivesHelper.switchPerspective((String)product.getPerspectiveID());
    }

    static void assignActionToWidget(@NonNull Widget widget, final @NonNull Runnable action) {
        SelectionAdapter actionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                action.run();
            }
        };
        if (widget instanceof Button) {
            ((Button)widget).addSelectionListener((SelectionListener)actionAdapter);
        } else if (widget instanceof ToolItem) {
            ((ToolItem)widget).addSelectionListener((SelectionListener)actionAdapter);
        } else assert (false) : "widget type not supported";
    }

    static @NonNull ToolItem createFileStatusButton(@NonNull Composite fileNameGrp, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IGeneratedFilesStatusProvider.GeneratedFileStatus fileStatus, @Nullable String whyDisabled) {
        String fileStsDsbldImage;
        String fileStsImage;
        ToolBar toolbar = new ToolBar(fileNameGrp, 0x800100);
        ToolItem fileStsBtn = new ToolItem(toolbar, 8);
        if (whyDisabled != null) {
            fileStatus = null;
        }
        if (fileStatus != null) {
            switch (fileStatus.statusInfo) {
                default: {
                    assert (false);
                }
                case NOT_EXIST: {
                    fileStsImage = "icons/updateProjectCode.png";
                    fileStsDsbldImage = "icons/updateProjectCode_Blocked.png";
                    break;
                }
                case MODIFIED: {
                    fileStsImage = "icons/updateProjectCode_Dirty.png";
                    fileStsDsbldImage = "icons/updateProjectCode_Blocked.png";
                    break;
                }
                case DELETE: {
                    fileStsImage = "icons/updateProjectCode_Delete.png";
                    fileStsDsbldImage = "icons/updateProjectCode_Delete.png";
                    break;
                }
                case UP_TO_DATE: {
                    whyDisabled = Messages.get().Dashboard_TooltipUpdPrjCode_FileUpToDate;
                    fileStsImage = "icons/updateProjectCode_Updated.png";
                    fileStsDsbldImage = "icons/updateProjectCode_Updated.png";
                    break;
                }
                case USER_TEMPLATE: {
                    fileStsImage = "icons/userTemplateProjectCode.png";
                    fileStsDsbldImage = "icons/userTemplateProjectCode.png";
                    break;
                }
            }
        } else {
            fileStsImage = "icons/updateProjectCode_Disabled.png";
            fileStsDsbldImage = "icons/updateProjectCode_Blocked.png";
            if (whyDisabled == null) {
                whyDisabled = Messages.get().Dashboard_TooltipUpdPrjCode_StsNotDetected;
            }
        }
        fileStsBtn.setEnabled(whyDisabled == null);
        fileStsBtn.setImage(ToolsImages.getImage((String)fileStsImage));
        fileStsBtn.setDisabledImage(ToolsImages.getImage((String)fileStsDsbldImage));
        if (whyDisabled != null) {
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)toolbar, whyDisabled);
        } else {
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)toolbar, Messages.get().Dashboard_TooltipUpdPrjCode_Default);
        }
        return fileStsBtn;
    }
}

