/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dashboard;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.dashboard.internal.DashboardUiUtils;
import com.nxp.swtools.dashboard.ui.DashboardDialog;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.utils.tools.Tools;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    @NonNull
    public static final String PLUGIN_ID = "com.nxp.swtools.dashboard";
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(Activator.class);
    @NonNull
    private static final String JOB_NAME = "Disabled tool detector";
    private static Activator plugin;
    static boolean delayedDisabledToolDetectorIsRunning;
    static final DelayedExecution delayedDetectorOfPerspWithDisbldTool;

    static {
        delayedDisabledToolDetectorIsRunning = false;
        delayedDetectorOfPerspWithDisbldTool = new DelayedExecution(JOB_NAME, (IDelayedActionExecutor)new DelayedActionExecutorAdapter(){

            public void runAction() {
                delayedDisabledToolDetectorIsRunning = true;
                try {
                    UIJob job;
                    ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
                    if (!sharedConfig.isEmpty() && (job = UIJobHelper.runUIJob(() -> {
                        if (DashboardUiUtils.getDisabledProductErrorMessage() != null) {
                            DashboardDialog.createAndOpen(null, true);
                        }
                    }, (String)Activator.JOB_NAME, (boolean)true)) != null) {
                        try {
                            job.join();
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.SEVERE, "Failed to wait until job for opening dashboard is DONE", e);
                        }
                    }
                }
                finally {
                    delayedDisabledToolDetectorIsRunning = false;
                }
            }
        }, 100);
    }

    static void requestDsbldToolDetectIfAnyDisabled(@NonNull ISharedConfiguration sharedConfig) {
        if (!sharedConfig.isEmpty() && !delayedDisabledToolDetectorIsRunning) {
            if (CollectionsUtils.findAny((Collection)sharedConfig.getTools().getTools(), t -> !t.isEnabled()) != null) {
                delayedDetectorOfPerspWithDisbldTool.requestExecution();
            } else if (CollectionsUtils.findAny((Collection)Tools.getTools(), t -> !t.isProcessorSupported(sharedConfig)) != null) {
                delayedDetectorOfPerspWithDisbldTool.requestExecution();
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                Activator.requestDsbldToolDetectIfAnyDisabled(SharedConfigurationFactory.getSharedConfigurationSingleton());
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                if (delayedDetectorOfPerspWithDisbldTool.isExecRequested() && !delayedDisabledToolDetectorIsRunning) {
                    delayedDetectorOfPerspWithDisbldTool.requestExecution();
                }
            }
        });
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        sharedConfig.addListener((ISharedConfigurationListener)new SharedConfigurationAdapter(){

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                Activator.requestDsbldToolDetectIfAnyDisabled(sharedConfiguration);
            }

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                String perspId = PerspectivesHelper.getActivePerspectiveId();
                if (perspId == null) {
                    return;
                }
                SwToolsProduct product = SwToolsProductConfiguration.getRegisteredProductForPerspective((String)perspId);
                if (product != null && changeContext.getToolId().equals(product.getProductId())) {
                    Activator.requestDsbldToolDetectIfAnyDisabled(sharedConfiguration);
                }
            }

            public int getListenerOrder() {
                return Integer.MAX_VALUE;
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

