/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.parser;

import com.nxp.s32ds.cle.ide.software.manager.internal.marker.SoftwareManifestMarker;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerComponentImplementatin;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerFactory;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerRequiredComponentImplementation;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SoftwareManifestParserHandler {
    private SoftwareManagerPackageDescriptor descriptor;
    private IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private DefaultHandler defaultHandler = new DefaultHandler(){

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("swpackage")) {
                SoftwareManifestParserHandler.this.createSoftwareDescriptor(attributes);
            } else if (qName.equals("variable")) {
                this.createVariable(attributes);
            } else if (qName.equals("requirement")) {
                SoftwareManifestParserHandler.this.createRequirement(attributes);
            } else if (qName.equals("component")) {
                SoftwareManifestParserHandler.this.createComponent(attributes);
            }
        }

        private void createVariable(Attributes attributes) {
            String name = null;
            String value = null;
            String type = null;
            int i = 0;
            while (i < attributes.getLength()) {
                String qName = attributes.getQName(i);
                if ("value".equalsIgnoreCase(qName)) {
                    value = attributes.getValue(i);
                } else if ("name".equalsIgnoreCase(qName)) {
                    name = attributes.getValue(i);
                } else if ("type".equalsIgnoreCase(qName)) {
                    type = attributes.getValue(i);
                }
                ++i;
            }
            if (type != null) {
                SoftwareManagerFactory.createVariableByType(name, value, type);
                return;
            }
            if (name != null && value != null) {
                SoftwareManagerFactory.addVariablesEntryToSwPackageDescriptor(SoftwareManifestParserHandler.this.descriptor, name, value);
            } else {
                if (SoftwareManifestParserHandler.this.iWorkspaceRoot != null) {
                    SoftwareManifestMarker.createMarker((IResource)SoftwareManifestParserHandler.this.iWorkspaceRoot, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateVariable, name, (Object)value));
                }
                SoftwareManagerActivator.getDefault().logError(SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateVariable, name, (Object)value));
            }
        }
    };

    private void createComponent(Attributes attributes) {
        String type = null;
        String id = null;
        String version = null;
        String name = null;
        String manifest = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                id = attributes.getValue(i);
            } else if ("name".equalsIgnoreCase(attributes.getQName(i))) {
                name = attributes.getValue(i);
            } else if ("version".equalsIgnoreCase(attributes.getQName(i))) {
                version = attributes.getValue(i);
            } else if ("type".equalsIgnoreCase(attributes.getQName(i))) {
                type = attributes.getValue(i);
            } else if ("manifest".equals(attributes.getQName(i))) {
                manifest = attributes.getValue(i);
            }
            ++i;
        }
        if (type != null && id != null && version != null && name != null) {
            SoftwareManagerComponentImplementatin component = SoftwareManagerFactory.createComponent(type, id, version, name, manifest);
            SoftwareManagerFactory.addComponentToSwPackageDescriptor(this.descriptor, component);
        } else {
            Object[] objects = new Object[]{type, id, version, name, manifest};
            if (this.iWorkspaceRoot != null) {
                SoftwareManifestMarker.createMarker((IResource)this.iWorkspaceRoot, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateVariable, (Object[])objects));
            }
            SoftwareManagerActivator.getDefault().logError(SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateVariable, (Object[])objects));
        }
    }

    private void createRequirement(Attributes attributes) {
        if (this.descriptor != null) {
            String type = null;
            String id = null;
            String version = null;
            String name = null;
            int i = 0;
            while (i < attributes.getLength()) {
                if ("id".equalsIgnoreCase(attributes.getQName(i))) {
                    id = attributes.getValue(i);
                } else if ("name".equalsIgnoreCase(attributes.getQName(i))) {
                    name = attributes.getValue(i);
                } else if ("version".equalsIgnoreCase(attributes.getQName(i))) {
                    version = attributes.getValue(i);
                } else if ("type".equalsIgnoreCase(attributes.getQName(i))) {
                    type = attributes.getValue(i);
                }
                ++i;
            }
            if (type != null && id != null && version != null && name != null) {
                SoftwareManagerRequiredComponentImplementation requirement = new SoftwareManagerRequiredComponentImplementation(type, id, version, name);
                SoftwareManagerFactory.addRequiredComponentToSwPackageDescriptor(this.descriptor, requirement);
            } else {
                Object[] objects = new Object[]{type, id, version, name};
                if (this.iWorkspaceRoot != null) {
                    SoftwareManifestMarker.createMarker((IResource)this.iWorkspaceRoot, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateRequirement, (Object[])objects));
                }
                SoftwareManagerActivator.getDefault().logError(SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateRequirement, (Object[])objects));
            }
        }
    }

    public DefaultHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    private void createSoftwareDescriptor(Attributes attributes) {
        String name = null;
        String id = null;
        String version = null;
        int i = 0;
        while (i < attributes.getLength()) {
            if ("id".equals(attributes.getQName(i))) {
                id = attributes.getValue(i);
            } else if ("version".equals(attributes.getQName(i))) {
                version = attributes.getValue(i);
            } else if ("name".equals(attributes.getQName(i))) {
                name = attributes.getValue(i);
            }
            ++i;
        }
        if (name != null && id != null && version != null) {
            this.descriptor = SoftwareManagerFactory.createSwPackageDescriptor(id, name, version);
        } else {
            Object[] objects = new Object[]{id, version, name};
            if (this.iWorkspaceRoot != null) {
                SoftwareManifestMarker.createMarker((IResource)this.iWorkspaceRoot, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateSoftwareDescriptor, (Object[])objects));
            }
            SoftwareManagerActivator.getDefault().logError(SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_CanNotCreateSoftwareDescriptor, (Object[])objects));
        }
    }

    public SoftwareManagerPackageDescriptor getDescriptor() {
        return this.descriptor;
    }
}

