/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.variables.handlers;

import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.Messages;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class LinkedResourcesVariableHandler {
    private SoftwareManagerActivator activator = SoftwareManagerActivator.getDefault();

    public void process(String name, String value) {
        if (name == null) {
            this.activator.logError(Messages.LinkedResourcesVariableHandler_NameIsNull);
            return;
        }
        if (value == null) {
            this.activator.logError(Messages.LinkedResourcesVariableHandler_ValueIsNull);
            return;
        }
        IPathVariableManager pathManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        if (pathManager == null) {
            this.activator.logError(Messages.LinkedResourcesVariableHandler_PathManagerIsNull);
            return;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        if (variableManager == null) {
            this.activator.logError(Messages.LinkedResourcesVariableHandler_StringVariableManagerIsNull);
            return;
        }
        try {
            String substitutedValue = variableManager.performStringSubstitution(value);
            URI resolvedURI = pathManager.resolveURI(URIUtil.toURI((String)substitutedValue));
            if (resolvedURI == null || resolvedURI.toString().isEmpty()) {
                this.handleError(name);
            } else {
                pathManager.setURIValue(name, resolvedURI);
            }
        }
        catch (CoreException ex) {
            this.handleError(name, ex);
        }
    }

    private void handleError(String name) {
        this.handleError(name, null);
    }

    private void handleError(String name, Throwable ex) {
        if (ex != null) {
            this.activator.logError(SoftwareManagerMessages.bind((String)Messages.LinkedResourcesVariableHandler_CannotResolveVariable, (Object)name), ex);
        } else {
            this.activator.logError(SoftwareManagerMessages.bind((String)Messages.LinkedResourcesVariableHandler_CannotResolveVariable, (Object)name));
        }
    }
}

