/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core;

import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentListenerManager;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventBuilder;
import com.nxp.s32ds.cle.ide.software.manager.internal.marker.SoftwareManifestMarker;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;

public class SoftwareManagerJobChangeListener
implements IJobChangeListener {
    private static final String DELIMITER = ", ";
    private static final String VALUE = "value ";
    private static final String NAME = "name ";
    private final SoftwareManagerPackageRegistry registry;

    public SoftwareManagerJobChangeListener(SoftwareManagerPackageRegistry packageRegistry) {
        this.registry = packageRegistry;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        this.resolveVariablies();
        ComponentChangeEvent changeEvent = this.createComponentChangeEvent();
        if (changeEvent != null) {
            ComponentListenerManager.INSTANCE.notifyComponentChange(changeEvent);
        }
    }

    private void resolveVariablies() {
        List<IValueVariable> valueVariable;
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        HashMap<String, String> collect = new HashMap<String, String>();
        for (SoftwareManagerPackageDescriptor packageDescriptor : this.registry.getSwPackageDescriptors()) {
            for (Map.Entry entry2 : packageDescriptor.getVariablesNames2KeyValue().entrySet()) {
                if (!collect.containsKey(entry2.getKey())) {
                    collect.put((String)entry2.getKey(), (String)entry2.getValue());
                    continue;
                }
                SoftwareManagerActivator.getDefault().logWarning(SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJobChangeListener_DuplicateNameOfVariable, entry2.getKey()));
            }
        }
        if (!collect.isEmpty() && !(valueVariable = collect.entrySet().parallelStream().map(entry -> stringVariableManager.newValueVariable((String)entry.getKey(), SoftwareManagerMessages.SoftwareManagerJobChangeListener_VariableNameDescriptor, true, (String)entry.getValue())).collect(Collectors.toList())).isEmpty()) {
            try {
                stringVariableManager.addVariables(valueVariable.toArray(new IValueVariable[valueVariable.size()]));
            }
            catch (CoreException e) {
                String namesAndValue = valueVariable.stream().map(var -> NAME + var.getName() + VALUE + var.getValue()).collect(Collectors.joining(DELIMITER));
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                SoftwareManifestMarker.createMarker((IResource)workspace.getRoot(), SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_VariablesCantResolve, (Object)namesAndValue));
                SoftwareManagerActivator.getDefault().logError(e.getMessage());
            }
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private ComponentChangeEvent createComponentChangeEvent() {
        ArrayList<SoftwareManagerPackageDescriptor> descriptors = new ArrayList<SoftwareManagerPackageDescriptor>();
        for (SoftwareManagerPackageDescriptor descriptor : this.registry.getSwPackageDescriptors()) {
            descriptors.add(descriptor);
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        return ComponentChangeEventBuilder.builder().archetypeId("software_package").payload(descriptors).build();
    }
}

