/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core;

import com.nxp.s32ds.cle.ide.software.manager.internal.marker.SoftwareManifestMarker;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.parser.SoftwareManifestParserHandler;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.xml.sax.SAXException;

public class SoftwareManagerJob
extends Job {
    private final SoftwareManagerPackageRegistry registry;
    private final Set<String> strings;

    public SoftwareManagerJob(String name, Set<String> strings, SoftwareManagerPackageRegistry registry) {
        super(name);
        this.registry = registry;
        this.strings = strings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            SAXParser saxParser = factory.newSAXParser();
            Set<String> loadFromExtension = this.strings;
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            for (String path : loadFromExtension) {
                try {
                    File file = new File(stringVariableManager.performStringSubstitution(path));
                    if (!file.exists()) {
                        SoftwareManifestMarker.createMarker((IResource)workspaceRoot, path, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)path.toString()));
                        break;
                    }
                    IPath location = Path.fromOSString((String)file.getPath());
                    SoftwareManifestParserHandler dh = new SoftwareManifestParserHandler();
                    try {
                        Throwable throwable = null;
                        Object var13_15 = null;
                        try (FileInputStream is = new FileInputStream(file);){
                            saxParser.parse((InputStream)is, dh.getDefaultHandler());
                            SoftwareManagerPackageDescriptor descriptor = dh.getDescriptor();
                            if (descriptor == null) continue;
                            this.registry.addSwPackageDescriptor(descriptor);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException | SAXException exception) {
                        IFile fileForLocation = workspaceRoot.getFileForLocation(location);
                        if (fileForLocation != null) {
                            SoftwareManifestMarker.createMarker((IResource)fileForLocation, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)path.toString()));
                        } else {
                            SoftwareManifestMarker.createMarker((IResource)workspaceRoot, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)path.toString()));
                        }
                        SoftwareManagerActivator.getDefault().log((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.software.manager", SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_FileOpenParseError, (Object)path)));
                    }
                }
                catch (CoreException coreException) {
                    SoftwareManifestMarker.createMarker((IResource)workspaceRoot, path, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_VaribleCantResolve, (Object)path));
                    SoftwareManagerActivator.getDefault().log((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.software.manager", SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_VaribleCantResolve, (Object)path)));
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SoftwareManagerActivator.getDefault().log((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.software.manager", SoftwareManagerMessages.SoftwareManagerActivator_ParserConficurationErrorMessage));
        }
        catch (SAXException e) {
            SoftwareManagerActivator.getDefault().log((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.software.manager", e.getMessage()));
        }
        return Status.OK_STATUS;
    }
}

