/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.isp.ispgen.core.gen;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class GenUtil {
    private static final Pattern PATTERN = Pattern.compile("\\s*(\\{.*\\}\\s*),?");
    private static Map<String, Integer> offsets = new HashMap<String, Integer>();
    private static int offset = 0;
    private static int localOffset = 0;

    public static int getParamSize(String string) {
        if (string == null || string.trim().isEmpty()) {
            return 0;
        }
        int counter = 0;
        Matcher matcher = PATTERN.matcher(string);
        boolean found = matcher.find();
        while (found) {
            ++counter;
            found = matcher.find();
        }
        return counter;
    }

    public static String cleanupParam(IspIpuEngine engine) {
        String parameters = engine.getParameters();
        if (parameters == null || parameters.trim().isEmpty()) {
            return "0";
        }
        return parameters.trim();
    }

    public static void clearOffset() {
        offsets.clear();
        offset = 0;
    }

    public Integer getOffset(String name) {
        Integer integer = offsets.get(name);
        if (integer == null) {
            return -1;
        }
        return (int)integer;
    }

    public Integer addOffset(String name, Integer size) {
        offsets.put(name, new Integer(offset));
        offset += size.intValue();
        return size;
    }

    public static void setLocalOffset(Integer size) {
        localOffset = size;
    }

    public Integer increaseLocalOffset(Integer size) {
        int o = localOffset;
        localOffset += size.intValue();
        return o;
    }

    public void increaseLocalOffsetSilently(Integer size) {
        localOffset += size.intValue();
    }

    public String toString(Resource resource) {
        URI uri = EmfResources.getUri((Resource)resource);
        IPath path = EmfResources.getPath((URI)uri);
        if (path != null) {
            return path.toPortableString();
        }
        File file = EmfResources.getFile((URI)uri);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "<undefined>";
    }
}

