/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.clt.isp.ispgen.core;

import com.nxp.s32ds.ext.emf.acceleo.AbstractGenerator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractGenerate {
    private final File targetFolder;
    private final List<? extends Object> arguments;
    private final Map<String, String> properties;

    public AbstractGenerate(File targetFolder, List<? extends Object> arguments, Map<String, String> properties) {
        this.targetFolder = targetFolder;
        this.arguments = arguments;
        this.properties = properties;
    }

    public File getTargetFolder() {
        return this.targetFolder;
    }

    public List<? extends Object> getArguments() {
        return this.arguments;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void doGenerate(IProgressMonitor monitor, URI modelURI) throws IOException {
        this.prepareTargetFolder();
        monitor.subTask("Loading...");
        AbstractGenerator gen0 = this.createGenerator(modelURI);
        monitor.worked(1);
        gen0.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
    }

    public void doGenerate(IProgressMonitor monitor, EObject modelEObject) throws IOException {
        this.prepareTargetFolder();
        monitor.subTask("Loading...");
        AbstractGenerator gen0 = this.createGenerator(modelEObject);
        monitor.worked(1);
        gen0.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
    }

    private void prepareTargetFolder() {
        if (!this.targetFolder.exists()) {
            this.targetFolder.mkdirs();
        }
    }

    protected abstract AbstractGenerator createGenerator(EObject var1) throws IOException;

    protected abstract AbstractGenerator createGenerator(URI var1) throws IOException;
}

